/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.inputlist;

import com.tridium.eas.ui.EasUiUtil;
import com.tridium.eas.ui.inputlist.InputConfigDialog;
import com.tridium.eas.ui.inputlist.InputList;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.widgets.ColorIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.JComponent;
import javax.swing.tree.TreePath;

public class InputListItem
extends JComponent
implements MouseListener,
MouseMotionListener {
    private InputList il;
    private ReportInput input;
    private boolean layoutExpandable = true;
    private boolean expanded = false;
    private String text;
    private int baseline;
    private int colorX;
    private int colorY;
    private int maxItemText = -1;
    private ColorIcon colorIcon = null;
    private Lexicon lex;

    public InputListItem(InputList inputList, ReportInput reportInput) {
        this.il = inputList;
        this.input = reportInput;
        this.lex = inputList.getModel().getLexicon();
        this.setOpaque(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void reset() {
        this.text = null;
    }

    public InputConfigDialog getConfigDialog() {
        return new InputConfigDialog(this.getInput(), this.lex, this);
    }

    public String getText() {
        BUnit bUnit = this.input.getUnit();
        String string = this.lex.getText(this.input.getName());
        if (bUnit != null && bUnit.getSymbol().length() > 0) {
            string = string + " (" + bUnit.toString() + ")";
        }
        return string;
    }

    public boolean isExpandable() {
        return this.input.isAggregate() || !this.input.isAutoName();
    }

    public void setLayoutExpandable(boolean bl) {
        if (this.layoutExpandable != bl) {
            this.invalidate();
        }
        this.layoutExpandable = bl;
        if (!this.layoutExpandable) {
            this.expanded = false;
        }
    }

    public int getMaxItemText() {
        if (this.maxItemText == -1) {
            this.il.updateUi();
            int n = this.input.getInputItemCount();
            for (int i = 0; i < n; ++i) {
                String string = this.input.getInputItem(i).getText();
                this.maxItemText = Math.max(this.maxItemText, this.il.fm.stringWidth(string));
            }
        }
        return this.maxItemText;
    }

    public Dimension getPreferredSize() {
        this.il.updateUi();
        int n = 2;
        int n2 = 0;
        n2 = this.il.rowHeight;
        if (this.layoutExpandable) {
            if (this.expanded) {
                n = this.il.expandedIcon.getIconWidth();
                n2 += this.il.rowHeight * this.input.getInputItemCount();
            } else {
                n = this.il.collapsedIcon.getIconWidth() + 2;
            }
        }
        int n3 = n;
        n += this.colorIcon.getIconWidth() + this.il.fm.stringWidth(this.getText()) + 4;
        n = Math.max(n, n3 + this.getMaxItemText() + 2);
        return new Dimension(n, n2);
    }

    public void doLayout() {
        this.baseline = (this.il.rowHeight - this.il.fm.getAscent()) / 2 + this.il.fm.getAscent() - 1;
        this.colorX = this.layoutExpandable ? this.il.iconWidth + 4 : 0;
        this.colorY = (this.il.rowHeight - this.colorIcon.getIconHeight()) / 2;
    }

    public void invalidate() {
        this.maxItemText = -1;
        super.invalidate();
    }

    public void paintComponent(Graphics graphics) {
        ReportInput reportInput;
        int n = 2;
        int n2 = 0;
        if (this.input.hasNormalizingPoint()) {
            graphics.setColor(EasUiUtil.DP_NORMALIZED_COLOR);
        } else {
            graphics.setColor(this.il.bg);
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(this.il.bg);
        boolean bl = this.isExpandable();
        if (bl) {
            if (this.expanded) {
                this.il.expandedIcon.paintIcon(this, graphics, n, this.il.iconY);
            } else {
                this.il.collapsedIcon.paintIcon(this, graphics, n, this.il.iconY);
            }
        }
        if (this.layoutExpandable) {
            n += this.il.iconWidth + 2;
        }
        if ((reportInput = this.input.getAggregateParent()) == null) {
            this.colorIcon.setDogEarColor(null);
        } else {
            this.colorIcon.setDogEarColor(reportInput.getColor());
        }
        this.colorIcon.setColor(this.input.getColor());
        this.colorIcon.paintIcon(this, graphics, this.colorX, this.colorY);
        n += this.colorIcon.getIconWidth() + 2;
        String string = this.getText();
        if (this.input.hasNormalizingPoint()) {
            string = "* " + string;
        }
        int n3 = this.il.fm.stringWidth(string);
        graphics.setFont(this.il.font);
        if (this.isSelected()) {
            if (this.input.isEnabled()) {
                graphics.setColor(this.il.selBg);
            } else {
                graphics.setColor(this.il.dsblFg);
            }
            graphics.fillRect(n - 2, this.baseline - this.il.fm.getAscent(), n3 + 4, this.il.fm.getAscent() + 3);
            if (this.input.hasNormalizingPoint()) {
                graphics.setColor(EasUiUtil.DP_NORMALIZED_COLOR);
            } else {
                graphics.setColor(this.il.selFg);
            }
        } else if (this.input.isEnabled()) {
            graphics.setColor(this.il.fg);
        } else {
            graphics.setColor(this.il.dsblFg);
        }
        graphics.drawString(string, n, this.baseline);
        graphics.setColor(this.il.fg);
        if (bl && this.expanded) {
            n2 += this.il.rowHeight;
            ReportInputItem[] reportInputItemArray = this.input.getInputItems();
            if (reportInputItemArray != null) {
                int n4 = reportInputItemArray.length;
                for (int i = 0; i < n4; ++i) {
                    this.paintInputItem(graphics, reportInputItemArray[i], this.colorX, n2, this.isRowSelected(i));
                    n2 += this.il.rowHeight;
                }
            }
        }
    }

    public boolean isSelected() {
        return this.il.getSelectionModel().isPathSelected(new TreePath(this.input));
    }

    public boolean isRowSelected(int n) {
        return this.il.getSelectionModel().isPathSelected(new TreePath(new Object[]{this.input, this.input.getInputItem(n)}));
    }

    private void paintInputItem(Graphics graphics, ReportInputItem reportInputItem, int n, int n2, boolean bl) {
        graphics.setFont(this.il.font);
        String string = reportInputItem.getText();
        if (this.input.hasNormalizingPoint()) {
            string = "* " + string;
        }
        int n3 = this.il.fm.stringWidth(string);
        if (bl) {
            if (this.input.isEnabled()) {
                graphics.setColor(this.il.selBg);
            } else {
                graphics.setColor(this.il.dsblFg);
            }
            graphics.fillRect(n - 2, n2 + this.baseline - this.il.fm.getAscent(), n3 + 4, this.il.fm.getAscent() + 3);
            if (this.input.hasNormalizingPoint()) {
                graphics.setColor(EasUiUtil.DP_NORMALIZED_COLOR);
            } else {
                graphics.setColor(this.il.selFg);
            }
        } else if (this.input.isEnabled()) {
            graphics.setColor(this.il.fg);
        } else {
            graphics.setColor(this.il.dsblFg);
        }
        graphics.drawString(string, n, n2 + this.baseline);
    }

    public boolean isColor(Color color) {
        Color color2 = this.input.getColor();
        return color2 != null && color2.equals(color);
    }

    public void setColor(Color color) {
        this.input.setColor(color);
        if (this.colorIcon == null) {
            this.colorIcon = new ColorIcon(color, new Dimension(12, 12), new Insets(0, 0, 0, 0));
        } else {
            this.colorIcon.setColor(color);
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TreePath treePath;
        boolean bl = (mouseEvent.getModifiers() & 4) != 0;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getRow(n2);
        if (n3 == -1) {
            this.il.getSelectionModel().clearSelection();
            return;
        }
        if (n3 == 0) {
            if (!bl && this.inExpander(n, n2)) {
                this.expanded = !this.expanded;
                this.revalidate();
                this.repaint();
                return;
            }
            treePath = new TreePath(this.input);
        } else {
            treePath = new TreePath(new Object[]{this.input, this.input.getInputItem(n3 - 1)});
        }
        if (mouseEvent.isControlDown() || mouseEvent.isShiftDown()) {
            if (this.il.getSelectionModel().isPathSelected(treePath) && !bl) {
                this.il.getSelectionModel().removeSelectionPath(treePath);
            } else {
                this.il.getSelectionModel().addSelectionPath(treePath);
            }
        } else if (bl && !this.il.getSelectionModel().isPathSelected(treePath) || !bl) {
            this.il.getSelectionModel().setSelectionPath(treePath);
        }
        if (mouseEvent.getClickCount() == 2 && n3 == 0) {
            this.il.configureItem(this);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = (mouseEvent.getModifiers() & 4) != 0;
        if (bl) {
            this.il.doPopup(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private boolean inExpander(int n, int n2) {
        if (!this.isExpandable()) {
            return false;
        }
        return n >= 2 && n <= 2 + this.il.iconWidth && n2 >= this.il.iconY && n2 <= this.il.iconY + this.il.iconHeight;
    }

    private int getRow(int n) {
        if (n < 0) {
            return -1;
        }
        int n2 = n / this.il.rowHeight;
        if (!this.expanded) {
            if (n2 == 0) {
                return 0;
            }
            return -1;
        }
        int n3 = this.input.getInputItemCount();
        if (n2 > n3) {
            return -1;
        }
        return n2;
    }

    public ReportInput getInput() {
        return this.input;
    }

    public ReportInputItem removeInputItem(int n) {
        ReportInputItem reportInputItem = this.il.getModel().removeItemFromInput(this.input, n);
        this.invalidate();
        this.revalidate();
        return reportInputItem;
    }

    public void removeInputItem(ReportInputItem reportInputItem) {
        for (int i = 0; i < this.input.getInputItemCount(); ++i) {
            if (reportInputItem != this.input.getInputItem(i)) continue;
            this.removeInputItem(i);
        }
    }

    public void addInputItems(ReportInputItem[] reportInputItemArray) {
        this.il.getModel().addItemsToInput(this.input, reportInputItemArray);
        this.invalidate();
    }

    public boolean isEmpty() {
        return this.input.getInputItemCount() == 0;
    }
}

