/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.inputlist;

import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.inputlist.InputConfigDialog;
import com.tridium.eas.ui.inputlist.InputListItem;
import com.tridium.eas.ui.inputlist.InputListItemPopup;
import com.tridium.eas.ui.inputlist.InputListModel;
import com.tridium.eas.ui.inputlist.InputListPopup;
import com.tridium.eas.ui.inputlist.InputUnitDialog;
import com.tridium.eas.ui.inputlist.MultipleItemPopup;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.baja.util.Lexicon;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class InputList
extends JComponent
implements Scrollable,
EasDataListener,
MouseListener,
TreeSelectionListener {
    private static final int MIN_WIDTH = 175;
    private static final int MIN_HEIGHT = 200;
    static final int MARGIN = 2;
    static final int COLUMN_GAP = 10;
    public EasReport report;
    private InputListModel model;
    private DefaultTreeSelectionModel selModel;
    Font font;
    FontMetrics fm;
    int rowHeight;
    Color bg;
    Color fg;
    Color selFg;
    Color selBg;
    Color dsblFg;
    Icon expandedIcon;
    Icon collapsedIcon;
    int iconHeight;
    int iconWidth;
    int iconY;
    private int preferredWidth = -1;
    private InputListPopup popup;
    private InputListItemPopup itemPopup;
    private MultipleItemPopup multipleItemPopup;
    private DropTarget dropTarget;
    private boolean editable = true;

    public InputList(EasReport easReport) {
        this(easReport, null);
    }

    public InputList(EasReport easReport, InputListModel inputListModel) {
        this.report = easReport;
        this.updateUi();
        if (inputListModel == null) {
            Lexicon lexicon = BEasApplet.lex;
            inputListModel = new InputListModel(lexicon);
        }
        this.setModel(inputListModel);
        this.addMouseListener(this);
        this.selModel = new DefaultTreeSelectionModel();
        this.selModel.addTreeSelectionListener(this);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public EasReport getReport() {
        return this.report;
    }

    public InputListModel getModel() {
        return this.model;
    }

    public void setModel(InputListModel inputListModel) {
        this.removeAll();
        if (this.model != null) {
            this.model.setInputList(null);
        }
        this.model = inputListModel;
        this.model.setInputList(this);
        this.buildItems();
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selModel;
    }

    public int getItemCount() {
        return this.getComponentCount();
    }

    public InputListItem getItem(int n) {
        return (InputListItem)this.getComponent(n);
    }

    public InputListItem getSelectionItem(int n) {
        int n2 = this.getComponentCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            InputListItem inputListItem = (InputListItem)this.getComponent(i);
            n3 = inputListItem.getInput().getInputItemCount() > 1 ? (n3 += inputListItem.getInput().getInputItemCount() + 1) : ++n3;
            if (n >= n3) continue;
            return inputListItem;
        }
        return null;
    }

    public int getInputIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            InputListItem inputListItem = (InputListItem)this.getComponent(i);
            n2 = inputListItem.getInput().getInputItemCount() > 1 ? (n2 += inputListItem.getInput().getInputItemCount() + 1) : ++n2;
            if (n >= n2) continue;
            return i;
        }
        return -1;
    }

    void updateUi() {
        if (this.font == null) {
            this.font = new Font(Theme.widget().getLargeFont().getName(), 0, 10);
            this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            this.fg = UIManager.getColor("Tree.foreground");
            this.dsblFg = Color.gray;
            this.bg = UIManager.getColor("Tree.background");
            this.setBackground(this.bg);
            this.selFg = UIManager.getColor("Tree.selectionForeground");
            this.selBg = UIManager.getColor("Tree.selectionBackground");
            this.rowHeight = this.fm.getHeight() + 4;
            this.expandedIcon = UIManager.getIcon("Tree.expandedIcon");
            this.collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
            this.iconWidth = this.collapsedIcon.getIconWidth();
            this.iconHeight = this.collapsedIcon.getIconHeight();
            this.iconY = (this.rowHeight - this.iconHeight) / 2;
        }
    }

    public Dimension getPreferredSize() {
        InputListItem inputListItem;
        int n;
        this.updateUi();
        int n2 = 175;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getItemCount();
        boolean bl = false;
        for (n = 0; n < n6; ++n) {
            inputListItem = this.getItem(n);
            if (!inputListItem.isExpandable()) continue;
            bl = true;
            break;
        }
        for (n = 0; n < n6; ++n) {
            inputListItem = this.getItem(n);
            inputListItem.setLayoutExpandable(bl);
            Dimension dimension = inputListItem.getPreferredSize();
            n2 = Math.max(n2, dimension.width);
            n5 = Math.max(n5, inputListItem.getMaxItemText());
            n4 += dimension.height;
        }
        n3 = Math.max(n4, n3);
        n2 = this.preferredWidth >= 0 ? this.preferredWidth : Math.max(n2, this.iconWidth + n5 + 2);
        return new Dimension(Math.max(175, n2), n3);
    }

    public void doLayout() {
        InputListItem inputListItem;
        int n;
        int n2 = this.getWidth();
        this.updateUi();
        int n3 = 0;
        boolean bl = false;
        int n4 = this.getItemCount();
        for (n = 0; n < n4; ++n) {
            inputListItem = this.getItem(n);
            if (!inputListItem.isExpandable()) continue;
            bl = true;
            break;
        }
        for (n = 0; n < n4; ++n) {
            inputListItem = this.getItem(n);
            inputListItem.setLayoutExpandable(bl);
            Dimension dimension = inputListItem.getPreferredSize();
            inputListItem.setBounds(0, n3, n2, dimension.height);
            n3 += dimension.height;
        }
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.bg);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void buildItems() {
        int n = this.model.getInputCount();
        for (int i = 0; i < n; ++i) {
            InputListItem inputListItem = new InputListItem(this, this.model.getInput(i));
            this.assignColor(inputListItem);
            this.add(inputListItem);
        }
    }

    public int indexForInput(ReportInput reportInput) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            InputListItem inputListItem = (InputListItem)this.getComponent(i);
            if (inputListItem.getInput() != reportInput) continue;
            return i;
        }
        return -1;
    }

    public InputListItem getItemForInput(ReportInput reportInput) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            InputListItem inputListItem = (InputListItem)this.getComponent(i);
            if (inputListItem.getInput() != reportInput) continue;
            return inputListItem;
        }
        return null;
    }

    public InputListItemPopup getItemPopup() {
        if (this.itemPopup == null) {
            this.itemPopup = new InputListItemPopup(this);
            if (this.report != null) {
                this.report.addInputListPopupItems(this.itemPopup);
            }
        }
        return this.itemPopup;
    }

    public MultipleItemPopup getMultipleItemPopup() {
        if (this.multipleItemPopup == null) {
            this.multipleItemPopup = new MultipleItemPopup(this);
        }
        return this.multipleItemPopup;
    }

    public void assignColor(InputListItem inputListItem) {
        Color color = inputListItem.getInput().getColor();
        if (color == null) {
            boolean bl = false;
            Enumeration enumeration = ChartColors.getColors();
            while (enumeration.hasMoreElements() && !ChartColors.isOverflow(color = (Color)enumeration.nextElement())) {
                bl = false;
                int n = this.getItemCount();
                for (int i = 0; i < n; ++i) {
                    if (!this.getItem(i).isColor(color)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                break;
            }
        }
        inputListItem.setColor(color);
    }

    public void disaggregate(ReportInput reportInput) {
        if (!this.editable) {
            return;
        }
        reportInput.setDisaggregated(true);
        int n = reportInput.getInputItemCount();
        ReportInput[] reportInputArray = new ReportInput[n];
        Lexicon lexicon = BEasApplet.lex;
        for (int i = 0; i < n; ++i) {
            ReportInputItem reportInputItem = reportInput.getInputItem(i);
            reportInputArray[i] = new ReportInput(null, reportInput.getUnit(), reportInputItem, lexicon);
            reportInputArray[i].setAggregateParent(reportInput);
            this.model.addInput(reportInputArray[i]);
        }
        this.getReport().disaggregate(reportInput, reportInputArray);
    }

    public void reaggregate(ReportInput reportInput) {
        if (!this.editable) {
            return;
        }
        reportInput.setDisaggregated(false);
        Vector<ReportInput> vector = new Vector<ReportInput>(3);
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            InputListItem inputListItem = this.getItem(i);
            if (inputListItem.getInput().getAggregateParent() != reportInput) continue;
            vector.addElement(inputListItem.getInput());
        }
        Object[] objectArray = new ReportInput[vector.size()];
        vector.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.model.removeInput((ReportInput)objectArray[i]);
        }
        this.getReport().reaggregate((ReportInput[])objectArray);
    }

    void showPopup(Component component, int n, int n2) {
        if (!this.editable) {
            return;
        }
        if (this.popup == null) {
            this.popup = new InputListPopup(this);
            this.add(this.popup);
        }
        int n3 = n;
        int n4 = n2;
        while (component != this && component != null) {
            Point point = component.getLocation();
            n3 += point.x;
            n4 += point.y;
            component = component.getParent();
        }
        this.popup.arm();
        this.popup.show(this, n3, n4);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return this.rowHeight;
        }
        return this.iconWidth;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return rectangle.height / this.rowHeight;
        }
        return this.iconWidth;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.model.getInputCount() == 0;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.model.getInputCount() == 0;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) == 0) {
            return;
        }
        this.doPopup(this, mouseEvent.getX(), mouseEvent.getY());
    }

    void doPopup(Component component, int n, int n2) {
        if (!this.editable) {
            return;
        }
        if (this.getSelectionModel().getSelectionCount() == 0) {
            this.showPopup(component, n, n2);
        } else if (this.getSelectionModel().getSelectionCount() == 1) {
            this.getItemPopup().arm(this.getSelectionModel().getSelectionPath().getPath());
            this.getItemPopup().show(component, n, n2);
        } else {
            this.getMultipleItemPopup().arm(this.getSelectionModel().getSelectionPaths());
            this.getMultipleItemPopup().show(component, n, n2);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.getSelectionModel().clearSelection();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            int n = this.indexForInput((ReportInput)treePathArray[i].getPath()[0]);
            if (n < 0) continue;
            InputListItem inputListItem = this.getItem(n);
            inputListItem.invalidate();
            inputListItem.repaint();
        }
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            int n = this.model.indexOfInput((ReportInput)objectArray[i]);
            if (n < 0) continue;
            this.getItem(n).invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            int n = this.model.indexOfInput((ReportInput)objectArray[i]);
            if (n < 0) continue;
            InputListItem inputListItem = new InputListItem(this, (ReportInput)objectArray[i]);
            this.assignColor(inputListItem);
            this.add((Component)inputListItem, n);
            this.revalidate();
            this.repaint();
        }
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            int n = this.indexForInput((ReportInput)objectArray[i]);
            if (n < 0) continue;
            this.remove(n);
            this.revalidate();
            this.repaint();
        }
    }

    public void configureItem(InputListItem inputListItem) {
        if (!this.editable) {
            return;
        }
        InputConfigDialog inputConfigDialog = inputListItem.getConfigDialog();
        if (this.report != null) {
            this.report.restrictInputToComponent(inputConfigDialog);
        }
        inputConfigDialog.open();
        if (this.report != null) {
            this.report.setInputEnabled(true);
        }
        if (!inputConfigDialog.isCancelled()) {
            this.model.notifyInputHasChanged(inputListItem.getInput());
            inputListItem.reset();
            inputListItem.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    public void configureItems(InputListItem[] inputListItemArray, boolean bl, boolean bl2) {
        if (!this.editable) {
            return;
        }
        Lexicon lexicon = BEasApplet.lex;
        InputUnitDialog inputUnitDialog = new InputUnitDialog(inputListItemArray, lexicon, this, bl, bl2);
        if (this.report != null) {
            this.report.restrictInputToComponent(inputUnitDialog);
        }
        inputUnitDialog.open();
        if (this.report != null) {
            this.report.setInputEnabled(true);
        }
        if (!inputUnitDialog.isCancelled()) {
            for (int i = 0; i < inputListItemArray.length; ++i) {
                this.model.notifyInputHasChanged(inputListItemArray[i].getInput());
                inputListItemArray[i].reset();
                inputListItemArray[i].invalidate();
            }
            this.revalidate();
            this.repaint();
        }
    }

    public JScrollPane createScrollPane() {
        InputListViewport inputListViewport = new InputListViewport(this.getBackground());
        inputListViewport.addMouseListener(this);
        inputListViewport.add(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewport(inputListViewport);
        return jScrollPane;
    }

    public class DropHandler
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    static class InputListViewport
    extends JViewport {
        private Color color;

        public InputListViewport(Color color) {
            this.color = color;
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

