/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.inputlist;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.chart.ChartColorCellRenderer;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.SiteDataPoint;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.ClassSelectionModel;
import com.tridium.eas.ui.widgets.DbObjectValidator;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTreeDialog;
import com.tridium.eas.ui.widgets.GridBagManager;
import com.tridium.eas.ui.widgets.UnitComboBox;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InputConfigDialog
extends JDialog
implements ActionListener,
DocumentListener,
DbObjectValidator {
    private EasApplication easApplication = null;
    private ReportInput input;
    private Component comp;
    private XpComboBox colorChoice;
    private JTextField nameField;
    private UnitComboBox unitChoice;
    private JButton okButton;
    private JButton cancelButton;
    private DataPoint normalizer = null;
    private JCheckBox normalizeCheckBox;
    private JLabel normalizerLabel;
    private JButton pickNormalizerButton;
    private String origName;
    private Lexicon lex;
    static /* synthetic */ Class class$com$tridium$eas$api$DataPoint;
    static /* synthetic */ Class class$com$tridium$eas$api$StaticGroup;
    static /* synthetic */ Class class$com$tridium$eas$api$DynGroup;
    static /* synthetic */ Class class$com$tridium$eas$api$Site;
    static /* synthetic */ Class class$com$tridium$eas$api$Meter;

    public InputConfigDialog(ReportInput reportInput, Lexicon lexicon, Component component) {
        super((Frame)null, lexicon.getText("inputConfiguration"), true);
        this.input = reportInput;
        this.lex = lexicon;
        this.comp = component;
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                InputConfigDialog.this.nameField.requestFocus();
                InputConfigDialog.this.nameField.selectAll();
            }

            public void windowClosing(WindowEvent windowEvent) {
                InputConfigDialog.this.doCancel();
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                if (InputConfigDialog.this.isModal()) {
                    InputConfigDialog.this.toFront();
                }
            }
        });
        int n = 0;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridBagManager gridBagManager = new GridBagManager(jComponent);
        this.colorChoice = new XpComboBox();
        this.colorChoice.setRenderer(new ChartColorCellRenderer());
        int n2 = ChartColors.getColorCount();
        for (int i = 0; i < n2; ++i) {
            this.colorChoice.addItem(new Integer(i));
        }
        gridBagManager.anchor(10);
        gridBagManager.add(0, 100, 1, 1, 0, n, this.colorChoice);
        this.nameField = new JTextField(20);
        this.nameField.getDocument().addDocumentListener(this);
        gridBagManager.fill(2);
        gridBagManager.add(100, 100, 1, 1, 1, n, this.nameField);
        gridBagManager.fill(0);
        BUnit bUnit = reportInput.getUnit();
        if (bUnit != null) {
            if (bUnit.isNull()) {
                gridBagManager.add(0, 100, 1, 1, 2, n, new JLabel(" " + bUnit.toString()));
            } else {
                this.unitChoice = new UnitComboBox(UnitDatabase.getDefault().getQuantity(bUnit), lexicon);
                gridBagManager.add(0, 100, 1, 1, 2, n, this.unitChoice);
                if (bUnit != null) {
                    this.unitChoice.setSelectedUnit(bUnit);
                }
            }
        }
        if (this.supportsDataPointNormalization(reportInput)) {
            this.normalizer = reportInput.hasNormalizingPoint() ? reportInput.getNormalizingPoint() : null;
            this.normalizeCheckBox = new JCheckBox(lexicon.getText("normalizeBy"));
            this.normalizeCheckBox.setSelected(this.normalizer != null);
            this.normalizeCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InputConfigDialog.this.normalizerLabel.setEnabled(InputConfigDialog.this.normalizeCheckBox.isSelected());
                    InputConfigDialog.this.pickNormalizerButton.setEnabled(InputConfigDialog.this.normalizeCheckBox.isSelected());
                }
            });
            gridBagManager.add(0, 100, 1, 1, 0, ++n, this.normalizeCheckBox);
            this.normalizerLabel = new JLabel(InputConfigDialog.getNormalizerText(this.normalizer, lexicon), 2);
            this.normalizerLabel.setEnabled(this.normalizer != null);
            gridBagManager.fill(2);
            gridBagManager.add(100, 100, 1, 1, 1, n, this.normalizerLabel);
            gridBagManager.fill(0);
            this.pickNormalizerButton = new JButton(lexicon.getText("select"));
            this.pickNormalizerButton.setEnabled(this.normalizer != null);
            this.pickNormalizerButton.addActionListener(this);
            gridBagManager.add(0, 100, 1, 1, 2, n, this.pickNormalizerButton);
        }
        ++n;
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new FlowLayout());
        this.okButton = new JButton(lexicon.getText("ok"));
        this.okButton.addActionListener(this);
        jPanel.add(this.okButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.addActionListener(this);
        jPanel.add(this.cancelButton);
        gridBagManager.add(100, 100, 3, 1, 0, n, jPanel);
        this.pack();
        this.getRootPane().setDefaultButton(this.okButton);
        int n3 = ChartColors.getIndex(reportInput.getColor());
        this.colorChoice.setSelectedIndex(n3);
        this.origName = reportInput.getName();
        this.nameField.setText(this.origName);
    }

    public void open() {
        int n = 0;
        int n2 = 0;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        Dimension dimension2 = this.getPreferredSize();
        this.setSize(dimension2.width, dimension2.height);
        this.setLocation(n2 + (n3 - dimension2.width) / 2, n + (n4 - dimension2.height) / 2);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCancelled() {
        return this.input == null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.doOk();
        } else if (object == this.cancelButton) {
            this.doCancel();
        } else if (object == this.pickNormalizerButton) {
            this.doSelectNormalizer();
        }
    }

    public void doOk() {
        this.input.setColor(ChartColors.getColor(this.colorChoice.getSelectedIndex()));
        if (!this.nameField.getText().equals(this.origName)) {
            this.input.setName(this.nameField.getText().trim());
        }
        if (this.unitChoice != null) {
            this.input.setUnit(this.unitChoice.getSelectedUnit());
        }
        if (this.normalizeCheckBox != null && this.normalizeCheckBox.isSelected()) {
            this.input.setNormalizingPoint(this.normalizer);
        } else {
            this.input.setNormalizingPoint(null);
        }
        this.close();
    }

    public void doCancel() {
        this.input = null;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doSelectNormalizer() {
        try {
            this.getParentApplication().setInputEnabled(true);
            this.setModal(false);
            this.normalizer = (DataPoint)FilterTreeDialog.getSelection(this.getParentApplication(), this.normalizer, this.lex.getText("select"), this.lex.getText("selectNormalizer"), new FilterRootNode((Filter)new AllSitesFilter(this.getParentApplication().getSession(), this.lex), this), new ClassSelectionModel(class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = InputConfigDialog.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint), this.getParentApplication(), this.lex);
            Object var2_1 = null;
            this.getParentApplication().restrictInputToComponent(this);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.getParentApplication().restrictInputToComponent(this);
            this.setModal(true);
            throw throwable;
        }
        this.setModal(true);
        this.normalizerLabel.setText(InputConfigDialog.getNormalizerText(this.normalizer, this.lex));
        ((JComponent)this.getContentPane()).revalidate();
        this.repaint();
    }

    private static String getNormalizerText(DataPoint dataPoint, Lexicon lexicon) {
        if (dataPoint == null) {
            return lexicon.getText("noPointSelected");
        }
        String string = dataPoint.getName();
        try {
            string = dataPoint.getDescr();
            if (dataPoint.getMeter() != null) {
                string = dataPoint.getMeter().getName() + " " + string;
            }
            string = string + " (" + dataPoint.getSite().getName() + ")";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private EasApplication getParentApplication() {
        if (this.easApplication != null) {
            return this.easApplication;
        }
        while (true) {
            if (this.comp instanceof EasApplication) {
                this.easApplication = (EasApplication)this.comp;
                return this.easApplication;
            }
            this.comp = this.comp.getParent();
        }
    }

    private boolean supportsDataPointNormalization(ReportInput reportInput) {
        ReportInputItem[] reportInputItemArray = reportInput.getInputItems();
        if (reportInputItemArray != null) {
            for (int i = 0; i < reportInputItemArray.length; ++i) {
                if (reportInputItemArray[i].getType() == 1) {
                    DataPoint dataPoint = ((SiteDataPoint)reportInputItemArray[i]).getDataPoint();
                    if (dataPoint == null || this.getParentApplication().getSession().getDataPointExec().isMultistate(dataPoint.getName())) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public boolean allowLoadUserObject(Class clazz) {
        return (class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = InputConfigDialog.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz) || (class$com$tridium$eas$api$StaticGroup == null ? (class$com$tridium$eas$api$StaticGroup = InputConfigDialog.class$("com.tridium.eas.api.StaticGroup")) : class$com$tridium$eas$api$StaticGroup).isAssignableFrom(clazz) || (class$com$tridium$eas$api$DynGroup == null ? (class$com$tridium$eas$api$DynGroup = InputConfigDialog.class$("com.tridium.eas.api.DynGroup")) : class$com$tridium$eas$api$DynGroup).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Site == null ? (class$com$tridium$eas$api$Site = InputConfigDialog.class$("com.tridium.eas.api.Site")) : class$com$tridium$eas$api$Site).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = InputConfigDialog.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter).isAssignableFrom(clazz);
    }

    public boolean allowShowUserObject(Object object) {
        if (!(object instanceof DataPoint)) {
            return true;
        }
        try {
            DataPoint dataPoint = (DataPoint)object;
            return !this.getParentApplication().getSession().getDataPointExec().isMultistate(dataPoint.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOkButtonState();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOkButtonState();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOkButtonState();
    }

    private void updateOkButtonState() {
        String string = this.nameField.getText().trim();
        this.okButton.setEnabled(string.length() > 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

