/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.Group;
import com.tridium.eas.ui.EasUiUtil;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.GroupPropertiesTable;
import com.tridium.eas.ui.dbconfig.GroupPropertiesTableModel;
import com.tridium.eas.ui.widgets.EasTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.baja.util.Lexicon;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StaticGroupSummaryPanel
extends JPanel {
    private JLabel nameLabel = null;
    private GroupPropertiesTableModel propertiesTableModel = null;
    private EasTable propertiesTable = null;
    private Lexicon lex;

    public StaticGroupSummaryPanel(ResourceManager resourceManager, Lexicon lexicon) {
        this.lex = lexicon;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel(lexicon.getText("name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.nameLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.add(jPanel);
        this.propertiesTableModel = new GroupPropertiesTableModel(new String[]{"addr1", "addr2", "city", "stateprov", "countrycd", "postalcd", "floorarea"}, lexicon);
        this.propertiesTable = new GroupPropertiesTable(resourceManager, this.propertiesTableModel, lexicon);
        this.propertiesTable.setEnabled(false);
        this.add(this.propertiesTable.getScrollPane());
    }

    public void setGroup(Group group) {
        this.nameLabel.setText(group.getName());
        this.propertiesTableModel.setGroup(group);
    }
}

