/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.StaticGroup;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.EasUiUtil;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.DataPointSummaryPanel;
import com.tridium.eas.ui.dbconfig.DbConfigNavigator;
import com.tridium.eas.ui.dbconfig.GroupDetailPanel;
import com.tridium.eas.ui.dbconfig.GroupEditor;
import com.tridium.eas.ui.dbconfig.GroupMembersList;
import com.tridium.eas.ui.dbconfig.GroupMembersTreeSelectionModel;
import com.tridium.eas.ui.dbconfig.GroupTree;
import com.tridium.eas.ui.dbconfig.NewGroupDialog;
import com.tridium.eas.ui.dbconfig.SiteSummaryPanel;
import com.tridium.eas.ui.dbconfig.StaticGroupSummaryPanel;
import com.tridium.eas.ui.dbconfig.Tracker;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.DbObjectValidator;
import com.tridium.eas.ui.widgets.DynamicGroupFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasCheckBox;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.ListPopupHandler;
import com.tridium.eas.ui.widgets.SortedListModel;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class StaticGroupDetailPanel
extends GroupDetailPanel
implements GroupEditor {
    private CardLayout memberDetailLayout = null;
    private CardLayout memberButtonLayout = null;
    private CardLayout rightPanelLayout = null;
    private JPanel memberDetailPanel = null;
    private JPanel memberButtonPanel = null;
    private JPanel rightPanel = null;
    private EasTextField nameTextField = null;
    private JButton applyButton = null;
    private JButton discardButton = null;
    private JButton deleteGroupButton = null;
    private JButton addGroupButton = null;
    private GroupMembersList currentMembersList = null;
    private JButton addMemberButton = null;
    private JButton removeMemberButton = null;
    private JButton newSubgroupButton = null;
    private XpComboBox memberTypeComboBox = null;
    private GroupTree candidates = null;
    private SiteSummaryPanel siteSummaryPanel = null;
    private StaticGroupSummaryPanel groupSummaryPanel = null;
    private DataPointSummaryPanel dataPointSummaryPanel = null;
    private String memberButtonTopCard = null;
    private Tracker subgroupTracker = null;
    private DbConfigNavigator navigator = null;
    private JButton changeMembersButton = null;
    private boolean newFlag = false;
    private MemberPopup memberPopup = null;
    private CardLayout layout = null;
    private EasCheckBox publicCheckBox = null;
    private DbObjectValidator groupValidator = null;
    private DbObjectValidator dynGroupValidator = null;
    private DbObjectValidator siteValidator = null;
    private static final String BLANK_CARD = "";
    private static final String SITES_CARD = "allSites";
    private static final String DATA_POINTS_CARD = "allDataPoints";
    private static final String GROUPS_CARD = "byGroup";
    private static final String DYN_GROUPS_CARD = "groupNameHere";
    private static final String MEMBERS_CARD = "members";
    private static final String DETAILS_BUTTON_CARD = "detail";
    static /* synthetic */ Class class$com$tridium$eas$api$StaticGroup;
    static /* synthetic */ Class class$com$tridium$eas$api$Site;
    static /* synthetic */ Class class$com$tridium$eas$api$DataPoint;
    static /* synthetic */ Class class$com$tridium$eas$api$Meter;
    static /* synthetic */ Class class$com$tridium$eas$api$DynGroup;

    public StaticGroupDetailPanel(ResourceManager resourceManager, EasApplication easApplication, Lexicon lexicon) {
        super(resourceManager, easApplication, lexicon);
        this.setAllowFireEditStarted(false);
        this.buildToolBar();
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        this.add(lexicon.getText("show"), jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.add(lexicon.getText("hide"), jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)this.buildDetailsPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        jPanel3.setBorder(BorderFactory.createTitledBorder(lexicon.getText("groupMembers")));
        jPanel3.add((Component)this.buildGroupMembersPanel(), "Center");
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        JPanel jPanel4 = new JPanel(new BorderLayout(), false);
        jPanel4.setBorder(BorderFactory.createTitledBorder(lexicon.getText("groupProperties")));
        jPanel4.add((Component)this.buildGroupPropertiesPanel(new String[0]), "Center");
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        JPanel jPanel5 = new JPanel(new FlowLayout(1), false);
        this.applyButton = new JButton(lexicon.getText("applyChanges"));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.applyChanges();
            }
        });
        jPanel5.add(this.applyButton);
        this.discardButton = new JButton(lexicon.getText("discardChanges"));
        this.discardButton.setEnabled(false);
        this.discardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.discardChanges();
            }
        });
        jPanel5.add(this.discardButton);
        jPanel.add((Component)jPanel5, gridBagConstraints);
        this.setGroupEditorValue(null);
        this.setAllowFireEditStarted(true);
    }

    protected JComponent buildGroupMembersPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.currentMembersList = new GroupMembersList(this.getResourceManager());
        this.addEasDataListener(this.currentMembersList);
        this.currentMembersList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() > 1 && !StaticGroupDetailPanel.this.groupIsDirty() && (n = StaticGroupDetailPanel.this.currentMembersList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    StaticGroupDetailPanel.this.navigator.navigateTo(StaticGroupDetailPanel.this.currentMembersList.getModel().getElementAt(n));
                }
            }
        });
        this.currentMembersList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StaticGroupDetailPanel.this.setRightPanelDetails();
                StaticGroupDetailPanel.this.setMemberButtonStates();
                if (!StaticGroupDetailPanel.this.currentMembersList.isSelectionEmpty()) {
                    StaticGroupDetailPanel.this.candidates.clearSelection();
                }
            }
        });
        this.currentMembersList.setPopupHandler(new ListPopupHandler(){

            public void openPopup(Object object, int n, int n2, int n3) {
                if (StaticGroupDetailPanel.this.getGroupEditorValue() == null || !StaticGroupDetailPanel.this.canUpdate()) {
                    return;
                }
                if (StaticGroupDetailPanel.this.memberPopup == null) {
                    StaticGroupDetailPanel.this.memberPopup = new MemberPopup();
                }
                if (n < 0) {
                    StaticGroupDetailPanel.this.memberPopup.show(StaticGroupDetailPanel.this.currentMembersList, false, n2, n3);
                } else {
                    StaticGroupDetailPanel.this.memberPopup.show(StaticGroupDetailPanel.this.currentMembersList, true, n2, n3);
                }
            }
        });
        this.currentMembersList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    StaticGroupDetailPanel.this.removeMembers();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.currentMembersList);
        jScrollPane.getViewport().setBackground(Color.white);
        jScrollPane.getViewport().setMinimumSize(new Dimension(150, 0));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.buildMemberButtonPanel(), gridBagConstraints);
        this.rightPanelLayout = new CardLayout();
        this.rightPanel = new JPanel(this.rightPanelLayout, false);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.memberTypeComboBox = new XpComboBox(new String[]{this.lex.getText(SITES_CARD), this.lex.getText(GROUPS_CARD)});
        jPanel2.add((Component)this.memberTypeComboBox, "North");
        this.memberDetailLayout = new CardLayout();
        this.memberDetailPanel = new JPanel(this.memberDetailLayout, false);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StaticGroupDetailPanel.this.setMemberButtonStates();
                if (!((JList)listSelectionEvent.getSource()).isSelectionEmpty()) {
                    StaticGroupDetailPanel.this.currentMembersList.clearSelection();
                }
            }
        };
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                StaticGroupDetailPanel.this.setMemberButtonStates();
                if (!((JTree)treeSelectionEvent.getSource()).isSelectionEmpty()) {
                    StaticGroupDetailPanel.this.currentMembersList.clearSelection();
                }
            }
        };
        this.memberDetailPanel.add(BLANK_CARD, new JPanel());
        this.groupValidator = new DbObjectValidator(){

            public boolean allowLoadUserObject(Class clazz) {
                return (class$com$tridium$eas$api$StaticGroup == null ? (class$com$tridium$eas$api$StaticGroup = StaticGroupDetailPanel.class$("com.tridium.eas.api.StaticGroup")) : class$com$tridium$eas$api$StaticGroup).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Site == null ? (class$com$tridium$eas$api$Site = StaticGroupDetailPanel.class$("com.tridium.eas.api.Site")) : class$com$tridium$eas$api$Site).isAssignableFrom(clazz) || (class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = StaticGroupDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = StaticGroupDetailPanel.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter).isAssignableFrom(clazz);
            }

            public boolean allowShowUserObject(Object object) {
                return !StaticGroupDetailPanel.this.currentMembersList.contains(object) && !object.equals(StaticGroupDetailPanel.this.getGroupEditorValue());
            }
        };
        this.dynGroupValidator = new DbObjectValidator(){

            public boolean allowLoadUserObject(Class clazz) {
                return (class$com$tridium$eas$api$StaticGroup == null ? (class$com$tridium$eas$api$StaticGroup = StaticGroupDetailPanel.class$("com.tridium.eas.api.StaticGroup")) : class$com$tridium$eas$api$StaticGroup).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Site == null ? (class$com$tridium$eas$api$Site = StaticGroupDetailPanel.class$("com.tridium.eas.api.Site")) : class$com$tridium$eas$api$Site).isAssignableFrom(clazz) || (class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = StaticGroupDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = StaticGroupDetailPanel.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter).isAssignableFrom(clazz) || (class$com$tridium$eas$api$DynGroup == null ? (class$com$tridium$eas$api$DynGroup = StaticGroupDetailPanel.class$("com.tridium.eas.api.DynGroup")) : class$com$tridium$eas$api$DynGroup).isAssignableFrom(clazz);
            }

            public boolean allowShowUserObject(Object object) {
                return !StaticGroupDetailPanel.this.currentMembersList.contains(object) && !object.equals(StaticGroupDetailPanel.this.getGroupEditorValue());
            }
        };
        this.siteValidator = new DbObjectValidator(){

            public boolean allowLoadUserObject(Class clazz) {
                return (class$com$tridium$eas$api$Site == null ? (class$com$tridium$eas$api$Site = StaticGroupDetailPanel.class$("com.tridium.eas.api.Site")) : class$com$tridium$eas$api$Site).isAssignableFrom(clazz) || (class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = StaticGroupDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = StaticGroupDetailPanel.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter).isAssignableFrom(clazz);
            }

            public boolean allowShowUserObject(Object object) {
                return !StaticGroupDetailPanel.this.currentMembersList.contains(object) && !object.equals(StaticGroupDetailPanel.this.getGroupEditorValue());
            }
        };
        this.candidates = new GroupTree(this.getResourceManager());
        this.candidates.addTreeSelectionListener(treeSelectionListener);
        this.candidates.setSelectionModel(new GroupMembersTreeSelectionModel());
        this.addEasDataListener(this.candidates);
        JScrollPane jScrollPane2 = new JScrollPane(this.candidates);
        jScrollPane2.getViewport().setBackground(Color.white);
        this.memberDetailPanel.add(this.lex.getText(DYN_GROUPS_CARD), jScrollPane2);
        jPanel2.add((Component)this.memberDetailPanel, "Center");
        this.siteSummaryPanel = new SiteSummaryPanel(this.getResourceManager(), this.lex);
        this.groupSummaryPanel = new StaticGroupSummaryPanel(this.getResourceManager(), this.lex);
        this.dataPointSummaryPanel = new DataPointSummaryPanel(this.lex);
        this.rightPanel.add(this.lex.getText(MEMBERS_CARD), jPanel2);
        this.rightPanel.add(BLANK_CARD, new JPanel());
        this.rightPanel.add(this.lex.getText(SITES_CARD), this.siteSummaryPanel);
        this.rightPanel.add(this.lex.getText(DATA_POINTS_CARD), this.dataPointSummaryPanel);
        this.rightPanel.add(this.lex.getText(GROUPS_CARD), this.groupSummaryPanel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        this.setRightPanelDetails();
        jPanel.add((Component)this.rightPanel, gridBagConstraints);
        this.memberTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.showMemberDetailPanel(StaticGroupDetailPanel.this.memberTypeComboBox.getSelectedItem());
                StaticGroupDetailPanel.this.candidates.clearSelection();
            }
        });
        this.memberTypeComboBox.setSelectedItem(null);
        return jPanel;
    }

    public void setMemberButtonStates() {
        this.addMemberButton.setEnabled(this.canUpdate() && !this.candidates.isSelectionEmpty());
        this.removeMemberButton.setEnabled(this.canUpdate() && !this.currentMembersList.isSelectionEmpty());
    }

    protected JComponent buildMemberButtonPanel() {
        this.memberButtonLayout = new CardLayout();
        this.memberButtonPanel = new JPanel(this.memberButtonLayout, false);
        JPanel jPanel = new JPanel(false);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JButton jButton = new JButton(this.lex.getText("details"));
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.showMemberButtonPanel(StaticGroupDetailPanel.this.lex.getText(StaticGroupDetailPanel.DETAILS_BUTTON_CARD));
                StaticGroupDetailPanel.this.setRightPanelDetails();
            }
        });
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.addMemberButton = new JButton(this.lex.getText("add"));
        this.addMemberButton.setAlignmentX(0.5f);
        this.addMemberButton.setEnabled(false);
        this.addMemberButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.addMembers();
            }
        });
        jPanel.add(this.addMemberButton);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.removeMemberButton = new JButton(this.lex.getText("removeWithDirection"));
        this.removeMemberButton.setAlignmentX(0.5f);
        this.removeMemberButton.setEnabled(false);
        this.removeMemberButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.removeMembers();
            }
        });
        jPanel.add(this.removeMemberButton);
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        this.newSubgroupButton = new JButton(this.lex.getText("newSubgroup"));
        this.newSubgroupButton.setAlignmentX(0.5f);
        this.newSubgroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.createSubgroup();
            }
        });
        jPanel.add(this.newSubgroupButton);
        this.memberButtonPanel.add(this.lex.getText(MEMBERS_CARD), jPanel);
        this.addMemberButton.setMaximumSize(jPanel.getMaximumSize());
        jButton.setMaximumSize(jPanel.getMaximumSize());
        this.removeMemberButton.setMaximumSize(jPanel.getMaximumSize());
        JPanel jPanel2 = new JPanel(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.changeMembersButton = new JButton(this.lex.getText("update"));
        this.changeMembersButton.setAlignmentX(0.5f);
        this.changeMembersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.showMemberButtonPanel(StaticGroupDetailPanel.this.lex.getText(StaticGroupDetailPanel.MEMBERS_CARD));
                StaticGroupDetailPanel.this.setRightPanelDetails();
            }
        });
        jPanel2.add(this.changeMembersButton);
        this.memberButtonPanel.add(this.lex.getText(DETAILS_BUTTON_CARD), jPanel2);
        this.memberButtonLayout.show(this.memberButtonPanel, this.lex.getText(DETAILS_BUTTON_CARD));
        return this.memberButtonPanel;
    }

    protected void showMemberButtonPanel(String string) {
        this.memberButtonTopCard = string;
        this.memberButtonLayout.show(this.memberButtonPanel, string);
    }

    protected void setRightPanelDetails() {
        if (this.memberButtonTopCard == this.lex.getText(MEMBERS_CARD)) {
            this.rightPanelLayout.show(this.rightPanel, this.lex.getText(MEMBERS_CARD));
        } else {
            Object e = this.currentMembersList.getSelectedValue();
            if (e == null) {
                this.rightPanelLayout.show(this.rightPanel, BLANK_CARD);
            } else if (e instanceof Group) {
                Group group = (Group)e;
                if (group instanceof Site) {
                    this.siteSummaryPanel.setSite(group);
                    this.rightPanelLayout.show(this.rightPanel, this.lex.getText(SITES_CARD));
                } else if (group instanceof StaticGroup) {
                    this.groupSummaryPanel.setGroup(group);
                    this.rightPanelLayout.show(this.rightPanel, this.lex.getText(GROUPS_CARD));
                }
            } else if (e instanceof DataPoint) {
                this.dataPointSummaryPanel.setDataPoint((DataPoint)e);
                this.rightPanelLayout.show(this.rightPanel, this.lex.getText(DATA_POINTS_CARD));
            } else {
                this.rightPanelLayout.show(this.rightPanel, BLANK_CARD);
            }
        }
    }

    protected void showMemberDetailPanel(Object object) {
        if (object == null) {
            this.memberDetailLayout.show(this.memberDetailPanel, BLANK_CARD);
        } else if (object instanceof DynGroupListItem) {
            this.candidates.setShowsRootHandles(true);
            this.candidates.setModel(new FilterTreeModel(new FilterRootNode((Filter)new DynamicGroupFilter(this.getSession(), ((DynGroupListItem)object).getDynGroup(), this.lex), this.dynGroupValidator)));
            this.memberDetailLayout.show(this.memberDetailPanel, this.lex.getText(DYN_GROUPS_CARD));
        } else if (object == this.lex.getText(SITES_CARD)) {
            this.candidates.setShowsRootHandles(true);
            this.candidates.setModel(new FilterTreeModel(new FilterRootNode((Filter)new AllSitesFilter(this.getSession(), this.lex), this.siteValidator)));
            this.memberDetailLayout.show(this.memberDetailPanel, this.lex.getText(DYN_GROUPS_CARD));
        } else if (object == this.lex.getText(GROUPS_CARD)) {
            this.candidates.setShowsRootHandles(true);
            this.candidates.setModel(new FilterTreeModel(new FilterRootNode((Filter)new StaticGroupFilter(this.getSession(), this.lex), this.groupValidator)));
            this.memberDetailLayout.show(this.memberDetailPanel, this.lex.getText(DYN_GROUPS_CARD));
        } else {
            this.memberDetailLayout.show(this.memberDetailPanel, object.toString());
        }
    }

    protected JComponent buildDetailsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("groupName")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.nameTextField = new EasTextField(30, 32);
        this.nameTextField.setUseLabelAppearanceWhenDisabled(true);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                StaticGroupDetailPanel.this.setGroupIsDirty(true);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                StaticGroupDetailPanel.this.setGroupIsDirty(true);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                StaticGroupDetailPanel.this.setGroupIsDirty(true);
            }
        });
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.publicCheckBox = new EasCheckBox(this.lex.getText("public"));
        this.publicCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.setGroupIsDirty(true);
            }
        });
        jPanel.add((Component)this.publicCheckBox.getPanel(this.lex.getText("public"), this.lex.getText("private")), gridBagConstraints);
        return jPanel;
    }

    protected Set getCurrentMembers() {
        Group group = this.getGroupEditorValue();
        HashSet<EasObject> hashSet = new HashSet<EasObject>();
        if (group != null) {
            hashSet.add(group);
            DataPoint[] dataPointArray = group.getLinkedDataPoints();
            for (int i = 0; i < dataPointArray.length; ++i) {
                hashSet.add(dataPointArray[i]);
            }
            Group[] groupArray = group.getChildren();
            for (int i = 0; i < groupArray.length; ++i) {
                if (!(groupArray[i] instanceof Site)) continue;
                hashSet.add(groupArray[i]);
            }
        }
        return hashSet;
    }

    public boolean canAdd() {
        if (this.getSession() == null) {
            return false;
        }
        return this.getSession().hasOperatorWrite();
    }

    public boolean canUpdate() {
        if (this.getSession() == null || this.getGroupEditorValue() == null) {
            return false;
        }
        try {
            if (this.getGroupEditorValue().isPublic()) {
                return this.getSession().hasAdminWrite();
            }
            if (this.getSession().hasAdminWrite()) {
                return true;
            }
            return this.getGroupEditorValue().getUserId().equals(this.getSession().getUserName());
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return false;
        }
    }

    public void init(EasSession easSession, DbConfigNavigator dbConfigNavigator) {
        this.layout.show(this, this.lex.getText("hide"));
        String string = easSession.getServerDebugTag();
        super.init(easSession);
        this.navigator = dbConfigNavigator;
        Set set = this.getCurrentMembers();
        this.candidates.init(easSession);
        Group[] groupArray = DynGroup.getGroups(this.getSession());
        for (int i = 0; i < groupArray.length; ++i) {
            try {
                if (groupArray[i].isHidden()) continue;
                this.memberTypeComboBox.addItem(new DynGroupListItem((DynGroup)groupArray[i], this.lex));
                continue;
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
        this.addGroupButton.setEnabled(this.canAdd());
        easSession.setServerDebugTag(string);
    }

    protected void setGroupIsDirty(boolean bl) {
        super.setGroupIsDirty(bl);
        this.applyButton.setEnabled(this.canUpdate() && bl);
        this.discardButton.setEnabled(this.canUpdate() && bl);
        this.addGroupButton.setEnabled(this.canAdd() && !bl);
    }

    protected void saveGroup() throws EasException {
        Group group;
        Iterator iterator;
        Group group2 = this.getGroupEditorValue();
        group2.changeName(this.nameTextField.getText());
        if (this.publicCheckBox.isSelected()) {
            group2.setUserId(BLANK_CARD);
        } else {
            group2.setUserId(this.getSession().getUserName());
        }
        if (!this.subgroupTracker.getRemovedData().isEmpty()) {
            iterator = this.subgroupTracker.getAddedData().iterator();
            while (iterator.hasNext()) {
                group = (Group)iterator.next();
                group.save();
            }
            this.fireDataInserted(new DataEditedEvent((Object)this, this.subgroupTracker.getAddedData().toArray()));
        }
        if (!this.subgroupTracker.getRemovedData().isEmpty()) {
            iterator = this.subgroupTracker.getRemovedData().iterator();
            while (iterator.hasNext()) {
                group = (Group)iterator.next();
                group.save();
                group2.remChild(group);
            }
            this.fireDataRemoved(new DataEditedEvent((Object)this, this.subgroupTracker.getRemovedData().toArray()));
        }
        this.subgroupTracker.clear();
        group2.save();
        if (this.newFlag) {
            this.fireDataInserted(new DataEditedEvent((Object)this, group2));
        } else {
            this.fireDataChanged(new DataEditedEvent((Object)this, group2));
        }
        this.candidates.init(this.getSession());
        this.newFlag = false;
        this.setGroupIsDirty(false);
    }

    public void setGroupEditorValue(Group group) {
        this.setGroupEditorValue(group, true);
    }

    public void setGroupEditorValue(Group group, boolean bl) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.newFlag = false;
        this.setAllowFireEditStarted(false);
        this.currentMembersList.setParent(group);
        if (group == null) {
            super.setGroupEditorValue(group);
            this.layout.show(this, this.lex.getText("hide"));
            this.addGroupButton.setEnabled(this.canAdd());
            this.deleteGroupButton.setEnabled(false);
        } else {
            if (bl) {
                group.loadProperties(true);
                group.loadLinkedDataPoints(true);
                group.restoreChildren();
                group.restoreParents();
            }
            super.setGroupEditorValue(group);
            this.nameTextField.setText(group.getName());
            this.nameTextField.setEnabled(this.canUpdate());
            this.memberTypeComboBox.setSelectedItem(this.lex.getText(GROUPS_CARD));
            this.showMemberButtonPanel(this.lex.getText(DETAILS_BUTTON_CARD));
            this.setRightPanelDetails();
            this.subgroupTracker = new Tracker();
            this.candidates.init(this.getSession());
            this.deleteGroupButton.setEnabled(this.canUpdate());
            this.changeMembersButton.setEnabled(this.canUpdate());
            this.layout.show(this, this.lex.getText("show"));
            this.setGroupIsDirty(false);
            this.setRightPanelDetails();
            try {
                this.publicCheckBox.setSelected(group.isPublic());
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
        this.nameTextField.setEnabled(this.canUpdate());
        this.changeMembersButton.setEnabled(this.canUpdate());
        this.publicCheckBox.setEnabled(false);
        this.setAllowFireEditStarted(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void deleteGroup() {
        if (this.getGroupEditorValue() == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, this.lex.getText("deleteGroupWarning1") + " '" + this.getGroupEditorValue().getName() + "' " + this.lex.getText("deleteGroupWarning2") + "\n" + this.lex.getText("deleteGroupWarning3") + "\n" + this.lex.getText("deleteGroupWarning4"), this.lex.getText("deletingGroup"), 2, 2) == 0) {
            Group group = this.getGroupEditorValue();
            DataEditedEvent dataEditedEvent = new DataEditedEvent((Object)this, group);
            try {
                group.remove();
                group.save();
                this.fireEditingDeleted();
                this.fireDataRemoved(dataEditedEvent);
                this.setGroupEditorValue(null);
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
    }

    public void applyChanges() {
        if (!this.groupDataIsValid()) {
            return;
        }
        try {
            this.saveGroup();
            this.fireEditingStopped();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, this.lex.getText("unrecoverableError"), this.lex.getText("error"), 0);
            this.initApplication();
        }
    }

    public void discardChanges() {
        Iterator iterator = this.subgroupTracker.getAddedData().iterator();
        while (iterator.hasNext()) {
            try {
                ((Group)iterator.next()).remove();
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
        this.subgroupTracker.clear();
        this.getGroupEditorValue().restoreChildren();
        this.getGroupEditorValue().restoreParents();
        this.getGroupEditorValue().loadLinkedDataPoints(true);
        this.cancelGroupEditing();
    }

    public void createSubgroup() {
        Group group = NewGroupDialog.getNewGroup('S', this.getSession(), this, this.lex);
        if (group != null) {
            try {
                this.getGroupEditorValue().addChild(group, this.getGroupEditorValue().getChildren().length);
                ((SortedListModel)this.currentMembersList.getModel()).addElement(group);
                this.subgroupTracker.trackAdd(group);
                this.setGroupIsDirty(true);
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
    }

    public void addMembers() {
        Object[] objectArray = this.candidates.getSelectedUserObjects();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                EasObject easObject;
                if (objectArray[i] instanceof Group) {
                    easObject = (Group)objectArray[i];
                    this.getGroupEditorValue().addChild((Group)easObject, this.getGroupEditorValue().getChildren().length);
                    ((SortedListModel)this.currentMembersList.getModel()).addElement(easObject);
                    if (easObject instanceof StaticGroup) {
                        this.subgroupTracker.trackRemove(easObject);
                    }
                } else if (objectArray[i] instanceof DataPoint) {
                    easObject = (DataPoint)objectArray[i];
                    this.getGroupEditorValue().linkDataPoint((DataPoint)easObject);
                    ((SortedListModel)this.currentMembersList.getModel()).addElement(easObject);
                }
                this.candidates.revalidateUserObject(objectArray[i]);
                continue;
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
        this.setGroupIsDirty(true);
        this.setMemberButtonStates();
    }

    public void removeMembers() {
        if (!this.canUpdate()) {
            return;
        }
        Object[] objectArray = this.currentMembersList.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            EasObject easObject;
            if (objectArray[i] instanceof Group) {
                easObject = (Group)objectArray[i];
                if (easObject instanceof StaticGroup) {
                    this.subgroupTracker.trackRemove(easObject);
                }
                this.getGroupEditorValue().remChild((Group)easObject);
            } else {
                easObject = (DataPoint)objectArray[i];
                this.getGroupEditorValue().unlinkDataPoint((DataPoint)easObject);
            }
            ((SortedListModel)this.currentMembersList.getModel()).removeElement(objectArray[i]);
            this.candidates.revalidateUserObject(objectArray[i]);
        }
        this.setGroupIsDirty(true);
        this.setMemberButtonStates();
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
        boolean bl = this.isFireEditStartedAllowed();
        this.setAllowFireEditStarted(false);
        if (this.getGroupEditorValue() != null) {
            Set set = this.getMyAncestors();
            for (int i = 0; i < dataEditedEvent.getEditedData().length; ++i) {
                if (!(dataEditedEvent.getEditedData()[i] instanceof Group) || !set.contains(dataEditedEvent.getEditedData()[i])) continue;
                this.cancelGroupEditing();
                return;
            }
        }
        super.dataRemoved(dataEditedEvent);
        this.candidates.dataRemoved(dataEditedEvent);
        this.currentMembersList.dataRemoved(dataEditedEvent);
        this.setAllowFireEditStarted(bl);
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        boolean bl = this.isFireEditStartedAllowed();
        this.setAllowFireEditStarted(false);
        super.dataChanged(dataEditedEvent);
        this.candidates.dataChanged(dataEditedEvent);
        this.currentMembersList.dataChanged(dataEditedEvent);
        this.setAllowFireEditStarted(bl);
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        boolean bl = this.isFireEditStartedAllowed();
        this.setAllowFireEditStarted(false);
        super.dataInserted(dataEditedEvent);
        this.candidates.dataInserted(dataEditedEvent);
        this.currentMembersList.dataInserted(dataEditedEvent);
        this.setAllowFireEditStarted(bl);
    }

    private Set getMyAncestors() {
        HashSet hashSet = new HashSet();
        if (this.getGroupEditorValue() == null) {
            return hashSet;
        }
        Group[] groupArray = this.getGroupEditorValue().getParents();
        if (groupArray.length > 0) {
            return this.addAncestors(hashSet, groupArray[0]);
        }
        return hashSet;
    }

    private Set addAncestors(Set set, Group group) {
        set.add(group);
        Group[] groupArray = group.getParents();
        if (groupArray.length > 0) {
            return this.addAncestors(set, groupArray[0]);
        }
        return set;
    }

    public void refreshData() {
        super.refreshData();
    }

    protected void buildToolBar() {
        super.buildToolBar();
        this.addGroupButton = new EasButton(this.getResourceManager(), new int[]{4, 29}, this.lex.getText("newGroup"));
        this.addGroupButton.setEnabled(this.canUpdate());
        this.addGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.addGroup();
            }
        });
        this.addGroupButton.setEnabled(this.canAdd());
        this.getToolBar().add(this.addGroupButton);
        this.deleteGroupButton = new EasButton(this.getResourceManager(), new int[]{4, 16}, this.lex.getText("deleteGroup"));
        this.deleteGroupButton.setEnabled(false);
        this.deleteGroupButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StaticGroupDetailPanel.this.deleteGroup();
            }
        });
        this.getToolBar().add(this.deleteGroupButton);
        this.getToolBar().addSeparator();
        this.addPropertiesToolBarButtons();
    }

    protected boolean groupDataIsValid() {
        if (this.nameTextField.getText() == null || this.nameTextField.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, this.lex.getText("groupNotSaved"), this.lex.getText("errorsInGroup"), 0);
            return false;
        }
        try {
            Group group;
            if ((this.newFlag || !this.nameTextField.getText().equals(this.getGroupEditorValue().getName())) && (group = Group.get(this.nameTextField.getText(), this.getSession())) != null) {
                JOptionPane.showMessageDialog(this, this.lex.getText("theName") + " '" + this.nameTextField.getText() + "' " + this.lex.getText("alreadyInUse"), this.lex.getText("errorsInGroup"), 0);
                return false;
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        return true;
    }

    public void addGroup() {
        this.setGroupEditorValue(StaticGroup.create(this.lex.getText("newGroup"), this.getSession().getUserName(), this.getSession()), false);
        if (this.getSession().hasAdminWrite()) {
            this.publicCheckBox.setSelected(false);
            this.publicCheckBox.setEnabled(true);
        }
        this.nameTextField.requestFocus();
        this.nameTextField.selectAll();
        this.showMemberButtonPanel(this.lex.getText(MEMBERS_CARD));
        this.setRightPanelDetails();
        this.setAllowFireEditStarted(true);
        this.setGroupIsDirty(true);
        this.newFlag = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MemberPopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;

        public MemberPopup() {
            this.add(new EasPopupMenu.EasPopupMenuItem(StaticGroupDetailPanel.this.lex.getText("newSubgroup"), 0, null));
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(StaticGroupDetailPanel.this.lex.getText("removeMember"), 1, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    StaticGroupDetailPanel.this.createSubgroup();
                    break;
                }
                case 1: {
                    StaticGroupDetailPanel.this.removeMembers();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            if (bl && !this.deleteItemShowing) {
                this.add(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            super.show(component, n, n2);
        }
    }

    private static class DynGroupListItem {
        private DynGroup group;
        private Lexicon lex;

        public DynGroupListItem(DynGroup dynGroup, Lexicon lexicon) {
            this.group = dynGroup;
            this.lex = lexicon;
        }

        public DynGroup getDynGroup() {
            return this.group;
        }

        public String toString() {
            return this.lex.getText(EasUiUtil.replace(this.group.getName(), " ", StaticGroupDetailPanel.BLANK_CARD));
        }
    }
}

