/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.Group;
import com.tridium.eas.api.Property;
import com.tridium.eas.ui.EasUiUtil;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.GroupPropertiesTable;
import com.tridium.eas.ui.dbconfig.GroupPropertiesTableModel;
import com.tridium.eas.ui.widgets.EasTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SiteSummaryPanel
extends JPanel {
    private JLabel nameLabel = null;
    private JLabel floorAreaValueLabel = null;
    private JLabel address1Label = null;
    private JLabel address2Label = null;
    private JLabel address3Label = null;
    private GroupPropertiesTableModel propertiesTableModel = null;
    private EasTable propertiesTable = null;
    private Lexicon lex;

    public SiteSummaryPanel(ResourceManager resourceManager, Lexicon lexicon) {
        this.lex = lexicon;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.nameLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("address")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.address1Label = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.address1Label, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.address2Label = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.address2Label, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.address3Label = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.address3Label, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("floorArea")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        this.floorAreaValueLabel = EasUiUtil.createDataLabel();
        jPanel.add((Component)this.floorAreaValueLabel, gridBagConstraints);
        this.add(jPanel);
        this.propertiesTableModel = new GroupPropertiesTableModel(new String[]{"addr1", "addr2", "city", "stateprov", "countrycd", "postalcd", "floorarea"}, lexicon);
        this.propertiesTable = new GroupPropertiesTable(resourceManager, this.propertiesTableModel, lexicon);
        this.propertiesTable.setEnabled(false);
        this.add(this.propertiesTable.getScrollPane());
    }

    public void setSite(Group group) {
        Property property = group.getProperty("floorarea");
        BUnit bUnit = BUnit.getUnit((String)property.getUnit());
        this.nameLabel.setText(group.getName());
        this.floorAreaValueLabel.setText(property.getValue() + " " + bUnit.toString());
        this.address1Label.setText(group.getProperty("addr1").getValue());
        this.address2Label.setText(group.getProperty("addr2").getValue());
        StringBuffer stringBuffer = new StringBuffer(group.getProperty("city").getValue());
        String string = group.getProperty("stateprov").getValue();
        if (string != null && string.trim().length() > 0) {
            stringBuffer.append(", ");
            stringBuffer.append(string);
        }
        if ((string = group.getProperty("countrycd").getValue()) != null && string.trim().length() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        if ((string = group.getProperty("postalcd").getValue()) != null && string.trim().length() > 0) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        this.address3Label.setText(stringBuffer.toString());
        this.propertiesTableModel.setGroup(group);
    }
}

