/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Property;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.GroupDetailPanel;
import com.tridium.eas.ui.dbconfig.GroupEditor;
import com.tridium.eas.ui.dbconfig.LinkedDataPointValidator;
import com.tridium.eas.ui.dbconfig.MeterChoiceDialog;
import com.tridium.eas.ui.dbconfig.MeterTypeRadioGroup;
import com.tridium.eas.ui.dbconfig.NewDataPointDialog;
import com.tridium.eas.ui.dbconfig.NewMeterDialog;
import com.tridium.eas.ui.dbconfig.Tracker;
import com.tridium.eas.ui.widgets.ClassSelectionModel;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.DbObjectValidator;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.EasScrollPane;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeDialog;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import com.tridium.eas.ui.widgets.FilterTreePopupHandler;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.RcSubtypeWidget;
import com.tridium.eas.ui.widgets.SiteFilter;
import com.tridium.eas.ui.widgets.TopLevelFilter;
import com.tridium.eas.ui.widgets.UnitComboBox;
import com.tridium.eas.xml.XmlMessage;
import com.tridium.eas.xml.XmlSupport;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.baja.history.BHistoryId;
import javax.baja.naming.SlotPath;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class SiteDetailPanel
extends GroupDetailPanel
implements GroupEditor,
DocumentListener,
DbObjectValidator {
    private JButton addDataPointButton = null;
    private JButton linkDataPointButton = null;
    private JButton addMeterButton = null;
    private JButton delDataPointButton = null;
    private JButton delMeterButton = null;
    private JButton applyButton = null;
    private JButton discardChangesButton = null;
    private JButton delSiteButton = null;
    private JButton newButton = null;
    private UnitComboBox floorAreaUnitComboBox = null;
    private EasTextField nameTextField = null;
    private NumberTextField floorAreaValueTextField = null;
    private EasTextField address1TextField = null;
    private EasTextField address2TextField = null;
    private EasTextField cityTextField = null;
    private EasTextField stateProvinceTextField = null;
    private EasTextField zipPostalTextField = null;
    private EasTextField countryTextField = null;
    private Tracker dpTracker = null;
    private boolean newFlag = false;
    private DataPointPopup dataPointPopup = null;
    private CardLayout layout = null;
    private JPanel dpSelectionPanel = null;
    private FilterTree dpTree = null;
    private JLabel dpSourceLabel = null;
    private EasTextField dpDescTextField = null;
    private NumberTextField dpFloorAreaValueTextField = null;
    private UnitComboBox dpFloorAreaUnitComboBox = null;
    private RcSubtypeWidget dpTypeWidget = null;
    private CardLayout dpMeterLayout = null;
    private JPanel dpMeterPanel = null;
    private HashMap logCache = new HashMap();
    private HashMap availableLogNames = null;
    private boolean initializingDpValues = false;
    private Tracker meterTracker = null;
    private JCheckBox mainMeterCheckBox = null;
    private JCheckBox mainDataPointCheckBox = null;
    private EasScrollPane upperPanelScrollPane = null;
    private EasTextField meterNameTextField = null;
    private EasTextField meterDescrTextField = null;
    private NumberTextField meterFloorAreaValueTextField = null;
    private UnitComboBox meterFloorAreaUnitComboBox = null;
    private MeterTypeRadioGroup meterTypeButtonGroup = null;
    private boolean initializingMeterValues = false;
    private boolean initFloorArea = false;
    private boolean checkDemoMode = false;
    private boolean demoMode = false;
    public static final String DATA_POINT_CARD = "showDataPoints";
    public static final String METER_CARD = "meterDetail";
    public static final String BLANK_CARD = "blank";
    static /* synthetic */ Class class$com$tridium$eas$api$DataPoint;
    static /* synthetic */ Class class$com$tridium$eas$api$Meter;
    static /* synthetic */ Class class$com$tridium$eas$api$Site;

    public SiteDetailPanel(ResourceManager resourceManager, EasApplication easApplication, Lexicon lexicon) {
        super(resourceManager, easApplication, lexicon);
        this.setAllowFireEditStarted(false);
        this.buildToolBar();
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add(lexicon.getText("show"), jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.add(lexicon.getText("hide"), jPanel2);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        jPanel3.add((Component)this.buildSitePropertiesPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        jPanel3.add((Component)this.buildDataPointsPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        JPanel jPanel4 = new JPanel(new BorderLayout(), false);
        jPanel4.setBorder(BorderFactory.createTitledBorder(lexicon.getText("siteProperties")));
        jPanel4.add((Component)this.buildGroupPropertiesPanel(new String[]{"addr1", "addr2", "city", "stateprov", "countrycd", "postalcd", "floorarea"}), "Center");
        jPanel4.setPreferredSize(new Dimension(jPanel4.getMinimumSize().width, 90));
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        this.upperPanelScrollPane = new EasScrollPane(jPanel3);
        this.upperPanelScrollPane.getViewport().setBackground(Color.white);
        jPanel.add((Component)this.upperPanelScrollPane, "Center");
        JPanel jPanel5 = new JPanel(new FlowLayout(1), false);
        this.applyButton = new JButton(lexicon.getText("applyChanges"));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.discardChangesButton.setEnabled(false);
                SiteDetailPanel.this.applyButton.setEnabled(false);
                SiteDetailPanel.this.applyChanges();
            }
        });
        jPanel5.add(this.applyButton);
        this.discardChangesButton = new JButton(lexicon.getText("discardChanges"));
        this.discardChangesButton.setEnabled(false);
        this.discardChangesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.applyButton.setEnabled(false);
                SiteDetailPanel.this.discardChangesButton.setEnabled(false);
                SiteDetailPanel.this.cancelGroupEditing();
            }
        });
        jPanel5.add(this.discardChangesButton);
        jPanel.add((Component)jPanel5, "South");
        this.setGroupEditorValue(null);
        this.setAllowFireEditStarted(true);
    }

    protected void buildToolBar() {
        super.buildToolBar();
        this.newButton = new EasButton(this.getResourceManager(), new int[]{7, 29}, this.lex.getText("createNewSite"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.createNewSite();
            }
        });
        this.getToolBar().add(this.newButton);
        this.delSiteButton = new EasButton(this.getResourceManager(), new int[]{7, 16}, this.lex.getText("deleteSite"));
        this.delSiteButton.setEnabled(false);
        this.delSiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.deleteSite();
            }
        });
        this.getToolBar().add(this.delSiteButton);
        this.getToolBar().addSeparator();
        this.addMeterButton = new EasButton(this.getResourceManager(), new int[]{26, 29}, this.lex.getText("newMeter"));
        this.addMeterButton.setEnabled(false);
        this.addMeterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.addMeter();
            }
        });
        this.getToolBar().add(this.addMeterButton);
        this.delMeterButton = new EasButton(this.getResourceManager(), new int[]{26, 16}, this.lex.getText("deleteMeter"));
        this.delMeterButton.setEnabled(false);
        this.delMeterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.deleteMeter();
            }
        });
        this.getToolBar().add(this.delMeterButton);
        this.getToolBar().addSeparator();
        this.addDataPointButton = new EasButton(this.getResourceManager(), new int[]{10, 29}, this.lex.getText("newDataPoint"));
        this.addDataPointButton.setEnabled(false);
        this.addDataPointButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.addDataPoint();
            }
        });
        this.getToolBar().add(this.addDataPointButton);
        this.linkDataPointButton = new EasButton(this.getResourceManager(), new int[]{10, 14}, this.lex.getText("linkDataPoint"));
        this.linkDataPointButton.setEnabled(false);
        this.linkDataPointButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.linkDataPoint();
            }
        });
        this.getToolBar().add(this.linkDataPointButton);
        this.delDataPointButton = new EasButton(this.getResourceManager(), new int[]{10, 16}, this.lex.getText("deleteDataPoint"));
        this.delDataPointButton.setEnabled(false);
        this.delDataPointButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.deleteDataPoint();
            }
        });
        this.getToolBar().add(this.delDataPointButton);
        this.getToolBar().addSeparator();
        this.addPropertiesToolBarButtons();
    }

    protected JComponent buildSitePropertiesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("siteDetails")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.nameTextField = new EasTextField(15, 32);
        this.nameTextField.setUseLabelAppearanceWhenDisabled(true);
        this.nameTextField.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("address")), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.address1TextField = new EasTextField();
        this.address1TextField.setMaxLength(32);
        this.address1TextField.setUseLabelAppearanceWhenDisabled(true);
        this.address1TextField.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.address1TextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("floorArea")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.floorAreaValueTextField = new NumberTextField(5);
        this.floorAreaValueTextField.setAllowNegative(false);
        this.floorAreaValueTextField.setUseLabelAppearanceWhenDisabled(true);
        this.floorAreaValueTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                try {
                    if (!SiteDetailPanel.this.initFloorArea) {
                        SiteDetailPanel.this.updateFloorAreaProperty();
                    }
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
                SiteDetailPanel.this.setDataPointFloorAreaData();
                SiteDetailPanel.this.setGroupIsDirty(true);
            }
        });
        this.floorAreaValueTextField.setMinimumSize(this.floorAreaValueTextField.getPreferredSize());
        jPanel.add((Component)this.floorAreaValueTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        this.floorAreaUnitComboBox = new UnitComboBox(new BUnit[]{BUnit.getUnit((String)"square foot"), BUnit.getUnit((String)"square meter")}, this.lex);
        this.floorAreaUnitComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SiteDetailPanel.this.setDataPointFloorAreaData();
                SiteDetailPanel.this.setGroupIsDirty(true);
            }
        });
        jPanel.add((Component)this.floorAreaUnitComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.address2TextField = new EasTextField();
        this.address2TextField.setMaxLength(32);
        this.address2TextField.setUseLabelAppearanceWhenDisabled(true);
        this.address2TextField.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.address2TextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("city")), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.cityTextField = new EasTextField(10, 32);
        this.cityTextField.setUseLabelAppearanceWhenDisabled(true);
        this.cityTextField.getDocument().addDocumentListener(this);
        this.cityTextField.setMinimumSize(this.cityTextField.getPreferredSize());
        jPanel.add((Component)this.cityTextField, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("stateProvince")), gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.stateProvinceTextField = new EasTextField(2, 32);
        this.stateProvinceTextField.setUseLabelAppearanceWhenDisabled(true);
        this.stateProvinceTextField.setMinimumSize(this.stateProvinceTextField.getPreferredSize());
        this.stateProvinceTextField.getDocument().addDocumentListener(this);
        this.stateProvinceTextField.setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent jComponent) {
                if (SiteDetailPanel.this.stateProvinceTextField.getText() != null) {
                    SiteDetailPanel.this.stateProvinceTextField.setText(SiteDetailPanel.this.stateProvinceTextField.getText().toUpperCase());
                }
                return true;
            }
        });
        jPanel.add((Component)this.stateProvinceTextField, gridBagConstraints);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("zipPostal")), gridBagConstraints);
        gridBagConstraints.gridx = 8;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.zipPostalTextField = new EasTextField(5, 10);
        this.zipPostalTextField.setUseLabelAppearanceWhenDisabled(true);
        this.zipPostalTextField.getDocument().addDocumentListener(this);
        this.zipPostalTextField.setMinimumSize(this.zipPostalTextField.getPreferredSize());
        jPanel.add((Component)this.zipPostalTextField, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("country")), gridBagConstraints);
        gridBagConstraints.gridx = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.countryTextField = new EasTextField(3, 3);
        this.countryTextField.setUseLabelAppearanceWhenDisabled(true);
        this.countryTextField.getDocument().addDocumentListener(this);
        this.countryTextField.setMinimumSize(this.countryTextField.getPreferredSize());
        jPanel.add((Component)this.countryTextField, gridBagConstraints);
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                SiteDetailPanel.this.getPropertiesTable().clearSelection();
                JComponent jComponent = (JComponent)focusEvent.getSource();
                SiteDetailPanel.this.upperPanelScrollPane.makeVisible(jComponent);
            }
        };
        this.nameTextField.setNextFocusableComponent(this.address1TextField);
        this.address1TextField.setNextFocusableComponent(this.address2TextField);
        this.address2TextField.setNextFocusableComponent(this.cityTextField);
        this.cityTextField.setNextFocusableComponent(this.stateProvinceTextField);
        this.stateProvinceTextField.setNextFocusableComponent(this.zipPostalTextField);
        this.zipPostalTextField.setNextFocusableComponent(this.countryTextField);
        this.countryTextField.setNextFocusableComponent(this.floorAreaValueTextField);
        this.floorAreaValueTextField.setNextFocusableComponent(this.floorAreaUnitComboBox);
        this.floorAreaUnitComboBox.setNextFocusableComponent(this.nameTextField);
        this.nameTextField.addFocusListener(focusAdapter);
        this.address1TextField.addFocusListener(focusAdapter);
        this.address2TextField.addFocusListener(focusAdapter);
        this.cityTextField.addFocusListener(focusAdapter);
        this.stateProvinceTextField.addFocusListener(focusAdapter);
        this.zipPostalTextField.addFocusListener(focusAdapter);
        this.countryTextField.addFocusListener(focusAdapter);
        this.floorAreaValueTextField.addFocusListener(focusAdapter);
        this.floorAreaUnitComboBox.addFocusListener(focusAdapter);
        return jPanel;
    }

    public Site getSite() {
        return (Site)this.getGroupEditorValue();
    }

    public void refreshData() {
        super.refreshData();
        Site site = this.getSite();
        if (site != null) {
            try {
                site.loadOwnedDataPoints(true);
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
    }

    protected Set getMyData() {
        Set set = super.getMyData();
        if (this.getSite() != null) {
            try {
                this.addToSet(set, this.getSite().getOwnedDataPoints());
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
        return set;
    }

    public boolean canUpdate() {
        return this.getSite() != null && this.canAdd();
    }

    public boolean canAdd() {
        if (this.getSession() == null) {
            return false;
        }
        return this.getSession().hasAdminWrite();
    }

    private boolean isDemoMode() {
        if (!this.checkDemoMode) {
            this.demoMode = !Meter.isEasCostLicensed(this.getSession()) && !Meter.isEasE2Licensed(this.getSession());
            this.checkDemoMode = true;
        }
        return this.demoMode;
    }

    public void enforceSecurity() {
        super.enforceSecurity();
        this.newButton.setEnabled(this.canAdd());
        this.dpDescTextField.setEnabled(this.canUpdate());
        this.dpFloorAreaValueTextField.setEnabled(this.canUpdate());
        this.dpFloorAreaUnitComboBox.setEnabled(this.canUpdate());
        this.dpTypeWidget.setEnabled(this.canUpdate());
        this.floorAreaUnitComboBox.setEnabled(this.canUpdate());
        this.nameTextField.setEnabled(this.canUpdate());
        this.floorAreaValueTextField.setEnabled(this.canUpdate());
        this.address1TextField.setEnabled(this.canUpdate());
        this.address2TextField.setEnabled(this.canUpdate());
        this.cityTextField.setEnabled(this.canUpdate());
        this.stateProvinceTextField.setEnabled(this.canUpdate());
        this.zipPostalTextField.setEnabled(this.canUpdate());
        this.countryTextField.setEnabled(this.canUpdate());
    }

    protected JComponent buildDataPointsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        this.dpTree = new FilterTree(this.getResourceManager());
        this.dpTree.setPopupHandler(new FilterTreePopupHandler(){

            public void openPopup(FilterTree filterTree, FilterTreeNode filterTreeNode, int n, int n2) {
                if (filterTree.isEnabled()) {
                    if (SiteDetailPanel.this.dataPointPopup == null) {
                        SiteDetailPanel.this.dataPointPopup = new DataPointPopup();
                    }
                    SiteDetailPanel.this.dataPointPopup.show(filterTree, filterTreeNode, n, n2);
                }
            }
        });
        this.dpTree.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    if (SiteDetailPanel.this.dpTree.isSelected(class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = SiteDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint)) {
                        SiteDetailPanel.this.deleteDataPoint();
                    } else if (SiteDetailPanel.this.dpTree.isSelected(class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = SiteDetailPanel.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter)) {
                        SiteDetailPanel.this.deleteMeter();
                    }
                }
            }
        });
        this.dpTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SiteDetailPanel.this.delDataPointButton.setEnabled(SiteDetailPanel.this.canUpdate() && SiteDetailPanel.this.dpTree.isSelected(class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = SiteDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint));
                SiteDetailPanel.this.delMeterButton.setEnabled(SiteDetailPanel.this.canUpdate() && SiteDetailPanel.this.dpTree.isSelected(class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = SiteDetailPanel.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter));
                SiteDetailPanel.this.showDpTreeNodeDetails();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.dpTree);
        jScrollPane.getViewport().setMaximumSize(new Dimension(205, (int)jScrollPane.getViewport().getPreferredSize().getHeight()));
        jScrollPane.getViewport().setPreferredSize(new Dimension(205, 60));
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        this.dpMeterLayout = new CardLayout();
        this.dpMeterPanel = new JPanel(this.dpMeterLayout, false);
        this.dpMeterPanel.add((Component)new JPanel(), this.lex.getText(BLANK_CARD));
        this.dpMeterPanel.add((Component)this.buildDataPointDetailPanel(), this.lex.getText(DATA_POINT_CARD));
        this.dpMeterPanel.add((Component)this.buildMeterDetailPanel(), this.lex.getText(METER_CARD));
        this.dpMeterLayout.show(this.dpMeterPanel, this.lex.getText(DATA_POINT_CARD));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this.dpMeterPanel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        jPanel2.add(Box.createHorizontalGlue(), gridBagConstraints);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel3.add((Component)jPanel, "Center");
        return jPanel3;
    }

    protected void showDpTreeNodeDetails() {
        boolean bl = this.isFireEditStartedAllowed();
        this.setAllowFireEditStarted(false);
        if (this.dpTree.isSelected(class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = SiteDetailPanel.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter)) {
            this.initializingMeterValues = true;
            this.dpMeterLayout.show(this.dpMeterPanel, this.lex.getText(METER_CARD));
            Meter meter = (Meter)this.dpTree.getSelectedUserObject();
            try {
                this.meterNameTextField.setEnabled(this.canUpdate());
                this.meterDescrTextField.setEnabled(this.canUpdate());
                this.meterFloorAreaValueTextField.setEnabled(this.canUpdate() && !meter.isMain());
                this.meterFloorAreaUnitComboBox.setEnabled(this.canUpdate() && !meter.isMain());
                this.meterTypeButtonGroup.setEnabled(this.canUpdate());
                Meter[] meterArray = this.getSite().getMeters();
                if (meter.getRcTypeObj() == RcType.OTHER) {
                    this.mainMeterCheckBox.setSelected(false);
                    meter.setMain(false);
                    this.mainMeterCheckBox.setEnabled(false);
                } else {
                    this.mainMeterCheckBox.setSelected(meter.isMain());
                    this.mainMeterCheckBox.setEnabled(this.canUpdate());
                    for (int i = 0; i < meterArray.length; ++i) {
                        if (meterArray[i].equals(meter) || !meterArray[i].isMain() || meterArray[i].getRcTypeObj() != meter.getRcTypeObj()) continue;
                        this.mainMeterCheckBox.setSelected(false);
                        meter.setMain(false);
                        this.mainMeterCheckBox.setEnabled(false);
                    }
                }
                this.meterNameTextField.setText(meter.getName());
                this.meterDescrTextField.setText(meter.getDescr());
                this.meterFloorAreaValueTextField.setText(meter.getFloorAreaValue());
                this.meterFloorAreaUnitComboBox.setSelectedUnit(meter.getFloorAreaUnit());
                this.meterTypeButtonGroup.setRcType(meter.getRcTypeObj());
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
            this.initializingMeterValues = false;
        } else if (this.dpTree.isSelected(class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = SiteDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint)) {
            this.initializingDpValues = true;
            this.dpMeterLayout.show(this.dpMeterPanel, this.lex.getText(DATA_POINT_CARD));
            DataPoint dataPoint = (DataPoint)this.dpTree.getSelectedUserObject();
            boolean bl2 = !this.dataPointIsLinked(dataPoint);
            try {
                Object object;
                Group[] groupArray = dataPoint.getLinkedGroups();
                boolean bl3 = groupArray == null || groupArray.length == 0;
                this.dpDescTextField.setEnabled(this.canUpdate() && bl2);
                this.dpTypeWidget.setEnabled(this.canUpdate() && bl2);
                this.mainDataPointCheckBox.setSelected(dataPoint.isMain());
                Meter meter = dataPoint.getMeter();
                if (meter == null) {
                    this.dpTypeWidget.removeConstraints();
                } else {
                    dataPoint.setRcType(meter.getRcTypeObj());
                    this.dpTypeWidget.constrainRcType(meter.getRcTypeObj());
                }
                this.dpTypeWidget.setSelection(dataPoint.getRcTypeObj(), dataPoint.getRcSubTypeObj());
                if (this.dpTypeWidget.getSelectedRcType() == RcType.OTHER || this.dpTypeWidget.getSelectedRcSubtype() == RcSubtype.OTHER && this.dpTypeWidget.getSelectedRcType().getValidSubtypes().length > 1) {
                    this.mainDataPointCheckBox.setSelected(false);
                    dataPoint.setMain(false);
                    this.mainDataPointCheckBox.setEnabled(false);
                } else {
                    int n;
                    this.mainDataPointCheckBox.setEnabled(this.canUpdate() && bl2 && bl3);
                    object = this.getSite().getOwnedDataPoints();
                    for (n = 0; n < ((DataPoint[])object).length; ++n) {
                        if (object[n].equals(dataPoint) || !object[n].isMain() || object[n].getRcTypeObj() != this.dpTypeWidget.getSelectedRcType() || object[n].getRcSubTypeObj() != this.dpTypeWidget.getSelectedRcSubtype()) continue;
                        this.mainDataPointCheckBox.setSelected(false);
                        dataPoint.setMain(false);
                        this.mainDataPointCheckBox.setEnabled(false);
                    }
                    object = this.getSite().getLinkedDataPoints();
                    for (n = 0; n < ((DataPoint[])object).length; ++n) {
                        if (object[n].equals(dataPoint) || !object[n].isMain() || object[n].getRcTypeObj() != this.dpTypeWidget.getSelectedRcType() || object[n].getRcSubTypeObj() != this.dpTypeWidget.getSelectedRcSubtype()) continue;
                        this.mainDataPointCheckBox.setSelected(false);
                        dataPoint.setMain(false);
                        this.mainDataPointCheckBox.setEnabled(false);
                    }
                }
                this.dpFloorAreaValueTextField.setEnabled(this.canUpdate() && !dataPoint.isMain() && bl2);
                this.dpFloorAreaUnitComboBox.setEnabled(this.canUpdate() && !dataPoint.isMain() && bl2);
                object = SlotPath.unescape((String)dataPoint.getName());
                this.dpSourceLabel.setText(this.getShortDPSource((String)object));
                this.dpSourceLabel.setToolTipText((String)object);
                this.dpDescTextField.setText(dataPoint.getDescr());
                this.dpFloorAreaValueTextField.setText(dataPoint.getFloorAreaValue());
                this.dpFloorAreaUnitComboBox.setSelectedUnit(dataPoint.getFloorAreaUnit());
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
            this.initializingDpValues = false;
        } else {
            this.dpMeterLayout.show(this.dpMeterPanel, this.lex.getText(BLANK_CARD));
        }
        this.setAllowFireEditStarted(bl);
    }

    protected String getShortDPSource(String string) {
        if (string.length() > 50) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 22));
            stringBuffer.append("...");
            stringBuffer.append(string.substring(string.length() - 25));
            return stringBuffer.toString();
        }
        return string;
    }

    protected void handleSelectedMeterChange() {
        if (this.initializingMeterValues) {
            return;
        }
        Meter meter = (Meter)this.dpTree.getSelectedUserObject();
        try {
            if (meter.getRcTypeObj() == RcType.OTHER) {
                this.mainMeterCheckBox.setEnabled(false);
                meter.setMain(false);
                this.mainMeterCheckBox.setSelected(false);
            } else {
                Meter[] meterArray = this.getSite().getMeters();
                this.mainMeterCheckBox.setEnabled(this.canUpdate());
                for (int i = 0; i < meterArray.length; ++i) {
                    if (!meterArray[i].isMain() || meterArray[i] == meter || meterArray[i].getRcTypeObj() != meter.getRcTypeObj()) continue;
                    this.mainMeterCheckBox.setEnabled(false);
                    meter.setMain(false);
                    this.mainMeterCheckBox.setSelected(false);
                }
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
            this.mainMeterCheckBox.setEnabled(false);
            this.mainMeterCheckBox.setSelected(false);
        }
        this.dpTree.refreshUserObject(this.dpTree.getSelectedUserObject());
        if (this.isFireEditStartedAllowed()) {
            this.setGroupIsDirty(true);
            this.meterTracker.trackUpdate((Meter)this.dpTree.getSelectedUserObject());
        }
    }

    protected void handleSelectedDataPointChange() {
        if (this.initializingDpValues) {
            return;
        }
        this.dpTree.refreshUserObject(this.dpTree.getSelectedUserObject());
        if (this.isFireEditStartedAllowed()) {
            this.setGroupIsDirty(true);
            this.dpTracker.trackUpdate((DataPoint)this.dpTree.getSelectedUserObject());
        }
    }

    protected JComponent buildMeterDetailPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("name")), gridBagConstraints);
        this.meterNameTextField = new EasTextField(20, 32);
        this.meterNameTextField.setUseLabelAppearanceWhenDisabled(true);
        this.meterNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (SiteDetailPanel.this.initializingMeterValues) {
                    return;
                }
                try {
                    ((Meter)SiteDetailPanel.this.dpTree.getSelectedUserObject()).setName(SiteDetailPanel.this.meterNameTextField.getText());
                    SiteDetailPanel.this.handleSelectedMeterChange();
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.meterNameTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("floorArea")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.meterFloorAreaValueTextField = new NumberTextField(10);
        this.meterFloorAreaValueTextField.setAllowNegative(false);
        this.meterFloorAreaValueTextField.setUseLabelAppearanceWhenDisabled(true);
        this.meterFloorAreaValueTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (SiteDetailPanel.this.initializingMeterValues) {
                    return;
                }
                try {
                    ((Meter)SiteDetailPanel.this.dpTree.getSelectedUserObject()).setFloorAreaValue(SiteDetailPanel.this.meterFloorAreaValueTextField.getDoubleValue());
                    SiteDetailPanel.this.handleSelectedMeterChange();
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
            }
        });
        jPanel.add((Component)this.meterFloorAreaValueTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.meterFloorAreaUnitComboBox = new UnitComboBox(new BUnit[]{BUnit.getUnit((String)"square foot"), BUnit.getUnit((String)"square meter")}, this.lex);
        this.meterFloorAreaUnitComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SiteDetailPanel.this.initializingMeterValues) {
                    return;
                }
                try {
                    ((Meter)SiteDetailPanel.this.dpTree.getSelectedUserObject()).setFloorAreaUnit(SiteDetailPanel.this.meterFloorAreaUnitComboBox.getSelectedUnit());
                    SiteDetailPanel.this.handleSelectedMeterChange();
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
            }
        });
        jPanel.add((Component)this.meterFloorAreaUnitComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("description")), gridBagConstraints);
        this.meterDescrTextField = new EasTextField(20, 100);
        this.meterDescrTextField.setUseLabelAppearanceWhenDisabled(true);
        this.meterDescrTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (SiteDetailPanel.this.initializingMeterValues) {
                    return;
                }
                try {
                    ((Meter)SiteDetailPanel.this.dpTree.getSelectedUserObject()).setDescr(SiteDetailPanel.this.meterDescrTextField.getText());
                    SiteDetailPanel.this.handleSelectedMeterChange();
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.meterDescrTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)new JLabel(this.lex.getText("type")), gridBagConstraints);
        this.meterTypeButtonGroup = new MeterTypeRadioGroup(3, this.lex);
        this.meterTypeButtonGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SiteDetailPanel.this.initializingMeterValues) {
                    return;
                }
                try {
                    ((Meter)SiteDetailPanel.this.dpTree.getSelectedUserObject()).setRcType(SiteDetailPanel.this.meterTypeButtonGroup.getRcType());
                    SiteDetailPanel.this.handleSelectedMeterChange();
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.meterTypeButtonGroup.getPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.mainMeterCheckBox = new JCheckBox(this.lex.getText("mainMeter"));
        this.mainMeterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SiteDetailPanel.this.initializingDpValues) {
                    return;
                }
                try {
                    Meter meter = (Meter)SiteDetailPanel.this.dpTree.getSelectedUserObject();
                    meter.setMain(SiteDetailPanel.this.mainMeterCheckBox.isSelected());
                    if (meter.isMain()) {
                        SiteDetailPanel.this.meterFloorAreaValueTextField.setText(SiteDetailPanel.this.floorAreaValueTextField.getDoubleValue());
                        SiteDetailPanel.this.meterFloorAreaUnitComboBox.setSelectedUnit(SiteDetailPanel.this.floorAreaUnitComboBox.getSelectedUnit());
                    }
                    SiteDetailPanel.this.meterFloorAreaValueTextField.setEnabled(SiteDetailPanel.this.canUpdate() && !meter.isMain());
                    SiteDetailPanel.this.meterFloorAreaUnitComboBox.setEnabled(SiteDetailPanel.this.canUpdate() && !meter.isMain());
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
                SiteDetailPanel.this.handleSelectedMeterChange();
            }
        });
        jPanel.add((Component)this.mainMeterCheckBox, gridBagConstraints);
        return jPanel;
    }

    protected JComponent buildDataPointDetailPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("description")), gridBagConstraints);
        this.dpDescTextField = new EasTextField(20, 100);
        this.dpDescTextField.setUseLabelAppearanceWhenDisabled(true);
        this.dpDescTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (SiteDetailPanel.this.initializingDpValues) {
                    return;
                }
                try {
                    ((DataPoint)SiteDetailPanel.this.dpTree.getSelectedUserObject()).setDescr(SiteDetailPanel.this.dpDescTextField.getText());
                    SiteDetailPanel.this.handleSelectedDataPointChange();
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.dpDescTextField, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("source")), gridBagConstraints);
        this.dpSourceLabel = new JLabel();
        this.dpSourceLabel.setForeground(Color.darkGray);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.dpSourceLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("floorArea")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.dpFloorAreaValueTextField = new NumberTextField(10);
        this.dpFloorAreaValueTextField.setAllowNegative(false);
        this.dpFloorAreaValueTextField.setUseLabelAppearanceWhenDisabled(true);
        this.dpFloorAreaValueTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (SiteDetailPanel.this.initializingDpValues) {
                    return;
                }
                try {
                    ((DataPoint)SiteDetailPanel.this.dpTree.getSelectedUserObject()).setFloorAreaValue(SiteDetailPanel.this.dpFloorAreaValueTextField.getDoubleValue());
                    SiteDetailPanel.this.handleSelectedDataPointChange();
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
            }
        });
        jPanel.add((Component)this.dpFloorAreaValueTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.dpFloorAreaUnitComboBox = new UnitComboBox(new BUnit[]{BUnit.getUnit((String)"square foot"), BUnit.getUnit((String)"square meter")}, this.lex);
        this.dpFloorAreaUnitComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SiteDetailPanel.this.initializingDpValues) {
                    return;
                }
                try {
                    ((DataPoint)SiteDetailPanel.this.dpTree.getSelectedUserObject()).setFloorAreaUnit(SiteDetailPanel.this.dpFloorAreaUnitComboBox.getSelectedUnit());
                    SiteDetailPanel.this.handleSelectedDataPointChange();
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
            }
        });
        jPanel.add((Component)this.dpFloorAreaUnitComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)new JLabel(this.lex.getText("type")), gridBagConstraints);
        this.dpTypeWidget = new RcSubtypeWidget(this.getResourceManager(), this.lex);
        this.dpTypeWidget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SiteDetailPanel.this.initializingDpValues) {
                    return;
                }
                try {
                    DataPoint dataPoint = (DataPoint)SiteDetailPanel.this.dpTree.getSelectedUserObject();
                    dataPoint.setRcType(SiteDetailPanel.this.dpTypeWidget.getSelectedRcType());
                    dataPoint.setRcSubType(SiteDetailPanel.this.dpTypeWidget.getSelectedRcSubtype());
                    if (SiteDetailPanel.this.dpTypeWidget.getSelectedRcType() == RcType.OTHER || SiteDetailPanel.this.dpTypeWidget.getSelectedRcSubtype() == RcSubtype.OTHER && SiteDetailPanel.this.dpTypeWidget.getSelectedRcType().getValidSubtypes().length > 1) {
                        SiteDetailPanel.this.mainDataPointCheckBox.setEnabled(false);
                        SiteDetailPanel.this.mainDataPointCheckBox.setSelected(false);
                        dataPoint.setMain(false);
                    } else {
                        DataPoint[] dataPointArray = SiteDetailPanel.this.getSite().getOwnedDataPoints();
                        SiteDetailPanel.this.mainDataPointCheckBox.setEnabled(SiteDetailPanel.this.canUpdate());
                        for (int i = 0; i < dataPointArray.length; ++i) {
                            if (!dataPointArray[i].isMain() || dataPointArray[i].equals(dataPoint) || dataPointArray[i].getRcTypeObj() != dataPoint.getRcTypeObj() || dataPointArray[i].getRcSubTypeObj() != dataPoint.getRcSubTypeObj()) continue;
                            SiteDetailPanel.this.mainDataPointCheckBox.setEnabled(false);
                            SiteDetailPanel.this.mainDataPointCheckBox.setSelected(false);
                            dataPoint.setMain(false);
                        }
                    }
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
                SiteDetailPanel.this.handleSelectedDataPointChange();
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.dpTypeWidget.getPanel(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.mainDataPointCheckBox = new JCheckBox(this.lex.getText("mainDataPoint"));
        jPanel.add((Component)this.mainDataPointCheckBox, gridBagConstraints);
        this.mainDataPointCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SiteDetailPanel.this.initializingDpValues) {
                    return;
                }
                try {
                    DataPoint dataPoint = (DataPoint)SiteDetailPanel.this.dpTree.getSelectedUserObject();
                    dataPoint.setMain(SiteDetailPanel.this.mainDataPointCheckBox.isSelected());
                    if (dataPoint.isMain()) {
                        SiteDetailPanel.this.dpFloorAreaValueTextField.setText(SiteDetailPanel.this.floorAreaValueTextField.getDoubleValue());
                        SiteDetailPanel.this.dpFloorAreaUnitComboBox.setSelectedUnit(SiteDetailPanel.this.floorAreaUnitComboBox.getSelectedUnit());
                    }
                    SiteDetailPanel.this.dpFloorAreaValueTextField.setEnabled(SiteDetailPanel.this.canUpdate() && !dataPoint.isMain());
                    SiteDetailPanel.this.dpFloorAreaUnitComboBox.setEnabled(SiteDetailPanel.this.canUpdate() && !dataPoint.isMain());
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
                SiteDetailPanel.this.handleSelectedDataPointChange();
            }
        });
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return jPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EasSession easSession) {
        this.layout.show(this, this.lex.getText("hide"));
        super.init(easSession);
        this.newButton.setEnabled(this.canAdd());
        HashMap hashMap = this.logCache;
        synchronized (hashMap) {
            this.logCache.clear();
        }
    }

    protected void setGroupIsDirty(boolean bl) {
        super.setGroupIsDirty(bl);
        this.discardChangesButton.setEnabled(this.groupIsDirty());
        this.applyButton.setEnabled(this.groupIsDirty());
        this.newButton.setEnabled(this.canAdd() && !this.groupIsDirty());
        this.delSiteButton.setEnabled(this.canUpdate() && this.getSite() != null);
    }

    protected void updateFloorAreaProperty() throws EasException {
        Property property = this.getSite().getProperty("floorarea");
        String string = this.floorAreaUnitComboBox.getSelectedUnitId();
        if (property == null) {
            this.getSite().addProperty(new Property((Group)this.getSite(), "floorarea", this.floorAreaValueTextField.getDoubleValue(), "area", string));
        } else {
            property.setVType("area");
            property.setValue(this.floorAreaValueTextField.getDoubleValue());
            property.setUnit(string);
        }
    }

    protected void saveGroup() throws EasException {
        EasObject easObject;
        Iterator iterator;
        Site site = this.getSite();
        site.changeName(this.nameTextField.getText());
        this.updateFloorAreaProperty();
        this.setPropertyValue("addr1", this.address1TextField.getText());
        this.setPropertyValue("addr2", this.address2TextField.getText());
        this.setPropertyValue("city", this.cityTextField.getText());
        this.setPropertyValue("stateprov", this.stateProvinceTextField.getText());
        this.setPropertyValue("postalcd", this.zipPostalTextField.getText());
        this.setPropertyValue("countrycd", this.countryTextField.getText());
        if (!this.meterTracker.getAddedData().isEmpty()) {
            iterator = this.meterTracker.getAddedData().iterator();
            while (iterator.hasNext()) {
                easObject = (Meter)iterator.next();
                ((Meter)easObject).save();
            }
            this.fireDataInserted(new DataEditedEvent((Object)this, this.meterTracker.getAddedData().toArray()));
        }
        if (!this.meterTracker.getUpdatedData().isEmpty()) {
            iterator = this.meterTracker.getUpdatedData().iterator();
            while (iterator.hasNext()) {
                easObject = (Meter)iterator.next();
                ((Meter)easObject).save();
            }
            this.fireDataChanged(new DataEditedEvent((Object)this, this.meterTracker.getUpdatedData().toArray()));
        }
        if (!this.meterTracker.getRemovedData().isEmpty()) {
            iterator = this.meterTracker.getRemovedData().iterator();
            while (iterator.hasNext()) {
                easObject = (Meter)iterator.next();
                ((Meter)easObject).remove();
                ((Meter)easObject).save();
            }
            this.fireDataRemoved(new DataEditedEvent((Object)this, this.meterTracker.getRemovedData().toArray()));
        }
        this.meterTracker.clear();
        if (!this.dpTracker.getAddedData().isEmpty()) {
            iterator = this.dpTracker.getAddedData().iterator();
            while (iterator.hasNext()) {
                easObject = (DataPoint)iterator.next();
                ((DataPoint)easObject).save();
            }
            this.fireDataInserted(new DataEditedEvent((Object)this, this.dpTracker.getAddedData().toArray()));
        }
        if (!this.dpTracker.getUpdatedData().isEmpty()) {
            iterator = this.dpTracker.getUpdatedData().iterator();
            while (iterator.hasNext()) {
                easObject = (DataPoint)iterator.next();
                ((DataPoint)easObject).save();
            }
            this.fireDataChanged(new DataEditedEvent((Object)this, this.dpTracker.getUpdatedData().toArray()));
        }
        this.dpTracker.clear();
        site.save();
        if (this.newFlag) {
            this.fireDataInserted(new DataEditedEvent((Object)this, site));
        } else {
            this.fireDataChanged(new DataEditedEvent((Object)this, site));
        }
        this.newFlag = false;
        this.setGroupIsDirty(false);
    }

    protected void reloadGroup(Group group) {
        super.reloadGroup(group);
        try {
            ((Site)group).loadOwnedDataPoints(true);
            ((Site)group).loadMeters(true);
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        this.dpTracker.clear();
        this.meterTracker.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupEditorValue(Group group) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Site site = (Site)group;
            this.newFlag = false;
            this.setAllowFireEditStarted(false);
            this.initializingDpValues = true;
            this.initializingMeterValues = true;
            this.dpTree.setEnabled(true);
            this.dpTracker = new Tracker();
            this.meterTracker = new Tracker();
            this.dpTree.clearSelection();
            this.getPropertiesTable().clearSelection();
            if (site == null) {
                super.setGroupEditorValue(site);
                this.layout.show(this, this.lex.getText("hide"));
                this.newButton.setEnabled(this.canAdd());
            } else {
                super.setGroupEditorValue(site);
                this.dpTree.setModel(new FilterTreeModel(new FilterRootNode(new SiteFilter(this.getSession(), site, this.lex), site, (DbObjectValidator)this)));
                this.nameTextField.setText(site.getName());
                this.nameTextField.setEnabled(this.canUpdate());
                this.newButton.setEnabled(this.canAdd());
                this.dpDescTextField.setEnabled(this.canUpdate());
                this.dpFloorAreaValueTextField.setEnabled(this.canUpdate());
                this.dpFloorAreaUnitComboBox.setEnabled(this.canUpdate());
                this.dpTypeWidget.setEnabled(this.canUpdate());
                this.mainDataPointCheckBox.setEnabled(this.canUpdate());
                this.mainMeterCheckBox.setEnabled(this.canUpdate());
                Property property = site.getProperty("floorarea");
                this.initFloorArea = true;
                if (property == null) {
                    this.floorAreaValueTextField.setText(null);
                    this.floorAreaUnitComboBox.setSelectedItem(null);
                } else {
                    this.floorAreaValueTextField.setText(property.getValue());
                    this.floorAreaUnitComboBox.setSelectedUnit(property.getUnitObject());
                }
                this.initFloorArea = false;
                this.floorAreaValueTextField.setEnabled(this.canUpdate());
                this.floorAreaUnitComboBox.setEnabled(this.canUpdate());
                this.address1TextField.setText(this.getPropertyValue("addr1"));
                this.address1TextField.setEnabled(this.canUpdate());
                this.address2TextField.setText(this.getPropertyValue("addr2"));
                this.address2TextField.setEnabled(this.canUpdate());
                this.cityTextField.setText(this.getPropertyValue("city"));
                this.cityTextField.setEnabled(this.canUpdate());
                this.stateProvinceTextField.setText(this.getPropertyValue("stateprov"));
                this.stateProvinceTextField.setEnabled(this.canUpdate());
                this.zipPostalTextField.setText(this.getPropertyValue("postalcd"));
                this.zipPostalTextField.setEnabled(this.canUpdate());
                this.countryTextField.setText(this.getPropertyValue("countrycd"));
                this.countryTextField.setEnabled(this.canUpdate());
                this.addDataPointButton.setEnabled(this.canUpdate());
                this.linkDataPointButton.setEnabled(this.canUpdate());
                this.addMeterButton.setEnabled(this.canUpdate());
                this.availableLogNames = null;
                this.layout.show(this, this.lex.getText("show"));
                this.setGroupIsDirty(false);
            }
            this.showDpTreeNodeDetails();
            this.initializingDpValues = false;
            this.initializingMeterValues = false;
            this.setAllowFireEditStarted(true);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean stopGroupEditing(boolean bl) {
        if (super.stopGroupEditing(bl)) {
            this.newButton.setEnabled(this.canAdd());
            return true;
        }
        return false;
    }

    public void unlinkDataPoint() {
        if (!this.canUpdate() || !this.dpTree.isSelected(class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = SiteDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint)) {
            return;
        }
        DataPoint dataPoint = (DataPoint)this.dpTree.getSelectedUserObject();
        try {
            if (JOptionPane.showConfirmDialog(this, this.lex.getText("unlinkDataPoint") + " '" + dataPoint.getDescr() + "'.", this.lex.getText("unlinkingDataPoint"), 2, 2) == 0) {
                this.getSite().unlinkDataPoint((DataPoint)this.dpTree.getSelectedUserObject());
                this.dpTree.revalidateUserObject(this.getSite());
                this.setGroupIsDirty(true);
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void linkDataPoint() {
        DataPoint dataPoint = (DataPoint)FilterTreeDialog.getSelection(this, null, this.lex.getText("linkDataPoint"), this.lex.getText("chooseDataPointLink"), new FilterRootNode((Filter)new TopLevelFilter(this.getSession(), this.lex), new LinkedDataPointValidator(this.getSite())), new ClassSelectionModel(class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = SiteDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint), this.getResourceManager(), this.lex);
        if (dataPoint != null) {
            try {
                this.getSite().linkDataPoint(dataPoint);
                DataPoint[] dataPointArray = this.getSite().getLinkedDataPoints();
                this.dpTree.revalidateUserObject(dataPoint);
                this.dpTree.setSelectedUserObject(dataPoint);
                this.setGroupIsDirty(true);
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
    }

    public void addDataPoint() {
        if (this.canUpdate()) {
            Iterator iterator = NewDataPointDialog.getNewDataPoints(this.getSite(), this.getAvailableLogs(), this.dpTree.getSelectedUserObject() instanceof Meter ? (Meter)this.dpTree.getSelectedUserObject() : null, this.getSession(), this.getResourceManager(), this, this.lex);
            while (iterator.hasNext()) {
                DataPoint dataPoint = (DataPoint)iterator.next();
                this.dpTree.revalidateUserObject(dataPoint);
                this.dpTree.setSelectedUserObject(dataPoint);
                this.dpTracker.trackAdd(dataPoint);
                this.setGroupIsDirty(true);
            }
        }
    }

    public void deleteMeter() {
        if (!this.canUpdate() || !this.dpTree.isSelected(class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = SiteDetailPanel.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter)) {
            return;
        }
        Meter meter = (Meter)this.dpTree.getSelectedUserObject();
        try {
            if (JOptionPane.showConfirmDialog(this, this.lex.getText("deleteMeterWarning") + " '" + meter.getName() + "'.", this.lex.getText("deletingMeter"), 2, 2) == 0) {
                DataPoint[] dataPointArray = meter.getDataPoints();
                for (int i = 0; i < dataPointArray.length; ++i) {
                    this.dpTracker.trackRemove(dataPointArray[i]);
                    this.getSite().remOwnedDataPoint(dataPointArray[i]);
                    String string = dataPointArray[i].getName();
                    this.getAvailableLogs().put(string, BHistoryId.make((String)string).getDeviceName());
                    this.dpTree.revalidateUserObject(dataPointArray[i]);
                }
                this.getSite().remMeter(meter);
                this.dpTree.revalidateUserObject(meter);
                this.meterTracker.trackRemove(meter);
                this.setGroupIsDirty(true);
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void assignDataPointToMeter() {
        if (!this.canUpdate() || !this.dpTree.isSelected(class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = SiteDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint)) {
            return;
        }
        try {
            DataPoint dataPoint = (DataPoint)this.dpTree.getSelectedUserObject();
            Meter meter = dataPoint.getMeter();
            if (MeterChoiceDialog.setMeter(dataPoint, this, this.lex)) {
                this.setGroupIsDirty(true);
                this.dpTracker.trackUpdate(dataPoint);
                this.dpTree.refreshUserObject(dataPoint);
                if (meter != null) {
                    this.meterTracker.trackUpdate(meter);
                    this.dpTree.refreshUserObject(meter);
                } else {
                    this.dpTree.refreshUserObject(this.getSite());
                }
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void deleteDataPoint() {
        if (!this.canUpdate() || !this.dpTree.isSelected(class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = SiteDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint)) {
            return;
        }
        DataPoint dataPoint = (DataPoint)this.dpTree.getSelectedUserObject();
        if (this.dataPointIsLinked(dataPoint)) {
            this.unlinkDataPoint();
            return;
        }
        try {
            if (JOptionPane.showConfirmDialog(this, this.lex.getText("deleteDataPointWarning") + " '" + dataPoint.getDescr() + "'.", this.lex.getText("deletingDataPoint"), 2, 2) == 0) {
                Meter meter = dataPoint.getMeter();
                this.dpTracker.trackRemove(dataPoint);
                String string = dataPoint.getName();
                this.getAvailableLogs().put(string, BHistoryId.make((String)string).getDeviceName());
                this.getSite().remOwnedDataPoint(dataPoint);
                if (meter == null) {
                    this.dpTree.revalidateUserObject(this.getSite());
                } else {
                    this.dpTree.revalidateUserObject(meter);
                }
                this.setGroupIsDirty(true);
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void addMeter() {
        if (!this.canUpdate()) {
            return;
        }
        Iterator iterator = NewMeterDialog.getNewMeters(this.getSite(), this, this.getSession(), this.lex);
        while (iterator.hasNext()) {
            Meter meter = (Meter)iterator.next();
            this.dpTree.revalidateUserObject(meter);
            this.dpTree.setSelectedUserObject(meter);
            this.meterTracker.trackAdd(meter);
            this.setGroupIsDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges() {
        block6: {
            if (!this.siteDataIsValid()) {
                return;
            }
            try {
                this.saveGroup();
                this.fireEditingStopped();
                if (this.availableLogNames == null) break block6;
                HashMap hashMap = this.logCache;
                synchronized (hashMap) {
                    this.logCache.clear();
                    this.logCache.putAll(this.availableLogNames);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, this.lex.getText("unrecoverableError"), this.lex.getText("error"), 0);
                this.initApplication();
            }
        }
    }

    public void createNewSite() {
        if (!this.canAdd()) {
            return;
        }
        try {
            Group group = Site.createSite(this.lex.getText("newSite"), this.getSession());
            group.addProperty(new Property(group, "countrycd", this.lex.getText("usa"), "misc", "null"));
            group.addProperty(new Property(group, "floorarea", 0.0, "area", "square foot"));
            this.setGroupEditorValue(group);
            this.nameTextField.requestFocus();
            this.nameTextField.selectAll();
            this.setAllowFireEditStarted(true);
            this.setGroupIsDirty(true);
            this.newFlag = true;
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void deleteSite() {
        if (!this.canUpdate()) {
            return;
        }
        if (this.getSite() == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, this.lex.getText("deleteSiteWarning") + " '" + this.nameTextField.getText() + "'.", this.lex.getText("deletingSite"), 2, 2) == 0) {
            Site site = this.getSite();
            DataEditedEvent dataEditedEvent = new DataEditedEvent((Object)this, site);
            try {
                site.remove();
                site.save();
                this.fireDataRemoved(dataEditedEvent);
                this.cancelGroupEditing();
            }
            catch (EasException easException) {
                easException.printStackTrace();
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setGroupIsDirty(true);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setGroupIsDirty(true);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setGroupIsDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getAvailableLogs() {
        if (this.availableLogNames == null) {
            HashMap hashMap = this.logCache;
            synchronized (hashMap) {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (this.logCache.isEmpty()) {
                        this.populateLogNames(this.logCache);
                    }
                    this.availableLogNames = (HashMap)this.logCache.clone();
                    DataPoint[] dataPointArray = this.getSite().getOwnedDataPoints();
                    for (int i = 0; i < dataPointArray.length; ++i) {
                        this.availableLogNames.remove(dataPointArray[i].getName());
                    }
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
        return this.availableLogNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearLogCache() {
        HashMap hashMap = this.logCache;
        synchronized (hashMap) {
            this.logCache.clear();
        }
        this.availableLogNames = null;
    }

    private void populateLogNames(HashMap hashMap) {
        XmlMessage xmlMessage = new XmlMessage("getUnassignedLogs");
        xmlMessage.add("request", "eas");
        xmlMessage.add("command", "getUnassignedLogs");
        XmlMessage xmlMessage2 = this.getSession().sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return;
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n = xmlSupportArray != null ? xmlSupportArray.length : 0;
        try {
            for (int i = 0; i < n; ++i) {
                String string = xmlMessage2.getString("i" + i);
                String string2 = BHistoryId.make((String)string).getDeviceName();
                hashMap.put(string, string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean siteDataIsValid() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        bl = this.requiredFieldIsPresent(this.lex.getText("name"), stringBuffer, this.nameTextField) && bl;
        bl = this.requiredFieldIsPresent(this.lex.getText("floorArea"), stringBuffer, this.floorAreaValueTextField) && bl;
        try {
            Group group;
            if ((this.newFlag || !this.nameTextField.getText().equals(this.getSite().getName())) && (group = Group.get(this.nameTextField.getText(), this.getSession())) != null) {
                stringBuffer.append(this.lex.getText("theName") + " '" + this.nameTextField.getText() + "' " + this.lex.getText("alreadyInUse"));
                bl = false;
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this, stringBuffer.toString(), this.lex.getText("siteDataErrors"), 0);
        }
        return bl;
    }

    protected boolean requiredFieldIsPresent(String string, StringBuffer stringBuffer, JTextField jTextField) {
        if (jTextField.getText() == null || jTextField.getText().trim().length() == 0) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append(this.lex.getText("siteNotSaved"));
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append("  - ");
            stringBuffer.append(string);
            stringBuffer.append(" " + this.lex.getText("isRequired"));
            return false;
        }
        return true;
    }

    protected double getFloorAreaValue() {
        double d = 0.0;
        DecimalFormat decimalFormat = new DecimalFormat();
        if (this.floorAreaValueTextField.getText().trim().length() > 0) {
            try {
                d = decimalFormat.parse(this.floorAreaValueTextField.getText()).doubleValue();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return d;
    }

    public void setDataPointFloorAreaData() {
        double d = this.getFloorAreaValue();
        BUnit bUnit = this.floorAreaUnitComboBox.getSelectedUnit();
        try {
            Meter[] meterArray = this.getSite().getMeters();
            for (int i = 0; i < meterArray.length; ++i) {
                if (!meterArray[i].isMain()) continue;
                meterArray[i].setFloorAreaValue(d);
                meterArray[i].setFloorAreaUnit(bUnit);
                if (!this.initializingMeterValues) {
                    this.meterTracker.trackUpdate(meterArray[i]);
                }
                this.dpTree.revalidateUserObject(meterArray[i]);
            }
            DataPoint[] dataPointArray = this.getSite().getOwnedDataPoints();
            for (int i = 0; i < dataPointArray.length; ++i) {
                if (!dataPointArray[i].isMain()) continue;
                dataPointArray[i].setFloorAreaValue(d);
                dataPointArray[i].setFloorAreaUnit(bUnit);
                if (!this.initializingDpValues) {
                    this.dpTracker.trackUpdate(dataPointArray[i]);
                }
                this.dpTree.revalidateUserObject(dataPointArray[i]);
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public boolean allowLoadUserObject(Class clazz) {
        return (class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = SiteDetailPanel.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Meter == null ? (class$com$tridium$eas$api$Meter = SiteDetailPanel.class$("com.tridium.eas.api.Meter")) : class$com$tridium$eas$api$Meter).isAssignableFrom(clazz) || (class$com$tridium$eas$api$Site == null ? (class$com$tridium$eas$api$Site = SiteDetailPanel.class$("com.tridium.eas.api.Site")) : class$com$tridium$eas$api$Site).isAssignableFrom(clazz);
    }

    public boolean allowShowUserObject(Object object) {
        try {
            if (object instanceof DataPoint) {
                int n;
                DataPoint[] dataPointArray = this.getSite().getOwnedDataPoints();
                for (n = 0; n < dataPointArray.length; ++n) {
                    if (!object.equals(dataPointArray[n])) continue;
                    return true;
                }
                dataPointArray = this.getSite().getLinkedDataPoints();
                for (n = 0; n < dataPointArray.length; ++n) {
                    if (!object.equals(dataPointArray[n])) continue;
                    return true;
                }
            } else if (object instanceof Meter) {
                Meter[] meterArray = this.getSite().getMeters();
                for (int i = 0; i < meterArray.length; ++i) {
                    if (!object.equals(meterArray[i])) continue;
                    return true;
                }
            } else if (object.equals(this.getSite())) {
                return true;
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        return false;
    }

    protected boolean dataPointIsLinked(DataPoint dataPoint) {
        try {
            return this.getSite() != dataPoint.getSite();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DataPointPopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteDataPointItem = null;
        private boolean deleteDataPointItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem unlinkDataPointItem = null;
        private boolean unlinkDataPointItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem deleteMeterItem = null;
        private boolean deleteMeterItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem assignToMeterItem = null;
        private boolean assignToMeterItemShowing = false;

        public DataPointPopup() {
            this.add(new EasPopupMenu.EasPopupMenuItem(SiteDetailPanel.this.lex.getText("newDataPoint"), 0, null));
            this.add(new EasPopupMenu.EasPopupMenuItem(SiteDetailPanel.this.lex.getText("linkDataPoint"), 1, null));
            this.deleteDataPointItem = new EasPopupMenu.EasPopupMenuItem(SiteDetailPanel.this.lex.getText("deleteDataPoint"), 2, null);
            this.add(new EasPopupMenu.EasPopupMenuItem(SiteDetailPanel.this.lex.getText("newMeter"), 3, null));
            this.deleteMeterItem = new EasPopupMenu.EasPopupMenuItem(SiteDetailPanel.this.lex.getText("deleteMeter"), 4, null);
            this.unlinkDataPointItem = new EasPopupMenu.EasPopupMenuItem(SiteDetailPanel.this.lex.getText("unlinkDP"), 5, null);
            this.assignToMeterItem = new EasPopupMenu.EasPopupMenuItem(SiteDetailPanel.this.lex.getText("assignToMeter"), 6, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    SiteDetailPanel.this.addDataPoint();
                    break;
                }
                case 1: {
                    SiteDetailPanel.this.linkDataPoint();
                    break;
                }
                case 2: {
                    SiteDetailPanel.this.deleteDataPoint();
                    break;
                }
                case 3: {
                    SiteDetailPanel.this.addMeter();
                    break;
                }
                case 4: {
                    SiteDetailPanel.this.deleteMeter();
                    break;
                }
                case 5: {
                    SiteDetailPanel.this.unlinkDataPoint();
                    break;
                }
                case 6: {
                    SiteDetailPanel.this.assignDataPointToMeter();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, FilterTreeNode filterTreeNode, int n, int n2) {
            Object object = filterTreeNode == null ? null : filterTreeNode.getUserObject();
            boolean bl = false;
            if (!(!this.unlinkDataPointItemShowing || object != null && object instanceof DataPoint && SiteDetailPanel.this.dataPointIsLinked((DataPoint)object))) {
                this.remove(this.unlinkDataPointItem);
                this.unlinkDataPointItemShowing = false;
                bl = true;
            }
            if (!this.unlinkDataPointItemShowing && object != null && object instanceof DataPoint && SiteDetailPanel.this.dataPointIsLinked((DataPoint)object)) {
                this.add(this.unlinkDataPointItem);
                this.unlinkDataPointItemShowing = true;
                bl = true;
            }
            if (this.deleteDataPointItemShowing && (object == null || !(object instanceof DataPoint) || SiteDetailPanel.this.dataPointIsLinked((DataPoint)object))) {
                this.remove(this.deleteDataPointItem);
                this.deleteDataPointItemShowing = false;
                bl = true;
            }
            if (!this.deleteDataPointItemShowing && object != null && object instanceof DataPoint && !SiteDetailPanel.this.dataPointIsLinked((DataPoint)object)) {
                this.add(this.deleteDataPointItem);
                this.deleteDataPointItemShowing = true;
                bl = true;
            }
            if (this.deleteMeterItemShowing && (object == null || !(object instanceof Meter))) {
                this.remove(this.deleteMeterItem);
                this.deleteMeterItemShowing = false;
                bl = true;
            }
            if (!this.deleteMeterItemShowing && object != null && object instanceof Meter) {
                this.add(this.deleteMeterItem);
                this.deleteMeterItemShowing = true;
                bl = true;
            }
            if (!this.assignToMeterItemShowing && object != null && object instanceof DataPoint && !SiteDetailPanel.this.dataPointIsLinked((DataPoint)object)) {
                this.add(this.assignToMeterItem);
                this.assignToMeterItemShowing = true;
                bl = true;
            }
            if (this.assignToMeterItemShowing && (object == null || !(object instanceof DataPoint) || SiteDetailPanel.this.dataPointIsLinked((DataPoint)object))) {
                this.remove(this.assignToMeterItem);
                this.assignToMeterItemShowing = false;
                bl = true;
            }
            if (bl) {
                this.revalidate();
            }
            super.show(component, n, n2);
        }
    }
}

