/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Property;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.Site;
import com.tridium.eas.ui.dbconfig.MeterTypeRadioGroup;
import com.tridium.eas.ui.widgets.EasDialog;
import com.tridium.eas.ui.widgets.EasTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewMeterDialog
extends EasDialog
implements ActionListener {
    private boolean done = false;
    private Site site = null;
    private EasTextField nameTextField = null;
    private MeterTypeRadioGroup typeGroup = null;
    private JButton doneButton = null;
    private JButton continueButton = null;
    private JButton cancelButton = null;
    private JCheckBox mainCheckBox = null;
    private String meterName = null;
    private int meterType = -1;
    private boolean meterMain = false;
    private EasSession session = null;
    private Lexicon lex;

    private NewMeterDialog(Site site, Component component, EasSession easSession, Lexicon lexicon) {
        super(NewMeterDialog.getParentFrame(component), component);
        Object object;
        this.lex = lexicon;
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setTitle(lexicon.getText("newMeter"));
        this.site = site;
        this.session = easSession;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        jComponent.add((Component)new JLabel(lexicon.getText("name")), gridBagConstraints);
        this.nameTextField = new EasTextField(20, 32);
        gridBagConstraints.gridx = 1;
        jComponent.add((Component)this.nameTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        jComponent.add((Component)new JLabel(lexicon.getText("type")), gridBagConstraints);
        this.typeGroup = new MeterTypeRadioGroup(lexicon);
        this.typeGroup.setRcType(RcType.OTHER);
        gridBagConstraints.gridx = 1;
        jComponent.add((Component)this.typeGroup, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        this.mainCheckBox = new JCheckBox(lexicon.getText("mainMeter"));
        this.mainCheckBox.setEnabled(true);
        try {
            if (this.typeGroup.getRcType() == RcType.OTHER) {
                this.mainCheckBox.setSelected(false);
                this.mainCheckBox.setEnabled(false);
            } else {
                object = site.getMeters();
                for (int i = 0; i < ((Meter[])object).length; ++i) {
                    if (!object[i].isMain() || object[i].getRcTypeObj() != this.typeGroup.getRcType()) continue;
                    this.mainCheckBox.setSelected(false);
                    this.mainCheckBox.setEnabled(false);
                }
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        jComponent.add((Component)this.mainCheckBox, gridBagConstraints);
        object = new JPanel(new FlowLayout(1), false);
        this.doneButton = new JButton(lexicon.getText("saveDone"));
        this.doneButton.setActionCommand("done");
        ((Container)object).add(this.doneButton);
        this.continueButton = new JButton(lexicon.getText("saveContinue"));
        this.continueButton.setActionCommand("continue");
        ((Container)object).add(this.continueButton);
        this.cancelButton = new JButton(lexicon.getText("cancel"));
        this.cancelButton.setActionCommand("cancel");
        ((Container)object).add(this.cancelButton);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jComponent.add((Component)object, gridBagConstraints);
        this.typeGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (NewMeterDialog.this.typeGroup.getRcType() == RcType.OTHER) {
                        NewMeterDialog.this.mainCheckBox.setSelected(false);
                        NewMeterDialog.this.mainCheckBox.setEnabled(false);
                    } else {
                        Meter[] meterArray = NewMeterDialog.this.site.getMeters();
                        NewMeterDialog.this.mainCheckBox.setEnabled(true);
                        for (int i = 0; i < meterArray.length; ++i) {
                            if (!meterArray[i].isMain() || meterArray[i].getRcTypeObj() != NewMeterDialog.this.typeGroup.getRcType()) continue;
                            NewMeterDialog.this.mainCheckBox.setSelected(false);
                            NewMeterDialog.this.mainCheckBox.setEnabled(false);
                        }
                    }
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                    NewMeterDialog.this.mainCheckBox.setSelected(false);
                    NewMeterDialog.this.mainCheckBox.setEnabled(false);
                }
                NewMeterDialog.this.doneButton.setEnabled(NewMeterDialog.this.dataIsValid());
                NewMeterDialog.this.continueButton.setEnabled(NewMeterDialog.this.dataIsValid());
            }
        });
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.removeUpdate(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.removeUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NewMeterDialog.this.doneButton.setEnabled(NewMeterDialog.this.dataIsValid());
                NewMeterDialog.this.continueButton.setEnabled(NewMeterDialog.this.dataIsValid());
            }
        });
        this.registerKeyboardActions(jComponent);
        this.registerKeyboardActions(this.nameTextField);
        this.doneButton.addActionListener(this);
        this.continueButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.doneButton.setEnabled(this.dataIsValid());
        this.continueButton.setEnabled(this.dataIsValid());
        this.site = site;
    }

    private void captureFieldData() {
        this.meterName = this.nameTextField.getText();
        this.meterType = this.typeGroup.getType();
        this.meterMain = this.mainCheckBox.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.doneButton || actionEvent.getActionCommand().equals("done") && this.doneButton.isEnabled()) {
            this.done = true;
            this.captureFieldData();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.continueButton) {
            this.done = false;
            this.captureFieldData();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton || actionEvent.getActionCommand().equals("cancel")) {
            this.done = true;
            this.setVisible(false);
        }
    }

    private boolean dataIsValid() {
        return this.nameTextField.getText() != null && this.nameTextField.getText().trim().length() > 0;
    }

    private void registerKeyboardActions(JComponent jComponent) {
        jComponent.registerKeyboardAction(this, "done", KeyStroke.getKeyStroke(10, 0), 1);
        jComponent.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
    }

    public static Iterator getNewMeters(Site site, Component component, EasSession easSession, Lexicon lexicon) {
        return new MeterIterator(new NewMeterDialog(site, component, easSession, lexicon));
    }

    public Meter getMeter() {
        if (this.meterName == null) {
            return null;
        }
        try {
            Property property = this.site.getProperty("floorarea");
            Meter meter = Meter.create(this.meterName, "", this.meterType, this.meterMain, this.site, property == null ? "square foot" : property.getUnit(), property == null ? 0.0 : property.getDouble());
            this.meterName = null;
            if (this.meterMain) {
                this.mainCheckBox.setEnabled(false);
            }
            this.mainCheckBox.setSelected(false);
            this.typeGroup.setRcType(RcType.OTHER);
            this.nameTextField.setText("");
            this.nameTextField.requestFocus();
            return meter;
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return null;
        }
    }

    private static class MeterIterator
    implements Iterator {
        private NewMeterDialog dlg = null;
        private Meter meter = null;

        public MeterIterator(NewMeterDialog newMeterDialog) {
            this.dlg = newMeterDialog;
        }

        public boolean hasNext() {
            if (this.dlg != null && this.dlg.done) {
                return false;
            }
            this.dlg.setVisible(true);
            this.meter = this.dlg.getMeter();
            return this.meter != null;
        }

        public Object next() {
            return this.meter;
        }

        public void remove() {
        }
    }
}

