/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Property;
import com.tridium.eas.ui.widgets.AbstractRowMappedTableModel;
import com.tridium.eas.ui.widgets.UserObjectComparator;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;

public class GroupPropertiesTableModel
extends AbstractRowMappedTableModel {
    public static final int NAME_COL_IX = 0;
    public static final int VALUE_COL_IX = 1;
    public static final int UNIT_COL_IX = 2;
    private Group group = null;
    private ArrayList rowCollection = null;
    private Hashtable propsByName = null;
    private Hashtable excludedProperties = null;
    private Comparator comparator = null;
    private Lexicon lex;

    GroupPropertiesTableModel(Lexicon lexicon) {
        this.lex = lexicon;
        this.excludedProperties = new Hashtable();
        this.propsByName = new Hashtable();
        this.rowCollection = new ArrayList();
        this.comparator = new UserObjectComparator();
    }

    GroupPropertiesTableModel(String[] stringArray, Lexicon lexicon) {
        this(lexicon);
        for (int i = 0; i < stringArray.length; ++i) {
            this.excludedProperties.put(stringArray[i], stringArray[i]);
        }
    }

    public void setGroup(Group group) {
        this.group = group;
        this.propsByName = new Hashtable();
        try {
            if (group != null) {
                TreeSet<Property> treeSet = new TreeSet<Property>(this.comparator);
                String[] stringArray = group.getPropertyNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.excludedProperties.containsKey(stringArray[i])) continue;
                    Property property = group.getProperty(stringArray[i]);
                    treeSet.add(property);
                    if (stringArray[i] == null) continue;
                    this.propsByName.put(stringArray[i], property);
                }
                this.rowCollection = new ArrayList(treeSet);
            }
            this.fireTableDataChanged();
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void addProperty(Property property) {
        try {
            Property property2;
            if (property.getName() != null) {
                this.propsByName.put(property.getName(), property);
                this.getGroup().addProperty(property);
            }
            int n = 0;
            Iterator iterator = this.rowCollection.iterator();
            while (iterator.hasNext() && this.comparator.compare(property, property2 = (Property)iterator.next()) >= 0) {
                ++n;
            }
            this.fireTableRowsInserted(n, n);
            this.rowCollection.add(n, property);
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    public void clearGroup() {
        this.setGroup(null);
    }

    public Group getGroup() {
        return this.group;
    }

    public int getRowCount() {
        return this.rowCollection.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Property getPropertyAt(int n) {
        int n2 = this.convertRowIndexToModel(n);
        return (Property)this.rowCollection.get(n2);
    }

    public Object getModelValueAt(int n, int n2) {
        Property property = this.getPropertyAt(n);
        switch (n2) {
            case 0: {
                return property.getName();
            }
            case 1: {
                return property.getValue();
            }
            case 2: {
                if (property.getUnit() == null) {
                    return BUnit.getUnit((String)"null");
                }
                return BUnit.getUnit((String)property.getUnit());
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.convertRowIndexToModel(n);
        Property property = this.getPropertyAt(this.convertRowIndexToModel(n3));
        String string = object == null ? null : object.toString();
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    String string2 = null;
                    if (property != null) {
                        string2 = property.getUnit();
                    }
                    if (string2 == null || string2.equals("null")) {
                        property.setValue(string);
                    } else {
                        property.setValue(this.doubleValueOf(string));
                    }
                    this.fireTableRowsUpdated(n3, n3);
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    if (string == null) {
                        property.setUnit("null");
                        property.setVType("misc");
                    } else if (object instanceof BUnit) {
                        BUnit bUnit = (BUnit)object;
                        String string3 = null;
                        string3 = UnitDatabase.getDefault().getQuantity(bUnit) != null ? UnitDatabase.getDefault().getQuantity(bUnit).getName() : "";
                        property.setVType(string3);
                        property.setUnit(bUnit.getUnitName());
                    }
                }
                catch (EasException easException) {
                    easException.printStackTrace();
                }
                this.fireTableRowsUpdated(n3, n3);
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    protected double doubleValueOf(String string) {
        try {
            return NumberFormat.getNumberInstance().parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    public boolean hasProperty(String string) {
        return this.propsByName.containsKey(string) || this.excludedProperties.containsKey(string);
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return this.lex.getText("property");
            }
            case 1: {
                return this.lex.getText("value");
            }
            case 2: {
                return this.lex.getText("unit");
            }
        }
        return this.lex.getText("error");
    }

    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return false;
            }
            case 2: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void removeRow(int n) {
        int n2 = this.convertRowIndexToModel(n);
        this.group.remProperty(this.getPropertyAt(n2).getName());
        this.propsByName.remove(this.getPropertyAt(n2).getName());
        this.rowCollection.remove(n2);
        this.fireTableRowsDeleted(n, n);
    }
}

