/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.Group;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasList;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.EasListCellRenderer;
import com.tridium.eas.ui.widgets.SortedListModel;

public class GroupMembersList
extends EasList
implements EasDataListener {
    private Group parent = null;

    public GroupMembersList(ResourceManager resourceManager) {
        this.setModel(new SortedListModel());
        this.setCellRenderer(new EasListCellRenderer(resourceManager));
    }

    public void setParent(Group group) {
        this.parent = group;
        this.refreshData();
    }

    public void refreshData() {
        SortedListModel sortedListModel = (SortedListModel)this.getModel();
        sortedListModel.removeAllElements();
        if (this.parent != null) {
            Group[] groupArray = this.parent.getChildren();
            for (int i = 0; i < groupArray.length; ++i) {
                sortedListModel.addElement(groupArray[i]);
            }
            DataPoint[] dataPointArray = this.parent.getLinkedDataPoints();
            for (int i = 0; i < dataPointArray.length; ++i) {
                sortedListModel.addElement(dataPointArray[i]);
            }
        }
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        this.refreshData();
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        this.refreshData();
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
        SortedListModel sortedListModel = (SortedListModel)this.getModel();
        Object[] objectArray = dataEditedEvent.getEditedData();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!sortedListModel.contains(objectArray[i])) continue;
            sortedListModel.removeElement(objectArray[i]);
        }
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
    }

    public boolean contains(Object object) {
        SortedListModel sortedListModel = (SortedListModel)this.getModel();
        return sortedListModel.contains(object);
    }
}

