/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.dbconfig;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Property;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasEditorListener;
import com.tridium.eas.ui.dbconfig.GroupEditor;
import com.tridium.eas.ui.dbconfig.GroupPropertiesTable;
import com.tridium.eas.ui.dbconfig.GroupPropertiesTableModel;
import com.tridium.eas.ui.dbconfig.NewPropertyDialog;
import com.tridium.eas.ui.widgets.DataEditedEvent;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasDataListener;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.ListPopupHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class GroupDetailPanel
extends JPanel
implements GroupEditor,
EasDataListener {
    private boolean groupDirtyFlag = false;
    private boolean allowFireEditStarted = false;
    private Group group = null;
    private EasSession session = null;
    private ArrayList easEditorListeners = null;
    private GroupPropertiesTableModel propertiesTableModel = null;
    private JButton addPropButton = null;
    private JButton delPropButton = null;
    private GroupPropertiesTable propertiesTable = null;
    private ArrayList easDataListeners = null;
    private ResourceManager resourceManager = null;
    private JToolBar toolbar = null;
    private PropertyPopup propertyPopup = null;
    private EasApplication parentApplication = null;
    protected Lexicon lex;

    protected GroupDetailPanel(ResourceManager resourceManager, EasApplication easApplication, Lexicon lexicon) {
        this.lex = lexicon;
        this.resourceManager = resourceManager;
        this.easEditorListeners = new ArrayList();
        this.easDataListeners = new ArrayList();
        this.parentApplication = easApplication;
    }

    protected JComponent buildGroupPropertiesPanel() {
        return this.buildGroupPropertiesPanel(new String[0]);
    }

    protected JComponent buildGroupPropertiesPanel(String[] stringArray) {
        this.propertiesTableModel = new GroupPropertiesTableModel(stringArray, this.lex);
        this.propertiesTableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (GroupDetailPanel.this.isFireEditStartedAllowed()) {
                    GroupDetailPanel.this.setGroupIsDirty(true);
                }
            }
        });
        this.propertiesTable = new GroupPropertiesTable(this.getResourceManager(), this.propertiesTableModel, this.lex);
        this.propertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GroupDetailPanel.this.delPropButton.setEnabled(GroupDetailPanel.this.canUpdate() && !((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty());
            }
        });
        this.propertiesTable.setPopupHandler(new ListPopupHandler(){

            public void openPopup(Object object, int n, int n2, int n3) {
                if (!GroupDetailPanel.this.canUpdate()) {
                    return;
                }
                if (GroupDetailPanel.this.propertyPopup == null) {
                    GroupDetailPanel.this.propertyPopup = new PropertyPopup();
                }
                if (n >= 0) {
                    GroupDetailPanel.this.propertiesTable.setRowSelectionInterval(n, n);
                    GroupDetailPanel.this.propertyPopup.show(GroupDetailPanel.this.propertiesTable, true, n2, n3);
                } else {
                    GroupDetailPanel.this.propertyPopup.show(GroupDetailPanel.this.propertiesTable, false, n2, n3);
                }
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    GroupDetailPanel.this.deleteProperty();
                }
            }
        };
        this.propertiesTable.addKeyListener(keyAdapter);
        return this.propertiesTable.getScrollPane();
    }

    protected double doubleValueOf(String string) {
        try {
            return NumberFormat.getNumberInstance().parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            return 0.0;
        }
    }

    protected void enforceSecurity() {
    }

    public abstract boolean canUpdate();

    public abstract boolean canAdd();

    protected void init(EasSession easSession) {
        this.session = easSession;
        this.setGroupEditorValue(null);
        this.enforceSecurity();
    }

    protected void initApplication() {
        this.parentApplication.initApplication(true);
    }

    protected void setGroupIsDirty(boolean bl) {
        if (bl && !this.groupIsDirty()) {
            this.fireEditingStarted();
        }
        this.groupDirtyFlag = bl;
    }

    protected boolean groupIsDirty() {
        return this.groupDirtyFlag;
    }

    public void addEasDataListener(EasDataListener easDataListener) {
        this.easDataListeners.add(easDataListener);
    }

    public void removeEasDataListener(EasDataListener easDataListener) {
        this.easDataListeners.remove(easDataListener);
    }

    public void addEasEditorListener(EasEditorListener easEditorListener) {
        this.easEditorListeners.add(easEditorListener);
    }

    public void removeEasEditorListener(EasEditorListener easEditorListener) {
        this.easEditorListeners.remove(easEditorListener);
    }

    public void cancelGroupEditing() {
        if (this.getGroupEditorValue() != null) {
            this.reloadGroup(this.getGroupEditorValue());
            this.setGroupEditorValue(null);
            this.fireEditingCancelled();
        }
    }

    protected void reloadGroup(Group group) {
        group.loadProperties(true);
        group.restoreChildren();
        group.restoreParents();
        group.loadLinkedDataPoints(true);
    }

    public void startGroupEditing() {
        this.setGroupIsDirty(true);
    }

    public Group getGroupEditorValue() {
        return this.group;
    }

    public boolean stopGroupEditing(boolean bl) {
        if (this.groupIsDirty()) {
            if (bl) {
                if (JOptionPane.showConfirmDialog(null, this.lex.getText("saveChangesTo") + " '" + this.getGroupEditorValue().getName() + "'?", this.lex.getText("saveChanges") + "?", 0) == 0) {
                    try {
                        this.saveGroup();
                    }
                    catch (EasException easException) {
                        easException.printStackTrace();
                    }
                }
                return true;
            }
            switch (JOptionPane.showConfirmDialog(null, this.lex.getText("saveChangesTo") + " '" + this.getGroupEditorValue().getName() + "'?", this.lex.getText("saveChanges") + "?", 1)) {
                case 0: {
                    try {
                        this.saveGroup();
                    }
                    catch (EasException easException) {
                        easException.printStackTrace();
                    }
                    return true;
                }
                case 1: {
                    this.cancelGroupEditing();
                    return true;
                }
            }
            return false;
        }
        this.fireEditingStopped();
        return true;
    }

    protected abstract void saveGroup() throws EasException;

    public void refreshData() {
        Group group = this.getGroupEditorValue();
        if (group != null) {
            group.restoreChildren();
            group.loadProperties(true);
            if (this.propertiesTableModel != null) {
                this.propertiesTableModel.setGroup(group);
                this.propertiesTable.setEnabled(this.canUpdate());
                this.addPropButton.setEnabled(this.canUpdate());
            }
        }
    }

    public void setGroupEditorValue(Group group) {
        this.group = group;
        if (this.propertiesTableModel != null && group != null) {
            this.propertiesTableModel.setGroup(group);
            this.propertiesTable.setEnabled(this.canUpdate());
            this.addPropButton.setEnabled(this.canUpdate());
        }
    }

    protected void fireEditingStopped() {
        EventObject eventObject = new EventObject(this);
        Iterator iterator = this.easEditorListeners.iterator();
        while (iterator.hasNext()) {
            EasEditorListener easEditorListener = (EasEditorListener)iterator.next();
            easEditorListener.editingStopped(eventObject);
        }
    }

    protected void fireEditingDeleted() {
        EventObject eventObject = new EventObject(this);
        Iterator iterator = this.easEditorListeners.iterator();
        while (iterator.hasNext()) {
            EasEditorListener easEditorListener = (EasEditorListener)iterator.next();
            easEditorListener.editingDeleted(eventObject);
        }
    }

    protected void fireEditingCancelled() {
        EventObject eventObject = new EventObject(this);
        Iterator iterator = this.easEditorListeners.iterator();
        while (iterator.hasNext()) {
            EasEditorListener easEditorListener = (EasEditorListener)iterator.next();
            easEditorListener.editingCancelled(eventObject);
        }
    }

    protected void fireEditingStarted() {
        if (this.isFireEditStartedAllowed()) {
            EventObject eventObject = new EventObject(this);
            Iterator iterator = this.easEditorListeners.iterator();
            while (iterator.hasNext()) {
                EasEditorListener easEditorListener = (EasEditorListener)iterator.next();
                easEditorListener.editingStarted(eventObject);
            }
        }
    }

    public void addProperty() {
        if (!this.canUpdate()) {
            return;
        }
        Iterator iterator = NewPropertyDialog.getNewProperties(this.propertiesTableModel, this.getResourceManager(), this.propertiesTable.getParent(), this.lex);
        while (iterator.hasNext()) {
            this.propertiesTableModel.addProperty((Property)iterator.next());
            this.setGroupIsDirty(true);
        }
    }

    public void deleteProperty() {
        if (!this.canUpdate()) {
            return;
        }
        if (this.propertiesTable.getSelectionModel().isSelectionEmpty()) {
            return;
        }
        Property property = this.propertiesTableModel.getPropertyAt(this.propertiesTable.getSelectionModel().getMinSelectionIndex());
        if (JOptionPane.showConfirmDialog(this, this.lex.getText("deletePropertyWarning") + " '" + property.getName() + "'.", this.lex.getText("deletingProperty"), 2, 2) == 0) {
            this.propertiesTableModel.removeRow(this.propertiesTable.getSelectionModel().getMinSelectionIndex());
            this.propertiesTable.getSelectionModel().clearSelection();
            this.delPropButton.setEnabled(this.canUpdate() && !this.propertiesTable.getSelectionModel().isSelectionEmpty());
            this.setGroupIsDirty(true);
        }
    }

    protected void setPropertyValue(String string, double d) {
        Property property = this.group.getProperty(string);
        try {
            if (property != null) {
                property.setValue(d);
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    protected void setPropertyValue(String string, String string2) {
        Property property = this.group.getProperty(string);
        try {
            if (property == null) {
                property = new Property(this.group, string, string2, "misc", "null");
                this.group.addProperty(property);
            } else {
                property.setValue(string2);
            }
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
    }

    protected String getPropertyValue(String string) {
        Property property = this.group.getProperty(string);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    protected boolean isFireEditStartedAllowed() {
        return this.allowFireEditStarted;
    }

    protected void setAllowFireEditStarted(boolean bl) {
        this.allowFireEditStarted = bl;
    }

    protected EasSession getSession() {
        return this.session;
    }

    public void dataChanged(DataEditedEvent dataEditedEvent) {
        boolean bl = this.isFireEditStartedAllowed();
        this.setAllowFireEditStarted(false);
        Set set = this.getMyData();
        for (int i = 0; i < dataEditedEvent.getEditedData().length; ++i) {
            if (!set.contains(dataEditedEvent.getEditedData()[i])) continue;
            this.refreshData();
            return;
        }
        this.setAllowFireEditStarted(bl);
    }

    public void dataInserted(DataEditedEvent dataEditedEvent) {
        this.dataChanged(dataEditedEvent);
    }

    public void dataToBeRemoved(DataEditedEvent dataEditedEvent) {
        boolean bl = this.isFireEditStartedAllowed();
        this.setAllowFireEditStarted(false);
        Set set = this.getMyData();
        for (int i = 0; i < dataEditedEvent.getEditedData().length; ++i) {
            if (dataEditedEvent.getEditedData()[i] instanceof Group && dataEditedEvent.getEditedData()[i].equals(this.getGroupEditorValue())) {
                this.cancelGroupEditing();
                return;
            }
            if (!set.contains(dataEditedEvent.getEditedData()[i])) continue;
            this.refreshData();
            return;
        }
        this.setAllowFireEditStarted(bl);
    }

    public void dataRemoved(DataEditedEvent dataEditedEvent) {
    }

    protected Set getMyData() {
        HashSet<Group> hashSet = new HashSet<Group>();
        if (this.getGroupEditorValue() != null) {
            hashSet.add(this.getGroupEditorValue());
            Group[] groupArray = this.getGroupEditorValue().getChildren();
            for (int i = 0; i < groupArray.length; ++i) {
                hashSet.add(groupArray[i]);
            }
            this.addToSet(hashSet, this.getGroupEditorValue().getLinkedDataPoints());
        }
        return hashSet;
    }

    protected void addToSet(Set set, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            set.add(objectArray[i]);
        }
    }

    protected void fireDataChanged(DataEditedEvent dataEditedEvent) {
        Iterator iterator = this.easDataListeners.iterator();
        while (iterator.hasNext()) {
            ((EasDataListener)iterator.next()).dataChanged(dataEditedEvent);
        }
    }

    protected void fireDataInserted(DataEditedEvent dataEditedEvent) {
        Iterator iterator = this.easDataListeners.iterator();
        while (iterator.hasNext()) {
            ((EasDataListener)iterator.next()).dataInserted(dataEditedEvent);
        }
    }

    protected void fireDataRemoved(DataEditedEvent dataEditedEvent) {
        Iterator iterator = this.easDataListeners.iterator();
        while (iterator.hasNext()) {
            ((EasDataListener)iterator.next()).dataRemoved(dataEditedEvent);
        }
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    protected void buildToolBar() {
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.addSeparator();
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    public void addPropertiesToolBarButtons() {
        this.addPropButton = new EasButton(this.getResourceManager(), new int[]{13, 29}, this.lex.getText("newProperty"));
        this.addPropButton.setEnabled(false);
        this.addPropButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupDetailPanel.this.addProperty();
            }
        });
        this.getToolBar().add(this.addPropButton);
        this.delPropButton = new EasButton(this.getResourceManager(), new int[]{13, 16}, this.lex.getText("deleteProperty"));
        this.delPropButton.setEnabled(false);
        this.delPropButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupDetailPanel.this.deleteProperty();
            }
        });
        this.getToolBar().add(this.delPropButton);
    }

    protected JTable getPropertiesTable() {
        return this.propertiesTable;
    }

    private class PropertyPopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;

        public PropertyPopup() {
            this.add(new EasPopupMenu.EasPopupMenuItem(GroupDetailPanel.this.lex.getText("newProperty"), 0, null));
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(GroupDetailPanel.this.lex.getText("deleteProperty"), 1, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    GroupDetailPanel.this.addProperty();
                    break;
                }
                case 1: {
                    GroupDetailPanel.this.deleteProperty();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            if (bl && !this.deleteItemShowing) {
                this.add(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            super.show(component, n, n2);
        }
    }
}

