/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeSeries;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.baja.util.Lexicon;

public class TimeAxis
extends Axis {
    public static final int SCALE_AUTO = -1;
    public static final int SCALE_MILLISECOND = 0;
    public static final int SCALE_SECOND = 1;
    public static final int SCALE_MINUTE = 2;
    public static final int SCALE_HOUR = 3;
    public static final int SCALE_HOUR_BY_DAY = 4;
    public static final int SCALE_DAY = 5;
    public static final int SCALE_MONTH = 6;
    public static final int SCALE_YEAR = 7;
    public static final long MILLIS_PER_MILLI = 1L;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_MONTH = 2592000000L;
    public static final long MILLIS_PER_YEAR = 31536000000L;
    private long min = 1L;
    private long max = 0L;
    private long displayMin;
    private long displayMax;
    private long minIncrement;
    private long tickIncrement = -1L;
    private int tickSpacing = -1;
    private int scale = -1;
    private String axisLabel;
    private String[] labels;
    private int[] labelLens;
    private int maxLabelLen;
    private DateFormat valueFormat;
    private Lexicon lex;

    public TimeAxis(int n, AxisInfo axisInfo, Lexicon lexicon) {
        super(n, axisInfo);
        this.lex = lexicon;
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        this.checkFont();
        if (this.isHorizontal()) {
            n = 50;
            n2 = this.labelFm.getHeight() * 2 + 4 + 8;
        } else {
            n = this.maxLabelLen + 4 + 8;
            n2 = 50;
        }
        return new Dimension(n, n2);
    }

    public void doLayout() {
        super.doLayout();
        this.checkFont();
        this.tickSpacing = this.getTickSpacing();
        if (this.getDrawTickLabels()) {
            this.buildLabels();
        }
        this.axisLabel = this.getAxisTitle();
    }

    public String getAxisTitle() {
        boolean bl;
        SimpleDateFormat simpleDateFormat;
        String string = null;
        AxisInfo axisInfo = this.getAxisInfo();
        if (axisInfo != null) {
            string = axisInfo.getTitle();
        }
        if (string != null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = new Date(this.displayMin);
        gregorianCalendar.setTime(date);
        Date date2 = new Date(this.displayMax);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date2);
        if (this.lex != null) {
            try {
                simpleDateFormat = new SimpleDateFormat(this.lex.getText("timeAxisDateFormat"), new Locale(this.lex.language, ""));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                simpleDateFormat = new SimpleDateFormat("MMM d, yyyy", new Locale(this.lex.language, ""));
            }
        } else {
            simpleDateFormat = new SimpleDateFormat("MMM d, yyyy");
        }
        stringBuffer.append(simpleDateFormat.format(date));
        boolean bl2 = bl = gregorianCalendar.get(1) == gregorianCalendar2.get(1) && gregorianCalendar.get(2) == gregorianCalendar2.get(2) && gregorianCalendar.get(5) == gregorianCalendar2.get(5);
        if (!bl) {
            if (this.lex != null) {
                stringBuffer.append(" " + this.lex.getText("to") + " ");
            } else {
                stringBuffer.append(" to ");
            }
            stringBuffer.append(simpleDateFormat.format(date2));
        }
        return stringBuffer.toString();
    }

    protected void resetLayout() {
        this.tickIncrement = -1L;
        this.tickSpacing = -1;
        this.scale = -1;
        this.axisLabel = null;
        this.labels = null;
        this.labelLens = null;
        this.maxLabelLen = 0;
        this.valueFormat = null;
    }

    public void paintAxis(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        boolean bl = this.getDrawTicks();
        boolean bl2 = this.getDrawTickLabels();
        this.checkFont();
        String[] stringArray = null;
        if (bl2) {
            stringArray = this.getLabels();
        }
        boolean bl3 = false;
        int n4 = 0;
        this.setFont(this.labelFont);
        if (!this.isHorizontal()) {
            n = n3 - this.getFirstTickSpacing();
            int n5 = this.labelFm.getAscent() / 2;
            graphics.setColor(Color.black);
            int n6 = 0;
            n4 = n3;
            while (n > 0) {
                if (bl2) {
                    int n7 = n + n5 - 1;
                    boolean bl4 = bl3 = n7 + 2 < n4 - 2 && n - n5 > 0;
                    if (n6 < stringArray.length && bl3) {
                        graphics.drawString(stringArray[n6], n2 - 4 - 4 - this.labelLens[n6], n7);
                        n4 = n7 + this.labelFm.getAscent();
                    }
                }
                if (bl) {
                    if (bl3) {
                        graphics.drawLine(n2 - 4, n, n2, n);
                    } else {
                        graphics.drawLine(n2 - 4 - 2, n, n2, n);
                    }
                }
                n -= this.tickSpacing;
                ++n6;
            }
        } else {
            n = this.getFirstTickSpacing();
            int n8 = 8 + this.labelFm.getAscent();
            int n9 = 0;
            int n10 = this.maxLabelLen / 2;
            n4 = 0;
            bl3 = true;
            graphics.setColor(Color.black);
            int n11 = 0;
            while (n < n2) {
                bl3 = false;
                if (bl2) {
                    int n12 = this.labelLens[n11] / 2;
                    n9 = n - n12;
                    boolean bl5 = bl3 = n - n10 - 2 > n4 + 2 && n9 + this.labelLens[n11] < n2;
                    if (bl3) {
                        graphics.drawString(stringArray[n11], n9, n8);
                        n4 = n + n10;
                    }
                }
                if (bl && n != 0) {
                    if (bl3) {
                        graphics.drawLine(n, 0, n, 6);
                    } else {
                        graphics.drawLine(n, 0, n, 2);
                    }
                }
                n += this.tickSpacing;
                ++n11;
            }
        }
        if (this.axisLabel != null) {
            n = 8 + this.labelFm.getAscent() + this.labelFm.getHeight();
            graphics.drawString(this.axisLabel, (n2 - this.labelFm.stringWidth(this.axisLabel)) / 2, n);
        }
    }

    private String[] getLabels() {
        if (this.labels == null) {
            this.buildLabels();
        }
        return this.labels;
    }

    private void buildLabels() {
        this.checkFont();
        int n = this.getAxisLength() / this.getTickSpacing() + 1;
        this.labels = new String[n];
        this.labelLens = new int[n];
        long l = this.getFirstIncrement();
        this.maxLabelLen = 0;
        for (int i = 0; i < n; ++i) {
            this.labels[i] = this.getTickLabel(new Date(l));
            this.labelLens[i] = this.labelFm.stringWidth(this.labels[i]);
            this.maxLabelLen = Math.max(this.labelLens[i], this.maxLabelLen);
            l += this.getTickIncrement();
        }
    }

    public String getDefaultTickLabel(Object object) {
        if (object instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getLabelTemplate());
            if (this.lex != null) {
                simpleDateFormat = new SimpleDateFormat(this.getLabelTemplate(), new Locale(this.lex.language, ""));
            }
            return simpleDateFormat.format((Date)object);
        }
        if (object instanceof Number) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getLabelTemplate());
            if (this.lex != null) {
                simpleDateFormat = new SimpleDateFormat(this.getLabelTemplate(), new Locale(this.lex.language, ""));
            }
            return simpleDateFormat.format(new Date(((Number)object).longValue()));
        }
        return null;
    }

    public String getDefaultValueLabel(Object object) {
        if (object instanceof Number) {
            if (this.valueFormat == null) {
                if (this.lex != null) {
                    try {
                        this.valueFormat = new SimpleDateFormat(this.lex.getText("valueDateFormat"), new Locale(this.lex.language, ""));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.valueFormat = new SimpleDateFormat("EEE d MMM yyyy, h:mm:ssa", new Locale(this.lex.language, ""));
                    }
                } else {
                    this.valueFormat = new SimpleDateFormat("EEE d MMM yyyy, h:mm:ssa");
                }
            }
            return this.valueFormat.format(new Date(((Number)object).longValue()));
        }
        return null;
    }

    public String pixelToLabel(int n) {
        long l = this.pixelToValue(n);
        return this.getValueLabel(new Long(l));
    }

    private String format(long l) {
        return new Date(l).toString();
    }

    public void updateRange(long l, long l2) {
        if (this.min > this.max) {
            this.min = l;
            this.max = l2;
        } else {
            this.min = Math.min(this.min, l);
            this.max = Math.max(this.max, l2);
        }
        if (this.min >= this.max) {
            this.max = this.min + 3600000L;
        }
        this.displayMin = this.min;
        this.displayMax = this.max;
        this.updateDisplayRange();
    }

    private void updateDisplayRange() {
        long l = this.minIncrement = this.getMinIncrement(this.displayMin, this.displayMax);
        long l2 = !this.isHorizontal() ? ((float)(this.displayMin % l) == 0.0f ? this.displayMin : (this.displayMin >= 0L ? (long)((int)(this.displayMin / l)) * l : (long)((int)(this.displayMin / l * l)) - l)) : this.displayMin;
        long l3 = (float)(this.displayMax % l) == 0.0f ? this.displayMax : (this.max >= 0L ? (long)((int)(this.displayMax / l)) * l + l : (long)((int)(this.displayMax / l)) * l);
        this.displayMin = l2;
        this.displayMax = l3;
    }

    private long getMinIncrement(long l, long l2) {
        long l3 = l2 - l;
        if (l3 < 1000L) {
            return 1L;
        }
        if (l3 < 60000L) {
            return 1000L;
        }
        if (l3 < 3600000L) {
            return 60000L;
        }
        return 3600000L;
    }

    private long getFirstIncrement() {
        if (this.displayMin % this.minIncrement == 0L) {
            return this.displayMin;
        }
        if (this.displayMin >= 0L) {
            return this.displayMin / this.minIncrement * this.minIncrement + this.minIncrement;
        }
        return this.displayMin / this.minIncrement * this.minIncrement;
    }

    public double getPixelsPerUnit() {
        return (double)this.getAxisLength() / (double)(this.displayMax - this.displayMin);
    }

    private long getTickIncrement() {
        if (this.tickIncrement != -1L) {
            return this.tickIncrement;
        }
        long l = this.getFirstIncrement();
        long l2 = this.minIncrement;
        int n = (int)((this.displayMax - l) / l2);
        while (n > 30) {
            n = (int)((this.displayMax - l) / (l2 *= 2L));
        }
        return l2;
    }

    public int getFirstTickSpacing() {
        if (!this.isHorizontal()) {
            return this.getTickSpacing();
        }
        long l = this.getFirstIncrement();
        return (int)((double)(l - this.displayMin) * this.getPixelsPerUnit());
    }

    public int getTickSpacing() {
        if (this.tickSpacing != -1 && this.tickSpacing != 0) {
            return this.tickSpacing;
        }
        this.tickSpacing = (int)((double)this.getTickIncrement() * this.getPixelsPerUnit());
        return this.tickSpacing;
    }

    public int valueToPixel(Object object) {
        if (object instanceof Number) {
            return this.valueToPixel(((Number)object).longValue());
        }
        if (object instanceof Date) {
            return this.valueToPixel(((Date)object).getTime());
        }
        return -1;
    }

    public int indexToPixel(Series series, int n) {
        return this.valueToPixel(((TimeSeries)series).getTimestamp(n));
    }

    public int valueToPixel(long l) {
        int n = this.getAxisLength();
        long l2 = this.getFirstIncrement();
        int n2 = this.getFirstTickSpacing();
        int n3 = 0;
        if (l < l2) {
            double d = (double)(l - this.displayMin) / (double)(l2 - this.displayMin);
            n3 = (int)((double)n2 * d);
        } else {
            long l3 = this.getTickIncrement();
            int n4 = this.getTickSpacing();
            int n5 = (int)((l - l2) / l3);
            int n6 = n2 + n5 * n4;
            long l4 = l2 + (long)n5 * l3;
            double d = (double)(l - l4) / (double)l3;
            n3 = n6 + (int)((double)n4 * d);
        }
        if (!this.isHorizontal()) {
            n3 = this.getAxisLength() - n3;
        }
        return n3;
    }

    public long pixelToValue(int n) {
        int n2 = this.getAxisLength();
        int n3 = this.getFirstTickSpacing();
        long l = this.getFirstIncrement();
        if (!this.isHorizontal()) {
            n = this.getHeight() - n;
        }
        if (n < n3) {
            return this.displayMin + (long)((double)(l - this.displayMin) * ((double)n / (double)n3));
        }
        int n4 = this.getTickSpacing();
        int n5 = (n - n3) / n4;
        int n6 = n3 + n5 * n4;
        long l2 = l + (long)n5 * this.getTickIncrement();
        return l2 + (long)((double)this.getTickIncrement() * ((double)(n - n6) / (double)n4));
    }

    public int getScale() {
        if (this.scale != -1) {
            return this.scale;
        }
        long l = this.displayMax - this.displayMin;
        if (l <= this.getMillisInScale(1)) {
            return 0;
        }
        if (l <= this.getMillisInScale(2) * 3L) {
            return 1;
        }
        if (l <= this.getMillisInScale(3) * 12L) {
            return 2;
        }
        if (l <= this.getMillisInScale(5)) {
            return 3;
        }
        if (l <= this.getMillisInScale(7) * 3L) {
            return 4;
        }
        return 7;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public long getMillisInScale(int n) {
        switch (n) {
            case -1: {
                return 1L;
            }
            case 0: {
                return 1L;
            }
            case 1: {
                return 1000L;
            }
            case 2: {
                return 60000L;
            }
            case 3: {
                return 3600000L;
            }
            case 5: {
                return 86400000L;
            }
            case 6: {
                return 2592000000L;
            }
            case 7: {
                return 31536000000L;
            }
        }
        return 1L;
    }

    public String getLabelTemplate() {
        int n = this.getScale();
        if (this.lex != null) {
            if (n == 7) {
                return this.lex.getText("yearScaleFormat");
            }
            if (n == 6) {
                return this.lex.getText("monthScaleFormat");
            }
            if (n == 5) {
                return this.lex.getText("dayScaleFormat");
            }
            if (n == 3) {
                return this.lex.getText("hourScaleFormat");
            }
            if (n == 4) {
                return this.lex.getText("hourByDayScaleFormat");
            }
            if (n == 2) {
                return this.lex.getText("minuteScaleFormat");
            }
            if (n == 1) {
                return this.lex.getText("secondScaleFormat");
            }
            if (n == 0) {
                return this.lex.getText("millisScaleFormat");
            }
            return this.lex.getText("defaultScaleFormat");
        }
        if (n == 7) {
            return "yyyy";
        }
        if (n == 6) {
            return "MMM yyyy";
        }
        if (n == 5) {
            return "MMM d";
        }
        if (n == 3) {
            return "H:mm";
        }
        if (n == 4) {
            return "MMM d, h:mma";
        }
        if (n == 2) {
            return "h:mma";
        }
        if (n == 1) {
            return ":mm:ss";
        }
        if (n == 0) {
            return ":mm:ss.SSS";
        }
        return "d MMM yyyy, h:mma";
    }

    protected Axis.ZoomRec doZoomIn(int n, int n2) {
        long l;
        long l2;
        if (this.isHorizontal()) {
            l2 = this.pixelToValue(n);
            l = this.pixelToValue(n2);
        } else {
            l = this.pixelToValue(n);
            l2 = this.pixelToValue(n2);
        }
        if (l2 >= l) {
            return null;
        }
        TimeZoomRec timeZoomRec = new TimeZoomRec(this.displayMin, this.displayMax);
        this.displayMin = l2;
        this.displayMax = l;
        this.updateDisplayRange();
        return timeZoomRec;
    }

    protected void zoomOut(Axis.ZoomRec zoomRec) {
        TimeZoomRec timeZoomRec = (TimeZoomRec)zoomRec;
        this.displayMin = timeZoomRec.min;
        this.displayMax = timeZoomRec.max;
        this.updateDisplayRange();
    }

    private class TimeZoomRec
    implements Axis.ZoomRec {
        public long min;
        public long max;

        public TimeZoomRec(long l, long l2) {
            this.min = l;
            this.max = l2;
        }
    }
}

