/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.function.Mean;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.StandardNormalValue;
import com.tridium.eas.function.Variance;
import java.util.ArrayList;
import javax.baja.units.BUnit;

public abstract class Series {
    public ArrayList popList = null;
    public static final int FLOAT = 0;
    public static final int INTEGER = 1;
    public static final int ENUM = 2;
    public static final int BOOLEAN = 3;

    public abstract String getSeriesName();

    public abstract int getRowCount();

    public String getRowName(int n) {
        return null;
    }

    public int getValueCount() {
        return 1;
    }

    public String getValueName(int n) {
        return null;
    }

    public abstract int getValueType();

    public abstract double getValue(int var1, int var2);

    public boolean isValid(int n, int n2) {
        return true;
    }

    public String getValueLabel(int n, int n2) {
        System.out.println("*** NOT IMPLEMENTED: Series.getValueLabel ***");
        return null;
    }

    public abstract double getMin(int var1);

    public abstract double getMax(int var1);

    public double getMin() {
        int n = this.getValueCount();
        if (n == 0) {
            return 0.0;
        }
        if (n == 1) {
            return this.getMin(0);
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.getMin(i));
        }
        return d;
    }

    public double getMax() {
        int n = this.getValueCount();
        if (n == 0) {
            return 100.0;
        }
        if (n == 1) {
            return this.getMax(0);
        }
        double d = -1.7976931348623157E308;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.getMax(i));
        }
        return d;
    }

    public double getMinRowTotal() {
        int n = this.getValueCount();
        if (n == 1) {
            return this.getMin(0);
        }
        throw new UnsupportedOperationException("This series does not provide row total min/max");
    }

    public double getMaxRowTotal() {
        int n = this.getValueCount();
        if (n == 1) {
            return this.getMax(0);
        }
        throw new UnsupportedOperationException("This series does not provide row total min/max");
    }

    public void resetStatistics() {
        this.popList = new ArrayList();
    }

    public double getValueMean(int n) {
        return ((ValuePopulation)this.getValuePopulation(n)).getMean();
    }

    public double getValueVariance(int n) {
        return ((ValuePopulation)this.getValuePopulation(n)).getVariance();
    }

    public double getValueStandardDeviation(int n) {
        return Math.sqrt(this.getValueVariance(n));
    }

    public double getStandardNormalValue(int n, int n2) {
        return StandardNormalValue.getStandardNormalValue(this.getValuePopulation(n2), this.getValueMean(n2), this.getValueStandardDeviation(n2), n);
    }

    public Population[] getValuePopulations() {
        if (this.popList == null) {
            for (int i = 0; i < this.getValueCount(); ++i) {
                this.getValuePopulation(i);
            }
        }
        Population[] populationArray = new Population[this.popList.size()];
        this.popList.toArray(populationArray);
        return populationArray;
    }

    public Population getValuePopulation(int n) {
        if (this.popList == null) {
            this.popList = new ArrayList();
        }
        while (this.popList.size() <= n) {
            this.popList.add(null);
        }
        ValuePopulation valuePopulation = new ValuePopulation(n);
        this.popList.set(n, valuePopulation);
        return valuePopulation;
    }

    public abstract BUnit getValueUnits();

    public class ValuePopulation
    implements Population {
        private int valueIndex;
        private Double mean = null;
        private Double variance = null;

        public ValuePopulation(int n) {
            this.valueIndex = n;
        }

        public int getSize() {
            return Series.this.getRowCount();
        }

        public double getSample(int n) {
            return Series.this.getValue(n, this.valueIndex);
        }

        public boolean isValid(int n) {
            return Series.this.isValid(n, this.valueIndex);
        }

        public double getMean() {
            if (this.mean == null) {
                this.mean = new Double(Mean.getMean(this));
            }
            return this.mean;
        }

        public double getVariance() {
            if (this.variance == null) {
                this.variance = new Double(Variance.getVariance(this, this.getMean()));
            }
            return this.variance;
        }

        public BUnit getUnit() {
            return Series.this.getValueUnits();
        }
    }
}

