/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.function.Maximum;
import com.tridium.eas.function.Minimum;
import com.tridium.eas.function.Population;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.eas.ui.chart.ValueColors;
import java.awt.Color;
import javax.baja.units.BUnit;

public class PopulationTimeSeries
extends TimeSeries
implements ValueColors {
    protected Population[] valuePopulations;
    protected Color[] valueColors;
    protected String[] valueNames;
    private Population timePopulation;
    private BUnit valueUnit;
    private String seriesName;
    private double rangeMin;
    private double rangeMax;

    public PopulationTimeSeries(Population population, Population[] populationArray, BUnit bUnit, double d, double d2) {
        this(population, populationArray, new String[0], new Color[0], bUnit, d, d2);
    }

    public PopulationTimeSeries(Population population, Population[] populationArray, BUnit bUnit) {
        this(population, populationArray, new String[0], new Color[0], bUnit, Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public PopulationTimeSeries(Population population, Population population2, String string, Color color) {
        this(population, population2, string, color, population2.getUnit(), Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public PopulationTimeSeries(Population population, Population population2, String string, Color color, double d, double d2) {
        this(population, population2, string, color, population2.getUnit(), d, d2);
    }

    public PopulationTimeSeries(Population population, Population population2, String string, Color color, BUnit bUnit) {
        this(population, new Population[]{population2}, new String[]{string}, new Color[]{color}, bUnit, Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public PopulationTimeSeries(Population population, Population population2, String string, Color color, BUnit bUnit, double d, double d2) {
        this(population, new Population[]{population2}, new String[]{string}, new Color[]{color}, bUnit, d, d2);
    }

    public PopulationTimeSeries(Population population, Population[] populationArray, BUnit bUnit, Series series) {
        this(population, populationArray, bUnit, series, Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public PopulationTimeSeries(Population population, Population[] populationArray, BUnit bUnit, Series series, double d, double d2) {
        this.timePopulation = population;
        this.valuePopulations = populationArray;
        this.valueUnit = bUnit;
        this.rangeMin = d;
        this.rangeMax = d2;
        this.valueNames = new String[series.getValueCount()];
        this.valueColors = new Color[series.getValueCount()];
        for (int i = 0; i < series.getValueCount(); ++i) {
            this.valueNames[i] = series.getValueName(i);
            this.valueColors[i] = series instanceof ValueColors ? ((ValueColors)((Object)series)).getValueColor(i) : Color.lightGray;
        }
    }

    public PopulationTimeSeries(Population population, Population[] populationArray, String[] stringArray, Color[] colorArray, BUnit bUnit) {
        this(population, populationArray, stringArray, colorArray, bUnit, Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public PopulationTimeSeries(Population population, Population[] populationArray, String[] stringArray, Color[] colorArray, BUnit bUnit, double d, double d2) {
        this.timePopulation = population;
        this.valuePopulations = populationArray;
        this.valueNames = stringArray;
        this.valueColors = colorArray;
        this.valueUnit = bUnit;
        this.rangeMin = d;
        this.rangeMax = d2;
    }

    public long getTimestamp(int n) {
        return (long)this.timePopulation.getSample(n);
    }

    public long getMinTimestamp() {
        return (long)this.timePopulation.getSample(0);
    }

    public long getMaxTimestamp() {
        return (long)this.timePopulation.getSample(this.timePopulation.getSize() - 1);
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public void setSeriesName(String string) {
        this.seriesName = string;
    }

    public int getRowCount() {
        return this.timePopulation.getSize();
    }

    public int getValueCount() {
        return this.valuePopulations.length;
    }

    public int getValueType() {
        return 0;
    }

    public double getValue(int n, int n2) {
        return this.getValueUnits().fromNormal(this.valuePopulations[n2].getUnit().toNormal(this.valuePopulations[n2].getSample(n)));
    }

    public boolean isValid(int n, int n2) {
        return this.valuePopulations[n2].isValid(n);
    }

    public Color getValueColor(int n) {
        return this.valueColors[n];
    }

    public double getMin(int n) {
        return Math.min(this.rangeMin, this.getValueUnits().fromNormal(this.valuePopulations[n].getUnit().toNormal(Minimum.getMinimum(this.valuePopulations[n], this.checkValidOnRange()))));
    }

    public double getMax(int n) {
        return Math.max(this.rangeMax, this.getValueUnits().fromNormal(this.valuePopulations[n].getUnit().toNormal(Maximum.getMaximum(this.valuePopulations[n], this.checkValidOnRange()))));
    }

    protected boolean checkValidOnRange() {
        return false;
    }

    public String getValueName(int n) {
        return this.valueNames[n];
    }

    public BUnit getValueUnits() {
        return this.valueUnit;
    }

    public Population getTimePopulation() {
        return this.timePopulation;
    }

    public void setRangeMin(double d) {
        this.rangeMin = d;
    }

    public void setRangeMax(double d) {
        this.rangeMax = d;
    }
}

