/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartCanvas;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultPieConfig;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.PieConfig;
import com.tridium.eas.ui.chart.Series;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.Random;
import javax.baja.units.BUnit;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class PieCanvas
extends ChartCanvas {
    private static final int PIE_MARGIN = 5;
    private int rows = 0;
    private int cols = 0;
    private int rowHeight;
    private int colWidth;
    private PieSpec[] specs;
    private boolean showPieLabels;
    private boolean showSliceLabels;
    private Font labelFont;
    private FontMetrics labelFm;

    public PieCanvas(Chart chart, Id id) {
        super(chart, id);
    }

    public boolean requiresAxes() {
        return false;
    }

    protected void checkFont() {
        if (this.labelFont == null) {
            Font font = UIManager.getFont("Table.font");
            this.labelFont = font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), font.getSize());
            this.labelFm = Toolkit.getDefaultToolkit().getFontMetrics(this.labelFont);
        }
    }

    public void doLayout() {
        int n;
        Series series = this.getSeries();
        int n2 = series.getRowCount();
        if (n2 == 0) {
            return;
        }
        double d = Math.sqrt(n2);
        this.cols = (double)((int)d) < d ? (int)d + 1 : (int)d;
        int n3 = n2 / this.cols;
        if (n3 * this.cols < n2) {
            ++n3;
        }
        this.rowHeight = this.getHeight() / n3;
        this.colWidth = this.getWidth() / this.cols;
        if (this.specs == null) {
            this.specs = new PieSpec[n2];
            for (n = 0; n < n2; ++n) {
                this.specs[n] = new PieSpec(n);
                this.specs[n].rebuild();
            }
        }
        this.showPieLabels = series.getRowName(0) != null;
        boolean bl = this.showSliceLabels = series.getValueLabel(0, 0) != null;
        if (this.showSliceLabels) {
            this.checkFont();
            n = Math.min(this.rowHeight, this.colWidth);
            this.showSliceLabels = n > this.labelFm.getAscent() * 5 && n > this.labelFm.stringWidth("00000") * 4;
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getSeries().getRowCount();
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 = n7 * this.colWidth;
            n5 = n6 * this.rowHeight;
            this.drawChart(graphics2D, i, this.specs[i], n4, n5, this.colWidth, this.rowHeight);
            if (++n7 != this.cols) continue;
            n7 = 0;
            ++n6;
        }
    }

    private void drawChart(Graphics2D graphics2D, int n, PieSpec pieSpec, int n2, int n3, int n4, int n5) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n6 = 0;
        if (this.showPieLabels) {
            this.checkFont();
            n6 = this.labelFm.getAscent();
        }
        int n7 = n4 - n6 - 10;
        int n8 = n5 - n6 - 10;
        int n9 = 0;
        int n10 = 0;
        if (this.showSliceLabels) {
            n9 = this.labelFm.stringWidth("000000");
            n10 = this.labelFm.getAscent();
            n7 -= n9 * 2;
            n8 -= n10 * 2;
        }
        if (n7 > n8) {
            n7 = n8;
        } else {
            n8 = n7;
        }
        int n11 = n2 + (n4 - n7) / 2;
        int n12 = this.showPieLabels ? n3 + (n5 - n8 - n6) / 2 : n3 + (n5 - n8) / 2;
        int n13 = n11 + n7 / 2;
        int n14 = n12 + n8 / 2;
        Series series = this.getSeries();
        int n15 = series.getValueCount();
        int n16 = 0;
        Arc2D.Float float_ = new Arc2D.Float(n11 - 5, n12 - 5, n7 + 10, n8 + 10, 0.0f, 0.0f, 2);
        Arc2D.Float float_2 = new Arc2D.Float(n11, n12, n7, n8, 0.0f, 0.0f, 2);
        PieConfig pieConfig = (PieConfig)this.getConfig();
        Color color = pieConfig.getBorderColor();
        LabelBounds[] labelBoundsArray = new LabelBounds[n15];
        int n17 = 0;
        for (int i = 0; i < n15; ++i) {
            String string;
            if (pieSpec.degrees[i] == 0) continue;
            graphics2D.setColor(pieConfig.getValueColor(i));
            float_2.setAngleStart(n16);
            float_2.setAngleExtent(pieSpec.degrees[i]);
            graphics2D.fill(float_2);
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.draw(float_2);
            }
            if (this.showSliceLabels && (string = series.getValueLabel(n, i)) != null) {
                boolean bl;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                graphics2D.setColor(Color.black);
                float_.setAngleStart(n16);
                float_.setAngleExtent(pieSpec.degrees[i] / 2);
                Point2D point2D = float_.getEndPoint();
                int n18 = (int)point2D.getX();
                int n19 = (int)point2D.getY();
                boolean bl2 = n13 - n18 <= 0;
                boolean bl3 = bl = n14 - n19 >= 0;
                if (bl2) {
                    if (bl) {
                        LabelBounds labelBounds = new LabelBounds(n18, n19, this.labelFm.stringWidth(string), this.labelFm.getHeight());
                        if (!PieCanvas.labelCollision(labelBoundsArray, labelBounds)) {
                            graphics2D.drawString(string, n18, n19);
                            labelBoundsArray[n17] = labelBounds;
                            ++n17;
                        }
                    } else {
                        LabelBounds labelBounds = new LabelBounds(n18, n19 + this.labelFm.getAscent(), this.labelFm.stringWidth(string), this.labelFm.getHeight());
                        if (!PieCanvas.labelCollision(labelBoundsArray, labelBounds)) {
                            graphics2D.drawString(string, n18, n19 + this.labelFm.getAscent());
                            labelBoundsArray[n17] = labelBounds;
                            ++n17;
                        }
                    }
                } else {
                    LabelBounds labelBounds;
                    int n20 = n18 - this.labelFm.stringWidth(string);
                    if (bl) {
                        labelBounds = new LabelBounds(n20, n19, this.labelFm.stringWidth(string), this.labelFm.getHeight());
                        if (!PieCanvas.labelCollision(labelBoundsArray, labelBounds)) {
                            graphics2D.drawString(string, n20, n19);
                            labelBoundsArray[n17] = labelBounds;
                            ++n17;
                        }
                    } else {
                        labelBounds = new LabelBounds(n20, n19 + this.labelFm.getAscent(), this.labelFm.stringWidth(string), this.labelFm.getHeight());
                        if (!PieCanvas.labelCollision(labelBoundsArray, labelBounds)) {
                            graphics2D.drawString(string, n20, n19 + this.labelFm.getAscent());
                            labelBoundsArray[n17] = labelBounds;
                            ++n17;
                        }
                    }
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            n16 += pieSpec.degrees[i];
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        if (this.showPieLabels) {
            graphics2D.setColor(Color.black);
            graphics2D.setFont(this.labelFont);
            String string = series.getRowName(n);
            int n21 = n3 + n5 - 4;
            int n22 = n2 + (n4 - this.labelFm.stringWidth(string)) / 2;
            graphics2D.drawString(string, n22, n21);
        }
    }

    private static boolean labelCollision(LabelBounds[] labelBoundsArray, LabelBounds labelBounds) {
        if (labelBoundsArray == null || labelBounds == null) {
            return false;
        }
        for (int i = 0; i < labelBoundsArray.length; ++i) {
            if (labelBoundsArray[i] == null) {
                return false;
            }
            if (!labelBoundsArray[i].intersects(labelBounds)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        Chart chart = new Chart();
        ChartModel chartModel = chart.getModel();
        TestSeries testSeries = new TestSeries(3, 5);
        DefaultPieConfig defaultPieConfig = new DefaultPieConfig();
        chartModel.addSeries(testSeries, defaultPieConfig, null, null);
        JFrame jFrame = new JFrame();
        jFrame.setBounds(200, 200, 500, 500);
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)chart, "Center");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    public static class TestSeries
    extends Series {
        double[][] values;

        public TestSeries(int n, int n2) {
            Random random = new Random();
            this.values = new double[n][n2];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    this.values[i][j] = 100.0f + 20.0f * random.nextFloat();
                }
            }
        }

        public String getSeriesName() {
            return "TestSeries";
        }

        public int getRowCount() {
            return this.values.length;
        }

        public String getRowName(int n) {
            return "rowName" + n;
        }

        public int getValueCount() {
            return this.values[0].length;
        }

        public String getValueName(int n) {
            return "valueName" + n;
        }

        public int getValueType() {
            return 0;
        }

        public double getValue(int n, int n2) {
            return this.values[n][n2];
        }

        public String getValueLabel(int n, int n2) {
            return "valueLabel" + n + "," + n2;
        }

        public double getMin(int n) {
            return this.getMin();
        }

        public double getMax(int n) {
            return this.getMax();
        }

        public double getMin() {
            return 0.0;
        }

        public double getMax() {
            return 1.0;
        }

        public BUnit getValueUnits() {
            return BUnit.getUnit((String)"kilowatt hour");
        }
    }

    private class LabelBounds {
        private Rectangle rect;

        public LabelBounds(int n, int n2, int n3, int n4) {
            this.rect = new Rectangle(n, n2 + n4, n3, n4);
        }

        public boolean intersects(LabelBounds labelBounds) {
            return this.rect.intersects(labelBounds.rect);
        }
    }

    private class PieSpec {
        public int row;
        public int[] degrees;

        public PieSpec(int n) {
            this.row = n;
        }

        public void rebuild() {
            int n;
            Series series = PieCanvas.this.getSeries();
            int n2 = series.getValueCount();
            if (n2 == 0) {
                return;
            }
            double d = 0.0;
            for (n = 0; n < n2; ++n) {
                double d2 = series.getValue(this.row, n);
                if (!(d2 > 0.0)) continue;
                d += d2;
            }
            this.degrees = new int[n2];
            if (n2 > 0) {
                n = 0;
                for (int i = 0; i < n2 - 1; ++i) {
                    double d3 = series.getValue(this.row, i);
                    if (d3 > 0.0) {
                        this.degrees[i] = (int)(d3 / d * 360.0);
                        n += this.degrees[i];
                        continue;
                    }
                    this.degrees[i] = 0;
                }
                this.degrees[this.degrees.length - 1] = d > 0.0 ? 360 - n : 0;
            }
        }
    }
}

