/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Overlay;
import com.tridium.eas.ui.chart.ValueToPixel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class LineOverlay
extends Overlay {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation;
    private Number location;
    private Stroke stroke;
    private Color color = Color.black;

    public LineOverlay(int n, double d) {
        this(n, new Double(d));
    }

    public LineOverlay(int n, float f) {
        this(n, new Float(f));
    }

    public LineOverlay(int n, int n2) {
        this(n, new Integer(n2));
    }

    public LineOverlay(int n, long l) {
        this(n, new Long(l));
    }

    public LineOverlay(int n, Number number) {
        this.orientation = n;
        this.location = number;
    }

    public Number getLocation() {
        return this.location;
    }

    public void setLocation(Number number) {
        this.location = number;
        this.fireModified();
    }

    public void setLocation(double d) {
        this.setLocation(new Double(d));
    }

    public void setLocation(float f) {
        this.setLocation(new Float(f));
    }

    public void setLocation(int n) {
        this.setLocation(new Integer(n));
    }

    public void setLocation(long l) {
        this.setLocation(new Long(l));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.fireModified();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.fireModified();
    }

    public void paint(Graphics graphics, int n, int n2, ValueToPixel valueToPixel) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.color);
        Stroke stroke = graphics2D.getStroke();
        if (this.stroke != null) {
            graphics2D.setStroke(this.stroke);
        }
        if (this.orientation == 0) {
            if (!valueToPixel.hasY()) {
                throw new IllegalStateException("Horizontal line requires a y axis.");
            }
            int n3 = valueToPixel.getYPixel(this.location);
            graphics2D.drawLine(0, n3, n, n3);
        } else {
            if (!valueToPixel.hasX()) {
                throw new IllegalStateException("Vertical line requires a x axis.");
            }
            int n4 = valueToPixel.getXPixel(this.location);
            graphics2D.drawLine(n4, 0, n4, n2);
        }
        graphics2D.setStroke(stroke);
    }
}

