/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.AreaConfig;
import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartCanvas;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultAreaConfig;
import com.tridium.eas.ui.chart.FloatAxis;
import com.tridium.eas.ui.chart.FloatSeries;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.IntAxis;
import com.tridium.eas.ui.chart.LineConfig;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.TimeAxis;
import com.tridium.eas.ui.chart.TimeSeries;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.util.Random;
import javax.baja.units.BUnit;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class LineCanvas
extends ChartCanvas {
    private Stroke stroke;

    public LineCanvas(Chart chart, Id id) {
        super(chart, id);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        LineConfig lineConfig = (LineConfig)this.getConfig();
        if (this.stroke == null) {
            this.stroke = lineConfig.getStroke();
        }
        graphics2D.setStroke(this.stroke);
        Series series = this.getSeries();
        if (series instanceof TimeSeries) {
            this.paintSeries(graphics, (TimeAxis)this.getXAxis(), (FloatAxis)this.getYAxis(), (TimeSeries)series);
        } else if (series instanceof FloatSeries) {
            this.paintSeries(graphics, (FloatAxis)this.getXAxis(), (FloatAxis)this.getYAxis(), (FloatSeries)series);
        } else {
            this.paintSeries(graphics, (IntAxis)this.getXAxis(), (FloatAxis)this.getYAxis(), series);
        }
        graphics2D.setStroke(stroke);
    }

    private void paintSeries(Graphics graphics, Axis axis, FloatAxis floatAxis, Series series) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = series.getRowCount();
        int n2 = series.getValueCount();
        if (n == 0) {
            return;
        }
        LineConfig lineConfig = (LineConfig)this.getConfig();
        boolean bl = lineConfig.getChartType() == 3;
        boolean bl2 = lineConfig.isDiscrete();
        Color color = null;
        Color color2 = null;
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            int n5 = n4 = axis.indexToPixel(series, 0);
            int n6 = n3 = floatAxis.valueToPixel(series.getValue(0, i));
            if (bl) {
                color2 = lineConfig.getValueColor(i);
                color = ((AreaConfig)lineConfig).getLineColor(i);
            } else {
                color = lineConfig.getValueColor(i);
            }
            int n7 = (bl2 ? n * 2 : n) + 1;
            GeneralPath generalPath = new GeneralPath(0, n7);
            generalPath.moveTo(n4, n3);
            for (int j = 0; j < n; ++j) {
                int n8 = axis.indexToPixel(series, j);
                int n9 = floatAxis.valueToPixel(series.getValue(j, i));
                if (bl2) {
                    generalPath.lineTo(n8, n3);
                    generalPath.lineTo(n8, n9);
                } else {
                    generalPath.lineTo(n8, n9);
                }
                n4 = n8;
                n3 = n9;
            }
            if (bl2) {
                n4 = this.getWidth();
                generalPath.lineTo(n4, n3);
            }
            if (bl) {
                generalPath.lineTo(n4, this.getHeight() + 5);
                generalPath.lineTo(n5, this.getHeight() + 5);
                graphics2D.setColor(color2);
                graphics2D.fill(generalPath);
            }
            if (!bl || color != null) {
                graphics2D.setColor(color);
                graphics2D.draw(generalPath);
            }
            if (!bl) continue;
            graphics2D.setColor(color2);
            graphics2D.drawLine(n4, n3 + 1, n4, this.getHeight() + 5);
        }
    }

    public static void main(String[] stringArray) {
        Chart chart = new Chart();
        ChartModel chartModel = chart.getModel();
        TestSeries testSeries = new TestSeries(10, 900000L);
        DefaultAreaConfig defaultAreaConfig = new DefaultAreaConfig(2, false, Color.red, Color.black);
        chartModel.addSeries(testSeries, defaultAreaConfig, null, null);
        JFrame jFrame = new JFrame();
        jFrame.setBounds(200, 200, 500, 500);
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)chart, "Center");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    public static class TestSeries
    extends FloatSeries {
        long startTime = System.currentTimeMillis();
        long endTime;
        long interval;
        double[] values;
        double min;
        double max;

        public TestSeries(int n, long l) {
            this.interval = l;
            this.endTime = this.startTime + (long)n * l;
            Random random = new Random();
            this.values = new double[n];
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
            for (int i = 0; i < n; ++i) {
                this.values[i] = 100.0f + 20.0f * random.nextFloat();
                this.min = Math.min(this.min, this.values[i]);
                this.max = Math.max(this.max, this.values[i]);
            }
        }

        public String getSeriesName() {
            return "TestSeries";
        }

        public int getRowCount() {
            return this.values.length;
        }

        public String getRowName(int n) {
            return "rowName" + n;
        }

        public int getValueCount() {
            return 1;
        }

        public String getValueName(int n) {
            return "valueName" + n;
        }

        public int getValueType() {
            return 0;
        }

        public double getValue(int n, int n2) {
            return this.values[n];
        }

        public String getValueLabel(int n, int n2) {
            return null;
        }

        public double getMin(int n) {
            return this.min;
        }

        public double getMax(int n) {
            return this.max;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getMinRowTotal() {
            return this.min;
        }

        public double getMaxRowTotal() {
            return this.max;
        }

        public BUnit getValueUnits() {
            return BUnit.getUnit((String)"kilowatt hour");
        }

        public double getDouble(int n) {
            return n;
        }

        public double getMinDouble() {
            return 0.0;
        }

        public double getMaxDouble() {
            return this.getRowCount();
        }

        public BUnit getDoubleUnits() {
            return BUnit.getUnit((String)"kilowatt hour");
        }

        public long getTimestamp(int n) {
            return this.startTime + (long)n * this.interval;
        }
    }
}

