/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.Series;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class IntAxis
extends Axis {
    private int displayMin;
    private int displayMax;
    private int min = 1;
    private int max = 0;
    private int tickIncrement = -1;
    private int tickSpacing = -1;
    private String[] labels;
    private int[] labelLens;
    private int maxLabelLen;

    public IntAxis(int n, AxisInfo axisInfo) {
        super(n, axisInfo);
    }

    public void updateRange(int n, int n2) {
        if (this.min > this.max) {
            this.min = n;
            this.max = n2;
        }
        this.min = this.displayMin = Math.min(this.min, n);
        this.max = this.displayMax = Math.max(this.max, n2);
    }

    private int getTickIncrement() {
        if (this.tickIncrement != -1) {
            return this.tickIncrement;
        }
        int n = this.displayMax - this.displayMin;
        this.tickIncrement = 1;
        int n2 = n / this.tickIncrement;
        while (n2 > 30) {
            ++this.tickIncrement;
            n2 = n / this.tickIncrement;
        }
        return this.tickIncrement;
    }

    private int getFirstIncrement() {
        int n = this.getTickIncrement();
        return this.displayMin + n;
    }

    private double getPixelsPerUnit() {
        return (double)this.getAxisLength() / (double)(this.displayMax - this.displayMin);
    }

    public int getTickSpacing() {
        if (this.tickSpacing != -1) {
            return this.tickSpacing;
        }
        while ((this.tickSpacing = (int)(this.getPixelsPerUnit() * (double)this.getTickIncrement())) < 10) {
            this.tickIncrement *= 2;
        }
        return this.tickSpacing;
    }

    public int indexToPixel(Series series, int n) {
        return this.valueToPixel(n);
    }

    public int valueToPixel(Object object) {
        if (object instanceof Number) {
            return this.valueToPixel(((Number)object).intValue());
        }
        return -1;
    }

    public int valueToPixel(int n) {
        return (int)((double)(n - this.displayMin) / (double)this.getTickIncrement() * (double)this.getTickSpacing());
    }

    public int pixelToValue(int n) {
        int n2 = this.getAxisLength();
        if (!this.isHorizontal()) {
            n = n2 - n;
        }
        return this.displayMin + (int)((double)n / (double)this.getTickSpacing() * (double)this.getTickIncrement());
    }

    private String[] getLabels() {
        if (this.labels == null) {
            this.buildLabels();
        }
        return this.labels;
    }

    private void buildLabels() {
        this.checkFont();
        int n = this.getAxisLength() / this.getTickSpacing() + 1;
        this.labels = new String[n];
        this.labelLens = new int[n];
        int n2 = this.displayMin + this.getTickIncrement();
        this.maxLabelLen = 0;
        for (int i = 0; i < n; ++i) {
            this.labels[i] = this.getTickLabel(new Integer(n2));
            this.labelLens[i] = this.labelFm.stringWidth(this.labels[i]);
            this.maxLabelLen = Math.max(this.labelLens[i], this.maxLabelLen);
            n2 += this.getTickIncrement();
        }
    }

    public String getDefaultTickLabel(Object object) {
        if (object instanceof Number) {
            return Integer.toString(((Number)object).intValue());
        }
        return null;
    }

    public String pixelToLabel(int n) {
        int n2 = this.pixelToValue(n);
        return this.getValueLabel(new Integer(n2));
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        this.checkFont();
        if (this.isHorizontal()) {
            n = 50;
            n2 = this.labelFm.getHeight() + 4 + 8;
            String string = this.getAxisTitle();
            if (string != null) {
                n2 += this.titleFm.getHeight();
            }
        } else {
            String string = this.getTickLabel(new Integer(this.displayMax));
            n = this.labelFm.stringWidth(string) + 4 + 8;
            String string2 = this.getAxisTitle();
            if (string2 != null) {
                n += this.titleFm.getHeight();
            }
            n2 = 50;
        }
        return new Dimension(n, n2);
    }

    protected void resetLayout() {
        this.tickIncrement = -1;
        this.tickSpacing = -1;
        this.labels = null;
        this.labelLens = null;
        this.maxLabelLen = 0;
    }

    public void doLayout() {
        super.doLayout();
        this.checkFont();
        if (this.displayMin > this.displayMax) {
            this.displayMin = 0;
            this.displayMax = 100;
        }
        this.tickSpacing = this.getTickSpacing();
        if (this.getDrawTickLabels()) {
            this.buildLabels();
        }
    }

    protected void axisResized() {
        this.resetLayout();
    }

    public void paintAxis(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = this.getDrawTicks();
        boolean bl2 = this.getDrawTickLabels();
        boolean bl3 = this.isLeftBottom();
        this.checkFont();
        String[] stringArray = null;
        boolean bl4 = false;
        int n3 = 0;
        if (bl2) {
            stringArray = this.getLabels();
        }
        this.setFont(this.labelFont);
        if (!this.isHorizontal()) {
            n3 = n2;
            int n4 = n2 - this.getFirstTickSpacing();
            int n5 = this.labelFm.getAscent() / 2;
            graphics.setColor(Color.black);
            int n6 = 0;
            while (n4 > 0) {
                if (bl2 && n6 < stringArray.length) {
                    int n7 = n4 + n5 - 1;
                    boolean bl5 = bl4 = n7 + 2 < n3 - 2 && n4 - n5 > 0;
                    if (bl4) {
                        int n8 = bl3 ? n - 4 - 4 - this.labelLens[n6] : 8;
                        n3 = n7;
                        graphics.drawString(stringArray[n6], n8, n3);
                    }
                }
                if (bl) {
                    if (bl4) {
                        if (bl3) {
                            graphics.drawLine(n - 4, n4, n, n4);
                        } else {
                            graphics.drawLine(0, n4, 6, n4);
                        }
                    } else if (bl3) {
                        graphics.drawLine(n - 4 + 2, n4, n, n4);
                    } else {
                        graphics.drawLine(0, n4, 4, n4);
                    }
                }
                n4 -= this.tickSpacing;
                ++n6;
            }
        } else {
            n3 = 0;
            int n9 = this.getFirstTickSpacing();
            int n10 = 0;
            int n11 = this.maxLabelLen / 2;
            int n12 = bl3 ? 8 + this.labelFm.getAscent() : n2 - 4 - 4;
            graphics.setColor(Color.black);
            int n13 = 0;
            while (n9 < n) {
                if (bl2) {
                    int n14 = this.labelLens[n13] / 2;
                    n10 = n9 - n14;
                    boolean bl6 = bl4 = n9 - n11 - 2 > n3 + 2 && n10 + this.labelLens[n13] < n;
                    if (bl4) {
                        graphics.drawString(stringArray[n13], n10, n12);
                        n3 = n9 + n11;
                    }
                }
                if (bl) {
                    if (bl4) {
                        if (bl3) {
                            graphics.drawLine(n9, 0, n9, 4);
                        } else {
                            graphics.drawLine(n9, n2 - 4, n9, n2);
                        }
                    } else if (bl3) {
                        graphics.drawLine(n9, 0, n9, 2);
                    } else {
                        graphics.drawLine(n9, n2 - 4 + 2, n9, n2);
                    }
                }
                n9 += this.tickSpacing;
                ++n13;
            }
            String string = this.getAxisTitle();
            if (string != null) {
                int n15 = bl3 ? n12 + this.labelFm.getHeight() : n12 - this.labelFm.getHeight();
                int n16 = (this.getWidth() - this.labelFm.stringWidth(string)) / 2;
                graphics.drawString(string, n16, n15);
            }
        }
    }

    protected Axis.ZoomRec doZoomIn(int n, int n2) {
        int n3;
        int n4;
        if (this.isHorizontal()) {
            n4 = this.pixelToValue(n);
            n3 = this.pixelToValue(n2);
        } else {
            n3 = this.pixelToValue(n);
            n4 = this.pixelToValue(n2);
        }
        if (n4 >= n3) {
            return null;
        }
        IntZoomRec intZoomRec = new IntZoomRec(this.displayMin, this.displayMax);
        this.displayMin = n4;
        this.displayMax = n3;
        return intZoomRec;
    }

    protected void zoomOut(Axis.ZoomRec zoomRec) {
        IntZoomRec intZoomRec = (IntZoomRec)zoomRec;
        this.displayMin = intZoomRec.min;
        this.displayMax = intZoomRec.max;
        this.resetLayout();
        this.revalidate();
        this.repaint();
    }

    private class IntZoomRec
    implements Axis.ZoomRec {
        public int min;
        public int max;

        public IntZoomRec(int n, int n2) {
            this.min = n;
            this.max = n2;
        }
    }
}

