/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.EasUiUtil;
import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.FloatSeries;
import com.tridium.eas.ui.chart.Series;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class FloatAxis
extends Axis {
    private static final double LOG10E = 0.4342944819018;
    private double displayMin;
    private double displayMax;
    private double min = 1.0;
    private double max = 0.0;
    private BUnit units;
    protected double tickIncrement = -1.0;
    protected int tickSpacing = -1;
    protected String[] labels;
    protected int[] labelLens;
    protected int maxLabelLen;
    private boolean drawUnitLabel;
    private DecimalFormat defTickFormat;
    private DecimalFormat defValueFormat;
    protected Lexicon lex;

    public FloatAxis(int n, AxisInfo axisInfo, Lexicon lexicon) {
        super(n, axisInfo);
        this.lex = lexicon;
    }

    public BUnit getUnit() {
        return this.units;
    }

    public void setUnits(BUnit bUnit) {
        this.units = bUnit;
    }

    public void updateRange(double d, double d2) {
        if (this.min > this.max) {
            this.min = d;
            this.max = d2;
        } else {
            this.min = Math.min(this.min, d);
            this.max = Math.max(this.max, d2);
        }
        if (this.min == this.max) {
            this.min -= 5.0;
            this.max += 5.0;
        } else if (this.min > this.max) {
            this.max = this.min + 10.0;
        }
        this.displayMin = this.min;
        this.displayMax = this.max;
        this.tickIncrement = -1.0;
        double d3 = this.getTickIncrement();
        double d4 = !this.isHorizontal() ? (this.min % d3 == 0.0 ? this.min : (this.min >= 0.0 ? (double)((int)(this.min / d3)) * d3 : (double)((int)(this.min / d3 * d3)) - d3)) : this.min;
        double d5 = this.max % d3 == 0.0 ? this.max : (this.max >= 0.0 ? (double)((int)(this.max / d3)) * d3 + d3 : (double)((int)(this.max / d3)) * d3);
        this.displayMin = d4;
        this.displayMax = d5;
        if (this.displayMin == this.displayMax) {
            this.displayMax = this.displayMin + 1.0;
        }
    }

    private double getTickIncrement() {
        if (this.tickIncrement != -1.0) {
            return this.tickIncrement;
        }
        double d = this.displayMax - this.displayMin;
        double d2 = Math.log(d) * 0.4342944819018;
        this.tickIncrement = Math.max(Math.pow(10.0, Math.round(d2) - 1L), Double.MIN_VALUE);
        return this.tickIncrement;
    }

    private double getFirstIncrement() {
        double d = this.getTickIncrement();
        double d2 = this.displayMin % d == 0.0 ? this.displayMin + d : (this.displayMin >= 0.0 ? (double)((int)(this.displayMin / d)) * d + d : (double)((int)(this.displayMin / d)) * d);
        return d2;
    }

    private double getPixelsPerUnit() {
        return Math.max(Double.MIN_VALUE, (double)this.getAxisLength() / (this.displayMax - this.displayMin));
    }

    public int getTickSpacing() {
        if (this.tickSpacing != -1) {
            return this.tickSpacing;
        }
        while ((this.tickSpacing = (int)(this.getPixelsPerUnit() * this.getTickIncrement())) < 10) {
            this.tickIncrement *= 2.0;
        }
        return this.tickSpacing;
    }

    public int getFirstTickSpacing() {
        return (int)((this.getFirstIncrement() - this.displayMin) * this.getPixelsPerUnit());
    }

    public int valueToPixel(Object object) {
        if (object instanceof Number) {
            return this.valueToPixel(((Number)object).doubleValue());
        }
        return -1;
    }

    public int indexToPixel(Series series, int n) {
        return this.valueToPixel(((FloatSeries)series).getDouble(n));
    }

    public int valueToPixel(double d) {
        int n = 0;
        int n2 = this.getFirstTickSpacing();
        double d2 = this.getFirstIncrement();
        if (d < d2) {
            n = (int)((double)n2 * ((d - this.displayMin) / (d2 - this.displayMin)));
        } else {
            int n3 = this.getTickSpacing();
            double d3 = this.getTickIncrement();
            int n4 = (int)((d - d2) / d3);
            int n5 = n2 + n4 * n3;
            double d4 = d2 + (double)n4 * d3;
            int n6 = (int)((double)n3 * ((d - d4) / d3));
            n = n5 + n6;
        }
        if (!this.isHorizontal()) {
            n = this.getFullLength() - n;
        }
        return n;
    }

    public double pixelToValue(int n) {
        int n2;
        int n3 = this.getFullLength();
        if (!this.isHorizontal()) {
            n = this.getHeight() - n;
        }
        if (n < (n2 = this.getFirstTickSpacing())) {
            double d = (double)n / (double)n2;
            return this.displayMin + (this.getFirstIncrement() - this.displayMin) * d;
        }
        int n4 = this.getTickSpacing();
        int n5 = (n - n2) / n4;
        int n6 = n2 + n5 * n4;
        double d = this.getFirstIncrement() + (double)n5 * this.getTickIncrement();
        return d + this.getTickIncrement() * ((double)(n - n6) / (double)n4);
    }

    public String[] getLabels() {
        if (this.labels == null) {
            this.buildLabels();
        }
        return this.labels;
    }

    protected void buildLabels() {
        this.checkFont();
        int n = this.getFullLength() / this.getTickSpacing() + 1;
        this.labels = new String[n];
        this.labelLens = new int[n];
        double d = this.getFirstIncrement();
        this.maxLabelLen = 0;
        for (int i = 0; i < n; ++i) {
            this.labels[i] = this.getTickLabel(new Double(d));
            this.labelLens[i] = this.labelFm.stringWidth(this.labels[i]);
            this.maxLabelLen = Math.max(this.labelLens[i], this.maxLabelLen);
            d += this.getTickIncrement();
        }
    }

    public DecimalFormat getDefaultTickFormat() {
        if (this.defTickFormat == null) {
            double d = this.getTickIncrement();
            if (d < 1.0) {
                this.defTickFormat = new DecimalFormat("#.00000");
                return this.defTickFormat;
            }
            this.defTickFormat = new DecimalFormat("########");
            return this.defTickFormat;
        }
        return this.defTickFormat;
    }

    public void setDefaultTickFormat(DecimalFormat decimalFormat) {
        this.defTickFormat = decimalFormat;
    }

    public String getDefaultTickLabel(Object object) {
        if (object instanceof Number) {
            return this.getDefaultTickFormat().format(((Number)object).doubleValue());
        }
        return null;
    }

    public String getDefaultValueLabel(Object object) {
        if (object instanceof Number) {
            return this.getDefaultValueFormat().format(((Number)object).doubleValue());
        }
        return null;
    }

    public DecimalFormat getDefaultValueFormat() {
        if (this.defValueFormat == null) {
            double d = this.getTickIncrement();
            if (d < 1.0) {
                this.defValueFormat = new DecimalFormat("#.00000");
                return this.defValueFormat;
            }
            this.defValueFormat = new DecimalFormat("#.00");
            return this.defValueFormat;
        }
        return this.defValueFormat;
    }

    public void setDefaultValueFormat(DecimalFormat decimalFormat) {
        this.defValueFormat = decimalFormat;
    }

    public String pixelToLabel(int n) {
        double d = this.pixelToValue(n);
        return this.getValueLabel(new Double(d));
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        this.checkFont();
        if (this.isHorizontal()) {
            n = 50;
            n2 = this.labelFm.getHeight() + 4 + 8;
            String string = this.getAxisTitle();
            if (string != null) {
                n2 += this.titleFm.getHeight();
            }
        } else {
            String string = this.getTickLabel(new Double(this.displayMax));
            String string2 = this.getTickLabel(new Double(this.displayMin));
            int n3 = Math.max(this.labelFm.stringWidth(string), this.labelFm.stringWidth(string2));
            n = n3 + 4 + 8;
            String string3 = this.getAxisTitle();
            if (string3 != null) {
                n += this.titleFm.getHeight();
            }
            if (this.units != null) {
                n = this.lex != null ? Math.max(n, this.labelFm.stringWidth(this.units.toString()) + 8) : Math.max(n, this.labelFm.stringWidth(this.units.getSymbol()) + 8);
            }
            n2 = 50;
        }
        return new Dimension(n, n2);
    }

    public void doLayout() {
        if (this.getWidth() < 5 || this.getHeight() < 5) {
            return;
        }
        super.doLayout();
        this.checkFont();
        if (this.displayMin >= this.displayMax) {
            this.displayMin = 0.0;
            this.displayMax = 100.0;
        }
        this.tickSpacing = this.getTickSpacing();
        boolean bl = this.drawUnitLabel = this.units != null && !this.units.equals((Object)BUnit.getUnit((String)"null"));
        if (this.getDrawTickLabels()) {
            this.buildLabels();
        }
    }

    protected void resetLayout() {
        this.tickIncrement = -1.0;
        this.tickSpacing = -1;
        this.defTickFormat = null;
        this.defValueFormat = null;
        this.labels = null;
        this.labelLens = null;
        this.maxLabelLen = 0;
    }

    protected void paintAxis(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        boolean bl = this.getDrawTicks();
        boolean bl2 = this.getDrawTickLabels();
        boolean bl3 = this.isLeftBottom();
        this.checkFont();
        String[] stringArray = null;
        boolean bl4 = false;
        int n3 = 0;
        if (bl2) {
            stringArray = this.getLabels();
        }
        this.setFont(this.labelFont);
        if (!this.isHorizontal()) {
            String string;
            n3 = n2;
            int n4 = n2 - this.getFirstTickSpacing();
            int n5 = this.labelFm.getAscent() / 2;
            graphics.setColor(Color.black);
            int n6 = 0;
            while (n4 > 0) {
                if (bl2 && n6 < stringArray.length) {
                    int n7 = n4 + n5 - 1;
                    bl4 = n7 + 2 < n3 - 2 && n4 - n5 > 0;
                    boolean bl5 = bl4 = bl4 && (!this.drawUnitLabel || n7 - this.labelFm.getAscent() > this.labelFm.getHeight());
                    if (bl4) {
                        int n8 = bl3 ? n - 4 - 4 - this.labelLens[n6] : 8;
                        n3 = n7;
                        graphics.drawString(stringArray[n6], n8, n3);
                    }
                }
                if (bl) {
                    if (bl4) {
                        if (bl3) {
                            graphics.drawLine(n - 4, n4, n, n4);
                        } else {
                            graphics.drawLine(0, n4, 6, n4);
                        }
                    } else if (bl3) {
                        graphics.drawLine(n - 4 + 2, n4, n, n4);
                    } else {
                        graphics.drawLine(0, n4, 4, n4);
                    }
                }
                n4 -= this.tickSpacing;
                ++n6;
            }
            boolean bl6 = false;
            if (this.drawUnitLabel) {
                graphics.setColor(Color.black);
                String string2 = this.units.getSymbol();
                if (this.lex != null) {
                    string2 = this.units.toString();
                }
                if (this.getAxisTitle() != null && this.labelFm.stringWidth(string2) < this.maxLabelLen) {
                    if (bl3) {
                        graphics.drawString(string2, this.titleFm.getHeight() + 2, this.labelFm.getHeight());
                    } else {
                        graphics.drawString(string2, n - this.labelFm.stringWidth(string2) - this.titleFm.getHeight() - 2, this.labelFm.getHeight());
                    }
                    string = EasUiUtil.trimToWidth(this.getAxisTitle(), this.titleFm, n2, 0);
                } else {
                    if (bl3) {
                        graphics.drawString(string2, 2, this.labelFm.getHeight());
                    } else {
                        graphics.drawString(string2, n - this.labelFm.stringWidth(string2) - 2, this.labelFm.getHeight());
                    }
                    string = EasUiUtil.trimToWidth(this.getAxisTitle(), this.titleFm, n2 - this.labelFm.getHeight(), 0);
                    bl6 = true;
                }
            } else {
                string = EasUiUtil.trimToWidth(this.getAxisTitle(), this.titleFm, n2, 0);
            }
            if (string != null) {
                int n9 = n - this.maxLabelLen - 2 - 4 - 8;
                int n10 = this.titleFm.stringWidth(string);
                int n11 = bl6 ? (n2 - n10 - this.labelFm.getHeight()) / 2 + n10 + this.labelFm.getHeight() : (n2 - n10) / 2 + n10;
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                double d = -1.5707963267948966;
                graphics2D.setTransform(AffineTransform.getRotateInstance(d, n9, n11));
                graphics2D.drawString(string, n9, n11);
                graphics2D.setTransform(affineTransform);
            }
        } else {
            String string;
            int n12;
            n3 = 0;
            int n13 = this.getFirstTickSpacing();
            int n14 = 0;
            int n15 = this.maxLabelLen / 2;
            int n16 = bl3 ? 8 + this.labelFm.getAscent() : n2 - 4 - 4;
            graphics.setColor(Color.black);
            int n17 = 0;
            int n18 = n12 = this.units == null ? 0 : this.labelFm.stringWidth(this.units.getSymbol());
            if (this.lex != null) {
                int n19 = n12 = this.units == null ? 0 : this.labelFm.stringWidth(this.units.toString());
            }
            while (n13 < n) {
                if (bl2) {
                    int n20 = this.labelLens[n17] / 2;
                    n14 = n13 - n20;
                    bl4 = n13 - n15 - 2 > n3 + 2 && n14 + this.labelLens[n17] < n;
                    boolean bl7 = bl4 = bl4 && (!this.drawUnitLabel || n14 + this.labelLens[n17] < n - n12 - 2);
                    if (bl4) {
                        graphics.drawString(stringArray[n17], n14, n16);
                        n3 = n13 + n15;
                    }
                }
                if (bl) {
                    if (bl4) {
                        if (bl3) {
                            graphics.drawLine(n13, 0, n13, 4);
                        } else {
                            graphics.drawLine(n13, n2 - 4, n13, n2);
                        }
                    } else if (bl3) {
                        graphics.drawLine(n13, 0, n13, 2);
                    } else {
                        graphics.drawLine(n13, n2 - 4 + 2, n13, n2);
                    }
                }
                n13 += this.tickSpacing;
                ++n17;
            }
            if (this.drawUnitLabel) {
                graphics.setColor(Color.black);
                string = this.units.getSymbol();
                if (this.lex != null) {
                    string = this.units.toString();
                }
                graphics.drawString(string, n - this.labelFm.stringWidth(string) - 2, n16);
            }
            if ((string = this.getAxisTitle()) != null) {
                string = EasUiUtil.trimToWidth(string, this.titleFm, n, 0);
                graphics.setFont(this.titleFont);
                graphics.drawString(string, (n - this.titleFm.stringWidth(string)) / 2, n16 += this.titleFm.getHeight());
            }
        }
    }

    protected Axis.ZoomRec doZoomIn(int n, int n2) {
        double d;
        double d2;
        if (this.isHorizontal()) {
            d2 = this.pixelToValue(n);
            d = this.pixelToValue(n2);
        } else {
            d = this.pixelToValue(n);
            d2 = this.pixelToValue(n2);
        }
        if (d2 >= d) {
            return null;
        }
        FloatZoomRec floatZoomRec = new FloatZoomRec(this.displayMin, this.displayMax);
        this.displayMin = d2;
        this.displayMax = d;
        return floatZoomRec;
    }

    protected void zoomOut(Axis.ZoomRec zoomRec) {
        FloatZoomRec floatZoomRec = (FloatZoomRec)zoomRec;
        this.displayMin = floatZoomRec.min;
        this.displayMax = floatZoomRec.max;
        this.resetLayout();
        this.revalidate();
        this.repaint();
    }

    private class FloatZoomRec
    implements Axis.ZoomRec {
        public double min;
        public double max;

        public FloatZoomRec(double d, double d2) {
            this.min = d;
            this.max = d2;
        }
    }
}

