/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.DefaultValueColors;
import com.tridium.eas.ui.chart.LineConfig;
import com.tridium.eas.ui.chart.ValueColors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public class DefaultLineConfig
implements LineConfig {
    public static final int DEFAULT_LINE_WIDTH = 2;
    public static final Color DEFAULT_VALUE_COLOR = Color.blue;
    private int lineWidth;
    private Stroke stroke;
    private boolean discrete = false;
    private ValueColors valueColors;
    private Color valueColor;

    public DefaultLineConfig() {
        this(2, false, (ValueColors)null);
    }

    public DefaultLineConfig(ValueColors valueColors) {
        this(2, false, valueColors);
    }

    public DefaultLineConfig(boolean bl, ValueColors valueColors) {
        this(2, bl, valueColors);
    }

    public DefaultLineConfig(int n, boolean bl, ValueColors valueColors) {
        this.lineWidth = n;
        this.discrete = bl;
        this.valueColors = valueColors == null ? new DefaultValueColors() : valueColors;
    }

    public DefaultLineConfig(int n, boolean bl, Color color) {
        this.lineWidth = n;
        this.discrete = bl;
        this.valueColor = color == null ? DEFAULT_VALUE_COLOR : color;
    }

    public int getChartType() {
        return 1;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
        this.stroke = null;
    }

    public Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.getLineWidth());
        }
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public boolean isDiscrete() {
        return this.discrete;
    }

    public void setDiscrete(boolean bl) {
        this.discrete = bl;
    }

    public Color getValueColor(int n) {
        if (this.valueColors != null) {
            return this.valueColors.getValueColor(n);
        }
        return this.valueColor;
    }

    public final Color getValueColor() {
        return this.valueColor;
    }

    public final void setValueColor(Color color) {
        this.valueColor = color;
    }
}

