/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartCanvas;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.OverlayPane;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class ChartArea
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final int ZOOM_NONE = 0;
    private static final int ZOOM_HORIZONTAL = 1;
    private static final int ZOOM_VERTICAL = 2;
    private static final int ZOOM_THRESHOLD = 5;
    private Chart chart;
    private ChartCanvas[] charts;
    private Point dragStart;
    private Point dragEnd;
    private int zoomMode = 0;
    private int reserved;
    private OverlayPane overlayPane;
    private Image buffer;
    private boolean repaintRequired = true;

    public ChartArea(Chart chart) {
        this.chart = chart;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setDoubleBuffered(false);
        this.overlayPane = new OverlayPane(chart);
    }

    public void setReserved(int n) {
        this.reserved = n;
    }

    public void addCanvas(ChartCanvas chartCanvas) {
        this.repaintRequired = true;
        if (this.charts == null) {
            this.charts = new ChartCanvas[1];
        } else {
            ChartCanvas[] chartCanvasArray = new ChartCanvas[this.charts.length + 1];
            System.arraycopy(this.charts, 0, chartCanvasArray, 0, this.charts.length);
            this.charts = chartCanvasArray;
        }
        this.charts[this.charts.length - 1] = chartCanvas;
    }

    public ChartCanvas removeCanvas(int n) {
        if (this.charts == null) {
            return null;
        }
        ChartCanvas chartCanvas = this.charts[n];
        this.repaintRequired = true;
        int n2 = this.charts.length;
        if (n2 == 1 && n == 0) {
            this.charts = null;
        } else {
            ChartCanvas[] chartCanvasArray = new ChartCanvas[n2 - 1];
            if (n > 0) {
                System.arraycopy(this.charts, 0, chartCanvasArray, 0, n);
            }
            if (n < n2 - 1) {
                System.arraycopy(this.charts, n + 1, chartCanvasArray, n, n2 - n - 1);
            }
            this.charts = chartCanvasArray;
        }
        return chartCanvas;
    }

    public ChartCanvas getCanvas(Id id) {
        if (this.charts == null) {
            return null;
        }
        int n = this.charts.length;
        for (int i = 0; i < n; ++i) {
            if (this.charts[i].getSeriesId() != id) continue;
            return this.charts[i];
        }
        return null;
    }

    public ChartCanvas removeCanvas(Id id) {
        if (this.charts == null) {
            return null;
        }
        int n = this.charts.length;
        for (int i = 0; i < n; ++i) {
            if (this.charts[i].getSeriesId() != id) continue;
            return this.removeCanvas(i);
        }
        return null;
    }

    public void removeAllCanvases() {
        this.repaintRequired = true;
        this.charts = null;
    }

    public OverlayPane getOverlayPane() {
        return this.overlayPane;
    }

    public void addOverlay(Id id) {
        this.overlayPane.addOverlay(id);
    }

    public void removeOverlay(Id id) {
        this.overlayPane.removeOverlay(id);
    }

    public void removeAllOverlays() {
        this.overlayPane.removeAllOverlays();
    }

    public void forceRepaint() {
        this.repaintRequired = true;
        this.repaint();
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.overlayPane.setBounds(0, this.reserved, n, n2 - this.reserved);
        if (this.buffer != null && (n != this.buffer.getWidth(null) || n2 != this.buffer.getHeight(null))) {
            this.buffer.flush();
            this.buffer = null;
        }
        int n3 = this.charts == null ? 0 : this.charts.length;
        for (int i = 0; i < n3; ++i) {
            if (!this.charts[i].requiresAxes()) {
                this.charts[i].setBounds(0, this.reserved, n, n2 - this.reserved);
            } else {
                this.charts[i].setBounds(0, 0, n, n2);
            }
            this.charts[i].doLayout();
        }
    }

    public void paintComponent(Graphics graphics) {
        Object object;
        Object object2;
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.buffer != null && !this.repaintRequired) {
            graphics.drawImage(this.buffer, 0, 0, null);
        } else {
            int n3;
            int n4;
            this.repaintRequired = false;
            if (this.buffer == null) {
                this.buffer = this.createImage(n, n2);
            }
            object2 = this.buffer.getGraphics();
            ((Graphics)object2).setColor(Color.white);
            ((Graphics)object2).fillRect(0, 0, n, n2);
            object = this.chart.getPrimaryXAxis();
            Axis axis = this.chart.getPrimaryYAxis();
            if (this.chart.getShowGrid()) {
                int n5;
                if (axis != null) {
                    ((Graphics)object2).setColor(Color.lightGray);
                    n5 = axis.getTickSpacing();
                    for (n4 = n2 - axis.getFirstTickSpacing(); n4 > 0; n4 -= n5) {
                        ((Graphics)object2).drawLine(0, n4, n, n4);
                    }
                }
                if (object != null) {
                    n5 = ((Axis)object).getTickSpacing();
                    n3 = n;
                    for (n4 = ((Axis)object).getFirstTickSpacing(); n4 < n3; n4 += n5) {
                        ((Graphics)object2).drawLine(n4, 0, n4, n2);
                    }
                }
            }
            if (this.charts != null) {
                ((Graphics)object2).setClip(0, this.reserved - 12, n, n2 - (this.reserved - 12));
                n4 = this.charts.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    ChartCanvas chartCanvas = this.charts[n3];
                    int n6 = chartCanvas.getX();
                    int n7 = chartCanvas.getY();
                    ((Graphics)object2).translate(n6, n7);
                    this.charts[n3].paint((Graphics)object2);
                    ((Graphics)object2).translate(-n6, -n7);
                }
            }
            ((Graphics)object2).dispose();
            object2 = null;
            graphics.drawImage(this.buffer, 0, 0, null);
        }
        object2 = graphics.getClip();
        object = this.overlayPane.createGraphics(graphics);
        this.overlayPane.paint((Graphics)object);
        ((Graphics)object).dispose();
        if (this.zoomMode != 0) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.black);
            if (this.zoomMode == 1) {
                int n8 = Math.min(this.dragStart.x, this.dragEnd.x);
                graphics.fillRect(n8, 0, Math.abs(this.dragEnd.x - this.dragStart.x), n2);
            } else if (this.zoomMode == 2) {
                int n9 = Math.min(this.dragStart.y, this.dragEnd.y);
                graphics.fillRect(0, n9, n, Math.abs(this.dragEnd.y - this.dragStart.y));
            }
        }
    }

    private void doHorizontalZoom(int n, int n2) {
        this.repaintRequired = true;
        int n3 = Math.min(this.dragStart.x, n);
        int n4 = Math.max(this.dragStart.x, n);
        this.chart.zoomHorizontal(n3, n4);
    }

    private void doVerticalZoom(int n, int n2) {
        this.repaintRequired = true;
        int n3 = Math.min(this.dragStart.y, n2);
        int n4 = Math.max(this.dragStart.y, n2);
        this.chart.zoomVertical(n3, n4);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragStart = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.chart.displayAxisValues(this.dragStart.x, this.dragStart.y);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.chart.clearStatus();
        this.chart.setCursor(Cursor.getPredefinedCursor(1));
        if ((mouseEvent.getModifiers() & 0x10) != 0 && this.zoomMode != 0) {
            switch (this.zoomMode) {
                case 1: {
                    this.doHorizontalZoom(mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
                case 2: {
                    this.doVerticalZoom(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
        this.dragStart = null;
        this.dragEnd = null;
        this.zoomMode = 0;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.zoomMode == 0) {
                int n3 = Math.abs(n - this.dragStart.x);
                if (n3 > 5) {
                    this.zoomMode = 1;
                    this.chart.setCursor(Cursor.getPredefinedCursor(10));
                    this.dragEnd = new Point(n, n2);
                    this.repaint();
                } else {
                    n3 = Math.abs(n2 - this.dragStart.y);
                    if (n3 > 5) {
                        this.zoomMode = 2;
                        this.dragEnd = new Point(n, n2);
                        this.chart.setCursor(Cursor.getPredefinedCursor(8));
                        this.repaint();
                    }
                }
            } else {
                this.dragEnd.x = n;
                this.dragEnd.y = n2;
                this.repaint();
            }
        }
        this.chart.displayAxisValues(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

