/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.BEasService;
import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.BarCanvas;
import com.tridium.eas.ui.chart.ChartArea;
import com.tridium.eas.ui.chart.ChartCanvas;
import com.tridium.eas.ui.chart.ChartEvent;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.ChartModelListener;
import com.tridium.eas.ui.chart.ChartStatus;
import com.tridium.eas.ui.chart.ChartTitle;
import com.tridium.eas.ui.chart.FloatAxis;
import com.tridium.eas.ui.chart.FloatSeries;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.IntAxis;
import com.tridium.eas.ui.chart.LineCanvas;
import com.tridium.eas.ui.chart.MultistateAxis;
import com.tridium.eas.ui.chart.PieCanvas;
import com.tridium.eas.ui.chart.ScatterPlotCanvas;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.SeriesAxis;
import com.tridium.eas.ui.chart.SpectrumCanvas;
import com.tridium.eas.ui.chart.TimeAxis;
import com.tridium.eas.ui.chart.TimeOfDayAxis;
import com.tridium.eas.ui.chart.TimeSeries;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Iterator;
import java.util.Stack;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.JComponent;
import javax.swing.JWindow;

public class Chart
extends JComponent
implements ComponentListener,
Printable,
ChartModelListener {
    private static final Integer ZOOM_HORIZONTAL = new Integer(0);
    private static final Integer ZOOM_VERTICAL = new Integer(1);
    public static final int EXTRA_RESERVE = 12;
    private Lexicon lex;
    private ChartModel model;
    private ChartArea chartArea;
    private Axis[] xaxes;
    private Axis[] yaxes;
    private boolean showGridLines = false;
    private boolean defUsesAxes = true;
    private ChartStatus statusDisplay;
    private Stack zoomStack;
    private ChartTitle chartTitle;
    private Dimension prefSize = new Dimension(100, 100);

    public Chart() {
        this(new ChartModel());
    }

    public Chart(Lexicon lexicon) {
        this(new ChartModel());
        this.lex = lexicon;
    }

    public Chart(ChartModel chartModel) {
        this.chartTitle = new ChartTitle();
        this.add(this.chartTitle);
        this.chartArea = new ChartArea(this);
        this.add(this.chartArea);
        this.setModel(chartModel);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addComponentListener(this);
    }

    public Chart(ChartModel chartModel, Lexicon lexicon) {
        this.lex = lexicon;
        this.chartTitle = new ChartTitle();
        this.add(this.chartTitle);
        this.chartArea = new ChartArea(this);
        this.add(this.chartArea);
        this.setModel(chartModel);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addComponentListener(this);
    }

    public ChartModel getModel() {
        return this.model;
    }

    public void setModel(ChartModel chartModel) {
        if (chartModel != this.model) {
            if (this.model != null) {
                this.model.removeListener(this);
            }
            this.model = chartModel;
            this.model.addListener(this);
            this.chartTitle.setTitle(this.model.getTitle(), this.model.getSubtitle());
            this.rebuild();
            this.repaint();
        }
    }

    public ChartArea getChartArea() {
        return this.chartArea;
    }

    public void setTitle(String string) {
        this.model.setTitle(string);
    }

    public void setSubtitle(String string) {
        this.model.setSubtitle(string);
    }

    public void setTitle(String string, String string2) {
        this.model.setTitle(string, string2);
    }

    public void setChartStatus(ChartStatus chartStatus) {
        this.statusDisplay = chartStatus;
    }

    public boolean getShowGrid() {
        return this.showGridLines;
    }

    public void setShowGrid(boolean bl) {
        this.showGridLines = bl;
        this.chartTitle.setShowBorder(bl);
        if (this.isVisible()) {
            this.chartArea.forceRepaint();
            this.repaint();
        }
    }

    public boolean getDefaultUsesAxes() {
        return this.defUsesAxes;
    }

    public void setDefaultUsesAxes(boolean bl) {
        this.defUsesAxes = bl;
    }

    public void rebuild() {
        this.chartArea.removeAllCanvases();
        this.chartArea.removeAllOverlays();
        this.removeAllAxes();
        Iterator iterator = this.model.getSeriesIds();
        while (iterator.hasNext()) {
            this.addSeries((Id)iterator.next(), false);
        }
        Iterator iterator2 = this.model.getOverlayIds();
        while (iterator2.hasNext()) {
            this.chartArea.addOverlay((Id)iterator2.next());
        }
        this.finishLayout();
    }

    private void finishLayout() {
        this.remove(this.chartArea);
        this.remove(this.chartTitle);
        this.add(this.chartTitle);
        this.add(this.chartArea);
        this.revalidate();
    }

    private boolean addSeries(Id id, boolean bl) {
        ChartCanvas chartCanvas = this.createCanvas(id, this.model.getChartType(id));
        if (chartCanvas != null) {
            boolean bl2 = chartCanvas.requiresAxes();
            if (bl2) {
                this.createAxes(chartCanvas, this.model.getSeriesXAxisInfo(id), this.model.getSeriesYAxisInfo(id));
            }
            this.chartArea.addCanvas(chartCanvas);
            if (bl) {
                this.finishLayout();
            }
            return bl2;
        }
        return false;
    }

    private void removeSeries(Id id) {
        Axis axis;
        ChartCanvas chartCanvas = this.chartArea.removeCanvas(id);
        if (chartCanvas == null) {
            return;
        }
        Axis axis2 = chartCanvas.getXAxis();
        if (axis2 != null) {
            axis2.removeUser(chartCanvas);
            if (!axis2.isUsed()) {
                this.xaxes = this.removeAxis(this.xaxes, axis2);
            }
        }
        if ((axis = chartCanvas.getYAxis()) != null) {
            axis.removeUser(chartCanvas);
            if (!axis.isUsed()) {
                this.yaxes = this.removeAxis(this.yaxes, axis);
            }
        }
    }

    public void displayAxisValues(int n, int n2) {
        String string;
        int n3;
        if (this.statusDisplay == null || this.xaxes == null || this.yaxes == null) {
            return;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(32);
        for (n3 = 0; n3 < this.xaxes.length; ++n3) {
            string = this.xaxes[n3].pixelToLabel(n);
            if (string == null) continue;
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(string);
            if (!(this.xaxes[n3] instanceof FloatAxis)) break;
            stringBuffer.append(" ");
            stringBuffer.append(((FloatAxis)this.xaxes[n3]).getUnit().toString());
            break;
        }
        for (n3 = 0; n3 < this.yaxes.length; ++n3) {
            string = this.yaxes[n3].pixelToLabel(n2);
            if (string == null) continue;
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(string);
            if (!(this.yaxes[n3] instanceof FloatAxis)) continue;
            stringBuffer.append(" ");
            stringBuffer.append(((FloatAxis)this.yaxes[n3]).getUnit().toString());
        }
        if (stringBuffer.length() > 0) {
            this.statusDisplay.setStatus(stringBuffer.toString());
        }
    }

    public void clearStatus() {
        if (this.statusDisplay != null) {
            this.statusDisplay.clearStatus();
        }
    }

    public void updateChartArea() {
        this.chartArea.doLayout();
        this.chartArea.forceRepaint();
    }

    public void zoomHorizontal(int n, int n2) {
        if (this.zoomStack == null) {
            this.zoomStack = new Stack();
        }
        this.zoomStack.push(ZOOM_HORIZONTAL);
        int n3 = this.xaxes == null ? 0 : this.xaxes.length;
        for (int i = 0; i < n3; ++i) {
            this.xaxes[i].zoomIn(n, n2);
        }
        this.repaint();
    }

    public void zoomVertical(int n, int n2) {
        if (this.zoomStack == null) {
            this.zoomStack = new Stack();
        }
        this.zoomStack.push(ZOOM_VERTICAL);
        int n3 = this.yaxes == null ? 0 : this.yaxes.length;
        for (int i = 0; i < n3; ++i) {
            this.yaxes[i].zoomIn(n, n2);
        }
        this.repaint();
    }

    public void zoomOut() {
        if (this.zoomStack == null || this.zoomStack.empty()) {
            return;
        }
        Object e = this.zoomStack.pop();
        if (e == ZOOM_HORIZONTAL) {
            int n = this.xaxes == null ? 0 : this.xaxes.length;
            for (int i = 0; i < n; ++i) {
                this.xaxes[i].zoomOut();
            }
        } else {
            int n = this.yaxes == null ? 0 : this.yaxes.length;
            for (int i = 0; i < n; ++i) {
                this.yaxes[i].zoomOut();
            }
        }
        this.chartArea.forceRepaint();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return (Dimension)this.prefSize.clone();
    }

    public void setPreferredSize(int n, int n2) {
        this.prefSize = new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public void doLayout() {
        int n;
        int n2;
        boolean bl;
        Insets insets = this.getInsets();
        int n3 = insets.left;
        int n4 = insets.top;
        int n5 = this.getWidth() - (insets.left + insets.right);
        int n6 = this.getHeight() - (insets.top + insets.bottom);
        Dimension dimension = this.chartTitle.getPreferredSize();
        Axis axis = null;
        Axis axis2 = null;
        Dimension dimension2 = null;
        Dimension[] dimensionArray = null;
        Dimension dimension3 = null;
        Dimension dimension4 = null;
        Dimension[] dimensionArray2 = null;
        Dimension dimension5 = null;
        boolean bl2 = this.xaxes != null && this.xaxes.length != 0;
        boolean bl3 = bl = this.yaxes != null && this.yaxes.length != 0;
        if (bl2) {
            axis = this.xaxes[0];
            dimension2 = axis.getPreferredSize();
            dimension3 = new Dimension(0, 0);
            n2 = this.xaxes.length - 1;
            if (n2 != 0) {
                dimensionArray = new Dimension[n2];
                for (n = 0; n < n2; ++n) {
                    dimensionArray[n] = this.xaxes[n + 1].getPreferredSize();
                    dimension3.width += dimensionArray[n].width;
                    dimension3.height += dimensionArray[n].height;
                }
            }
        } else {
            dimension2 = dimension3 = new Dimension(0, 0);
        }
        if (bl) {
            axis2 = this.yaxes[0];
            dimension4 = axis2.getPreferredSize();
            dimension5 = new Dimension(0, 0);
            n2 = this.yaxes.length - 1;
            if (n2 != 0) {
                dimensionArray2 = new Dimension[n2];
                for (n = 0; n < n2; ++n) {
                    dimensionArray2[n] = this.yaxes[n + 1].getPreferredSize();
                    dimension5.width += dimensionArray2[n].width;
                    dimension5.height += dimensionArray2[n].height;
                }
            }
        } else {
            dimension4 = dimension5 = new Dimension(0, 0);
        }
        if (bl2) {
            axis.setBounds(n3 + dimension4.width, n4 + n6 - dimension2.height, n5 - dimension4.width - dimension5.width, dimension2.height);
            axis.setLeftBottom(true);
            n2 = this.xaxes.length - 1;
            for (n = 0; n < n2; ++n) {
                Axis axis3 = this.xaxes[n + 1];
                axis3.setBounds(n3 + dimension4.width, n4 + n6 - dimension2.height, n5 - dimension4.width - dimension5.width, 1);
            }
        }
        if (bl) {
            axis2.setBounds(n3, n4, dimension4.width, n6 - dimension2.height);
            axis2.setReserved(dimension.height + 12);
            n2 = this.yaxes.length - 1;
            n = n5 - dimension5.width;
            for (int i = 0; i < n2; ++i) {
                Axis axis4 = this.yaxes[i + 1];
                axis4.setBounds(n3 + n, n4, dimensionArray2[i].width, n6 - dimension2.height);
                axis4.setReserved(dimension.height + 12);
                axis4.setLeftBottom(false);
                n += dimensionArray2[i].width;
            }
        }
        n2 = dimension4.width;
        n = 0;
        int n7 = n5 - dimension4.width - dimension5.width;
        int n8 = n6 - dimension2.height;
        this.chartArea.setBounds(n3 + n2, n4 + n, n7, n8);
        this.chartArea.setReserved(dimension.height + 12);
        this.chartTitle.setBounds(n3 + n2, n4 + n, n7, dimension.height);
    }

    public void paintComponent(Graphics graphics) {
        Axis axis = this.getPrimaryYAxis();
        if (axis == null) {
            return;
        }
        int n = axis.getWidth() - 1;
        int n2 = axis.getHeight();
        graphics.setColor(Color.black);
        graphics.drawLine(n, n2, n, n2);
        graphics.drawLine(n += this.chartArea.getWidth() + 1, n2, n, n2);
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        JWindow jWindow = new JWindow();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jWindow.setBounds(dimension.width + 1, dimension.height + 1, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        Chart chart = new Chart(this.lex);
        chart.setModel(this.model);
        chart.getChartArea().setBackground(Color.white);
        jWindow.getContentPane().add(chart);
        jWindow.setVisible(true);
        jWindow.print(graphics2D);
        jWindow.setVisible(false);
        return 0;
    }

    public Axis getPrimaryXAxis() {
        return this.xaxes != null ? this.xaxes[0] : null;
    }

    public Axis getPrimaryYAxis() {
        return this.yaxes != null ? this.yaxes[0] : null;
    }

    private ChartCanvas createCanvas(Id id, int n) {
        ChartCanvas chartCanvas = null;
        switch (n) {
            case 2: {
                chartCanvas = new BarCanvas(this, id);
                break;
            }
            case 4: {
                chartCanvas = new PieCanvas(this, id);
                break;
            }
            case 6: {
                chartCanvas = new SpectrumCanvas(this, id);
                break;
            }
            case 5: {
                chartCanvas = new ScatterPlotCanvas(this, id);
                break;
            }
            default: {
                chartCanvas = new LineCanvas(this, id);
            }
        }
        return chartCanvas;
    }

    private void createAxes(ChartCanvas chartCanvas, AxisInfo axisInfo, AxisInfo axisInfo2) {
        Series series = chartCanvas.getSeries();
        Axis axis = null;
        Axis axis2 = null;
        if (chartCanvas instanceof SpectrumCanvas) {
            TimeSeries timeSeries = (TimeSeries)series;
            axis2 = this.getTimeOfDayAxis(1, axisInfo2);
            axis = this.getTimeAxis(0, timeSeries.getMinTimestamp(), timeSeries.getMaxTimestamp(), axisInfo);
        } else {
            Series series2;
            if (series instanceof TimeSeries) {
                series2 = (TimeSeries)series;
                axis = this.getTimeAxis(0, ((TimeSeries)series2).getMinTimestamp(), ((TimeSeries)series2).getMaxTimestamp(), axisInfo);
            } else if (series instanceof FloatSeries) {
                series2 = (FloatSeries)series;
                axis = this.getFloatAxis(0, ((FloatSeries)series2).getMinDouble(), ((FloatSeries)series2).getMaxDouble(), ((FloatSeries)series2).getDoubleUnits(), axisInfo);
            } else if (series instanceof Series) {
                axis = chartCanvas instanceof BarCanvas ? this.getSeriesAxis(0, series, axisInfo) : this.getIntAxis(0, 0, series.getRowCount() - 1, axisInfo);
            }
            series2 = series.getValueUnits();
            if (series2 == null || !series2.equals(BEasService.MULTISTATE)) {
                boolean bl = chartCanvas.useRowTotals();
                double d = 0.0;
                double d2 = 0.0;
                if (!(chartCanvas instanceof BarCanvas)) {
                    d = bl ? series.getMinRowTotal() : series.getMin();
                }
                d2 = bl ? series.getMaxRowTotal() : series.getMax();
                axis2 = this.getFloatAxis(1, d, d2, series.getValueUnits(), axisInfo2);
            } else {
                axis2 = this.getMultistateAxis(1, (int)series.getMax(), axisInfo2);
            }
        }
        chartCanvas.setXAxis(axis);
        axis.addUser(chartCanvas);
        chartCanvas.setYAxis(axis2);
        axis2.addUser(chartCanvas);
    }

    private Axis[] addAxis(Axis axis, Axis[] axisArray) {
        this.add(axis);
        if (axisArray == null) {
            return new Axis[]{axis};
        }
        int n = axisArray.length;
        Axis[] axisArray2 = new Axis[n + 1];
        System.arraycopy(axisArray, 0, axisArray2, 0, n);
        axisArray2[n] = axis;
        return axisArray2;
    }

    void removeXAxis(Axis axis) {
        this.xaxes = this.removeAxis(this.xaxes, axis);
    }

    void removeYAxis(Axis axis) {
        this.yaxes = this.removeAxis(this.yaxes, axis);
    }

    private Axis[] removeAxis(Axis[] axisArray, Axis axis) {
        int n = axisArray == null ? 0 : axisArray.length;
        for (int i = 0; i < n; ++i) {
            if (axisArray[i] != axis) continue;
            return this.removeAxis(axisArray, i);
        }
        return axisArray;
    }

    private Axis[] removeAxis(Axis[] axisArray, int n) {
        Axis axis = axisArray[n];
        this.remove(axis);
        this.invalidate();
        int n2 = axisArray.length;
        if (n2 == 1 && n == 0) {
            return null;
        }
        Axis[] axisArray2 = new Axis[n2 - 1];
        if (n > 0) {
            System.arraycopy(axisArray, 0, axisArray2, 0, n);
        }
        if (n < n2 - 1) {
            System.arraycopy(axisArray, n + 1, axisArray2, n, n2 - n - 1);
        }
        return axisArray2;
    }

    private void removeAllAxes() {
        int n;
        int n2;
        if (this.xaxes != null) {
            n2 = this.xaxes.length;
            for (n = 0; n < n2; ++n) {
                this.remove(this.xaxes[n]);
            }
            this.xaxes = null;
        }
        if (this.yaxes != null) {
            n2 = this.yaxes.length;
            for (n = 0; n < n2; ++n) {
                this.remove(this.yaxes[n]);
            }
            this.yaxes = null;
        }
    }

    public Axis getTimeAxis(int n, long l, long l2, AxisInfo axisInfo) {
        TimeAxis timeAxis = null;
        if (axisInfo == null || axisInfo.isShareable()) {
            Axis[] axisArray = null;
            axisArray = n == 0 ? this.xaxes : this.yaxes;
            if (axisArray != null) {
                int n2 = axisArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (!(axisArray[i] instanceof TimeAxis) || !axisArray[i].isShareable(axisInfo)) continue;
                    timeAxis = (TimeAxis)axisArray[i];
                    timeAxis.updateRange(l, l2);
                    break;
                }
            }
        }
        if (timeAxis == null) {
            timeAxis = new TimeAxis(n, axisInfo, this.lex);
            timeAxis.updateRange(l, l2);
            if (n == 0) {
                this.xaxes = this.addAxis(timeAxis, this.xaxes);
            } else {
                this.yaxes = this.addAxis(timeAxis, this.yaxes);
            }
            this.add(timeAxis);
        }
        return timeAxis;
    }

    public Axis getTimeOfDayAxis(int n, AxisInfo axisInfo) {
        TimeOfDayAxis timeOfDayAxis = null;
        if (axisInfo == null || axisInfo.isShareable()) {
            Axis[] axisArray = null;
            axisArray = n == 0 ? this.xaxes : this.yaxes;
            if (axisArray != null) {
                int n2 = axisArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (!(axisArray[i] instanceof TimeOfDayAxis) || !axisArray[i].isShareable(axisInfo)) continue;
                    timeOfDayAxis = (TimeOfDayAxis)axisArray[i];
                    break;
                }
            }
        }
        if (timeOfDayAxis == null) {
            timeOfDayAxis = new TimeOfDayAxis(n, axisInfo);
            if (n == 0) {
                this.xaxes = this.addAxis(timeOfDayAxis, this.xaxes);
            } else {
                this.yaxes = this.addAxis(timeOfDayAxis, this.yaxes);
            }
            this.add(timeOfDayAxis);
        }
        return timeOfDayAxis;
    }

    public Axis getFloatAxis(int n, double d, double d2, BUnit bUnit, AxisInfo axisInfo) {
        FloatAxis floatAxis = null;
        if ((axisInfo == null || axisInfo.isShareable()) && bUnit != null) {
            Axis[] axisArray = null;
            axisArray = n == 0 ? this.xaxes : this.yaxes;
            if (axisArray != null) {
                int n2 = axisArray.length;
                for (int i = 0; i < n2; ++i) {
                    BUnit bUnit2;
                    if (!(axisArray[i] instanceof FloatAxis) || !axisArray[i].isShareable(axisInfo) || (bUnit2 = ((FloatAxis)axisArray[i]).getUnit()) == null || bUnit == null || !bUnit2.equals((Object)bUnit)) continue;
                    floatAxis = (FloatAxis)axisArray[i];
                    floatAxis.updateRange(d, d2);
                }
            }
        }
        if (floatAxis == null) {
            floatAxis = new FloatAxis(n, axisInfo, this.lex);
            floatAxis.updateRange(d, d2);
            floatAxis.setUnits(bUnit);
            if (n == 0) {
                this.xaxes = this.addAxis(floatAxis, this.xaxes);
            } else {
                this.yaxes = this.addAxis(floatAxis, this.yaxes);
            }
            this.add(floatAxis);
        }
        return floatAxis;
    }

    public Axis getSeriesAxis(int n, Series series, AxisInfo axisInfo) {
        SeriesAxis seriesAxis = new SeriesAxis(n, series, axisInfo);
        if (n == 0) {
            this.xaxes = this.addAxis(seriesAxis, this.xaxes);
        } else {
            this.yaxes = this.addAxis(seriesAxis, this.yaxes);
        }
        this.add(seriesAxis);
        return seriesAxis;
    }

    public Axis getIntAxis(int n, int n2, int n3, AxisInfo axisInfo) {
        IntAxis intAxis = null;
        if (axisInfo == null || axisInfo.isShareable()) {
            Axis[] axisArray = null;
            axisArray = n == 0 ? this.xaxes : this.yaxes;
            if (axisArray != null) {
                int n4 = axisArray.length;
                for (int i = 0; i < n4; ++i) {
                    if (!(axisArray[i] instanceof IntAxis) || !axisArray[i].isShareable(axisInfo)) continue;
                    intAxis = (IntAxis)axisArray[i];
                    intAxis.updateRange(n2, n3);
                }
            }
        }
        if (intAxis == null) {
            intAxis = new IntAxis(n, axisInfo);
            intAxis.updateRange(n2, n3);
            if (n == 0) {
                this.xaxes = this.addAxis(intAxis, this.xaxes);
            } else {
                this.yaxes = this.addAxis(intAxis, this.yaxes);
            }
            this.add(intAxis);
        }
        return intAxis;
    }

    public Axis getMultistateAxis(int n, int n2, AxisInfo axisInfo) {
        MultistateAxis multistateAxis = null;
        if (axisInfo == null || axisInfo.isShareable()) {
            Axis[] axisArray = null;
            axisArray = n == 0 ? this.xaxes : this.yaxes;
            if (axisArray != null) {
                int n3 = axisArray.length;
                for (int i = 0; i < n3; ++i) {
                    if (!(axisArray[i] instanceof MultistateAxis) || !axisArray[i].isShareable(axisInfo)) continue;
                    multistateAxis = (MultistateAxis)axisArray[i];
                    multistateAxis.updateMax(n2);
                }
            }
        }
        if (multistateAxis == null) {
            multistateAxis = new MultistateAxis(n, axisInfo, this.lex);
            multistateAxis.updateMax(n2);
            if (n == 0) {
                this.xaxes = this.addAxis(multistateAxis, this.xaxes);
            } else {
                this.yaxes = this.addAxis(multistateAxis, this.yaxes);
            }
            this.add(multistateAxis);
        }
        return multistateAxis;
    }

    public void chartModified(ChartEvent chartEvent) {
        int n = chartEvent.getEventType();
        switch (n) {
            case 0: {
                this.rebuild();
                this.repaint();
                break;
            }
            case 1: {
                this.addSeries(chartEvent.getId(), true);
                break;
            }
            case 2: {
                this.removeSeries(chartEvent.getId());
                break;
            }
            case 3: {
                this.removeSeries(chartEvent.getId());
                this.addSeries(chartEvent.getId(), true);
                break;
            }
            case 4: {
                this.chartArea.addOverlay(chartEvent.getId());
                break;
            }
            case 5: {
                this.chartArea.removeOverlay(chartEvent.getId());
                break;
            }
            case 6: {
                this.repaint();
                break;
            }
            case 7: {
                this.chartTitle.setTitle(this.model.getTitle(), this.model.getSubtitle());
            }
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }
}

