/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui.chart;

import com.tridium.eas.ui.DecimalFormatter;
import com.tridium.eas.ui.chart.Axis;
import com.tridium.eas.ui.chart.AxisInfo;
import com.tridium.eas.ui.chart.BarConfig;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartCanvas;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultBarConfig;
import com.tridium.eas.ui.chart.FloatAxis;
import com.tridium.eas.ui.chart.Id;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.SeriesAxis;
import com.tridium.eas.ui.chart.TimeAxis;
import com.tridium.eas.ui.chart.TimeSeries;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.baja.units.BUnit;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class BarCanvas
extends ChartCanvas {
    private static final int MIN_BAR_GAP = 1;
    private int barWidth;
    private Font labelFont;
    private FontMetrics labelFm;
    private boolean showLabels;

    public BarCanvas(Chart chart, Id id) {
        super(chart, id);
    }

    public boolean useRowTotals() {
        return this.getSeries().getValueCount() > 1;
    }

    private void checkFont() {
        if (this.labelFont == null) {
            Font font = UIManager.getFont("Table.font");
            this.labelFont = font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), font.getSize());
            this.labelFm = Toolkit.getDefaultToolkit().getFontMetrics(this.labelFont);
        }
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Series series = this.getSeries();
        if (series instanceof TimeSeries) {
            int n3 = this.getSeries().getRowCount();
            this.barWidth = Math.max(1, n / n3 - 1);
            this.barWidth = Math.min(this.barWidth, n / 4);
        } else {
            Axis axis = this.getXAxis();
            this.barWidth = axis.getTickSpacing() - axis.getTickSpacing() / 4;
        }
        this.checkFont();
        this.showLabels = this.labelFm.stringWidth(DecimalFormatter.format(series.getMaxRowTotal())) <= this.barWidth;
    }

    public void paint(Graphics graphics) {
        Series series = this.getSeries();
        if (series instanceof TimeSeries) {
            this.paintSeries(graphics, (TimeAxis)this.getXAxis(), (FloatAxis)this.getYAxis(), (TimeSeries)series);
        } else if (series instanceof Series) {
            this.paintSeries(graphics, (SeriesAxis)this.getXAxis(), (FloatAxis)this.getYAxis(), series);
        }
    }

    private void paintSeries(Graphics graphics, TimeAxis timeAxis, FloatAxis floatAxis, TimeSeries timeSeries) {
        int n = timeSeries.getRowCount();
        int n2 = timeSeries.getValueCount();
        if (n == 0) {
            return;
        }
        int n3 = this.getHeight();
        BarConfig barConfig = (BarConfig)this.getConfig();
        Color color = barConfig.getBorderColor();
        for (int i = 0; i < n2; ++i) {
            graphics.setColor(barConfig.getValueColor(i));
            for (int j = 0; j < n; ++j) {
                int n4 = timeAxis.valueToPixel(timeSeries.getTimestamp(j));
                int n5 = floatAxis.valueToPixel(timeSeries.getValue(j, i));
                graphics.setColor(this.getConfig().getValueColor(i));
                graphics.fillRect(n4 - this.barWidth / 2, n5, this.barWidth, n3 - n5);
                if (this.barWidth == 1 || color == null) continue;
                graphics.setColor(color);
                graphics.drawRect(n4 - this.barWidth / 2, n5, this.barWidth, n3 - n5);
            }
        }
    }

    private void paintSeries(Graphics graphics, SeriesAxis seriesAxis, FloatAxis floatAxis, Series series) {
        int n = series.getRowCount();
        int n2 = series.getValueCount();
        if (n == 0) {
            return;
        }
        int n3 = this.getHeight();
        double d = 0.0;
        int n4 = n3;
        BarConfig barConfig = (BarConfig)this.getConfig();
        Color color = barConfig.getBorderColor();
        for (int i = 0; i < n; ++i) {
            d = 0.0;
            n4 = n3;
            int n5 = seriesAxis.valueToPixel(i);
            for (int j = 0; j < n2; ++j) {
                int n6 = floatAxis.valueToPixel(d += series.getValue(i, j));
                graphics.setColor(barConfig.getValueColor(j));
                graphics.fillRect(n5 - this.barWidth / 2, n6, this.barWidth, n4 - n6);
                if (this.barWidth != 1 && color != null) {
                    graphics.setColor(color);
                    graphics.drawRect(n5 - this.barWidth / 2, n6, this.barWidth, n4 - n6);
                }
                n4 = n6;
            }
            if (!this.showLabels) continue;
            this.checkFont();
            String string = DecimalFormatter.format(d);
            graphics.setFont(this.labelFont);
            graphics.drawString(string, n5 - this.labelFm.stringWidth(string) / 2, n4 - this.labelFm.getDescent());
        }
    }

    public static void main(String[] stringArray) {
        Chart chart = new Chart();
        ChartModel chartModel = chart.getModel();
        TestSeries testSeries = new TestSeries(5, 3);
        DefaultBarConfig defaultBarConfig = new DefaultBarConfig();
        chartModel.addSeries(testSeries, defaultBarConfig, new AxisInfo(), new AxisInfo());
        JFrame jFrame = new JFrame();
        jFrame.setBounds(200, 200, 500, 500);
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)chart, "Center");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setVisible(true);
    }

    public static class TestSeries
    extends Series {
        double[][] values;
        double[] min;
        double[] max;
        double minTotal;
        double maxTotal;

        public TestSeries(int n, int n2) {
            int n3;
            Random random = new Random();
            this.values = new double[n][n2];
            this.min = new double[n2];
            this.max = new double[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.min[n3] = Double.MAX_VALUE;
                this.max[n3] = -1.7976931348623157E308;
            }
            for (n3 = 0; n3 < n; ++n3) {
                double d = 0.0;
                for (int i = 0; i < n2; ++i) {
                    this.values[n3][i] = 100.0f + 20.0f * random.nextFloat();
                    this.min[i] = Math.min(this.min[i], this.values[n3][i]);
                    this.max[i] = Math.max(this.max[i], this.values[n3][i]);
                    d += this.values[n3][i];
                }
                this.minTotal = Math.min(this.minTotal, d);
                this.maxTotal = Math.max(this.maxTotal, d);
            }
            System.out.println("minTotal = " + this.minTotal);
            System.out.println("maxTotal = " + this.maxTotal);
        }

        public String getSeriesName() {
            return "TestSeries";
        }

        public int getRowCount() {
            return this.values.length;
        }

        public String getRowName(int n) {
            return "rowName" + n;
        }

        public int getValueCount() {
            return this.values[0].length;
        }

        public String getValueName(int n) {
            return "valueName" + n;
        }

        public int getValueType() {
            return 0;
        }

        public double getValue(int n, int n2) {
            return this.values[n][n2];
        }

        public String getValueLabel(int n, int n2) {
            return "VL" + n + "," + n2;
        }

        public double getMin(int n) {
            return this.min[n];
        }

        public double getMax(int n) {
            return this.max[n];
        }

        public double getMinRowTotal() {
            return this.minTotal;
        }

        public double getMaxRowTotal() {
            return this.maxTotal;
        }

        public BUnit getValueUnits() {
            return BUnit.getUnit((String)"kilowatt hour");
        }
    }
}

