/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.ui;

import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.UIManager;

public final class EasUiUtil {
    public static final Color DP_NORMALIZED_COLOR = new Color(210, 228, 252);
    private static Font boldLabelFont = null;
    public static final int TRIM_BEGINNING = 0;
    public static final int TRIM_END = 1;

    public static final synchronized Font getBoldLabelFont() {
        if (boldLabelFont == null) {
            Font font = UIManager.getDefaults().getFont("Label.font");
            boldLabelFont = new Font(Theme.widget().getTextFont().getName(), font.getStyle() | 1, font.getSize());
        }
        return boldLabelFont;
    }

    public static final JLabel createBoldLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(EasUiUtil.getBoldLabelFont());
        return jLabel;
    }

    public static final JLabel createDataLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setForeground(Color.darkGray);
        return jLabel;
    }

    public static final String trimToWidth(String string, FontMetrics fontMetrics, int n) {
        return EasUiUtil.trimToWidth(string, fontMetrics, n, 1);
    }

    public static final String trimToWidth(String string, FontMetrics fontMetrics, int n, int n2) {
        if (string == null || fontMetrics.stringWidth(string) <= n) {
            return string;
        }
        int n3 = fontMetrics.stringWidth("...");
        int n4 = 0;
        while (n3 + fontMetrics.stringWidth(EasUiUtil.trimString(string, n4, n2)) > n) {
            if (++n4 < string.length()) continue;
            return "";
        }
        if (n2 == 0) {
            return "..." + EasUiUtil.trimString(string, n4, n2);
        }
        return EasUiUtil.trimString(string, n4, n2) + "...";
    }

    private static final String trimString(String string, int n, int n2) {
        if (n2 == 0) {
            return string.substring(n);
        }
        return string.substring(0, string.length() - n);
    }

    public static final String replace(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        int n = string2.length();
        int n2 = string.length();
        int n3 = string.indexOf(string2);
        if (n3 < 0) {
            return string;
        }
        n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < n2) {
            if (string.regionMatches(n3, string2, 0, n)) {
                stringBuffer.append(string3);
                n3 += n;
                continue;
            }
            stringBuffer.append(string.charAt(n3));
            ++n3;
        }
        string = stringBuffer.toString();
        return string;
    }
}

