/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.Function;
import com.tridium.eas.function.LinearFunction;
import com.tridium.eas.function.Population;

public class StatXY {
    public static final int CORRELATION = 0;
    public static final int STUDENT = 1;
    public static final int SLOPE_STANDARD_ERROR = 2;
    public static final int FIT_ERROR_SD = 4;
    public static final int LINEAR_REGRESSION = 5;
    public static final int MEAN = 6;
    public static final int MAX = 7;
    public static final int MIN = 8;
    public static final int SUM = 9;
    public static final int SUM2 = 10;
    public static final int VAR = 11;
    public static final int STDDEV = 12;
    public static final int SUM_XY = 13;
    public static final int SLOPE = 14;
    public static final int OFFSET = 15;
    public static final int X = 0;
    public static final int Y = 1;
    private double sx = 0.0;
    private double sy = 0.0;
    private double sxy = 0.0;
    private double sxx = 0.0;
    private double syy = 0.0;
    private double maxx;
    private double maxy;
    private double minx;
    private double miny;
    private double sdx = 0.0;
    private double sdy = 0.0;
    private double vx = 0.0;
    private double vy = 0.0;
    private int n = 0;
    private double mx;
    private double my;
    private double se;
    private double sde;
    private double a;
    private double b;
    private double r;
    private double t;
    private boolean valid = false;
    private Population x;
    private Population y;

    public StatXY() {
    }

    public StatXY(Population population, Population population2) {
        if (population.getSize() != population2.getSize()) {
            throw new IllegalArgumentException("Populations have different sizes");
        }
        this.x = population;
        this.y = population2;
        this.calculateBaseStats();
    }

    public StatXY(int n, double d, double d2, double d3, double d4, double d5) {
        this(n, d, d2, d3, d4, d5, Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public StatXY(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        d8 = d9;
        d7 = Double.MAX_VALUE;
        d6 = Double.MAX_VALUE;
        this.n = n;
        this.sx = d;
        this.sy = d2;
        this.sxy = d3;
        this.sxx = d5;
        this.calculateDerivedStats();
    }

    private void calculateBaseStats() {
        this.sxy = 0.0;
        this.syy = 0.0;
        this.sxx = 0.0;
        this.sy = 0.0;
        this.sx = 0.0;
        this.maxy = -1.7976931348623157E308;
        this.maxx = -1.7976931348623157E308;
        this.miny = Double.MAX_VALUE;
        this.minx = Double.MAX_VALUE;
        int n = this.n = this.x.getSize();
        while (--n >= 0) {
            if (this.x.isValid(n) && this.y.isValid(n)) {
                double d = this.x.getSample(n);
                double d2 = this.y.getSample(n);
                this.maxx = Math.max(d, this.maxx);
                this.minx = Math.min(d, this.minx);
                this.maxy = Math.max(d2, this.maxy);
                this.miny = Math.min(d2, this.miny);
                this.sx += d;
                this.sy += d2;
                this.sxy += d * d2;
                this.sxx += d * d;
                this.syy += d2 * d2;
                continue;
            }
            --this.n;
        }
        this.calculateDerivedStats();
    }

    private void calculateDerivedStats() {
        this.mx = this.sx / (double)this.n;
        this.my = this.sy / (double)this.n;
        this.vx = this.sxx - this.sx * this.mx;
        this.vy = this.syy - this.sy * this.my;
        this.r = (this.sxy - this.sy * this.sx / (double)this.n) / Math.sqrt(this.vx * this.vy);
        this.vx /= (double)(this.n - 1);
        this.vy /= (double)(this.n - 1);
        this.sdx = Math.sqrt(this.vx);
        this.sdy = Math.sqrt(this.vy);
        this.a = this.r * this.sdy / this.sdx;
        this.b = this.my - this.a * this.mx;
        this.t = 1.0 - this.r * this.r;
        this.sde = Math.sqrt(this.t * this.sdy * this.sdy);
        this.t = this.r * Math.sqrt((double)(this.n - 2) / this.t);
        this.se = this.my / this.t;
        this.valid = true;
    }

    public double getScalar(int n) {
        switch (n) {
            case 0: {
                return this.r;
            }
            case 1: {
                return this.t;
            }
            case 2: {
                return this.se;
            }
            case 4: {
                return this.sde;
            }
            case 13: {
                return this.sxy;
            }
            case 14: {
                return this.a;
            }
            case 15: {
                return this.b;
            }
        }
        throw new IllegalArgumentException("Illegal class argument");
    }

    public double getScalar(int n, int n2) {
        switch (n) {
            case 6: {
                return n2 == 0 ? this.mx : this.my;
            }
            case 7: {
                return n2 == 0 ? this.maxx : this.maxy;
            }
            case 8: {
                return n2 == 0 ? this.minx : this.miny;
            }
            case 9: {
                return n2 == 0 ? this.sx : this.sy;
            }
            case 10: {
                return n2 == 0 ? this.sxx : this.syy;
            }
            case 11: {
                return n2 == 0 ? this.vx : this.vy;
            }
            case 12: {
                return n2 == 0 ? this.sdx : this.sdy;
            }
        }
        throw new IllegalArgumentException("Illegal class argument");
    }

    public Function getFunction(int n) {
        switch (n) {
            case 5: {
                return new LinearFunction(this.a, this.b);
            }
        }
        throw new IllegalArgumentException("Illegal class argument");
    }

    public boolean isValid() {
        return this.valid;
    }
}

