/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.MutablePopulation;
import com.tridium.eas.function.Population;
import javax.baja.units.BUnit;

public class SimpleFloatPopulation
implements Population {
    private double[] data;
    private BUnit unit = null;
    private int size;

    public SimpleFloatPopulation(BUnit bUnit, double[] dArray, int n) {
        this.size = Math.min(dArray.length, n);
        this.unit = bUnit;
        this.data = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = dArray[i];
        }
    }

    public SimpleFloatPopulation(BUnit bUnit, double[] dArray) {
        this(bUnit, dArray, dArray.length);
    }

    public SimpleFloatPopulation(Population population) {
        this.size = population.getSize();
        this.unit = population.getUnit();
        this.data = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = population.getSample(i);
        }
    }

    public SimpleFloatPopulation(SimpleFloatPopulation simpleFloatPopulation) {
        this.size = simpleFloatPopulation.getSize();
        this.unit = this.unit;
        if (simpleFloatPopulation instanceof MutablePopulation) {
            this.data = new double[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.data[i] = simpleFloatPopulation.data[i];
            }
        } else {
            this.data = simpleFloatPopulation.data;
        }
    }

    public int getSize() {
        return this.size;
    }

    public double getSample(int n) {
        return this.data[n];
    }

    public BUnit getUnit() {
        return this.unit;
    }

    public boolean isValid(int n) {
        return true;
    }
}

