/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.BEasService;
import com.tridium.eas.function.BooleanPopulation;
import com.tridium.eas.function.MutablePopulation;
import com.tridium.eas.function.Population;
import com.tridium.eas.util.BoolArray;
import javax.baja.units.BUnit;

public class SimpleBooleanPopulation
implements BooleanPopulation {
    private boolean[] data;
    private static final BUnit unit = BEasService.MULTISTATE;

    public SimpleBooleanPopulation(int n) {
        this(n, true);
    }

    public SimpleBooleanPopulation(int n, boolean bl) {
        this.data = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.data[n2] = bl;
        }
    }

    public SimpleBooleanPopulation(boolean[] blArray) {
        int n = blArray.length;
        this.data = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.data[n2] = blArray[n2];
        }
    }

    public SimpleBooleanPopulation(BoolArray boolArray) {
        this.data = boolArray.get();
    }

    public SimpleBooleanPopulation(SimpleBooleanPopulation simpleBooleanPopulation) {
        if (simpleBooleanPopulation instanceof MutablePopulation) {
            int n = simpleBooleanPopulation.getSize();
            this.data = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                this.data[n2] = simpleBooleanPopulation.data[n2];
            }
        } else {
            this.data = simpleBooleanPopulation.data;
        }
    }

    public SimpleBooleanPopulation(BooleanPopulation booleanPopulation) {
        int n = booleanPopulation.getSize();
        this.data = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            this.data[n2] = booleanPopulation.getBoolean(n2);
        }
    }

    public SimpleBooleanPopulation(Population population, boolean bl) {
        int n = population.getSize();
        this.data = new boolean[n];
        if (bl) {
            int n2 = n;
            while (--n2 >= 0) {
                this.data[n2] = population.isValid(n2);
            }
        } else {
            int n3 = n;
            while (--n3 >= 0) {
                this.data[n3] = population.getSample(n3) > 0.0;
            }
        }
    }

    public BUnit getUnit() {
        return unit;
    }

    public boolean isValid(int n) {
        return true;
    }

    public int getSize() {
        return this.data.length;
    }

    public double getSample(int n) {
        return this.getBoolean(n) ? 1.0 : -1.0;
    }

    public boolean getBoolean(int n) {
        return this.data[n];
    }

    public BoolArray getBoolArray() {
        return new BoolArray(this.data);
    }
}

