/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.ParameterMetaData;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.Range;
import javax.baja.units.BUnit;

public class Parameters {
    private Population[] pops;
    private double[] scalars;
    private Range[] ranges;
    private BUnit[] scalarUnits;

    public Parameters(Population[] populationArray) {
        this(populationArray, new double[0], new BUnit[0], new Range[0]);
    }

    public Parameters(Population population) {
        this(new Population[]{population}, new double[0], new BUnit[0], new Range[0]);
    }

    public Parameters(double d, BUnit bUnit) {
        this(new Population[0], new double[]{d}, new BUnit[]{bUnit}, new Range[0]);
    }

    public Parameters(Range range) {
        this(new Population[0], new double[0], new BUnit[0], new Range[]{range});
    }

    public Parameters(Population[] populationArray, double[] dArray, BUnit[] bUnitArray, Range[] rangeArray) {
        this.pops = populationArray;
        this.scalars = dArray;
        this.scalarUnits = bUnitArray;
        this.ranges = rangeArray;
    }

    public Population getPopulation(int n) {
        return this.pops[n];
    }

    public double getScalar(int n) {
        return this.scalars[n];
    }

    public BUnit getScalarUnit(int n) {
        return this.scalarUnits[n];
    }

    public Range getRange(int n) {
        return this.ranges[n];
    }

    public Population[] getPopulations() {
        return this.pops;
    }

    public double[] getScalars() {
        return this.scalars;
    }

    public BUnit[] getScalarUnits() {
        return this.scalarUnits;
    }

    public Range[] getRanges() {
        return this.ranges;
    }

    public int getNumPopulations() {
        return this.pops.length;
    }

    public int getNumScalars() {
        return this.scalars.length;
    }

    public int getNumRanges() {
        return this.ranges.length;
    }

    public boolean conformsTo(ParameterMetaData parameterMetaData) {
        if (this.pops.length < parameterMetaData.getMinNumberOfPopulations()) {
            return false;
        }
        if (this.pops.length > parameterMetaData.getMaxNumberOfPopulations()) {
            return false;
        }
        if (this.scalars.length < parameterMetaData.getMinNumberOfScalars()) {
            return false;
        }
        if (this.scalars.length > parameterMetaData.getMaxNumberOfScalars()) {
            return false;
        }
        if (this.ranges.length < parameterMetaData.getMinNumberOfRanges()) {
            return false;
        }
        return this.ranges.length <= parameterMetaData.getMaxNumberOfRanges();
    }
}

