/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.ParameterMetaData;
import com.tridium.eas.function.Parameters;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.TransformFunction;
import com.tridium.eas.util.CompoundUnitUtil;
import javax.baja.units.BUnit;

public class NormalizeByScalar
implements TransformFunction {
    public static final ParameterMetaData PARAMETER_META_DATA = new ParameterMetaData(1, 1, new String[]{"Population to Normalize"}, 1, 1, new String[]{"Normal Value"}, 0, 0, null);

    public Population getPopulation(Parameters parameters) {
        return NormalizeByScalar.getNormalizedPopulation(parameters.getScalar(0), parameters.getScalarUnit(0), parameters.getPopulation(0));
    }

    public static Population[] getNormalizedPopulations(double[] dArray, BUnit bUnit, Population[] populationArray) {
        Population[] populationArray2 = new Population[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            populationArray2[i] = NormalizeByScalar.getNormalizedPopulation(dArray[i], bUnit, populationArray[i]);
        }
        return populationArray2;
    }

    public static Population getNormalizedPopulation(double d, BUnit bUnit, Population population) {
        return new NormalizedPopulation(d, bUnit, population);
    }

    public ParameterMetaData getParameterMetaData() {
        return PARAMETER_META_DATA;
    }

    private static class NormalizedPopulation
    implements Population {
        private double normal;
        private Population toNormalize;
        private BUnit unit;

        public NormalizedPopulation(double d, BUnit bUnit, Population population) {
            this.normal = d;
            this.toNormalize = population;
            this.unit = CompoundUnitUtil.make(population.getUnit(), bUnit);
        }

        public int getSize() {
            return this.toNormalize.getSize();
        }

        public double getSample(int n) {
            return this.toNormalize.getSample(n) / this.normal;
        }

        public BUnit getUnit() {
            return this.unit;
        }

        public boolean isValid(int n) {
            return this.toNormalize.isValid(n);
        }
    }
}

