/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.Function;
import com.tridium.eas.function.LinearFunction;
import com.tridium.eas.function.ParameterMetaData;
import com.tridium.eas.function.Population;

public class LinearRegression
implements Function {
    public static final ParameterMetaData PARAMETER_META_DATA = new ParameterMetaData(2, 2, 0, 0, 0, 0);

    public static LinearFunction getLinearRegressionFunction(Population population, Population population2) {
        int n;
        if (population.getSize() != population2.getSize()) {
            throw new IllegalArgumentException("Populations have different sizes");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = n = population.getSize();
        while (--n2 >= 0) {
            if (population.isValid(n2) && population2.isValid(n2)) {
                double d5 = population.getSample(n2);
                double d6 = population2.getSample(n2);
                d2 += d5;
                d3 += d6;
                d += d5 * d6;
                d4 += d5 * d5;
                continue;
            }
            --n;
        }
        double d7 = d2 / (double)n;
        double d8 = d3 / (double)n;
        double d9 = (d - d3 * d7) / (d4 - d2 * d7);
        double d10 = d8 - d9 * d7;
        return new LinearFunction(d9, d10);
    }

    public static LinearFunction getLinearRegressionFunction(Population population, double d, Population population2, double d2) {
        if (population.getSize() != population2.getSize()) {
            throw new IllegalArgumentException("Populations have different sizes");
        }
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < population.getSize(); ++i) {
            if (!population.isValid(i) || !population2.isValid(i)) continue;
            double d5 = population.getSample(i) - d;
            d4 += d5 * d5;
            d3 += d5 * population2.getSample(i);
        }
        double d6 = d2 - (d3 /= d4) * d;
        return new LinearFunction(d3, d6);
    }

    public ParameterMetaData getParameterMetaData() {
        return PARAMETER_META_DATA;
    }
}

