/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.Function;
import com.tridium.eas.function.MutablePopulation;
import com.tridium.eas.function.Parameters;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.PopulationChangedEvent;
import com.tridium.eas.function.PopulationListener;
import com.tridium.eas.function.ScalarFunction;
import com.tridium.eas.function.TransformFunction;
import java.util.Hashtable;

public class FunctionCache {
    private Parameters parameters;
    private Hashtable cache;

    public FunctionCache(Parameters parameters) {
        this.parameters = parameters;
        this.cache = new Hashtable();
    }

    public FunctionCache(Population population) {
        this(new Population[]{population});
    }

    public FunctionCache(Population[] populationArray) {
        this(new Parameters(populationArray));
        PopulationListener populationListener = new PopulationListener(){

            public void populationChanged(PopulationChangedEvent populationChangedEvent) {
                FunctionCache.this.invalidate();
            }
        };
        for (int i = 0; i < populationArray.length; ++i) {
            if (!(populationArray[i] instanceof MutablePopulation)) continue;
            ((MutablePopulation)populationArray[i]).addPopulationListener(populationListener);
        }
    }

    public double getResults(ScalarFunction scalarFunction) {
        if (!this.parameters.conformsTo(scalarFunction.getParameterMetaData())) {
            throw new IllegalArgumentException("Attempted to use function with incompatible signature");
        }
        Double d = (Double)this.getCachedResult(scalarFunction);
        if (d == null) {
            d = new Double(scalarFunction.getScalar(this.parameters));
            this.cacheResult(scalarFunction, (Object)d);
        }
        return d;
    }

    public Population getResults(TransformFunction transformFunction) {
        if (!this.parameters.conformsTo(transformFunction.getParameterMetaData())) {
            throw new IllegalArgumentException("Attempted to use function with incompatible signature");
        }
        Population population = (Population)this.getCachedResult(transformFunction);
        if (population == null) {
            population = transformFunction.getPopulation(this.parameters);
            this.cacheResult(transformFunction, (Object)population);
        }
        return population;
    }

    protected void cacheResult(Class clazz, Object object) {
        this.getCache().put(clazz, object);
    }

    protected void cacheResult(Function function, Object object) {
        this.getCache().put(function, object);
    }

    protected Object getCachedResult(Function function) {
        return this.getCache().get(function);
    }

    protected Object getCachedResult(Class clazz) {
        return this.getCache().get(clazz);
    }

    public void invalidate() {
        this.cache = new Hashtable();
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    protected Hashtable getCache() {
        return this.cache;
    }
}

