/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.function;

import com.tridium.eas.function.ParameterMetaData;
import com.tridium.eas.function.Parameters;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.ScalarFunction;
import com.tridium.eas.function.StandardNormalValue;

public class Correlation
implements ScalarFunction {
    public static final ParameterMetaData PARAMETER_META_DATA = new ParameterMetaData(2, 2, 0, 0, 0, 0);

    public double getScalar(Parameters parameters) {
        return Correlation.getCorrelation(parameters.getPopulation(0), parameters.getPopulation(1));
    }

    public static double getCorrelation(Population population, Population population2) {
        if (population.getSize() != population2.getSize()) {
            throw new IllegalArgumentException("Cannot correlate populations of different sizes " + population.getSize() + " != " + population2.getSize());
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        for (int i = 0; i < population.getSize(); ++i) {
            if (!population.isValid(i) || !population2.isValid(i)) continue;
            ++n;
            d += population.getSample(i);
            d4 += population.getSample(i) * population.getSample(i);
            d2 += population2.getSample(i);
            d5 += population2.getSample(i) * population2.getSample(i);
            d3 += population.getSample(i) * population2.getSample(i);
        }
        return (d3 - d * d2 / (double)n) / Math.sqrt((d4 - d * d / (double)n) * (d5 - d2 * d2 / (double)n));
    }

    public static double getCorrelation(Population population, double d, double d2, Population population2, double d3, double d4) {
        if (population.getSize() != population2.getSize()) {
            throw new IllegalArgumentException("Cannot correlate populations of different sizes " + population.getSize() + " != " + population2.getSize());
        }
        double d5 = 0.0;
        int n = 0;
        for (int i = 0; i < population.getSize(); ++i) {
            if (!population.isValid(i) || !population2.isValid(i)) continue;
            ++n;
            d5 += StandardNormalValue.getStandardNormalValue(population, d, d2, i) * StandardNormalValue.getStandardNormalValue(population2, d3, d4, i);
        }
        return d5 / (double)n;
    }

    public ParameterMetaData getParameterMetaData() {
        return PARAMETER_META_DATA;
    }
}

