/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.db;

import com.tridium.eas.EasDatabase;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.MeterExec;
import com.tridium.eas.api.Site;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.util.Dbx;
import com.tridium.eas.web.EasCostHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class MeterExecSrv
implements MeterExec {
    private EasDatabase easDb;
    private EasSession session;

    public MeterExecSrv(EasSession easSession, EasDatabase easDatabase) {
        this.easDb = easDatabase;
        this.session = easSession;
    }

    public Meter load(int n) {
        if (n == -1) {
            return null;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        Meter meter = null;
        try {
            statement = connection.createStatement();
            string = "select NAME, DESCR, RC_TYPE, SITE_ID, FLOORAREA_VUNIT, FLOORAREA_VALUE, MAIN from " + this.easDb.getDBSpecific().getFullTableName("EAS", "METER") + " where ID=" + n;
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                int n2 = resultSet.getInt(3);
                int n3 = resultSet.getInt(4);
                if (resultSet.wasNull()) {
                    n3 = -1;
                }
                String string4 = resultSet.getString(5);
                double d = resultSet.getDouble(6);
                boolean bl = resultSet.getInt(7) == 1;
                meter = Meter.get(n, string2, string3, n2, bl, n3, string4, d, true, this.session);
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return meter;
    }

    public int erase(int n) {
        int n2 = -1;
        if (n == -1) {
            return n2;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            string = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "METER") + " where ID=" + n;
            n2 = statement.executeUpdate(string);
            RateHistory.deleteFromRdb(n, statement, this.easDb.getDBSpecific());
            string = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "BUDGET_COSTS") + " where METER_ID=" + n;
            statement.executeUpdate(string);
            string = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "ACTUAL_COSTS") + " where METER_ID=" + n;
            statement.executeUpdate(string);
            string = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "MISC_COSTS") + " where METER_ID=" + n;
            statement.executeUpdate(string);
            string = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "BILLING_CYCLES") + " where METER_ID=" + n;
            statement.executeUpdate(string);
            EasCostHandler.deleteReconciliationNotesDirectory(n);
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.easDb.freeConnection(connection);
        return n2;
    }

    public int create(String string, String string2, int n, boolean bl, int n2, String string3, double d) {
        int n3 = -1;
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = null;
        boolean bl2 = true;
        int n4 = 11;
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            this.easDb.freeConnection(connection);
            return -1;
        }
        while (bl2 && --n4 >= 0) {
            try {
                n3 = this.easDb.getNewId();
                string4 = "insert into " + this.easDb.getDBSpecific().getFullTableName("EAS", "METER") + " (ID,NAME,DESCR,RC_TYPE,SITE_ID,FLOORAREA_VUNIT,FLOORAREA_VALUE,MAIN) values (" + n3 + "," + Dbx.str2db(string) + "," + Dbx.str2db(string2) + "," + n + "," + n2 + "," + Dbx.str2db(string3) + "," + d + "," + (bl ? 1 : 0) + ")";
                bl2 = statement.executeUpdate(string4) != 1;
            }
            catch (SQLException sQLException) {
                if (n4 != 0) continue;
                System.out.println(string4);
                sQLException.printStackTrace();
            }
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.easDb.freeConnection(connection);
        return bl2 ? -1 : n3;
    }

    public int update(int n, String string, String string2, int n2, boolean bl, int n3, String string3, double d) {
        int n4 = -1;
        if (n == -1) {
            return n4;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string4 = null;
        try {
            statement = connection.createStatement();
            string4 = "update " + this.easDb.getDBSpecific().getFullTableName("EAS", "METER") + " set NAME=" + Dbx.str2db(string) + ",DESCR=" + Dbx.str2db(string2) + ",RC_TYPE=" + n2 + ",SITE_ID=" + n3 + ",floorarea_vunit=" + Dbx.str2db(string3) + ",floorarea_value=" + d + ",MAIN=" + (bl ? 1 : 0) + " where ID=" + n;
            n4 = statement.executeUpdate(string4);
        }
        catch (SQLException sQLException) {
            System.out.println(string4);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.easDb.freeConnection(connection);
        return n4;
    }

    public Vector getSiteMeters(Site site) {
        return this.getSiteMeters(site == null ? -1 : site.getId(), site);
    }

    public Vector getSiteMeters(int n) {
        return this.getSiteMeters(n, null);
    }

    private Vector getSiteMeters(int n, Site site) {
        Vector<Meter> vector = new Vector<Meter>();
        if (n == -1) {
            return vector;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            string = "select NAME, DESCR, RC_TYPE, FLOORAREA_VUNIT, FLOORAREA_VALUE, ID, MAIN from " + this.easDb.getDBSpecific().getFullTableName("EAS", "METER") + " where SITE_ID=" + n;
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                int n2 = resultSet.getInt(3);
                String string4 = resultSet.getString(4);
                double d = resultSet.getDouble(5);
                int n3 = resultSet.getInt(6);
                boolean bl = resultSet.getInt(7) == 1;
                Meter meter = site == null ? Meter.get(n3, string2, string3, n2, bl, n, string4, d, true, this.session) : Meter.get(n3, string2, string3, n2, bl, site, string4, d, true);
                vector.addElement(meter);
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return vector;
    }

    public final int getAvailableLicensedMeterCount() {
        int n = this.easDb.getLicensedMeterCount();
        int n2 = 0;
        Group[] groupArray = Site.getGroups(this.session);
        if (groupArray != null) {
            for (int i = 0; i < groupArray.length; ++i) {
                Vector vector = this.getSiteMeters((Site)groupArray[i]);
                if (vector == null) continue;
                for (int j = 0; j < vector.size(); ++j) {
                    RateHistory rateHistory = null;
                    try {
                        rateHistory = EasCostHandler.loadRateHistory(((Meter)vector.elementAt(j)).getId());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (rateHistory == null || rateHistory.getRateLinks() == null || rateHistory.getRateLinks().length <= 0) continue;
                    ++n2;
                }
            }
        }
        return Math.max(n - n2, 0);
    }

    public final boolean isEasE2Licensed() {
        return this.easDb.isEasE2Licensed();
    }

    public final boolean isEasCostLicensed() {
        return this.easDb.isEasCostLicensed();
    }

    public final boolean isReportLicensed(String string) {
        return this.easDb.isReportLicensed(string);
    }

    public boolean isCustomRateComponentUnlocked(String string) {
        return this.easDb.isCustomRateComponentUnlocked(string);
    }
}

