/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.db;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.xml.XmlMessage;
import java.util.Vector;
import javax.baja.log.Log;

public class MeterDxDispatch {
    private EasSession srv;
    private static final Log log = Log.getLog((String)"eas");

    public MeterDxDispatch(EasSession easSession) {
        this.srv = easSession;
    }

    public XmlMessage process(XmlMessage xmlMessage) {
        String string = xmlMessage.getString("command", null);
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("create")) {
            return this.create(xmlMessage);
        }
        if (string.equalsIgnoreCase("erase")) {
            return this.erase(xmlMessage);
        }
        if (string.equalsIgnoreCase("update")) {
            return this.update(xmlMessage);
        }
        if (string.equalsIgnoreCase("load")) {
            return this.load(xmlMessage);
        }
        if (string.equalsIgnoreCase("getSiteMeters")) {
            return this.getSiteMeters(xmlMessage);
        }
        if (string.equalsIgnoreCase("availableLicensed")) {
            return this.getAvailableLicensedMeterCount();
        }
        if (string.equalsIgnoreCase("easE2Licensed")) {
            return this.isEasE2Licensed();
        }
        if (string.equalsIgnoreCase("easCostLicensed")) {
            return this.isEasCostLicensed();
        }
        if (string.equalsIgnoreCase("easReportLicensed")) {
            return this.isReportLicensed(xmlMessage);
        }
        if (string.equalsIgnoreCase("customRateComponentUnlocked")) {
            return this.isCustomRateComponentUnlocked(xmlMessage);
        }
        return null;
    }

    public XmlMessage load(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("meterId");
            Meter meter = this.srv.getMeterExec().load(n);
            if (meter == null) {
                return xmlMessage2;
            }
            xmlMessage2 = new XmlMessage("load");
            xmlMessage2.add("meterId", meter.getId());
            xmlMessage2.add("name", meter.getName());
            xmlMessage2.add("descr", meter.getDescr());
            xmlMessage2.add("rc_type", meter.getRcType());
            xmlMessage2.add("is_main", meter.isMain());
            xmlMessage2.add("site", meter.getSiteId());
            xmlMessage2.add("floorarea_vunit", meter.getFloorAreaVUnit());
            xmlMessage2.add("floorarea_value", meter.getFloorAreaValue());
        }
        catch (Exception exception) {
            log.error("Problem with meter load", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage create(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            String string = xmlMessage.getString("name");
            String string2 = xmlMessage.getString("descr");
            int n = xmlMessage.getInt("rc_type");
            boolean bl = xmlMessage.getBoolean("is_main");
            int n2 = xmlMessage.getInt("site");
            String string3 = xmlMessage.getString("floorarea_vunit");
            double d = xmlMessage.getDouble("floorarea_value");
            int n3 = this.srv.getMeterExec().create(string, string2, n, bl, n2, string3, d);
            xmlMessage2 = new XmlMessage("create");
            xmlMessage2.add("meterId", n3);
        }
        catch (Exception exception) {
            log.error("Problem with meter create", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage update(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("meterId");
            String string = xmlMessage.getString("name");
            String string2 = xmlMessage.getString("descr");
            int n2 = xmlMessage.getInt("rc_type");
            boolean bl = xmlMessage.getBoolean("is_main");
            int n3 = xmlMessage.getInt("site");
            String string3 = xmlMessage.getString("floorarea_vunit");
            double d = xmlMessage.getDouble("floorarea_value");
            int n4 = this.srv.getMeterExec().update(n, string, string2, n2, bl, n3, string3, d);
            xmlMessage2 = new XmlMessage("update");
            xmlMessage2.add("status", n4);
        }
        catch (Exception exception) {
            log.error("Problem with meter update", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage erase(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("meterId");
            int n2 = this.srv.getMeterExec().erase(n);
            xmlMessage2 = new XmlMessage("erase");
            xmlMessage2.add("status", n2);
        }
        catch (Exception exception) {
            log.error("Problem with meter erase", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage getSiteMeters(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = null;
        try {
            int n = xmlMessage.getInt("site");
            Vector vector = this.srv.getMeterExec().getSiteMeters(n);
            if (vector == null) {
                return null;
            }
            xmlMessage2 = new XmlMessage("getSiteMeters");
            for (int i = 0; i < vector.size(); ++i) {
                XmlMessage xmlMessage3 = new XmlMessage("row" + i);
                Meter meter = (Meter)vector.elementAt(i);
                xmlMessage3.add("meterIdx", meter.getId());
                xmlMessage3.add("nameIdx", meter.getName());
                xmlMessage3.add("descrIdx", meter.getDescr());
                xmlMessage3.add("rctypeIdx", meter.getRcType());
                xmlMessage3.add("ismainIdx", meter.isMain());
                xmlMessage3.add("siteIdx", meter.getSiteId());
                xmlMessage3.add("funitIdx", meter.getFloorAreaVUnit());
                xmlMessage3.add("fvalueIdx", meter.getFloorAreaValue());
                xmlMessage2.add("row" + i, xmlMessage3);
            }
        }
        catch (Exception exception) {
            log.error("Problem with getSiteMeters", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public final XmlMessage getAvailableLicensedMeterCount() {
        int n = this.srv.getMeterExec().getAvailableLicensedMeterCount();
        XmlMessage xmlMessage = new XmlMessage("availableLicensed");
        try {
            xmlMessage.add("count", n);
        }
        catch (Exception exception) {
            log.error("Problem with getAvailableLicensedMeterCount", (Throwable)exception);
        }
        return xmlMessage;
    }

    public final XmlMessage isEasE2Licensed() {
        boolean bl = this.srv.getMeterExec().isEasE2Licensed();
        XmlMessage xmlMessage = new XmlMessage("easE2Licensed");
        try {
            xmlMessage.add("licensed", bl);
        }
        catch (Exception exception) {
            log.error("Problem with isEasE2Licensed", (Throwable)exception);
        }
        return xmlMessage;
    }

    public final XmlMessage isEasCostLicensed() {
        boolean bl = this.srv.getMeterExec().isEasCostLicensed();
        XmlMessage xmlMessage = new XmlMessage("easCostLicensed");
        try {
            xmlMessage.add("licensed", bl);
        }
        catch (Exception exception) {
            log.error("Problem with isEasCostLicensed", (Throwable)exception);
        }
        return xmlMessage;
    }

    public final XmlMessage isReportLicensed(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = new XmlMessage("easReportLicensed");
        try {
            String string = xmlMessage.getString("report");
            boolean bl = this.srv.getMeterExec().isReportLicensed(string);
            xmlMessage2.add("licensed", bl);
        }
        catch (Exception exception) {
            log.error("Problem with isReportLicensed", (Throwable)exception);
        }
        return xmlMessage2;
    }

    public XmlMessage isCustomRateComponentUnlocked(XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = new XmlMessage("customRateComponentUnlocked");
        try {
            String string = xmlMessage.getString("customClassName");
            boolean bl = this.srv.getMeterExec().isCustomRateComponentUnlocked(string);
            xmlMessage2.add("unlocked", bl);
        }
        catch (Exception exception) {
            log.error("Problem with isCustomRateComponentUnlocked", (Throwable)exception);
        }
        return xmlMessage2;
    }
}

