/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.db;

import com.tridium.eas.BEasService;
import com.tridium.eas.EasDatabase;
import com.tridium.eas.api.DPNormInfo;
import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DataPointExec;
import com.tridium.eas.api.DataSample;
import com.tridium.eas.api.DataSummaryElement;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ExceptionSummary;
import com.tridium.eas.api.ExceptionSummaryData;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.RestorationMethod;
import com.tridium.eas.api.RollupMethod;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.SiteSummary;
import com.tridium.eas.api.TSDataFloat;
import com.tridium.eas.api.TSDataRegular;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.function.CompactBooleanPopulation;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.RepeatingPopulation;
import com.tridium.eas.function.SPCLimitsFunction;
import com.tridium.eas.function.ScalarDiffBinaryOperation;
import com.tridium.eas.function.SimpleBooleanPopulation;
import com.tridium.eas.function.SimpleFloatPopulation;
import com.tridium.eas.function.StatXY;
import com.tridium.eas.function.VectorBinaryOperation;
import com.tridium.eas.util.Alg;
import com.tridium.eas.util.BitOp;
import com.tridium.eas.util.BoolArray;
import com.tridium.eas.util.CompoundUnitUtil;
import com.tridium.eas.util.Dbx;
import com.tridium.history.BHistoryDeltaQuery;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Cursor;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class DataPointExecSrv
implements DataPointExec {
    public static final int NORM_NONE = 0;
    public static final int NORM_BY_SITE_PROP = 1;
    public static final int NORM_BY_FLOOR_AREA = 2;
    public static final int NORM_BY_TSDATA = 3;
    private static String BAD_PARAMS = "NON-COMPATIBLE PARAMETERS";
    public static final BTimeZone GMT = BTimeZone.getTimeZone((String)"GMT");
    private static final Cdd2HddOp cdd2HddOp = new Cdd2HddOp();
    private EasSession session;
    private EasDatabase easDb;
    private TimeInterval aDay = new TimeInterval(1L, 5);
    private static final TimeInterval[] tis = new TimeInterval[]{TimeInterval.INTERVAL_20_MINUTES, TimeInterval.HALF_HOUR, TimeInterval.ONE_HOUR, TimeInterval.SIX_HOURS, TimeInterval.HALF_DAY, TimeInterval.ONE_DAY};
    private static final int BAD_STATUS = 23;
    private static final int BAD_TREND_FLAGS = 4;
    static /* synthetic */ Class class$javax$baja$sys$BFacets;

    public DataPointExecSrv(EasSession easSession, EasDatabase easDatabase) {
        this.easDb = easDatabase;
        this.session = easSession;
    }

    public Vector getAllDataPointNames() {
        Vector<String> vector = new Vector<String>();
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            string = "select NAME from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT");
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                vector.addElement(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return vector;
    }

    public Vector getGroupDataPoints(int n) {
        Vector<DataPoint> vector = new Vector<DataPoint>();
        if (n == -1) {
            return vector;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            string = "select p.ID, p.NAME, p.DESCR, p.RC_TYPE, p.GROUP_ID, p.FLOORAREA_VUNIT, p.FLOORAREA_VALUE, p.METER_ID, p.RC_SUBTYPE, p.MAIN, p.FLAGS from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " p, " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_DP_GROUP") + " g where g.DP_ID=p.ID and g.GROUP_ID=" + n;
            boolean bl = true;
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (SQLException sQLException) {
                string = "select p.ID, p.NAME, p.DESCR, p.RC_TYPE, p.GROUP_ID, p.FLOORAREA_VUNIT, p.FLOORAREA_VALUE, p.METER_ID, p.RC_SUBTYPE, p.MAIN from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " p, " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_DP_GROUP") + " g where g.DP_ID=p.ID and g.GROUP_ID=" + n;
                resultSet = statement.executeQuery(string);
                bl = false;
            }
            while (resultSet.next()) {
                BTimeZone bTimeZone;
                Object object;
                String string2;
                int n2 = resultSet.getInt(1);
                String string3 = string2 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                int n3 = resultSet.getInt(4);
                BUnit bUnit = BUnit.NULL;
                BFacets bFacets = BFacets.NULL;
                String string5 = null;
                try {
                    object = this.easDb.getLog(string2).getConfig();
                    bTimeZone = object.getTimeZone();
                    if (bTimeZone != null) {
                        string5 = bTimeZone.getId();
                    }
                    bFacets = (BFacets)object.get("valueFacets");
                    bUnit = (BUnit)bFacets.get("units", (BObject)bUnit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string5 == null) {
                    string5 = BTimeZone.getLocal().getId();
                }
                object = null;
                object = UnitDatabase.getDefault().getQuantity(bUnit) != null ? UnitDatabase.getDefault().getQuantity(bUnit).getName() : "";
                bTimeZone = object;
                String string6 = bUnit.getUnitName();
                int n4 = resultSet.getInt(5);
                if (resultSet.wasNull()) {
                    n4 = -1;
                }
                String string7 = resultSet.getString(6);
                double d = resultSet.getDouble(7);
                int n5 = resultSet.getInt(8);
                if (resultSet.wasNull()) {
                    n5 = -1;
                }
                int n6 = resultSet.getInt(9);
                boolean bl2 = resultSet.getInt(10) == 1;
                int n7 = bl ? resultSet.getInt(11) : 1;
                vector.addElement(DataPoint.get(n2, string2, string3, string4, n7, n3, n6, bl2, (String)bTimeZone, string6, (Site)Site.get(n4, this.session), n5, string7, d, string5, true));
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        catch (EasException easException) {
            System.out.println(string);
            easException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return vector;
    }

    public Vector getDataPoints(String string) {
        Vector<DataPoint> vector = new Vector<DataPoint>();
        if (string == null || string.length() == 0) {
            return vector;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            statement = connection.createStatement();
            string2 = "select p.ID, p.NAME, p.DESCR, p.RC_TYPE, p.GROUP_ID, p.FLOORAREA_VUNIT, p.FLOORAREA_VALUE, p.METER_ID, p.RC_SUBTYPE, p.MAIN, p.FLAGS from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " p where p.ID in (" + string + ")";
            boolean bl = true;
            try {
                resultSet = statement.executeQuery(string2);
            }
            catch (SQLException sQLException) {
                string2 = "select p.ID, p.NAME, p.DESCR, p.RC_TYPE, p.GROUP_ID, p.FLOORAREA_VUNIT, p.FLOORAREA_VALUE, p.METER_ID, p.RC_SUBTYPE, p.MAIN from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " p where p.ID in (" + string + ")";
                resultSet = statement.executeQuery(string2);
                bl = false;
            }
            while (resultSet.next()) {
                BTimeZone bTimeZone;
                Object object;
                String string3;
                int n = resultSet.getInt(1);
                String string4 = string3 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                int n2 = resultSet.getInt(4);
                BUnit bUnit = BUnit.NULL;
                BFacets bFacets = BFacets.NULL;
                String string6 = null;
                try {
                    object = this.easDb.getLog(string3).getConfig();
                    bTimeZone = object.getTimeZone();
                    if (bTimeZone != null) {
                        string6 = bTimeZone.getId();
                    }
                    bFacets = (BFacets)object.get("valueFacets");
                    bUnit = (BUnit)bFacets.get("units", (BObject)bUnit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string6 == null) {
                    string6 = BTimeZone.getLocal().getId();
                }
                object = null;
                object = UnitDatabase.getDefault().getQuantity(bUnit) != null ? UnitDatabase.getDefault().getQuantity(bUnit).getName() : "";
                bTimeZone = object;
                String string7 = bUnit.getUnitName();
                int n3 = resultSet.getInt(5);
                if (resultSet.wasNull()) {
                    n3 = -1;
                }
                String string8 = resultSet.getString(6);
                double d = resultSet.getDouble(7);
                int n4 = resultSet.getInt(8);
                if (resultSet.wasNull()) {
                    n4 = -1;
                }
                int n5 = resultSet.getInt(9);
                boolean bl2 = resultSet.getInt(10) == 1;
                int n6 = bl ? resultSet.getInt(11) : 1;
                vector.addElement(DataPoint.get(n, string3, string4, string5, n6, n2, n5, bl2, (String)bTimeZone, string7, (Site)Site.get(n3, this.session), n4, string8, d, string6, true));
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string2);
            sQLException.printStackTrace();
        }
        catch (EasException easException) {
            System.out.println(string2);
            easException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return vector;
    }

    public DataPoint load(int n) {
        if (n == -1) {
            return null;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        DataPoint dataPoint = null;
        try {
            statement = connection.createStatement();
            string = "select ID, NAME, DESCR, RC_TYPE, GROUP_ID, FLOORAREA_VUNIT, FLOORAREA_VALUE, METER_ID, RC_SUBTYPE, MAIN, FLAGS from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " where ID=" + n;
            boolean bl = true;
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (SQLException sQLException) {
                string = "select ID, NAME, DESCR, RC_TYPE, GROUP_ID, FLOORAREA_VUNIT, FLOORAREA_VALUE, METER_ID, RC_SUBTYPE, MAIN from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " where ID=" + n;
                resultSet = statement.executeQuery(string);
                bl = false;
            }
            while (resultSet.next()) {
                BTimeZone bTimeZone;
                Object object;
                String string2;
                n = resultSet.getInt(1);
                String string3 = string2 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                int n2 = resultSet.getInt(4);
                BUnit bUnit = BUnit.NULL;
                BFacets bFacets = BFacets.NULL;
                String string5 = null;
                try {
                    object = this.easDb.getLog(string2).getConfig();
                    bTimeZone = object.getTimeZone();
                    if (bTimeZone != null) {
                        string5 = bTimeZone.getId();
                    }
                    bFacets = (BFacets)object.get("valueFacets");
                    bUnit = (BUnit)bFacets.get("units", (BObject)bUnit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string5 == null) {
                    string5 = BTimeZone.getLocal().getId();
                }
                object = null;
                object = UnitDatabase.getDefault().getQuantity(bUnit) != null ? UnitDatabase.getDefault().getQuantity(bUnit).getName() : "";
                bTimeZone = object;
                String string6 = bUnit.getUnitName();
                int n3 = resultSet.getInt(5);
                if (resultSet.wasNull()) {
                    n3 = -1;
                }
                String string7 = resultSet.getString(6);
                double d = resultSet.getDouble(7);
                int n4 = resultSet.getInt(8);
                if (resultSet.wasNull()) {
                    n4 = -1;
                }
                int n5 = resultSet.getInt(9);
                boolean bl2 = resultSet.getInt(10) == 1;
                int n6 = bl ? resultSet.getInt(11) : 1;
                dataPoint = DataPoint.get(n, string2, string3, string4, n6, n2, n5, bl2, (String)bTimeZone, string6, (Site)Site.get(n3, this.session), n4, string7, d, string5, true);
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        catch (EasException easException) {
            System.out.println(string);
            easException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return dataPoint;
    }

    public Vector getMeterDPs(int n) {
        return this.getMeterDPs(n, null);
    }

    public Vector getMeterDPs(Meter meter) {
        return this.getMeterDPs(meter == null ? -1 : meter.getId(), meter);
    }

    private Vector getMeterDPs(int n, Meter meter) {
        Vector<DataPoint> vector = new Vector<DataPoint>();
        if (n == -1) {
            return vector;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            string = "select ID, NAME, DESCR, RC_TYPE, FLOORAREA_VUNIT, FLOORAREA_VALUE, GROUP_ID, RC_SUBTYPE, MAIN, FLAGS from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " where METER_ID=" + n;
            boolean bl = true;
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (SQLException sQLException) {
                string = "select ID, NAME, DESCR, RC_TYPE, FLOORAREA_VUNIT, FLOORAREA_VALUE, GROUP_ID, RC_SUBTYPE, MAIN from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " where METER_ID=" + n;
                resultSet = statement.executeQuery(string);
                bl = false;
            }
            while (resultSet.next()) {
                BTimeZone bTimeZone;
                Object object;
                String string2;
                int n2 = resultSet.getInt(1);
                String string3 = string2 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                int n3 = resultSet.getInt(4);
                BUnit bUnit = BUnit.NULL;
                BFacets bFacets = BFacets.NULL;
                String string5 = null;
                try {
                    object = this.easDb.getLog(string2).getConfig();
                    bTimeZone = object.getTimeZone();
                    if (bTimeZone != null) {
                        string5 = bTimeZone.getId();
                    }
                    bFacets = (BFacets)object.get("valueFacets");
                    bUnit = (BUnit)bFacets.get("units", (BObject)bUnit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string5 == null) {
                    string5 = BTimeZone.getLocal().getId();
                }
                object = null;
                object = UnitDatabase.getDefault().getQuantity(bUnit) != null ? UnitDatabase.getDefault().getQuantity(bUnit).getName() : "";
                bTimeZone = object;
                String string6 = bUnit.getUnitName();
                String string7 = resultSet.getString(5);
                double d = resultSet.getDouble(6);
                int n4 = resultSet.getInt(7);
                int n5 = resultSet.getInt(8);
                boolean bl2 = resultSet.getInt(9) == 1;
                int n6 = bl ? resultSet.getInt(10) : 1;
                DataPoint dataPoint = meter == null ? DataPoint.get(n2, string2, string3, string4, n6, n3, n5, bl2, (String)bTimeZone, string6, (Site)Site.get(n4, this.session), n, string7, d, string5, true) : DataPoint.get(n2, string2, string3, string4, n6, n3, n5, bl2, (String)bTimeZone, string6, (Site)Site.get(n4, this.session), meter, string7, d, string5, true);
                vector.addElement(dataPoint);
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        catch (EasException easException) {
            System.out.println(string);
            easException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return vector;
    }

    public Vector getDataPoints(int n) {
        return this.getDataPoints(n, null);
    }

    public Vector getDataPoints(Site site) {
        return this.getDataPoints(site == null ? -1 : site.getId(), site);
    }

    private Vector getDataPoints(int n, Site site) {
        Vector<DataPoint> vector = new Vector<DataPoint>();
        if (n == -1) {
            return vector;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            string = "select ID, NAME, DESCR, RC_TYPE, FLOORAREA_VUNIT, FLOORAREA_VALUE, METER_ID, RC_SUBTYPE, MAIN, FLAGS from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " where GROUP_ID=" + n;
            boolean bl = true;
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (SQLException sQLException) {
                string = "select ID, NAME, DESCR, RC_TYPE, FLOORAREA_VUNIT, FLOORAREA_VALUE, METER_ID, RC_SUBTYPE, MAIN from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " where GROUP_ID=" + n;
                resultSet = statement.executeQuery(string);
                bl = false;
            }
            while (resultSet.next()) {
                BTimeZone bTimeZone;
                Object object;
                String string2;
                int n2 = resultSet.getInt(1);
                String string3 = string2 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                int n3 = resultSet.getInt(4);
                BUnit bUnit = BUnit.NULL;
                BFacets bFacets = BFacets.NULL;
                String string5 = null;
                try {
                    object = this.easDb.getLog(string2).getConfig();
                    bTimeZone = object.getTimeZone();
                    if (bTimeZone != null) {
                        string5 = bTimeZone.getId();
                    }
                    bFacets = (BFacets)object.get("valueFacets");
                    bUnit = (BUnit)bFacets.get("units", (BObject)bUnit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string5 == null) {
                    string5 = BTimeZone.getLocal().getId();
                }
                object = null;
                object = UnitDatabase.getDefault().getQuantity(bUnit) != null ? UnitDatabase.getDefault().getQuantity(bUnit).getName() : "";
                bTimeZone = object;
                String string6 = bUnit.getUnitName();
                String string7 = resultSet.getString(5);
                double d = resultSet.getDouble(6);
                int n4 = resultSet.getInt(7);
                if (resultSet.wasNull()) {
                    n4 = -1;
                }
                int n5 = resultSet.getInt(8);
                boolean bl2 = resultSet.getInt(9) == 1;
                int n6 = bl ? resultSet.getInt(10) : 1;
                DataPoint dataPoint = site == null ? DataPoint.get(n2, string2, string3, string4, n6, n3, n5, bl2, (String)bTimeZone, string6, (Site)Site.get(n, this.session), n4, string7, d, string5, true) : DataPoint.get(n2, string2, string3, string4, n6, n3, n5, bl2, (String)bTimeZone, string6, site, n4, string7, d, string5, true);
                vector.addElement(dataPoint);
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        catch (EasException easException) {
            System.out.println(string);
            easException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        return vector;
    }

    public int addGroupLink(int n, int n2) {
        int n3 = -1;
        if (n == -1 || n2 == -1) {
            return n3;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            string = "insert into " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_DP_GROUP") + " (DP_ID, GROUP_ID) values (" + n + "," + n2 + ")";
            n3 = statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.easDb.freeConnection(connection);
        return n3;
    }

    public int remGroupLink(int n, int n2) {
        int n3 = -1;
        if (n == -1 || n2 == -1) {
            return n3;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = null;
        try {
            statement = connection.createStatement();
            string = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "STATIC_DP_GROUP") + " where DP_ID=" + n + " and GROUP_ID=" + n2;
            n3 = statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            System.out.println(string);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.easDb.freeConnection(connection);
        return n3;
    }

    public int erase(int n, String string) {
        int n2 = -1;
        if (n == -1) {
            return n2;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        try {
            statement = connection.createStatement();
            string2 = "delete from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " where ID=" + n;
            n2 = statement.executeUpdate(string2);
        }
        catch (SQLException sQLException) {
            System.out.println(string2);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.easDb.freeConnection(connection);
        return n2;
    }

    public boolean isMultistate(String string) {
        try {
            BIHistory bIHistory = this.easDb.getLog(string);
            if (bIHistory == null) {
                throw new EasException("Can't open log for '" + string + "'");
            }
            Type type = bIHistory.getRecordType().getResolvedType();
            return type.is(BBooleanTrendRecord.TYPE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public final int getAvailableLicensedDataPointCount() {
        int n = this.easDb.getLicensedDataPointCount();
        int n2 = this.easDb.getDataPointCount();
        return Math.max(n - n2, 0);
    }

    public int create(String string, String string2, String string3, int n, int n2, int n3, boolean bl, String string4, String string5, int n4, int n5, String string6, double d, String string7) {
        int n6 = -9;
        int n7 = -1;
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string8 = null;
        int n8 = 11;
        try {
            statement = connection.createStatement();
            int n9 = this.easDb.getLicensedDataPointCount();
            int n10 = this.easDb.getDataPointCount();
            if (this.easDb.getService().isEasStationLicensed(this.easDb.getLog(string)) || n10 < n9) {
                while (n6 != 0 && --n8 >= 0) {
                    n7 = this.easDb.getNewId();
                    string8 = "insert into " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " (ID,NAME,DESCR,RC_TYPE,GROUP_ID,STATION_ID,METER_ID,FLOORAREA_VUNIT,FLOORAREA_VALUE,RC_SUBTYPE,MAIN,FLAGS) values (" + n7 + "," + Dbx.str2db(string) + "," + Dbx.str2db(string3) + "," + n2 + ",";
                    string8 = n4 == -1 ? string8 + "null" : string8 + n4;
                    string8 = string8 + ",-1";
                    string8 = string8 + "," + n5 + "," + Dbx.str2db(string6) + "," + d + "," + n3 + "," + (bl ? 1 : 0);
                    string8 = string8 + "," + n;
                    string8 = string8 + ")";
                    n6 = statement.executeUpdate(string8) == 1 ? 0 : -4;
                }
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string8);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            if (n6 == 0) {
                connection.commit();
            } else {
                connection.rollback();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.easDb.freeConnection(connection);
        return n6 != 0 ? -1 : n7;
    }

    public int update(int n, String string, String string2, String string3, int n2, int n3, int n4, boolean bl, String string4, String string5, int n5, int n6, String string6, double d, String string7) {
        int n7 = -1;
        if (n == -1) {
            return n7;
        }
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        String string8 = null;
        try {
            statement = connection.createStatement();
            int n8 = this.easDb.getLicensedDataPointCount();
            int n9 = this.easDb.getDataPointCount();
            string8 = "update " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " set name=" + Dbx.str2db(string) + ",descr=" + Dbx.str2db(string3) + ",RC_TYPE=" + n3 + ",RC_SUBTYPE=" + n4 + ",MAIN=" + (bl ? 1 : 0) + ",group_id=" + n5 + ",meter_id=" + n6 + ",floorarea_vunit=" + Dbx.str2db(string6) + ",floorarea_value=" + d + ",FLAGS=" + n2 + " where ID=" + n;
            n7 = statement.executeUpdate(string8);
        }
        catch (SQLException sQLException) {
            System.out.println(string8);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.easDb.freeConnection(connection);
        return n7;
    }

    public DataSample[] getRawData(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, BUnit bUnit) throws EasException {
        BAbsTime bAbsTime = BAbsTime.make((long)easLocalTime.getTimestamp(bTimeZone), (BTimeZone)BTimeZone.getTimeZone((String)bTimeZone.getId()));
        BAbsTime bAbsTime2 = BAbsTime.make((long)easLocalTime2.getTimestamp(bTimeZone), (BTimeZone)BTimeZone.getTimeZone((String)bTimeZone.getId()));
        try {
            boolean bl;
            int n;
            BBooleanTrendRecord bBooleanTrendRecord;
            BNumericTrendRecord bNumericTrendRecord;
            Object object;
            BIHistory bIHistory = this.easDb.getLog(string);
            if (bIHistory == null) {
                throw new EasException("Can't open log for '" + string + "'");
            }
            Type type = bIHistory.getRecordType().getResolvedType();
            BCollectionInterval bCollectionInterval = bIHistory.getConfig().getInterval();
            BAbsTime bAbsTime3 = bAbsTime;
            BAbsTime bAbsTime4 = bAbsTime2;
            boolean bl2 = false;
            if (!bCollectionInterval.isIrregular()) {
                for (int i = 0; i < 4; ++i) {
                    bAbsTime3 = bAbsTime3.subtract(bCollectionInterval.getInterval());
                    bAbsTime4 = bAbsTime4.add(bCollectionInterval.getInterval());
                }
            } else if (!type.is(BNumericTrendRecord.TYPE)) {
                bl2 = true;
            }
            Cursor cursor = null;
            if (this.easDb.requiresDeltaQuery(bIHistory)) {
                object = new BHistoryDeltaQuery(bIHistory, bAbsTime3, bAbsTime4);
                cursor = object.cursor();
            } else {
                cursor = bIHistory.timeQuery(bAbsTime3, bAbsTime4).cursor();
            }
            object = new Vector();
            boolean bl3 = true;
            long l = 0L;
            boolean bl4 = true;
            if (type.is(BBooleanTrendRecord.TYPE)) {
                BFacets bFacets;
                bNumericTrendRecord = null;
                bBooleanTrendRecord = null;
                n = 0;
                bl = false;
                if (bl2) {
                    Object var24_30 = null;
                    try {
                        bFacets = cursor.getContext().getFacets();
                        Class clazz = Sys.loadClass((String)"history", (String)"javax.baja.history.HistoryCursor");
                        Method method = clazz.getMethod("extractPreRecord", class$javax$baja$sys$BFacets == null ? (class$javax$baja$sys$BFacets = DataPointExecSrv.class$("javax.baja.sys.BFacets")) : class$javax$baja$sys$BFacets);
                        bNumericTrendRecord = (BBooleanTrendRecord)method.invoke(null, bFacets);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                boolean bl5 = true;
                while (cursor.next()) {
                    bFacets = (BBooleanTrendRecord)cursor.get();
                    if (bl5 && bNumericTrendRecord != null && bFacets.getTimestamp().isAfter(bAbsTime3)) {
                        ((Vector)object).addElement(new DataSample(bAbsTime3.getMillis(), bNumericTrendRecord.getValue(), bNumericTrendRecord.getStatus().getBits()));
                    }
                    if (bFacets.getTimestamp().isBefore(bAbsTime)) {
                        bBooleanTrendRecord = (BBooleanTrendRecord)bFacets.newCopy(true);
                        if (!bl) {
                            n = 1;
                        }
                    } else if (!bFacets.getTimestamp().isAfter(bAbsTime2)) {
                        if (n != 0) {
                            ((Vector)object).addElement(new DataSample(bBooleanTrendRecord.getTimestamp().getMillis(), bBooleanTrendRecord.getValue(), bBooleanTrendRecord.getStatus().getBits()));
                            n = 0;
                            bl = true;
                        }
                        ((Vector)object).addElement(new DataSample(bFacets.getTimestamp().getMillis(), bFacets.getValue(), bFacets.getStatus().getBits()));
                    }
                    bl5 = false;
                }
                if (bl5 && bNumericTrendRecord != null) {
                    ((Vector)object).addElement(new DataSample(bAbsTime3.getMillis(), bNumericTrendRecord.getValue(), bNumericTrendRecord.getStatus().getBits()));
                }
            } else {
                bNumericTrendRecord = null;
                boolean bl6 = false;
                n = 0;
                bl = false;
                while (cursor.next()) {
                    BNumericTrendRecord bNumericTrendRecord2 = (BNumericTrendRecord)cursor.get();
                    if (bNumericTrendRecord2.getTimestamp().isBefore(bAbsTime)) {
                        bNumericTrendRecord = (BNumericTrendRecord)bNumericTrendRecord2.newCopy(true);
                        if (n != 0) continue;
                        bl6 = true;
                        continue;
                    }
                    if (!bNumericTrendRecord2.getTimestamp().isAfter(bAbsTime2)) {
                        if (bl6) {
                            ((Vector)object).addElement(new DataSample(bNumericTrendRecord.getTimestamp().getMillis(), bNumericTrendRecord.getValue(), bNumericTrendRecord.getStatus().getBits()));
                            bl6 = false;
                            n = 1;
                        }
                        ((Vector)object).addElement(new DataSample(bNumericTrendRecord2.getTimestamp().getMillis(), bNumericTrendRecord2.getValue(), bNumericTrendRecord2.getStatus().getBits()));
                        continue;
                    }
                    if (bl) continue;
                    ((Vector)object).addElement(new DataSample(bNumericTrendRecord2.getTimestamp().getMillis(), bNumericTrendRecord2.getValue(), bNumericTrendRecord2.getStatus().getBits()));
                }
            }
            int n2 = ((Vector)object).size();
            if (n2 < 1) {
                throw new LocalizableRuntimeException("eas", "noDataForTimeRange", (Object[])new String[]{this.getDataPointDescription(string)});
            }
            bBooleanTrendRecord = new DataSample[n2];
            for (n = 0; n < n2; ++n) {
                bBooleanTrendRecord[n] = (DataSample)((Vector)object).elementAt(n);
            }
            if (type.is(BBooleanTrendRecord.TYPE)) {
                if (bBooleanTrendRecord[0].getTime() < bAbsTime.getMillis()) {
                    bBooleanTrendRecord[0].setTime(bAbsTime.getMillis());
                }
            } else {
                double d;
                long l2;
                BBooleanTrendRecord bBooleanTrendRecord2 = bBooleanTrendRecord[0];
                BBooleanTrendRecord bBooleanTrendRecord3 = bBooleanTrendRecord[1];
                if (bBooleanTrendRecord2.getTime() < bAbsTime.getMillis()) {
                    long l3 = bBooleanTrendRecord2.getTime();
                    double d2 = bBooleanTrendRecord2.getDouble();
                    l2 = bBooleanTrendRecord3.getTime();
                    d = bBooleanTrendRecord3.getDouble();
                    bBooleanTrendRecord[0] = new DataSample(bAbsTime.getMillis(), d2 + (double)(bAbsTime.getMillis() - l3) * (d - d2) / (double)(l2 - l3), 0);
                }
                bBooleanTrendRecord2 = bBooleanTrendRecord[n2 - 2];
                bBooleanTrendRecord3 = bBooleanTrendRecord[n2 - 1];
                if (bBooleanTrendRecord3.getTime() > bAbsTime2.getMillis()) {
                    long l4 = bBooleanTrendRecord2.getTime();
                    double d3 = bBooleanTrendRecord2.getDouble();
                    l2 = bBooleanTrendRecord3.getTime();
                    d = bBooleanTrendRecord3.getDouble();
                    bBooleanTrendRecord[n2 - 1] = new DataSample(bAbsTime.getMillis(), d3 + (double)(l4 - bAbsTime2.getMillis()) * (d - d3) / (double)(l2 - l4), 0);
                }
            }
            return bBooleanTrendRecord;
        }
        catch (LocalizableRuntimeException localizableRuntimeException) {
            throw localizableRuntimeException;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            throw new EasException(exception.getMessage());
        }
    }

    public double getTotal(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone) throws EasException {
        double d = 0.0;
        BAbsTime bAbsTime = BAbsTime.make((long)easLocalTime.getTimestamp(bTimeZone), (BTimeZone)BTimeZone.getTimeZone((String)bTimeZone.getId()));
        BAbsTime bAbsTime2 = BAbsTime.make((long)easLocalTime2.getTimestamp(bTimeZone), (BTimeZone)BTimeZone.getTimeZone((String)bTimeZone.getId()));
        try {
            BHistoryDeltaQuery bHistoryDeltaQuery;
            BIHistory bIHistory = this.easDb.getLog(string);
            if (bIHistory == null) {
                throw new EasException("Can't open log for '" + string + "'");
            }
            BRelTime bRelTime = BRelTime.make((long)150000L);
            BAbsTime bAbsTime3 = bAbsTime.subtract(bRelTime);
            BAbsTime bAbsTime4 = bAbsTime2.add(bRelTime);
            Cursor cursor = null;
            if (this.easDb.requiresDeltaQuery(bIHistory)) {
                bHistoryDeltaQuery = new BHistoryDeltaQuery(bIHistory, bAbsTime3, bAbsTime4);
                cursor = bHistoryDeltaQuery.cursor();
            } else {
                cursor = bIHistory.timeQuery(bAbsTime3, bAbsTime4).cursor();
            }
            while (cursor.next()) {
                bHistoryDeltaQuery = (BNumericTrendRecord)cursor.get();
                long l = bHistoryDeltaQuery.getTimestamp().getMillis();
                l = (l + 150000L) / 300000L * 300000L;
                double d2 = bHistoryDeltaQuery.getValue();
                if (l <= bAbsTime2.getMillis()) {
                    if (l >= bAbsTime2.getMillis() || l < bAbsTime.getMillis() || !DataPointExecSrv.validStatus(bHistoryDeltaQuery.getStatus().getBits(), bHistoryDeltaQuery.getTrendFlags().getBits())) continue;
                    d += d2;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            throw new EasException(exception.getMessage());
        }
        return d;
    }

    public TSDataFloat getData(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, RestorationMethod restorationMethod, BUnit bUnit, TimeInterval timeInterval, boolean bl, int n, double d, boolean bl2, DataPoint dataPoint) throws EasException {
        Object object;
        DataArray dataArray = this.getDataArray(string, easLocalTime, easLocalTime2, bTimeZone, restorationMethod, timeInterval, bl, n, d);
        BUnit bUnit2 = bUnit;
        if (bl2 && dataPoint != null) {
            object = this.getDataArray(dataPoint.getName(), easLocalTime, easLocalTime2, bTimeZone, RestorationMethod.getByRcSubType(dataPoint.getRcSubTypeObj()), timeInterval, bl, n, d);
            dataArray = this.normalizeData(dataArray, (DataArray)object);
            bUnit2 = CompoundUnitUtil.make(bUnit, dataPoint.getUnit());
        }
        object = new TSDataFloat(easLocalTime, bTimeZone, timeInterval, bUnit2, dataArray.data, dataArray.stat);
        return object;
    }

    public TSDataSummary getAggregatedSummaryNorm(DPNormInfo[] dPNormInfoArray, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, RestorationMethod restorationMethod, RollupMethod rollupMethod, BUnit bUnit, boolean bl, BUnit bUnit2, boolean bl2, double d, BUnit bUnit3, int n, int n2, TimeInterval timeInterval, int n3, boolean bl3, int n4, double d2, boolean bl4, DataPoint dataPoint) throws EasException {
        Object object;
        DPNormInfo dPNormInfo;
        boolean bl5;
        TimeInterval timeInterval2 = dPNormInfoArray[0].dataSampling;
        boolean bl6 = true;
        boolean bl7 = true;
        boolean bl8 = bl5 = bUnit3 != null;
        if (!bl5) {
            return this.getAggregatedSummary(dPNormInfoArray, easLocalTime, easLocalTime2, restorationMethod, rollupMethod, n, n2, timeInterval, n3, bUnit, bl3, n4, d2, bl4, dataPoint);
        }
        int n5 = dPNormInfoArray.length;
        while (--n5 >= 0) {
            dPNormInfo = dPNormInfoArray[n5];
            if (Math.abs(dPNormInfo.normCoeff) < (double)1.0E-20f) {
                bl6 = false;
            } else if (Math.abs(1.0 - dPNormInfo.normCoeff) > (double)1.0E-20f) {
                bl7 = false;
            } else {
                dPNormInfo.normCoeff = 1.0;
            }
            if (bl5 && dPNormInfo.temperatureLog == null) {
                throw new EasException("weather normalization required but at least one of temperature log names is null");
            }
            if (timeInterval2.equals(dPNormInfo.dataSampling)) continue;
            throw new EasException("all data points must have the same sampling interval");
        }
        int n6 = n5 = !bl7 ? 1 : 0;
        if (n5 != 0 && !bl6) {
            throw new EasException("normalization required but at least one of coefficents is nearly zero");
        }
        Alg.sort(dPNormInfoArray);
        dPNormInfo = null;
        Object var29_27 = null;
        Object var30_28 = null;
        double[] dArray = null;
        BoolArray boolArray = null;
        for (int i = 0; i < dPNormInfoArray.length; ++i) {
            int n7;
            object = dPNormInfoArray[i];
            double d3 = ((DPNormInfo)object).temperatureUnit.fromNormal(bUnit3.toNormal(d));
            TSDataFloat tSDataFloat = this.getDataNormalized(((DPNormInfo)object).dataLog, easLocalTime, easLocalTime2, ((DPNormInfo)object).tz, restorationMethod, rollupMethod, n, n2, timeInterval2, ((DPNormInfo)object).normCoeff, bUnit2, ((DPNormInfo)object).dataUnit, bUnit, ((DPNormInfo)object).temperatureLog, bUnit3, d3, timeInterval2, bl3, n4, d2, bl4, dataPoint);
            if (dArray == null) {
                dArray = new double[tSDataFloat.getSize()];
                boolArray = new BoolArray(tSDataFloat.getSize());
                for (n7 = 0; n7 < dArray.length; ++n7) {
                    dArray[n7] = tSDataFloat.isValid(n7) ? tSDataFloat.getDouble(n7) : 0.0;
                    boolArray.set(tSDataFloat.isValid(n7), n7);
                }
                continue;
            }
            n7 = Math.min(dArray.length, tSDataFloat.getSize());
            for (int j = 0; j < n7; ++j) {
                int n8 = j;
                dArray[n8] = dArray[n8] + (tSDataFloat.isValid(j) ? tSDataFloat.getDouble(j) : 0.0);
                boolArray.set(tSDataFloat.isValid(j) || boolArray.get(j), j);
            }
        }
        if (bl4 && dataPoint != null) {
            bUnit = CompoundUnitUtil.make(bUnit, dataPoint.getUnit());
        }
        if (bl) {
            bUnit = CompoundUnitUtil.make(bUnit, bUnit2);
        }
        TSDataFloat tSDataFloat = new TSDataFloat(easLocalTime, dPNormInfoArray[0].tz, timeInterval2, bUnit, dArray, boolArray);
        object = null;
        if (n3 >= 1) {
            tSDataFloat = tSDataFloat.rollup(timeInterval, n, rollupMethod.getId(), 0, 0, 24, 0, false);
            object = tSDataFloat.rollup(timeInterval, n, 0, 0, 24, 0, false);
            object = ((TSDataSummary)object).applyCycle(n3);
        } else {
            object = tSDataFloat.rollup(timeInterval, n, 0, 0, 24, 0, false);
        }
        return object;
    }

    public TSDataSummary getAggregatedSummary(String[] stringArray, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone[] bTimeZoneArray, RestorationMethod restorationMethod, int n, int n2, TimeInterval timeInterval, int n3, double[] dArray, BUnit[] bUnitArray, BUnit bUnit, int n4, TimeInterval timeInterval2, boolean bl, int n5, double d, boolean bl2, DataPoint dataPoint) throws EasException {
        DPNormInfo[] dPNormInfoArray = new DPNormInfo[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dPNormInfoArray[i] = new DPNormInfo(stringArray[i], bTimeZoneArray[i], dArray[i], bUnitArray[i], timeInterval2, null, null, null);
        }
        return this.getAggregatedSummary(dPNormInfoArray, easLocalTime, easLocalTime2, restorationMethod, new RollupMethod(n4), n, n2, timeInterval, n3, bUnit, bl, n5, d, bl2, dataPoint);
    }

    private TSDataSummary getAggregatedSummary(DPNormInfo[] dPNormInfoArray, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, RestorationMethod restorationMethod, RollupMethod rollupMethod, int n, int n2, TimeInterval timeInterval, int n3, BUnit bUnit, boolean bl, int n4, double d, boolean bl2, DataPoint dataPoint) throws EasException {
        Object object;
        int n5;
        Object object2;
        int n6;
        TimeInterval timeInterval2 = dPNormInfoArray[0].dataSampling;
        boolean bl3 = true;
        boolean bl4 = true;
        for (n6 = 0; n6 < dPNormInfoArray.length; ++n6) {
            object2 = dPNormInfoArray[n6];
            if (Math.abs(((DPNormInfo)object2).normCoeff) < (double)1.0E-20f) {
                bl3 = false;
                continue;
            }
            if (Math.abs(1.0 - ((DPNormInfo)object2).normCoeff) > (double)1.0E-20f) {
                bl4 = false;
                continue;
            }
            ((DPNormInfo)object2).normCoeff = 1.0;
        }
        int n7 = n6 = !bl4 ? 1 : 0;
        if (n6 != 0 && !bl3) {
            throw new EasException("normalization required but at least one of coefficents is nearly zero");
        }
        object2 = null;
        BoolArray boolArray = null;
        double d2 = 0.0;
        for (n5 = 0; n5 < dPNormInfoArray.length; ++n5) {
            int n8;
            boolean bl5;
            Object object3;
            object = dPNormInfoArray[n5];
            DataArray dataArray = this.getDataArray(((DPNormInfo)object).dataLog, easLocalTime, easLocalTime2, ((DPNormInfo)object).tz, restorationMethod, timeInterval2, bl, n4, d);
            if (bl2 && dataPoint != null) {
                object3 = this.getDataArray(dataPoint.getName(), easLocalTime, easLocalTime2, ((DPNormInfo)object).tz, RestorationMethod.getByRcSubType(dataPoint.getRcSubTypeObj()), timeInterval2, bl, n4, d);
                dataArray = this.normalizeData(dataArray, (DataArray)object3);
            }
            if ((object3 = dataArray.data) == null) continue;
            boolean bl6 = n6 != 0 && ((DPNormInfo)object).normCoeff != 1.0;
            d2 += ((DPNormInfo)object).normCoeff;
            boolean bl7 = bl5 = ((DPNormInfo)object).dataUnit != null && bUnit != null && !((DPNormInfo)object).dataUnit.equals((Object)bUnit);
            if (object2 == null) {
                object2 = dataArray.data;
                boolArray = dataArray.stat;
                for (n8 = 0; n8 < ((Object)object2).length; ++n8) {
                    if (!boolArray.get(n8)) {
                        object2[n8] = 0.0;
                        continue;
                    }
                    if (!bl5) continue;
                    object2[n8] = bUnit.fromNormal(((DPNormInfo)object).dataUnit.toNormal((double)object2[n8]));
                }
                continue;
            }
            boolArray.or(dataArray.stat);
            for (n8 = 0; n8 < ((Object)object2).length; ++n8) {
                if (!dataArray.stat.get(n8)) continue;
                double d3 = object3[n8];
                if (bl5) {
                    d3 = bUnit.fromNormal(((DPNormInfo)object).dataUnit.toNormal(d3));
                }
                Object object4 = object2;
                int n9 = n8;
                object4[n9] = object4[n9] + d3;
            }
        }
        if (n6 != 0 && d2 != 0.0 && d2 != 1.0) {
            n5 = 0;
            while (n5 < ((DPNormInfo)object2).length) {
                DPNormInfo dPNormInfo = object2;
                int n10 = n5++;
                dPNormInfo[n10] = dPNormInfo[n10] / d2;
            }
        }
        if (bl2 && dataPoint != null) {
            bUnit = CompoundUnitUtil.make(bUnit, dataPoint.getUnit());
        }
        TSDataFloat tSDataFloat = new TSDataFloat(easLocalTime, dPNormInfoArray[0].tz, timeInterval2, bUnit, (double[])object2, boolArray);
        object = null;
        if (n3 >= 1) {
            tSDataFloat = tSDataFloat.rollup(timeInterval, n, rollupMethod.getId(), 0, 0, 24, 0, false);
            object = tSDataFloat.rollup(timeInterval, n, 0, 0, 24, 0, false);
            object = ((TSDataSummary)object).applyCycle(n3);
        } else {
            object = tSDataFloat.rollup(timeInterval, n, 0, 0, 24, 0, false);
        }
        return object;
    }

    public TSDataSummary getDataSummary(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, RestorationMethod restorationMethod, int n, int n2, BUnit bUnit, BUnit bUnit2, TimeInterval timeInterval, int n3, double d, BUnit bUnit3, String string2, BUnit bUnit4, double d2, TimeInterval timeInterval2, boolean bl, int n4, double d3, boolean bl2, DataPoint dataPoint) throws EasException {
        TSDataFloat tSDataFloat = this.getDataNormalized(string, easLocalTime, easLocalTime2, bTimeZone, restorationMethod, restorationMethod.getRollupMethod(), n, n2, timeInterval2, d, bUnit3, bUnit, bUnit2, string2, bUnit4, d2, timeInterval2, bl, n4, d3, bl2, dataPoint);
        TSDataSummary tSDataSummary = tSDataFloat.rollup(timeInterval, n, 0, 0, 24, 0, false);
        if (n3 >= 1) {
            tSDataSummary = tSDataSummary.applyCycle(n3);
        }
        return tSDataSummary;
    }

    private TSDataFloat getDataNormalized(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, RestorationMethod restorationMethod, RollupMethod rollupMethod, int n, int n2, TimeInterval timeInterval, double d, BUnit bUnit, BUnit bUnit2, BUnit bUnit3, String string2, BUnit bUnit4, double d2, TimeInterval timeInterval2, boolean bl, int n3, double d3, boolean bl2, DataPoint dataPoint) throws EasException {
        Object object;
        boolean bl3;
        boolean bl4 = false;
        if (Math.abs(d) < (double)1.0E-20f) {
            throw new EasException("normalization required but at least one of coefficents is nearly zero");
        }
        if (Math.abs(1.0 - d) > (double)1.0E-20f) {
            bl4 = true;
        } else {
            d = 1.0;
        }
        DataArray dataArray = this.getDataArray(string, easLocalTime, easLocalTime2, bTimeZone, restorationMethod, timeInterval2, bl, n3, d3);
        if (bl2 && dataPoint != null) {
            DataArray dataArray2 = this.getDataArray(dataPoint.getName(), easLocalTime, easLocalTime2, bTimeZone, RestorationMethod.getByRcSubType(dataPoint.getRcSubTypeObj()), timeInterval2, bl, n3, d3);
            dataArray = this.normalizeData(dataArray, dataArray2);
        }
        boolean bl5 = bl3 = bUnit2 != null && bUnit3 != null && !bUnit2.equals((Object)bUnit3);
        if (bl4 || bl3) {
            object = dataArray.data;
            for (int i = 0; i < ((double[])object).length; ++i) {
                double d4 = object[i];
                if (bl3) {
                    d4 = bUnit3.fromNormal(bUnit2.toNormal(d4));
                }
                if (bl4) {
                    d4 /= d;
                }
                object[i] = d4;
            }
        }
        if (bl2 && dataPoint != null) {
            bUnit3 = CompoundUnitUtil.make(bUnit3, dataPoint.getUnit());
        }
        if (bl4) {
            bUnit3 = CompoundUnitUtil.make(bUnit3, bUnit);
        }
        object = new SimpleFloatPopulation(bUnit3, dataArray.data);
        SimpleBooleanPopulation simpleBooleanPopulation = new SimpleBooleanPopulation(dataArray.stat);
        if (string2 != null) {
            int n4;
            TSDataFloat tSDataFloat = this.getData(string2, easLocalTime, easLocalTime2, bTimeZone, RestorationMethod.AVG, bUnit4, timeInterval2, bl, n3, d3, false, null);
            tSDataFloat = tSDataFloat.rollup(this.aDay, n, 0, 0, 0, 24, 0, false);
            BoolArray boolArray = tSDataFloat.getStatusPopulation().getBoolArray();
            TSDataFloat tSDataFloat2 = new TSDataFloat(easLocalTime, bTimeZone, timeInterval2, (Population)object, simpleBooleanPopulation);
            tSDataFloat2 = tSDataFloat2.rollup(this.aDay, n, rollupMethod.getId(), 0, 0, 24, 0, false);
            boolArray.and(tSDataFloat2.getStatusPopulation().getBoolArray());
            BoolArray boolArray2 = new BoolArray(boolArray);
            BoolArray boolArray3 = new BoolArray(boolArray);
            for (n4 = 0; n4 < tSDataFloat.getSize(); ++n4) {
                if (tSDataFloat.getDouble(n4) <= d2) {
                    boolArray2.setf(n4);
                }
                if (!(tSDataFloat.getDouble(n4) >= d2)) continue;
                boolArray3.setf(n4);
            }
            n4 = boolArray2.trueCount();
            int n5 = boolArray3.trueCount();
            double d5 = 0.0;
            double d6 = 0.0;
            Population population = tSDataFloat2.getDataPopulation();
            Population population2 = tSDataFloat.getDataPopulation();
            Population population3 = new TSDataFloat(tSDataFloat.getTimeParameters(), population2, new SimpleBooleanPopulation(boolArray2)).getPopulation();
            Object object2 = new StatXY(population3, population);
            d5 = ((StatXY)object2).getScalar(14);
            double d7 = ((StatXY)object2).getScalar(6, 0);
            double d8 = ((StatXY)object2).getScalar(6, 1);
            int n6 = n4 - 2;
            double d9 = ((StatXY)object2).getScalar(1);
            double d10 = ((StatXY)object2).getScalar(0);
            double d11 = d5 * (d2 - d7);
            double d12 = (d5 + d5 / d9 * Alg.getStudentT(0.1, n6)) * (d2 - d7);
            double d13 = (d5 + d5 / d9 * Alg.getStudentT(0.05, n6)) * (d2 - d7);
            double d14 = (d5 + d5 / d9 * Alg.getStudentT(0.02, n6)) * (d2 - d7);
            double d15 = Math.abs(d12 - d11);
            double d16 = Math.abs(d13 - d11);
            double d17 = Math.abs(d14 - d11);
            if (n4 > 0 && BEasService.log.isTraceOn()) {
                BEasService.log.trace("Cooling n=" + n4 + " 1-A(t|v)=" + 100.0 * (1.0 - Alg.getStudentP(d9, n4 - 2)) + "%\n r=" + d10 + "\n t=" + d9 + "\n slope=" + d5 + "\n T(5%," + (n4 - 2) + ")=" + Alg.getStudentT(0.05, n6) + "\n slope(95%)=(" + (d5 - d5 / d9 * Alg.getStudentT(0.05, n6)) + " ... " + (d5 + d5 / d9 * Alg.getStudentT(0.05, n6)) + ")" + "\n avg. X offset=" + (d2 - d7) + "\n avg. Y offset=" + d11 + "\n Normalized consumption conf.interval(90%)=+-" + d15 + "(+-" + (int)Math.abs(100.0 * (d15 / (d8 + d11))) + "%)" + "\n Normalized consumption conf.interval(95%)=+-" + d16 + "(+-" + (int)Math.abs(100.0 * (d16 / (d8 + d11))) + "%)" + "\n Normalized consumption conf.interval(98%)=+-" + d17 + "(+-" + (int)Math.abs(100.0 * (d17 / (d8 + d11))) + "%)" + "\n Fit error: 90% interval=+-" + 1.65 * ((StatXY)object2).getScalar(4) + " (+-" + (int)(165.0 * ((StatXY)object2).getScalar(4) / d8) + "%)" + "\n Fit error: 95% interval=+-" + 2.0 * ((StatXY)object2).getScalar(4) + " (+-" + (int)(200.0 * ((StatXY)object2).getScalar(4) / d8) + "%)");
            }
            object2 = new TSDataFloat(tSDataFloat.getTimeParameters(), population2, new SimpleBooleanPopulation(boolArray3)).getPopulation();
            Object object3 = new StatXY((Population)object2, population);
            d6 = ((StatXY)object3).getScalar(14);
            double d18 = ((StatXY)object3).getScalar(0);
            double d19 = ((StatXY)object3).getScalar(1);
            if (n5 > 0 && BEasService.log.isTraceOn()) {
                BEasService.log.trace("Heating count=" + n5 + ", slope=" + d6 + " 1-A(t|v)=" + (1.0 - Alg.getStudentP(d19, n5 - 2)) + " r=" + d18 + " t=" + d19);
            }
            if (timeInterval.shorter(this.aDay)) {
                object3 = new TSDataFloat(tSDataFloat.getTimeParameters(), (Population)object, simpleBooleanPopulation);
                if (!timeInterval.equals(timeInterval2)) {
                    object3 = ((TSDataFloat)object3).rollup(timeInterval, n, rollupMethod.getId(), 0, 0, 24, 0, false);
                }
                int n7 = ((TSDataFloat)object3).getSize();
                double[] dArray = new double[n7];
                BoolArray boolArray4 = ((TSDataFloat)object3).getStatusPopulation().getBoolArray();
                n6 = (int)(this.aDay.getMilliseconds() / timeInterval.getMilliseconds());
                int n8 = n7 / n6;
                d5 /= (double)n6;
                d6 /= (double)n6;
                int n9 = 0;
                for (int i = 0; i < n8; ++i) {
                    double d20 = 0.0;
                    boolean bl6 = true;
                    if (!Double.isNaN(d5) && population3.isValid(i)) {
                        d20 = d5 * (d2 - population3.getSample(i));
                    } else if (!Double.isNaN(d6) && object2.isValid(i)) {
                        d20 = d6 * (d2 - object2.getSample(i));
                    } else {
                        bl6 = false;
                    }
                    for (int j = 0; j < n6; ++j) {
                        dArray[n9] = ((TSDataFloat)object3).getDouble(n9);
                        if (((TSDataFloat)object3).isValid(n9)) {
                            if (bl6) {
                                dArray[n9] = ((TSDataFloat)object3).getDouble(n9) + d20;
                            } else {
                                boolArray4.setf(n9);
                            }
                        }
                        ++n9;
                    }
                }
                return new TSDataFloat(easLocalTime, bTimeZone, timeInterval, bUnit3, dArray, boolArray4);
            }
            int n10 = population.getSize();
            double[] dArray = new double[n10];
            BoolArray boolArray5 = new BoolArray(n10, true);
            for (int i = 0; i < n10; ++i) {
                if (population3 != null && !Double.isNaN(d5) && population3.isValid(i)) {
                    dArray[i] = population.getSample(i) + d5 * (d2 - population3.getSample(i));
                    continue;
                }
                if (object2 != null && !Double.isNaN(d6) && object2.isValid(i)) {
                    dArray[i] = population.getSample(i) + d6 * (d2 - object2.getSample(i));
                    continue;
                }
                boolArray5.setf(i);
            }
            TSDataFloat tSDataFloat3 = new TSDataFloat(tSDataFloat.getTimeParameters(), bUnit3, dArray, boolArray5);
            if (timeInterval.equals(this.aDay)) {
                return tSDataFloat3;
            }
            return tSDataFloat3.rollup(timeInterval, n, rollupMethod.getId(), 0, 0, 24, 0, false);
        }
        TSDataFloat tSDataFloat = new TSDataFloat(easLocalTime, bTimeZone, timeInterval2, (Population)object, simpleBooleanPopulation);
        if (!timeInterval.equals(timeInterval2)) {
            tSDataFloat = tSDataFloat.rollup(timeInterval, n, rollupMethod.getId(), 0, 0, 24, 0, false);
        }
        return tSDataFloat;
    }

    public ExceptionSummaryData getExceptionSummaryData(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, TimeInterval timeInterval, BUnit bUnit, boolean bl2, String string2, int n7, EasLocalTime easLocalTime3, int n8, int n9, double d, double d2, int n10, int n11, RestorationMethod restorationMethod, TimeInterval timeInterval2, boolean bl3, int n12, double d3, boolean bl4, DataPoint dataPoint) throws EasException {
        Object object;
        ExceptionSummary.ExceptionSummaryLimitType exceptionSummaryLimitType = new ExceptionSummary.ExceptionSummaryLimitType(n9);
        long l = timeInterval.getNUnits();
        int n13 = timeInterval.getUnit();
        long l2 = timeInterval2.getNUnits();
        int n14 = timeInterval2.getUnit();
        long l3 = timeInterval.getMilliseconds();
        if (l3 % timeInterval2.getMilliseconds() != 0L) {
            throw new EasException("granularity_millis % sampling.getMilliseconds()) != 0");
        }
        long l4 = easLocalTime3.getTimestamp(bTimeZone);
        long l5 = l4 + (long)n8 * l3;
        if (l4 <= 0L || l5 <= 0L) {
            throw new EasException("baseline_start_time <= 0L || baseline_end_time <= 0L");
        }
        EasLocalTime easLocalTime4 = new EasLocalTime(l5, bTimeZone);
        TSDataFloat tSDataFloat = this.getData(string, easLocalTime, easLocalTime2, bTimeZone, restorationMethod, bUnit, timeInterval2, bl3, n12, d3, bl4, dataPoint);
        if (!timeInterval2.equals(timeInterval)) {
            tSDataFloat = tSDataFloat.rollup(timeInterval, n, n7, n3, n4, n5, n6, bl);
        }
        tSDataFloat.setDaysOfWeek(n);
        tSDataFloat.setTimeOfDay(n3, n4, n5, n6, bl);
        int n15 = tSDataFloat.getSize();
        TSDataFloat tSDataFloat2 = this.getNormBase(string, easLocalTime, easLocalTime2, bTimeZone, n, n3, n4, n5, n6, bl, timeInterval, bUnit, bl2, string2, n7, easLocalTime3, easLocalTime4, restorationMethod, timeInterval2, bl3, n12, d3, bl4, dataPoint);
        tSDataFloat2.setDaysOfWeek(n);
        tSDataFloat2.setTimeOfDay(n3, n4, n5, n6, bl);
        n8 = tSDataFloat2.getSize();
        boolean bl5 = n8 != n15;
        double d4 = 0.0;
        double d5 = 0.0;
        if (exceptionSummaryLimitType.hasSPCLimits()) {
            object = new RepeatingPopulation(tSDataFloat2.getPopulation(), n15);
            Population population = VectorBinaryOperation.getPopulation(tSDataFloat.getPopulation(), (Population)object, ScalarDiffBinaryOperation.OP);
            SPCLimitsFunction sPCLimitsFunction = new SPCLimitsFunction(population);
            if (exceptionSummaryLimitType.hasUpperLimits()) {
                d5 = d = sPCLimitsFunction.getUpperLimit();
            }
            if (exceptionSummaryLimitType.hasLowerLimits()) {
                d4 = d2 = sPCLimitsFunction.getLowerLimit();
            }
        }
        object = new int[n10];
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n19 = 0;
        for (int i = 0; i < n15; ++i) {
            int n20 = i;
            if (bl5) {
                n20 %= n8;
            }
            double d9 = tSDataFloat2.getDouble(n20);
            double d10 = tSDataFloat.getDouble(i);
            if (!tSDataFloat.isValid(i) || !tSDataFloat.isDayIncluded(i) || !tSDataFloat.isTimeOfDayIncluded(i) || !exceptionSummaryLimitType.hasFixedLimits() && (!tSDataFloat2.isValid(n20) || !tSDataFloat2.isDayIncluded(n20) || !tSDataFloat2.isTimeOfDayIncluded(n20))) continue;
            double d11 = d10;
            double d12 = d10;
            double d13 = d10 - d9;
            d6 += d10;
            if (!exceptionSummaryLimitType.hasFixedLimits()) {
                d7 += d13;
                if (d13 > 0.0) {
                    d8 += d13;
                }
            }
            ++n19;
            if (exceptionSummaryLimitType.hasLowerLimitRatio()) {
                d12 = d13 / d9;
            } else if (exceptionSummaryLimitType.hasLowerLimitSPC()) {
                d12 = d13;
            }
            if (exceptionSummaryLimitType.hasUpperLimitRatio()) {
                d11 = d13 / d9;
            } else if (exceptionSummaryLimitType.hasUpperLimitSPC()) {
                d11 = d13;
            }
            if (exceptionSummaryLimitType.hasUpperLimits() && d11 > d) {
                if (exceptionSummaryLimitType.hasFixedLimits()) {
                    d13 = d11 - d;
                    d7 += d13;
                    d8 += d13;
                }
                object[n16++] = i;
                ++n17;
                if (n16 >= n10) break;
            }
            if (!exceptionSummaryLimitType.hasLowerLimits() || !(d12 < d2)) continue;
            if (exceptionSummaryLimitType.hasFixedLimits()) {
                d7 += d12 - d2;
            }
            object[n16++] = i;
            ++n18;
            if (n16 >= n10) break;
        }
        return new ExceptionSummaryData(n17, n18, (int[])object, n19, d6, d7, d8, d5, d4);
    }

    public TSDataFloat getExceptionSeries(String string, boolean bl, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, int n, int n2, int n3, int n4, int n5, int n6, boolean bl2, TimeInterval timeInterval, BUnit bUnit, boolean bl3, String string2, int n7, EasLocalTime easLocalTime3, int n8, RestorationMethod restorationMethod, TimeInterval timeInterval2, boolean bl4, int n9, double d, boolean bl5, DataPoint dataPoint) throws EasException {
        long l = timeInterval.getMilliseconds();
        TSDataFloat tSDataFloat = null;
        if (bl) {
            int n10 = timeInterval.longer(new TimeInterval(1L, 5)) ? n : -1;
            tSDataFloat = this.getData(string, easLocalTime, easLocalTime2, bTimeZone, restorationMethod, bUnit, timeInterval2, bl4, n9, d, bl5, dataPoint);
            if (!timeInterval.equals(timeInterval2)) {
                tSDataFloat = tSDataFloat.rollup(timeInterval, n10, n7, n3, n4, n5, n6, bl2);
            }
            if (n != -1) {
                tSDataFloat.setDaysOfWeek(n);
                tSDataFloat.setTimeOfDay(n3, n4, n5, n6, bl2);
                int n11 = tSDataFloat.getSize();
                BoolArray boolArray = new BoolArray(n11);
                boolArray.setAll(true);
                for (int i = 0; i < n11; ++i) {
                    if (tSDataFloat.isDayIncluded(i) && tSDataFloat.isTimeOfDayIncluded(i) && tSDataFloat.isValid(i)) continue;
                    boolArray.setf(i);
                }
                return new TSDataFloat(tSDataFloat.getTimeParameters(), tSDataFloat.getDataPopulation(), new SimpleBooleanPopulation(boolArray));
            }
        } else {
            long l2 = easLocalTime3.getTimestamp(bTimeZone);
            long l3 = l2 + (long)n8 * l;
            EasLocalTime easLocalTime4 = new EasLocalTime(l3, bTimeZone);
            tSDataFloat = this.getNormBase(string, easLocalTime, easLocalTime2, bTimeZone, n, n3, n4, n5, n6, bl2, timeInterval, bUnit, bl3, string2, n7, easLocalTime3, easLocalTime4, restorationMethod, timeInterval2, bl4, n9, d, bl5, dataPoint);
        }
        return tSDataFloat;
    }

    private TSDataFloat getNormBase(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, int n, int n2, int n3, int n4, int n5, boolean bl, TimeInterval timeInterval, BUnit bUnit, boolean bl2, String string2, int n6, EasLocalTime easLocalTime3, EasLocalTime easLocalTime4, RestorationMethod restorationMethod, TimeInterval timeInterval2, boolean bl3, int n7, double d, boolean bl4, DataPoint dataPoint) throws EasException {
        Object object;
        TSDataFloat tSDataFloat = this.getData(string, easLocalTime3, easLocalTime4, bTimeZone, restorationMethod, bUnit, timeInterval2, bl3, n7, d, bl4, dataPoint);
        if (!timeInterval.equals(timeInterval2)) {
            tSDataFloat = tSDataFloat.rollup(timeInterval, -1, n6, n2, n3, n4, n5, bl);
            tSDataFloat.setDaysOfWeek(n);
            tSDataFloat.setTimeOfDay(n2, n3, n4, n5, bl);
            object = tSDataFloat.getStatusPopulation().getBoolArray();
            for (int i = 0; i < tSDataFloat.getSize(); ++i) {
                if (tSDataFloat.isDayIncluded(i) && tSDataFloat.isTimeOfDayIncluded(i)) continue;
                ((BoolArray)object).setf(i);
            }
            tSDataFloat = new TSDataFloat(tSDataFloat.getTimeParameters(), tSDataFloat.getDataPopulation(), new CompactBooleanPopulation((BoolArray)object));
        }
        if (bl2) {
            int n8;
            object = this.getData(string2, easLocalTime3, easLocalTime4, bTimeZone, RestorationMethod.AVG, bUnit, timeInterval2, bl3, n7, d, false, null);
            TSDataFloat tSDataFloat2 = this.getData(string2, easLocalTime, easLocalTime2, bTimeZone, RestorationMethod.AVG, bUnit, timeInterval2, bl3, n7, d, false, null);
            int n9 = n;
            object = ((TSDataFloat)object).rollup(timeInterval, n9, 4, n2, n3, n4, n5, bl);
            tSDataFloat2 = tSDataFloat2.rollup(timeInterval, n9, 4, n2, n3, n4, n5, bl);
            ((TSDataRegular)object).setDaysOfWeek(n);
            ((TSDataRegular)object).setTimeOfDay(n2, n3, n4, n5, bl);
            int n10 = tSDataFloat2.getSize();
            int n11 = ((TSDataFloat)object).getSize();
            double d2 = 65.0;
            BoolArray boolArray = ((TSDataFloat)object).getStatusPopulation().getBoolArray();
            boolArray.and(tSDataFloat.getStatusPopulation().getBoolArray());
            BoolArray boolArray2 = new BoolArray(boolArray);
            BoolArray boolArray3 = new BoolArray(boolArray);
            for (n8 = 0; n8 < n11; ++n8) {
                if (((TSDataFloat)object).getDouble(n8) <= d2) {
                    boolArray2.setf(n8);
                }
                if (!(((TSDataFloat)object).getDouble(n8) >= d2)) continue;
                boolArray3.setf(n8);
            }
            n8 = boolArray2.trueCount();
            int n12 = boolArray3.trueCount();
            Population population = tSDataFloat.getDataPopulation();
            Population population2 = ((TSDataFloat)object).getDataPopulation();
            Population population3 = new TSDataFloat(((TSDataRegular)object).getTimeParameters(), population2, new SimpleBooleanPopulation(boolArray2)).getPopulation();
            StatXY statXY = new StatXY(population3, population);
            double d3 = statXY.getScalar(14);
            Population population4 = new TSDataFloat(((TSDataRegular)object).getTimeParameters(), population2, new SimpleBooleanPopulation(boolArray3)).getPopulation();
            StatXY statXY2 = new StatXY(population4, population);
            double d4 = statXY2.getScalar(14);
            double[] dArray = new double[n10];
            BoolArray boolArray4 = new BoolArray(tSDataFloat2.getStatusPopulation().getBoolArray());
            for (int i = 0; i < n10; ++i) {
                int n13 = i % n11;
                dArray[i] = tSDataFloat.getDouble(n13);
                if (!tSDataFloat2.isValid(i)) continue;
                if (!Double.isNaN(d3) && population3.isValid(n13)) {
                    int n14 = i;
                    dArray[n14] = dArray[n14] + d3 * (tSDataFloat2.getDouble(i) - ((TSDataFloat)object).getDouble(n13));
                    continue;
                }
                if (!Double.isNaN(d4) && population4.isValid(n13)) {
                    int n15 = i;
                    dArray[n15] = dArray[n15] + d4 * (tSDataFloat2.getDouble(i) - ((TSDataFloat)object).getDouble(n13));
                    continue;
                }
                boolArray4.setf(i);
            }
            return new TSDataFloat(easLocalTime3, bTimeZone, timeInterval, bUnit, dArray, boolArray4);
        }
        return tSDataFloat;
    }

    public SiteSummary[] getRankedSummaries(String string, int n, int n2, boolean bl, int n3, String string2, int[] nArray, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n4, int n5, boolean bl2, double d, BUnit bUnit, TimeInterval timeInterval, boolean bl3, int n6, double d2, boolean[] blArray, DataPoint[] dataPointArray) throws EasException {
        long l = timeInterval.getNUnits();
        int n7 = timeInterval.getUnit();
        RestorationMethod restorationMethod = new RestorationMethod(RcSubtype.getByCode(n2));
        SiteSummary siteSummary = null;
        SiteSummary[] siteSummaryArray = new SiteSummary[n3 + 1];
        int n8 = 0;
        Connection connection = this.easDb.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl4 = false;
        int n9 = 0;
        String string3 = null;
        BUnit bUnit2 = null;
        double d3 = d;
        if (string2 != null) {
            bl4 = true;
            n9 = string2.equals("floorarea") ? 2 : 1;
        }
        BUnit bUnit3 = null;
        BUnit bUnit4 = null;
        double d4 = 1.0;
        String string4 = "select distinct DP.ID, DP.NAME, G.ID ";
        String string5 = " from " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUPS") + " G, " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " DP";
        String string6 = " where DP.GROUP_ID=G.ID and DP.RC_TYPE=" + n + " and DP.RC_SUBTYPE=" + n2 + " and DP.MAIN=" + (bl ? 1 : 0);
        int n10 = 7;
        if (n9 == 1) {
            string4 = string4 + ", P.NVALUE, P.VUNIT ";
            n10 += 3;
            string5 = string5 + ", " + this.easDb.getDBSpecific().getFullTableName("EAS", "GROUP_PROP") + " P ";
            string6 = string6 + " and P.GROUP_ID=ST.GROUP_ID and P.NAME=" + Dbx.str2db(string2) + " ";
        } else if (n9 == 2) {
            string4 = string4 + ", DP.FLOORAREA_VALUE, DP.FLOORAREA_VUNIT ";
            n10 += 2;
        }
        if (string != null && string.length() > 0) {
            string6 = string6 + " and G.ID in (" + string + ")";
        }
        String string7 = string4 + string5 + string6;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string7);
            Object object = null;
            String string8 = null;
            while (resultSet.next()) {
                TSDataSummary tSDataSummary;
                Object object2;
                BTimeZone bTimeZone;
                Object object3;
                int n11 = resultSet.getInt(1);
                string8 = resultSet.getString(2);
                BUnit bUnit5 = BUnit.NULL;
                BFacets bFacets = BFacets.NULL;
                String string9 = null;
                try {
                    object3 = this.easDb.getLog(string8).getConfig();
                    bTimeZone = object3.getTimeZone();
                    if (bTimeZone != null) {
                        string9 = bTimeZone.getId();
                    }
                    bFacets = (BFacets)object3.get("valueFacets");
                    bUnit5 = (BUnit)bFacets.get("units", (BObject)bUnit5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string9 == null) {
                    string9 = BTimeZone.getLocal().getId();
                }
                object3 = null;
                object3 = UnitDatabase.getDefault().getQuantity(bUnit5) != null ? UnitDatabase.getDefault().getQuantity(bUnit5).getName() : "";
                bTimeZone = object3;
                String string10 = bUnit5.getUnitName();
                int n12 = resultSet.getInt(3);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n13 = 0;
                while (stringTokenizer.hasMoreElements() && Integer.valueOf(stringTokenizer.nextToken()) != n12) {
                    ++n13;
                }
                BTimeZone bTimeZone2 = BTimeZone.getTimeZone((String)string9);
                if (bl2) {
                    object2 = DataPoint.get(n11, this.session);
                    if ((object2 = ((DataPoint)object2).getTemperatureDP()) == null) continue;
                    string3 = ((DataPoint)object2).getName();
                    bUnit2 = ((DataPoint)object2).getUnit();
                    d3 = bUnit2.fromNormal(bUnit.toNormal(d));
                }
                if (bl4) {
                    object2 = "null";
                    switch (n9) {
                        case 1: {
                            d4 = resultSet.getDouble(4);
                            object2 = resultSet.getString(5);
                            break;
                        }
                        case 2: {
                            d4 = resultSet.getDouble(4);
                            object2 = resultSet.getString(5);
                        }
                    }
                    bUnit4 = BUnit.getUnit((String)object2);
                    if (bUnit3 == null) {
                        bUnit3 = bUnit4;
                    } else {
                        d4 = bUnit3.fromNormal(bUnit4.toNormal(d4));
                    }
                }
                object2 = BUnit.getUnit((String)string10);
                if (object == null) {
                    object = object2;
                }
                if ((tSDataSummary = this.getDataSummary(string8, easLocalTime, easLocalTime2, bTimeZone2, restorationMethod, n4, n5, (BUnit)object2, (BUnit)object, new TimeInterval(24L, 4), 0, d4, bUnit4, string3, bUnit2, d3, timeInterval, bl3, n6, d2, n13 < blArray.length ? blArray[n13] : false, n13 < dataPointArray.length ? dataPointArray[n13] : null)) == null || tSDataSummary.getSize() <= 0) continue;
                DataSummaryElement dataSummaryElement = tSDataSummary.rollup();
                if (siteSummary == null || dataSummaryElement.compareTo(siteSummary, nArray) > 0) {
                    SiteSummary siteSummary2 = new SiteSummary(n12, (BUnit)object, bUnit3, dataSummaryElement);
                    int n14 = Math.min(++n8, siteSummaryArray.length - 1);
                    while (--n14 >= 0) {
                        if (siteSummaryArray[n14] != null) {
                            if (siteSummary2.compareTo(siteSummaryArray[n14], nArray) <= 0) break;
                            siteSummaryArray[n14 + 1] = siteSummaryArray[n14];
                            siteSummaryArray[n14] = siteSummary2;
                            continue;
                        }
                        siteSummaryArray[n14] = siteSummary2;
                    }
                }
                siteSummary = siteSummaryArray[siteSummaryArray.length - 1];
            }
        }
        catch (SQLException sQLException) {
            System.out.println(string7);
            sQLException.printStackTrace();
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.easDb.freeConnection(connection);
        siteSummaryArray[siteSummaryArray.length - 1] = null;
        return siteSummaryArray;
    }

    private DataArray getDataArray(String string, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BTimeZone bTimeZone, RestorationMethod restorationMethod, TimeInterval timeInterval, boolean bl, int n, double d) throws EasException {
        int n2;
        double d2;
        int n3;
        double d3;
        int n4;
        int n5;
        double d4;
        Object object;
        BAbsTime bAbsTime = BAbsTime.make((long)easLocalTime.getTimestamp(bTimeZone), (BTimeZone)BTimeZone.getTimeZone((String)bTimeZone.getId()));
        BAbsTime bAbsTime2 = BAbsTime.make((long)easLocalTime2.getTimestamp(bTimeZone), (BTimeZone)BTimeZone.getTimeZone((String)bTimeZone.getId()));
        long l = bAbsTime.getMillis() - (long)TimeInterval.MILLIS_IN_DAY;
        int n6 = ((TimeZone)bTimeZone.tzSupport()).inDaylightTime(easLocalTime2.getDate(bTimeZone));
        RegularTimeParameters regularTimeParameters = new RegularTimeParameters(new EasLocalTime(bAbsTime.getMillis(), bTimeZone), timeInterval, 0, bTimeZone);
        int n7 = Math.max(1, regularTimeParameters.getIndexByOffset(bAbsTime2.getMillis() - bAbsTime.getMillis()));
        double[] dArray = new double[n7];
        BoolArray boolArray = new BoolArray(dArray.length);
        boolArray.setAll(false);
        int[] nArray = null;
        double[] dArray2 = null;
        BoolArray boolArray2 = null;
        boolean bl2 = false;
        int n8 = 0;
        int n9 = -1;
        boolean bl3 = true;
        boolean bl4 = false;
        double d5 = restorationMethod.getInitialValue();
        int n10 = 0;
        double d6 = 0.0;
        boolean bl5 = timeInterval.equals(TimeInterval.INTERVAL_15_MINUTES);
        long l2 = 0L;
        int n11 = 0;
        boolean bl6 = false;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        long l3 = 0L;
        long l4 = 0L;
        BCollectionInterval bCollectionInterval = null;
        try {
            BTrendRecord bTrendRecord;
            Object object2;
            BIHistory bIHistory = this.easDb.getLog(string);
            if (bIHistory == null) {
                throw new EasException("Can't open log for '" + string + "'");
            }
            object = bIHistory.getRecordType().getResolvedType();
            boolean bl7 = object.is(BBooleanTrendRecord.TYPE);
            if (bl7) {
                restorationMethod = RestorationMethod.NON;
            }
            bCollectionInterval = bIHistory.getConfig().getInterval();
            BAbsTime bAbsTime3 = bAbsTime;
            BAbsTime bAbsTime4 = bAbsTime2;
            bl2 = bCollectionInterval.isIrregular();
            if (!bl2) {
                bAbsTime3 = bAbsTime3.subtract(bCollectionInterval.getInterval());
                bAbsTime4 = bAbsTime4.add(bCollectionInterval.getInterval());
            }
            BRelTime bRelTime = BRelTime.make((long)150000L);
            bAbsTime3 = bAbsTime3.subtract(bRelTime);
            bAbsTime4 = bAbsTime4.add(bRelTime);
            Cursor cursor = null;
            if (this.easDb.requiresDeltaQuery(bIHistory)) {
                object2 = new BHistoryDeltaQuery(bIHistory, bAbsTime3, bAbsTime4);
                cursor = object2.cursor();
            } else {
                cursor = bIHistory.timeQuery(bAbsTime3, bAbsTime4).cursor();
            }
            if (bl2 && bl5) {
                int n26 = 0;
                while (cursor.next()) {
                    ++n26;
                }
                nArray = new int[n26];
                dArray2 = new double[n26];
                boolArray2 = new BoolArray(n26);
                boolArray2.setAll(false);
                if (this.easDb.requiresDeltaQuery(bIHistory)) {
                    bTrendRecord = new BHistoryDeltaQuery(bIHistory, bAbsTime3, bAbsTime4);
                    cursor = bTrendRecord.cursor();
                } else {
                    cursor = bIHistory.timeQuery(bAbsTime3, bAbsTime4).cursor();
                }
            }
            l3 = bAbsTime2.getMillis() - bAbsTime.getMillis();
            l4 = 0L;
            object2 = new Date();
            while (cursor.next()) {
                bTrendRecord = (BTrendRecord)cursor.get();
                long l5 = bTrendRecord.getTimestamp().getMillis();
                long l6 = (l5 + 150000L) / 300000L * 300000L;
                double d7 = bl7 ? (((BBooleanTrendRecord)bTrendRecord).getValue() ? 1.0 : 0.0) : (d4 = ((BNumericTrendRecord)bTrendRecord).getValue());
                if (l6 < bAbsTime2.getMillis()) {
                    n5 = n6;
                    if (l6 - l >= (long)TimeInterval.MILLIS_IN_DAY) {
                        ((Date)object2).setTime(l6);
                        l = l6;
                        n6 = ((TimeZone)bTimeZone.tzSupport()).inDaylightTime((Date)object2);
                    }
                    if (Double.isNaN(d4) || Double.isInfinite(d4) || !DataPointExecSrv.validStatus(bTrendRecord.getStatus().getBits(), bTrendRecord.getTrendFlags().getBits())) continue;
                    n4 = n9;
                    n9 = regularTimeParameters.getIndexByOffset(l6 - bAbsTime.getMillis());
                    if (bl2 && bl5) {
                        nArray[n8] = n9;
                        dArray2[n8] = d4;
                        boolArray2.sett(n8);
                        ++n8;
                    }
                    if (bl3) {
                        bl3 = false;
                        l2 = l5;
                        d6 = d4;
                        bl4 = true;
                        if (n9 < 0 || n9 >= dArray.length) continue;
                        dArray[n9] = d4;
                        boolArray.sett(n9);
                        continue;
                    }
                    n11 = ((int)(l5 - l2) + 150000) / 300000;
                    l3 = ++l4 == 1L ? l5 - l2 : Math.min(l3, l5 - l2);
                    l2 = l5;
                    bl6 = false;
                    int n27 = n9 - n4;
                    if (n27 <= 0) {
                        switch (restorationMethod.getId()) {
                            case 0: 
                            case 3: {
                                ++n10;
                                d5 += d4;
                                break;
                            }
                            case 1: {
                                ++n10;
                                d5 = Math.max(d5, d4);
                                break;
                            }
                            case 2: {
                                ++n10;
                                d5 = Math.min(d5, d4);
                            }
                        }
                        bl4 = false;
                        continue;
                    }
                    d3 = d6;
                    if (n27 == 1) {
                        d6 = d4;
                        switch (restorationMethod.getId()) {
                            case 0: {
                                d6 += d5;
                                break;
                            }
                            case 3: {
                                d6 += d5;
                                d6 /= (double)(n10 + 1);
                                break;
                            }
                            case 1: {
                                d6 = Math.max(d5, d4);
                                break;
                            }
                            case 2: {
                                d6 = Math.min(d5, d4);
                            }
                        }
                        if (bl4 && n4 >= 0 && n4 < dArray.length) {
                            dArray[n4] = d3;
                            boolArray.sett(n4);
                        }
                        if (n9 < dArray.length) {
                            dArray[n9] = d6;
                            boolArray.sett(n9);
                        }
                    } else {
                        n3 = -1;
                        if (restorationMethod.equals(0)) {
                            double d8 = (d4 + d5) / (double)n27 - d3;
                            double d9 = d3 * (double)n27;
                            d2 = 2.0 * d8 / (1.0 + (double)n27);
                            bl6 = true;
                        } else {
                            switch (restorationMethod.getId()) {
                                case 3: {
                                    d4 += d5;
                                    d4 /= (double)(n10 + 1);
                                    break;
                                }
                                case 1: {
                                    d4 = Math.max(d5, d4);
                                    break;
                                }
                                case 2: {
                                    d4 = Math.min(d5, d4);
                                }
                            }
                            d2 = (d4 - d3) / (double)n27;
                        }
                        if (n4 + n27 >= dArray.length) {
                            n27 = dArray.length - n4 - 1;
                        }
                        n2 = 1;
                        if (n4 < 0) {
                            n2 = -n4;
                        }
                        if (restorationMethod.equals(RestorationMethod.NON)) {
                            while (n2 <= n27) {
                                n3 = n4 + n2;
                                d6 = dArray[n3] = d3;
                                if (restorationMethod.equals(RestorationMethod.NON)) {
                                    boolArray.sett(n3);
                                }
                                ++n2;
                            }
                        } else if (restorationMethod.equals(0) && d3 + d2 * (double)n27 < 0.0) {
                            while (n2 <= n27) {
                                n3 = n4 + n2;
                                d6 = dArray[n3] = (d4 + d5) / (double)n27;
                                boolArray.sett(n3);
                                ++n2;
                            }
                        } else {
                            while (n2 <= n27) {
                                n3 = n4 + n2;
                                d6 = dArray[n3] = d3 + d2 * (double)n2;
                                boolArray.sett(n3);
                                ++n2;
                            }
                        }
                    }
                    bl4 = false;
                    if (bl5) {
                        if (bl6) {
                            n11 = 3;
                        } else {
                            if (n11 == 288) {
                                ++n19;
                            }
                            if (n11 >= 288 && n11 % 288 == 0) {
                                ++n19;
                            } else {
                                ++n12;
                            }
                            if (n11 == 144) {
                                ++n20;
                            }
                            if (n11 >= 144 && n11 % 144 == 0) {
                                ++n20;
                            } else {
                                ++n13;
                            }
                            if (n11 == 72) {
                                ++n21;
                            }
                            if (n11 >= 72 && n11 % 72 == 0) {
                                ++n21;
                            } else {
                                ++n14;
                            }
                            if (n11 == 12) {
                                ++n22;
                            }
                            if (n11 >= 12 && n11 % 12 == 0) {
                                ++n22;
                            } else {
                                ++n15;
                            }
                            if (n11 == 6) {
                                ++n23;
                            }
                            if (n11 >= 6 && n11 % 6 == 0) {
                                ++n23;
                            } else {
                                ++n16;
                            }
                            if (n11 == 4) {
                                ++n24;
                            }
                            if (n11 >= 4 && n11 % 4 == 0) {
                                ++n24;
                            } else {
                                ++n17;
                            }
                            if (n11 == 3) {
                                ++n25;
                            }
                            if (n11 >= 3 && n11 % 3 == 0) {
                                ++n25;
                            } else {
                                ++n18;
                            }
                        }
                    }
                    d5 = restorationMethod.getInitialValue();
                    n10 = 0;
                    continue;
                }
                if (!bl2 || !bl5 || Double.isNaN(d4) || Double.isInfinite(d4) || !DataPointExecSrv.validStatus(bTrendRecord.getStatus().getBits(), bTrendRecord.getTrendFlags().getBits())) continue;
                nArray[n8] = n5 = regularTimeParameters.getIndexByOffset(l6 - bAbsTime.getMillis());
                dArray2[n8] = d4;
                boolArray2.sett(n8);
                ++n8;
            }
            if (restorationMethod.equals(RestorationMethod.NON) && !bl3) {
                while (n9 < dArray.length) {
                    dArray[n9] = d6;
                    boolArray.sett(n9);
                    ++n9;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            throw new EasException(exception.getMessage());
        }
        if (n9 == -1) {
            boolArray = new BoolArray(dArray.length);
            boolArray.setAll(false);
        }
        if (bl5) {
            object = new double[7];
            double d10 = n18;
            d10 *= d10 * d10;
            object[0] = (Type)((double)n25 - d10);
            d10 = n17;
            d10 *= d10 * d10;
            object[1] = (Type)((double)n24 - d10);
            d10 = n16;
            d10 *= d10 * d10;
            object[2] = (Type)((double)n23 - d10);
            d10 = n15;
            d10 *= d10 * d10;
            object[3] = (Type)((double)n22 - d10);
            d10 = n14;
            d10 *= d10 * d10;
            object[4] = (Type)((double)n21 - d10);
            d10 = n13;
            d10 *= d10 * d10;
            object[5] = (Type)((double)n20 - d10);
            d10 = n12;
            d10 *= d10 * d10;
            object[6] = (Type)((double)n19 - d10);
            Object object3 = 0.0;
            double d11 = 0.0;
            int n28 = -1;
            int n29 = -1;
            for (int i = 0; i < 7; ++i) {
                if (!(object[i] > object3)) continue;
                d11 = object3;
                n29 = n28;
                object3 = object[i];
                n28 = i;
            }
            if (n28 == -1 || n29 != -1 && (object3 - d11) / object3 < 0.3) {
                if (bl2) {
                    if (bl) {
                        DataArray dataArray = this.cleanseData(new DataArray(dArray2, boolArray2), restorationMethod, n, d);
                        dArray2 = dataArray.data;
                        boolArray2 = dataArray.stat;
                    }
                    double[] dArray3 = new double[n7];
                    for (int i = 0; i < n7; ++i) {
                        dArray3[i] = 0.0;
                    }
                    BoolArray boolArray3 = new BoolArray(n7);
                    boolArray3.setAll(false);
                    int n30 = 0;
                    int n31 = 0;
                    int n32 = 0;
                    for (n5 = 0; n5 < n8; ++n5) {
                        n4 = nArray[n5] - n30;
                        if (n4 == 0) {
                            switch (restorationMethod.getId()) {
                                case 0: {
                                    dArray3[n31] = dArray3[n31] + dArray2[n5];
                                    break;
                                }
                                case 3: {
                                    dArray3[n31] = (dArray3[n31] * (double)n32 + dArray2[n5]) / (double)(n32 + 1);
                                    ++n32;
                                    break;
                                }
                                case 1: {
                                    dArray3[n31] = Math.max(dArray3[n31], dArray2[n5]);
                                    break;
                                }
                                case 2: {
                                    dArray3[n31] = Math.min(dArray3[n31], dArray2[n5]);
                                }
                            }
                            boolArray3.set(boolArray2.get(n5) || boolArray3.get(n31), n31);
                        } else if (n4 > 0) {
                            n32 = 0;
                            double d12 = dArray2[n5] / (double)n4;
                            for (int i = 0; i < n4; ++i) {
                                switch (restorationMethod.getId()) {
                                    case 0: {
                                        dArray3[n31] = d12;
                                        break;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        dArray3[n31] = dArray2[n5];
                                    }
                                }
                                boolArray3.set(boolArray2.get(n5), n31);
                                if (++n31 >= n7) break;
                            }
                            if (n31 >= n7) {
                                break;
                            }
                        } else {
                            n32 = 0;
                        }
                        n30 = nArray[n5];
                    }
                    return new DataArray(dArray3, boolArray3);
                }
                long l7 = bCollectionInterval != null ? (long)bCollectionInterval.getInterval().getMinutes() : (l3 + 30000L) / 60000L;
                System.out.println("Can't recognize interval for history " + string + ", using " + l7 + " minutes. ");
                timeInterval = new TimeInterval(l7, 3);
                n28 = timeInterval.equals(TimeInterval.INTERVAL_15_MINUTES) ? 0 : (timeInterval.equals(TimeInterval.INTERVAL_20_MINUTES) ? 1 : 100);
            } else if (!bl2 && bCollectionInterval != null) {
                timeInterval = new TimeInterval(bCollectionInterval.getInterval().getMinutes(), 3);
                n28 = timeInterval.equals(TimeInterval.INTERVAL_15_MINUTES) ? 0 : (timeInterval.equals(TimeInterval.INTERVAL_20_MINUTES) ? 1 : 100);
            }
            if (n28 != 0) {
                if (n28 <= tis.length) {
                    timeInterval = tis[n28 - 1];
                }
                DataArray dataArray = this.getDataArray(string, easLocalTime, easLocalTime2, bTimeZone, restorationMethod, timeInterval, bl, n, d);
                double[] dArray4 = null;
                BoolArray boolArray4 = null;
                if (dataArray != null && dataArray.data != null && dataArray.data.length > 0) {
                    if (bl) {
                        dataArray = this.cleanseData(dataArray, restorationMethod, n, d);
                    }
                    if (n28 != 1) {
                        int n33 = (int)(timeInterval.getMilliseconds() / TimeInterval.INTERVAL_15_MINUTES.getMilliseconds());
                        if (n33 == 0) {
                            long l8 = timeInterval.getMilliseconds();
                            long l9 = TimeInterval.INTERVAL_15_MINUTES.getMilliseconds();
                            d3 = (double)l8 / (double)l9;
                            n33 = (int)Math.ceil((double)dataArray.data.length * d3);
                            dArray4 = new double[n33];
                            boolArray4 = new BoolArray(n33);
                            n3 = 0;
                            d2 = 0.0;
                            n2 = 1;
                            int n34 = 0;
                            for (int i = 0; i < dataArray.data.length; ++i) {
                                double d13 = dataArray.data[i];
                                if (d3 * (double)i > (double)n3) {
                                    if (n3 < dArray4.length) {
                                        long l10 = (long)i * l8;
                                        long l11 = (long)n3 * l9;
                                        if (l10 - l8 < l11) {
                                            switch (restorationMethod.getId()) {
                                                case 3: {
                                                    ++n34;
                                                    d2 += d13;
                                                    n2 = n2 != 0 && dataArray.stat.get(i) ? 1 : 0;
                                                    break;
                                                }
                                                case 0: {
                                                    double d14 = (double)(l11 - (l10 - l8)) / (double)l8;
                                                    ++n34;
                                                    d2 += d13 * d14;
                                                    n2 = n2 != 0 && dataArray.stat.get(i) ? 1 : 0;
                                                    d13 = (1.0 - d14) * d13;
                                                    break;
                                                }
                                            }
                                        }
                                        if (restorationMethod.getId() == 3) {
                                            d2 /= (double)n34;
                                        }
                                        dArray4[n3] = d2;
                                        boolArray4.set(n2 != 0, n3);
                                        d2 = 0.0;
                                        n34 = 0;
                                        n2 = 1;
                                    }
                                    ++n3;
                                }
                                switch (restorationMethod.getId()) {
                                    case 0: 
                                    case 3: {
                                        ++n34;
                                        d2 += d13;
                                        break;
                                    }
                                    case 1: {
                                        ++n34;
                                        d2 = Math.max(d2, d13);
                                        break;
                                    }
                                    case 2: {
                                        ++n34;
                                        d2 = Math.min(d2, d13);
                                    }
                                }
                                n2 = n2 != 0 && dataArray.stat.get(i) ? 1 : 0;
                            }
                            if (n3 < dArray4.length) {
                                if (restorationMethod.getId() == 3) {
                                    d2 /= (double)n34;
                                }
                                dArray4[n3] = d2;
                                boolArray4.set(n2 != 0, n3);
                            }
                        } else {
                            if (timeInterval.getMilliseconds() % TimeInterval.INTERVAL_15_MINUTES.getMilliseconds() != 0L) {
                                ++n33;
                            }
                            dArray4 = new double[dataArray.data.length * n33];
                            boolArray4 = new BoolArray(dataArray.data.length * n33);
                            double d15 = dataArray.data[0];
                            if (restorationMethod.equals(RestorationMethod.SUM)) {
                                d15 /= (double)n33;
                            }
                            boolArray4.set(dataArray.stat.get(0), 0);
                            int n35 = 0;
                            block51: for (int i = 0; i < dataArray.data.length; ++i) {
                                n2 = dataArray.stat.get(i) ? 1 : 0;
                                if (!restorationMethod.equals(RestorationMethod.SUM)) {
                                    d15 = dataArray.data[i];
                                    switch (restorationMethod.getId()) {
                                        case 1: 
                                        case 2: {
                                            for (int j = 0; j < n33; ++j) {
                                                if (n35 >= dArray4.length) continue;
                                                boolArray4.set(n2 != 0, n35);
                                                dArray4[n35++] = d15;
                                            }
                                            continue block51;
                                        }
                                        default: {
                                            double d16 = i == dataArray.data.length - 1 ? dataArray.data[i] : dataArray.data[i + 1];
                                            d3 = (d16 - d15) / (double)n33;
                                            dArray4[n35] = d15;
                                            int n36 = 1;
                                            while (n36 <= n33) {
                                                if (n35 < dArray4.length) {
                                                    boolArray4.set(n2 != 0, n35);
                                                    dArray4[n35] = d15 += d3;
                                                }
                                                ++n36;
                                                ++n35;
                                            }
                                            continue block51;
                                        }
                                    }
                                }
                                d15 = dataArray.data[i];
                                double d17 = d15 / (double)n33;
                                for (int j = 0; j < n33; ++j) {
                                    if (n35 >= dArray4.length) continue;
                                    boolArray4.set(n2 != 0, n35);
                                    dArray4[n35++] = d17;
                                }
                            }
                        }
                    } else {
                        boolean bl8;
                        dArray4 = new double[dataArray.data.length * 4 / 3];
                        boolArray4 = new BoolArray(dArray4.length);
                        d4 = 0.75;
                        double d18 = 0.0;
                        boolArray4.set(dataArray.stat.get(0), 0);
                        double d19 = dataArray.data[0];
                        if (restorationMethod.equals(RestorationMethod.SUM)) {
                            d19 *= d4;
                        }
                        double d20 = d19;
                        int n37 = 0;
                        boolean bl9 = bl8 = dataArray.stat.get(0);
                        for (int i = 0; i < dArray4.length; ++i) {
                            if (i * 3 / 4 >= n37) {
                                d20 = d19;
                                d19 = dataArray.data[++n37 == dataArray.data.length ? n37 - 1 : n37];
                                bl9 = bl8;
                                bl9 = dataArray.stat.get(n37 == dataArray.data.length ? n37 - 1 : n37);
                                if (restorationMethod.equals(RestorationMethod.SUM)) {
                                    d19 *= d4;
                                }
                                d18 = (d19 - d20) / 4.0;
                            }
                            int n38 = i * 3 % 4;
                            dArray4[i] = d20 + d18 * (double)n38;
                            boolArray4.set(n38 == 0 ? bl9 : bl9 && bl8, i);
                        }
                    }
                    return new DataArray(dArray4, boolArray4);
                }
            }
        }
        if (bl) {
            return this.cleanseData(new DataArray(dArray, boolArray), restorationMethod, n, d);
        }
        return new DataArray(dArray, boolArray);
    }

    private DataArray cleanseData(DataArray dataArray, RestorationMethod restorationMethod, int n, double d) {
        DataArray dataArray2 = null;
        if (dataArray != null) {
            double[] dArray = new double[dataArray.data.length];
            System.arraycopy(dataArray.data, 0, dArray, 0, dataArray.data.length);
            BoolArray boolArray = dataArray.stat;
            for (int i = 0; i < dataArray.data.length; ++i) {
                dArray[i] = DataPointExecSrv.getCleansedValue(dArray, i, restorationMethod, n, d);
            }
            dataArray2 = new DataArray(dArray, boolArray);
        }
        return dataArray2;
    }

    private static double getCleansedValue(double[] dArray, int n, RestorationMethod restorationMethod, int n2, double d) {
        double d2 = 0.0;
        if (dArray != null && n < dArray.length) {
            d2 = dArray[n];
            int n3 = dArray.length;
            int n4 = n - n2 / 2;
            int n5 = n4 + n2;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n5 >= n3) {
                n5 = n3 - 1;
            }
            if (n == n4) {
                return d2;
            }
            if (n == n5) {
                return d2;
            }
            int n6 = 0;
            double d3 = 0.0;
            double[] dArray2 = new double[n5 - n4 + 1];
            for (int i = n4; i <= n5; ++i) {
                if (i == n) continue;
                dArray2[n6] = dArray[i];
                d3 += dArray2[n6];
                ++n6;
            }
            if (n6 <= 1) {
                return d2;
            }
            double[] dArray3 = new double[n6];
            System.arraycopy(dArray2, 0, dArray3, 0, n6);
            double d4 = d3 / (double)n6;
            double d5 = 0.0;
            for (int i = 0; i < n6; ++i) {
                d5 += (dArray3[i] - d4) * (dArray3[i] - d4);
            }
            double d6 = Math.sqrt(d5 / (double)(n6 - 1));
            if (d2 >= d4 - d6 * d && d2 <= d4 + d6 * d) {
                return d2;
            }
            int n7 = n + 1;
            while (dArray[n7] < d4 - d6 * d || dArray[n7] > d4 + d6 * d) {
                if (++n7 < dArray.length) continue;
                n7 = n + 1;
                break;
            }
            d2 = (dArray[n - 1] + dArray[n7]) / 2.0;
            return d2;
        }
        return d2;
    }

    private DataArray normalizeData(DataArray dataArray, DataArray dataArray2) {
        if (dataArray == null || dataArray2 == null || dataArray.data == null || dataArray2.data == null) {
            return dataArray;
        }
        int n = dataArray.data.length;
        int n2 = dataArray2.data.length;
        if (n != n2) {
            System.out.println("Normalization by data point warning.  The size of the two data point arrays is not equal (" + n + " != " + n2 + ")");
        }
        double[] dArray = new double[n];
        BoolArray boolArray = new BoolArray(dataArray.stat);
        boolArray.and(dataArray2.stat);
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            if (i < n2) {
                d = dataArray2.data[i];
            }
            if (d == 0.0) {
                d = 1.0;
            }
            dArray[i] = dataArray.data[i] / d;
        }
        return new DataArray(dArray, boolArray);
    }

    public static boolean validStatus(int n, int n2) {
        return (n & 0x17) == 0 && (n2 & 4) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private String getDataPointDescription(String string) {
        block26: {
            SQLException sQLException3;
            String string2;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block21: {
                SQLException sQLException22;
                String string3;
                block22: {
                    connection = this.easDb.getConnection();
                    statement = null;
                    resultSet = null;
                    string2 = null;
                    statement = connection.createStatement();
                    string2 = "select p.DESCR from " + this.easDb.getDBSpecific().getFullTableName("EAS", "DATA_POINT") + " p where p.NAME=" + Dbx.str2db(string);
                    resultSet = statement.executeQuery(string2);
                    if (!resultSet.next()) break block21;
                    string3 = resultSet.getString(1);
                    Object var8_8 = null;
                    if (resultSet == null) break block22;
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException22) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException22) {
                        // empty catch block
                    }
                }
                this.easDb.freeConnection(connection);
                return string3;
            }
            Object var8_9 = null;
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException3) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException3) {
                    // empty catch block
                }
            }
            this.easDb.freeConnection(connection);
            {
                break block26;
                catch (Exception exception) {
                    SQLException sQLException42;
                    System.out.println(string2);
                    exception.printStackTrace();
                    Object var8_10 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException42) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException42) {
                            // empty catch block
                        }
                    }
                    this.easDb.freeConnection(connection);
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException52;
                Object var8_11 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException52) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException52) {
                        // empty catch block
                    }
                }
                this.easDb.freeConnection(connection);
                throw throwable;
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Cdd2HddOp
    implements BitOp {
        private Cdd2HddOp() {
        }

        public int ex(int n, int n2) {
            return ~n & n2;
        }
    }

    private class DataArray {
        public double[] data;
        public BoolArray stat;

        public DataArray(double[] dArray, BoolArray boolArray) {
            this.data = dArray;
            this.stat = boolArray;
        }
    }
}

