/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.util;

import com.tridium.eas.cost.util.DoubleRecord;
import java.util.Date;

public abstract class Record
implements Cloneable {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_INTEGER = 3;
    private long timestamp;
    private int status;

    public Record(long l, int n) {
        this.set(l, n);
    }

    protected Record() {
    }

    public void set(long l, int n) {
        this.timestamp = l;
        this.status = n;
    }

    public Date getDate() {
        return new Date(this.getTimestamp());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public double getDoubleValue() {
        throw new IllegalStateException("Type mismatch: double != " + Record.typeToString(this.getType()));
    }

    public int getIntValue() {
        throw new IllegalStateException("Type mismatch: int != " + Record.typeToString(this.getType()));
    }

    public boolean getBooleanValue() {
        throw new IllegalStateException("Type mismatch: boolean != " + Record.typeToString(this.getType()));
    }

    public abstract int getType();

    public static String typeToString(int n) {
        switch (n) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "double";
            }
            case 2: {
                return "boolean";
            }
        }
        return "error";
    }

    public static boolean isValidRecordType(int n) {
        return n == 1 || n == 2;
    }

    public static Record create(int n) {
        switch (n) {
            case 1: {
                return new DoubleRecord();
            }
        }
        throw new IllegalArgumentException("Unknown record type: " + n);
    }
}

