/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.reconciliation;

import com.tridium.eas.cost.report.ReconciliationNote;
import com.tridium.eas.cost.report.ReconciliationReport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextArea;

public class NotesList
extends JList {
    private ReconciliationReport reconciliation = null;

    public NotesList(ReconciliationReport reconciliationReport, Lexicon lexicon) {
        super(reconciliationReport.getReconciliationNotes() != null ? reconciliationReport.getReconciliationNotes() : new ReconciliationNote[]{});
        this.reconciliation = reconciliationReport;
        this.setCellRenderer(new NotesListCellRenderer(lexicon));
    }

    public void setReconciliation(ReconciliationReport reconciliationReport) {
        this.reconciliation = reconciliationReport;
        this.setListData(reconciliationReport.getReconciliationNotes() != null ? reconciliationReport.getReconciliationNotes() : new ReconciliationNote[]{});
    }

    public ReconciliationReport getReconciliation() {
        return this.reconciliation;
    }

    public ReconciliationNote getSelectedReconciliationNote() {
        return (ReconciliationNote)this.getSelectedValue();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = 400;
        int n2 = 600;
        if (dimension.width > n) {
            n = dimension.width;
        }
        if (dimension.height > n2) {
            n2 = dimension.height;
        }
        return new Dimension(n, n2);
    }

    private class NotesListCellRenderer
    extends DefaultListCellRenderer {
        private Lexicon lex;

        public NotesListCellRenderer(Lexicon lexicon) {
            this.lex = lexicon;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = "";
            if (object != null && object instanceof ReconciliationNote) {
                string = ((ReconciliationNote)object).toDisplayString(this.lex);
            }
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setForeground(jLabel.getForeground());
            jTextArea.setBackground(jLabel.getBackground());
            jTextArea.setBorder(BorderFactory.createLineBorder(Color.black));
            return jTextArea;
        }
    }
}

