/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.reconciliation;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.report.ReconciliationNote;
import com.tridium.eas.cost.report.ReconciliationNotePostInfo;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.ui.reports.reconciliation.NoteEditorDialog;
import com.tridium.eas.cost.ui.reports.reconciliation.NotesList;
import com.tridium.eas.ui.widgets.EasDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NotesDialog
extends EasDialog
implements ListSelectionListener {
    private JButton editNoteButton = null;
    private JButton removeNoteButton = null;
    private ReconciliationReport reconciliation = null;
    private EasSession session = null;
    private NotesList notesList = null;
    private Lexicon lex;
    private boolean notesChanged = false;

    private NotesDialog(ReconciliationReport reconciliationReport, String string, EasSession easSession, Frame frame, Component component, Lexicon lexicon) {
        super(frame, component);
        this.setModal(true);
        this.setTitle(string);
        this.lex = lexicon;
        this.reconciliation = reconciliationReport;
        this.session = easSession;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1), false);
        JButton jButton = new JButton(lexicon.getText("addNote"));
        jButton.setEnabled(easSession.hasOperatorWrite());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesDialog.this.addNote();
            }
        });
        jPanel.add(jButton);
        this.editNoteButton = new JButton(lexicon.getText("editNote"));
        this.editNoteButton.setEnabled(false);
        this.editNoteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesDialog.this.editNote();
            }
        });
        jPanel.add(this.editNoteButton);
        this.removeNoteButton = new JButton(lexicon.getText("removeNote"));
        this.removeNoteButton.setEnabled(false);
        this.removeNoteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesDialog.this.removeNote();
            }
        });
        jPanel.add(this.removeNoteButton);
        JButton jButton2 = new JButton(lexicon.getText("saveDone"));
        jButton2.setEnabled(true);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesDialog.this.hide();
            }
        });
        jPanel.add(jButton2);
        jComponent.add((Component)jPanel, "South");
        this.notesList = new NotesList(reconciliationReport, lexicon);
        this.notesList.addListSelectionListener(this);
        jComponent.add((Component)new JScrollPane(this.notesList), "Center");
    }

    private void addNote() {
        ReconciliationNote reconciliationNote = NoteEditorDialog.getNote(this.session.getUserName(), null, this, this, this.lex);
        if (reconciliationNote != null) {
            this.notesChanged = true;
            this.reconciliation.addNote(reconciliationNote);
            this.notesList.setReconciliation(this.reconciliation);
            this.notesList.setSelectedValue(reconciliationNote, true);
        }
    }

    private void editNote() {
        ReconciliationNote reconciliationNote;
        ReconciliationNote reconciliationNote2 = this.notesList.getSelectedReconciliationNote();
        if (NotesDialog.hasNoteEditPermission(reconciliationNote2, this.session) && (reconciliationNote = NoteEditorDialog.getNote(this.session.getUserName(), reconciliationNote2, this, this, this.lex)) != null) {
            this.notesChanged = true;
            this.reconciliation.addNote(reconciliationNote);
            this.notesList.setReconciliation(this.reconciliation);
            this.notesList.setSelectedValue(reconciliationNote, true);
        }
    }

    private void removeNote() {
        ReconciliationNote reconciliationNote;
        if (this.notesList != null && this.reconciliation != null && (reconciliationNote = this.notesList.getSelectedReconciliationNote()) != null && NotesDialog.hasNoteEditPermission(reconciliationNote, this.session)) {
            int n = JOptionPane.showConfirmDialog(this, this.lex.getText("deleteNoteWarning"), this.lex.getText("confirmDelete"), 0);
            if (n != 0) {
                return;
            }
            this.notesChanged = true;
            this.reconciliation.removeNote(reconciliationNote);
            this.notesList.setReconciliation(this.reconciliation);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ReconciliationNote reconciliationNote;
        boolean bl = false;
        if (this.notesList != null && (reconciliationNote = this.notesList.getSelectedReconciliationNote()) != null) {
            bl = NotesDialog.hasNoteEditPermission(reconciliationNote, this.session);
        }
        this.editNoteButton.setEnabled(bl);
        this.removeNoteButton.setEnabled(bl);
    }

    private ReconciliationNote[] getReconciliationNotes() {
        if (this.reconciliation == null) {
            return null;
        }
        return this.reconciliation.getReconciliationNotes();
    }

    public static ReconciliationNote[] getNotes(ReconciliationReport reconciliationReport, String string, EasSession easSession, Component component, Lexicon lexicon) throws EasException {
        NotesDialog notesDialog = new NotesDialog(reconciliationReport, string, easSession, NotesDialog.getParentFrame(component), component, lexicon);
        notesDialog.show();
        if (!notesDialog.notesChanged) {
            throw new EasException("No note changes");
        }
        return notesDialog.getReconciliationNotes();
    }

    private static boolean hasNoteEditPermission(ReconciliationNote reconciliationNote, EasSession easSession) {
        String string = easSession.getUserName();
        if (reconciliationNote == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        if (easSession.hasAdminWrite()) {
            return true;
        }
        ReconciliationNotePostInfo[] reconciliationNotePostInfoArray = reconciliationNote.getPostInfos();
        if (reconciliationNotePostInfoArray != null) {
            for (int i = 0; i < reconciliationNotePostInfoArray.length; ++i) {
                if (reconciliationNotePostInfoArray[i] == null || !reconciliationNotePostInfoArray[i].getOriginalPost()) continue;
                return string.equals(reconciliationNotePostInfoArray[i].getUser());
            }
        }
        return false;
    }
}

