/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.reconciliation;

import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.reports.reconciliation.PercentValuePair;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.chart.Series;
import com.tridium.eas.ui.chart.ValueColors;
import java.awt.Color;
import java.text.DecimalFormat;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class BillReconciliationSeries
extends Series
implements ValueColors {
    private ReconciliationReport reconciliation = null;
    private ReconciliationRow[] reconciliationRows = null;
    private int type;
    private Lexicon lex;
    private static final DecimalFormat percentFormat = new DecimalFormat("#0.0%");

    public BillReconciliationSeries(Lexicon lexicon, ReconciliationReport reconciliationReport, int n) {
        this.reconciliation = reconciliationReport;
        this.type = n;
        this.lex = lexicon;
        ReconciliationRow[] reconciliationRowArray = reconciliationReport.getReconciliationRows();
        if (reconciliationRowArray != null) {
            ReconciliationRow[] reconciliationRowArray2 = new ReconciliationRow[reconciliationRowArray.length];
            String string = "";
            int n2 = 0;
            BUnit bUnit = null;
            try {
                bUnit = BUnit.getUnit((String)"dollar");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bUnit == null) {
                bUnit = BUnit.make((String)"dollar", (String)"$", (BDimension)BDimension.make((int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)1));
            }
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (!reconciliationRowArray[i].getShowCostColumns()) continue;
                reconciliationRowArray2[n2] = reconciliationRowArray[i];
                string = reconciliationRowArray[i].getCurrency().toString();
                bUnit = reconciliationRowArray[i].getCurrency();
                ++n2;
            }
            if (n == 1 && reconciliationReport.getMiscCost(false, 1.0) != 0.0) {
                reconciliationRowArray2[n2] = new ReconciliationRow(lexicon.getText("miscCost"));
                reconciliationRowArray2[n2].setActualCost(reconciliationReport.getMiscCost(false, 1.0));
                reconciliationRowArray2[n2].setCurrency(bUnit);
                ++n2;
            }
            this.reconciliationRows = new ReconciliationRow[n2];
            System.arraycopy(reconciliationRowArray2, 0, this.reconciliationRows, 0, n2);
        }
    }

    public String getSeriesName() {
        return " ";
    }

    public int getRowCount() {
        return 1;
    }

    public int getValueCount() {
        if (this.reconciliationRows == null) {
            return 0;
        }
        return this.reconciliationRows.length;
    }

    public double getMin(int n) {
        return this.getValue(0, n);
    }

    public double getMax(int n) {
        return this.getValue(0, n);
    }

    public double getValue(int n, int n2) {
        if (this.reconciliationRows == null || this.reconciliationRows.length <= 0) {
            return 0.0;
        }
        double d = 0.0;
        switch (this.type) {
            case 0: {
                d = this.reconciliationRows[n2].getCalculatedCost();
                break;
            }
            case 1: {
                d = this.reconciliationRows[n2].getActualCost(false, 1.0);
                break;
            }
            case 2: {
                d = this.reconciliationRows[n2].getDeltaCost(false, 1.0);
            }
        }
        if (d < 0.0) {
            d *= -1.0;
        }
        return d;
    }

    private double getSignedValue(int n) {
        if (this.reconciliationRows == null || this.reconciliationRows.length <= 0) {
            return 0.0;
        }
        double d = 0.0;
        switch (this.type) {
            case 0: {
                d = this.reconciliationRows[n].getCalculatedCost();
                break;
            }
            case 1: {
                d = this.reconciliationRows[n].getActualCost(false, 1.0);
                break;
            }
            case 2: {
                d = this.reconciliationRows[n].getDeltaCost(false, 1.0);
            }
        }
        return d;
    }

    private String getValueCurrency(int n) {
        if (this.reconciliationRows == null || this.reconciliationRows.length <= 0) {
            return "";
        }
        return this.reconciliationRows[n].getCurrency().toString() + " ";
    }

    public int getValueType() {
        return 0;
    }

    public BUnit getValueUnits() {
        if (this.reconciliationRows == null || this.reconciliationRows.length <= 0) {
            BUnit bUnit = null;
            try {
                bUnit = BUnit.getUnit((String)"dollar");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bUnit == null) {
                bUnit = BUnit.make((String)"dollar", (String)"$", (BDimension)BDimension.make((int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)1));
            }
            return bUnit;
        }
        return this.reconciliationRows[0].getCurrency();
    }

    public double getMinRowTotal() {
        double d = 0.0;
        for (int i = 0; i < this.getValueCount(); ++i) {
            d += this.getValue(0, i);
        }
        return d;
    }

    public double getMaxRowTotal() {
        return this.getMinRowTotal();
    }

    public String getRowName(int n) {
        return "";
    }

    public Color getValueColor(int n) {
        if (n > ChartColors.getColorCount() - 1) {
            return ChartColors.getOverflowColor();
        }
        return ChartColors.getColor(n);
    }

    public String getValueName(int n) {
        if (this.reconciliationRows == null || this.reconciliationRows.length <= 0) {
            return "";
        }
        return this.reconciliationRows[n].getFullName();
    }

    public String getValueLabel(int n, int n2) {
        double d = this.getSignedValue(n2);
        double d2 = 1.0;
        switch (this.type) {
            case 0: {
                d2 = this.reconciliation.getAbsoluteTotalCalculatedCost();
                break;
            }
            case 1: {
                d2 = this.reconciliation.getAbsoluteTotalActualCost(false, 1.0);
                break;
            }
            case 2: {
                d2 = this.reconciliation.getAbsoluteTotalDeltaCost(false, 1.0);
            }
        }
        double d3 = d / d2;
        if (d3 < 0.0) {
            d3 *= -1.0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        stringBuffer.append(decimalFormat.format(d));
        stringBuffer.append('(');
        stringBuffer.append(percentFormat.format(d3));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public PercentValuePair getFullValue(int n) {
        double d = this.getSignedValue(n);
        double d2 = 1.0;
        switch (this.type) {
            case 0: {
                d2 = this.reconciliation.getAbsoluteTotalCalculatedCost();
                break;
            }
            case 1: {
                d2 = this.reconciliation.getAbsoluteTotalActualCost(false, 1.0);
                break;
            }
            case 2: {
                d2 = this.reconciliation.getAbsoluteTotalDeltaCost(false, 1.0);
            }
        }
        double d3 = d / d2;
        if (d3 < 0.0) {
            d3 *= -1.0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getValueCurrency(n));
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        stringBuffer.append(decimalFormat.format(d));
        String string = stringBuffer.toString();
        stringBuffer.append(' ');
        stringBuffer.append('(');
        stringBuffer.append(percentFormat.format(d3));
        stringBuffer.append(')');
        return new PercentValuePair(new Double(d3), stringBuffer.toString(), string);
    }
}

