/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.reconciliation;

import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.datatypes.RateBillingPeriod;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.linking.RateLinkDbObjectValidator;
import com.tridium.eas.cost.ui.reports.reconciliation.BillReconciliationDetailPanel;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.DateEditor;
import com.tridium.eas.ui.widgets.DynamicGroupFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.EasTimeEditor;
import com.tridium.eas.ui.widgets.EasToggleButton;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterJob;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class BillReconciliationApplication
extends EasApplication
implements ResourceManager,
TreeSelectionListener {
    public static final String DEFAULT_RECONCILIATION_PREFIX = "meter";
    private boolean initializingBillValues = false;
    private MeterTreePanel meters;
    private ReconciliationReport currentReconciliation;
    private String currentBillPeriod;
    private ReconciliationReport[] reconciliations = null;
    private BillReconciliationDetailPanel billDetails = null;
    private JSplitPane meterDateSplit = null;
    private JButton refreshButton;
    private JButton printButton;
    private JPanel mainSplit;
    private Filter currentFilter;
    private FilterTree tree;
    private XpComboBox filterSelection;
    private EasComboBox billMonthComboBox;
    private EasTextField billYearTextField;
    private JPanel billingPeriodsPanel;
    private JToggleButton expandView;
    private JButton runButton;
    private JButton saveButton;
    private JButton discardChangesButton;
    private JButton popupDetailsButton;
    private boolean billingPeriodChanged = false;
    private boolean administratorRights;
    private boolean reportRunning = false;

    public String getName() {
        Lexicon lexicon = BEasApplet.lex;
        return lexicon.getText("billReconcile");
    }

    public String getId() {
        return "billReconcile";
    }

    public final void initApplication(boolean bl) {
        if (bl) {
            Lexicon lexicon = BEasApplet.lex;
            this.initFilters();
            this.updateFilter();
            this.billDetails.init(this.getSession());
            if (this.meterDateSplit != null) {
                this.meterDateSplit.setDividerLocation(0.5);
            }
        }
    }

    protected void startApplication() {
        super.startApplication();
        if (this.meterDateSplit != null) {
            this.meterDateSplit.setDividerLocation(0.5);
        }
        if (globalBillPeriodMonth > -1) {
            this.billMonthComboBox.setSelectedIndex(globalBillPeriodMonth);
        }
        if (globalBillPeriodYear != null) {
            this.billYearTextField.setText(globalBillPeriodYear);
        }
    }

    protected void stopApplication() {
        super.stopApplication();
        globalBillPeriodMonth = this.billMonthComboBox.getSelectedIndex();
        globalBillPeriodYear = this.billYearTextField.getText();
    }

    protected JComponent getApplicationToolBar() {
        return this.getApplicationToolBar(new int[]{17, 28, 19});
    }

    protected JComponent getApplicationToolBar(int[] nArray) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        Lexicon lexicon = BEasApplet.lex;
        block5: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 17: {
                    this.refreshButton = new EasButton((ResourceManager)this, 17, lexicon.getText("refresh"));
                    this.refreshButton.addActionListener(this);
                    jToolBar.add(this.refreshButton);
                    continue block5;
                }
                case 28: {
                    this.printButton = new EasButton((ResourceManager)this, 28, lexicon.getText("print"));
                    this.printButton.addActionListener(this);
                    jToolBar.add(this.printButton);
                    continue block5;
                }
                case 19: {
                    this.expandView = new EasToggleButton(this, 19, lexicon.getText("toggleTree"));
                    this.expandView.addActionListener(this);
                    jToolBar.add(this.expandView);
                }
            }
        }
        return jToolBar;
    }

    protected JComponent getApplicationContent() {
        this.queueIconImage("/com/tridium/eas/cost/ui/images/comboPerFee.png", 301);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/demandCharge.png", 302);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/flatFee.png", 303);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/flatFeePerUnit.png", 304);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/historicalRatchet.png", 316);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/ratchet.png", 305);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/rate.png", 306);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/schedule.png", 307);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/compositeSchedule.png", 308);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/intersectionSchedule.png", 309);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/unionSchedule.png", 310);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/filter.png", 311);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/startTime.png", 312);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/endTime.png", 313);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/arrowUp.png", 314);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/arrowDown.png", 315);
        if (this.mainSplit == null) {
            this.initializingBillValues = true;
            Lexicon lexicon = BEasApplet.lex;
            this.administratorRights = this.getSession().hasAdminWrite();
            this.mainSplit = new JPanel(new BorderLayout(), false);
            this.add((Component)this.mainSplit, "Center");
            this.meterDateSplit = new JSplitPane(0);
            this.meterDateSplit.setDividerSize(4);
            this.meterDateSplit.setTopComponent(this.buildAvailableMetersContents(lexicon));
            this.meterDateSplit.setBottomComponent(this.buildBillDateContents(lexicon));
            this.mainSplit.add((Component)this.meterDateSplit, "West");
            this.mainSplit.add((Component)this.buildBillDetailContent(), "Center");
            JPanel jPanel = new JPanel(new FlowLayout(1), false);
            this.runButton = new JButton(lexicon.getText("runReport"));
            this.runButton.setEnabled(false);
            this.runButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!BillReconciliationApplication.this.reportRunning) {
                        RunReportThread runReportThread = new RunReportThread();
                        runReportThread.start();
                    }
                }
            });
            jPanel.add(this.runButton);
            this.saveButton = new JButton(lexicon.getText("saveCosts"));
            if (this.administratorRights) {
                this.saveButton.setEnabled(false);
                this.saveButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (BillReconciliationApplication.this.saveMeterReport()) {
                            BillReconciliationApplication.this.setMeterSelectionEnabled(true);
                            BillReconciliationApplication.this.discardChangesButton.setEnabled(false);
                            BillReconciliationApplication.this.saveButton.setEnabled(false);
                        }
                    }
                });
                jPanel.add(this.saveButton);
            }
            this.discardChangesButton = new JButton(lexicon.getText("discardChanges"));
            if (this.administratorRights) {
                this.discardChangesButton.setEnabled(false);
                this.discardChangesButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BillReconciliationApplication.this.discardChanges();
                        BillReconciliationApplication.this.saveButton.setEnabled(false);
                        BillReconciliationApplication.this.discardChangesButton.setEnabled(false);
                    }
                });
                jPanel.add(this.discardChangesButton);
            }
            JPanel jPanel2 = new JPanel(new BorderLayout(), false);
            JPanel jPanel3 = new JPanel(new FlowLayout(2), false);
            this.popupDetailsButton = new JButton(lexicon.getText("popupDetails"));
            this.popupDetailsButton.setEnabled(false);
            this.popupDetailsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BillReconciliationApplication.this.viewDetails();
                }
            });
            jPanel3.add(this.popupDetailsButton);
            jPanel2.add((Component)jPanel3, "East");
            jPanel2.add((Component)jPanel, "Center");
            this.mainSplit.add((Component)jPanel2, "South");
            this.initializingBillValues = false;
        }
        return this.mainSplit;
    }

    private JComponent buildBillDateContents(Lexicon lexicon) {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(lexicon.getText("billPeriod")), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
        int n2 = easLocalTime.getMonth();
        int n3 = easLocalTime.getYear();
        if (n2 == 0) {
            n2 = 11;
            --n3;
        } else {
            --n2;
        }
        this.billMonthComboBox = new EasComboBox(new String[]{lexicon.getText("january.short"), lexicon.getText("february.short"), lexicon.getText("march.short"), lexicon.getText("april.short"), lexicon.getText("may.short"), lexicon.getText("june.short"), lexicon.getText("july.short"), lexicon.getText("august.short"), lexicon.getText("september.short"), lexicon.getText("october.short"), lexicon.getText("november.short"), lexicon.getText("december.short")});
        this.billMonthComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BillReconciliationApplication.this.initializingBillValues) {
                    return;
                }
                BillReconciliationApplication.this.loadReconciliationReport(false);
            }
        });
        this.billMonthComboBox.setSelectedIndex(n2);
        jPanel2.add((Component)this.billMonthComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.billYearTextField = new EasTextField(4, 5);
        this.billYearTextField.setUseLabelAppearanceWhenDisabled(true);
        this.billYearTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (BillReconciliationApplication.this.initializingBillValues) {
                    return;
                }
                BillReconciliationApplication.this.billingPeriodChanged = true;
            }
        });
        this.billYearTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && BillReconciliationApplication.this.billingPeriodChanged) {
                    BillReconciliationApplication.this.billingPeriodChanged = false;
                    BillReconciliationApplication.this.loadReconciliationReport(false);
                }
            }
        });
        this.billYearTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                BillReconciliationApplication.this.billYearTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                if (BillReconciliationApplication.this.billingPeriodChanged) {
                    BillReconciliationApplication.this.billingPeriodChanged = false;
                    BillReconciliationApplication.this.loadReconciliationReport(false);
                }
            }
        });
        this.billYearTextField.setText(String.valueOf(n3));
        jPanel2.add((Component)this.billYearTextField, gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        this.billingPeriodsPanel = new JPanel(new GridBagLayout(), false);
        jPanel.add((Component)new JScrollPane(this.billingPeriodsPanel), "Center");
        return jPanel;
    }

    private void layoutBillingPeriods(ReconciliationReport reconciliationReport) {
        this.billingPeriodsPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        if (reconciliationReport != null && reconciliationReport.getRateBillingPeriods() != null) {
            Lexicon lexicon = BEasApplet.lex;
            RateBillingPeriod[] rateBillingPeriodArray = reconciliationReport.getRateBillingPeriods();
            for (int i = 0; i < rateBillingPeriodArray.length; ++i) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                JPanel jPanel = new JPanel(new BorderLayout(), false);
                jPanel.setBorder(BorderFactory.createTitledBorder(rateBillingPeriodArray[i].getName()));
                this.billingPeriodsPanel.add((Component)jPanel, gridBagConstraints);
                JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 17;
                jPanel2.add((Component)new JLabel(lexicon.getText("start")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                DateEditor dateEditor = new DateEditor(lexicon);
                EasTimeEditor easTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.getResourceManager().getIconImage(312)), new ImageIcon(this.getResourceManager().getIconImage(313)));
                dateEditor.setAllowFuture(true);
                dateEditor.setValue(new EasLocalTime(rateBillingPeriodArray[i].getStartTime(), CostTimeUtil.DEFAULT_TZ));
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(rateBillingPeriodArray[i].getStartTime()));
                easTimeEditor.setValues(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
                dateEditor.addActionListener(new StartActionListener(rateBillingPeriodArray[i], dateEditor, easTimeEditor));
                easTimeEditor.addActionListener(new StartActionListener(rateBillingPeriodArray[i], dateEditor, easTimeEditor));
                jPanel2.add((Component)dateEditor, gridBagConstraints);
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 17;
                jPanel2.add((Component)new JLabel(""), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                jPanel2.add((Component)easTimeEditor, gridBagConstraints);
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 17;
                jPanel2.add((Component)new JLabel(lexicon.getText("end")), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                DateEditor dateEditor2 = new DateEditor(lexicon);
                EasTimeEditor easTimeEditor2 = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.getResourceManager().getIconImage(312)), new ImageIcon(this.getResourceManager().getIconImage(313)));
                dateEditor2.setAllowFuture(true);
                dateEditor2.setValue(new EasLocalTime(rateBillingPeriodArray[i].getEndTime(), CostTimeUtil.DEFAULT_TZ));
                calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(rateBillingPeriodArray[i].getEndTime()));
                easTimeEditor2.setValues(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
                dateEditor2.addActionListener(new EndActionListener(rateBillingPeriodArray[i], dateEditor2, easTimeEditor2));
                easTimeEditor2.addActionListener(new EndActionListener(rateBillingPeriodArray[i], dateEditor2, easTimeEditor2));
                jPanel2.add((Component)dateEditor2, gridBagConstraints);
                gridBagConstraints.gridy = 4;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 17;
                jPanel2.add((Component)new JLabel(""), gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 1;
                jPanel2.add((Component)easTimeEditor2, gridBagConstraints);
                jPanel.add((Component)jPanel2, "Center");
            }
        }
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        this.billingPeriodsPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.billingPeriodsPanel.revalidate();
        this.billingPeriodsPanel.repaint();
    }

    private JComponent buildAvailableMetersContents(Lexicon lexicon) {
        this.meters = new MeterTreePanel();
        return this.meters;
    }

    private JComponent buildBillDetailContent() {
        Lexicon lexicon = BEasApplet.lex;
        this.billDetails = new BillReconciliationDetailPanel(this, this, this.administratorRights, lexicon);
        return this.billDetails;
    }

    public void setMeterSelectionEnabled(boolean bl) {
        boolean bl2 = bl || !this.administratorRights;
        this.tree.setEnabled(bl2);
        this.filterSelection.setEnabled(bl2);
        this.billMonthComboBox.setEnabled(bl2);
        this.billYearTextField.setEnabled(bl2);
    }

    private ReconciliationReport getMeterReport() {
        return this.currentReconciliation;
    }

    private void loadReconciliationReport(boolean bl) {
        Meter meter;
        if (this.billDetails == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.initializingBillValues = true;
        ReconciliationReport reconciliationReport = null;
        String string = "Jan" + this.billYearTextField.getText();
        Object object = this.tree.getSelectedUserObject();
        if (object != null && object instanceof Meter && (meter = (Meter)object) != null) {
            String string2;
            String string3 = string2 = DEFAULT_RECONCILIATION_PREFIX + meter.getId();
            switch (this.billMonthComboBox.getSelectedIndex()) {
                case 0: {
                    string3 = string2 + "_Jan" + this.billYearTextField.getText();
                    string = "Jan" + this.billYearTextField.getText();
                    break;
                }
                case 1: {
                    string3 = string2 + "_Feb" + this.billYearTextField.getText();
                    string = "Feb" + this.billYearTextField.getText();
                    break;
                }
                case 2: {
                    string3 = string2 + "_Mar" + this.billYearTextField.getText();
                    string = "Mar" + this.billYearTextField.getText();
                    break;
                }
                case 3: {
                    string3 = string2 + "_Apr" + this.billYearTextField.getText();
                    string = "Apr" + this.billYearTextField.getText();
                    break;
                }
                case 4: {
                    string3 = string2 + "_May" + this.billYearTextField.getText();
                    string = "May" + this.billYearTextField.getText();
                    break;
                }
                case 5: {
                    string3 = string2 + "_Jun" + this.billYearTextField.getText();
                    string = "Jun" + this.billYearTextField.getText();
                    break;
                }
                case 6: {
                    string3 = string2 + "_Jul" + this.billYearTextField.getText();
                    string = "Jul" + this.billYearTextField.getText();
                    break;
                }
                case 7: {
                    string3 = string2 + "_Aug" + this.billYearTextField.getText();
                    string = "Aug" + this.billYearTextField.getText();
                    break;
                }
                case 8: {
                    string3 = string2 + "_Sep" + this.billYearTextField.getText();
                    string = "Sep" + this.billYearTextField.getText();
                    break;
                }
                case 9: {
                    string3 = string2 + "_Oct" + this.billYearTextField.getText();
                    string = "Oct" + this.billYearTextField.getText();
                    break;
                }
                case 10: {
                    string3 = string2 + "_Nov" + this.billYearTextField.getText();
                    string = "Nov" + this.billYearTextField.getText();
                    break;
                }
                case 11: {
                    string3 = string2 + "_Dec" + this.billYearTextField.getText();
                    string = "Dec" + this.billYearTextField.getText();
                }
            }
            reconciliationReport = this.loadMeterReport(string2, string3, string, bl);
        }
        this.currentBillPeriod = string;
        this.currentReconciliation = reconciliationReport;
        this.billDetails.setReconciliationEditorValue(this.currentReconciliation, false);
        this.layoutBillingPeriods(this.currentReconciliation);
        if (this.currentReconciliation == null || this.currentReconciliation.getReconciliationRows() == null) {
            this.runButton.setEnabled(false);
            this.popupDetailsButton.setEnabled(false);
        } else {
            this.runButton.setEnabled(true);
            this.popupDetailsButton.setEnabled(true);
        }
        this.discardChangesButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.initializingBillValues = false;
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean saveMeterReport() {
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            return false;
        }
        Meter meter = (Meter)object;
        int n = meter.getId();
        String string = DEFAULT_RECONCILIATION_PREFIX + n;
        String string2 = "";
        switch (this.billMonthComboBox.getSelectedIndex()) {
            case 0: {
                string2 = "Jan" + this.billYearTextField.getText();
                break;
            }
            case 1: {
                string2 = "Feb" + this.billYearTextField.getText();
                break;
            }
            case 2: {
                string2 = "Mar" + this.billYearTextField.getText();
                break;
            }
            case 3: {
                string2 = "Apr" + this.billYearTextField.getText();
                break;
            }
            case 4: {
                string2 = "May" + this.billYearTextField.getText();
                break;
            }
            case 5: {
                string2 = "Jun" + this.billYearTextField.getText();
                break;
            }
            case 6: {
                string2 = "Jul" + this.billYearTextField.getText();
                break;
            }
            case 7: {
                string2 = "Aug" + this.billYearTextField.getText();
                break;
            }
            case 8: {
                string2 = "Sep" + this.billYearTextField.getText();
                break;
            }
            case 9: {
                string2 = "Oct" + this.billYearTextField.getText();
                break;
            }
            case 10: {
                string2 = "Nov" + this.billYearTextField.getText();
                break;
            }
            case 11: {
                string2 = "Dec" + this.billYearTextField.getText();
                break;
            }
            default: {
                return false;
            }
        }
        String string3 = string + "_" + string2;
        if (this.currentReconciliation != null) {
            this.currentReconciliation.setName(string3);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = true;
        try {
            if (this.currentReconciliation != null) {
                EasCostClient.storeReconciliationReport(this.getSession(), n, string2, this.currentReconciliation);
                this.cacheLocalReport(this.currentReconciliation);
            }
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
        return bl;
    }

    private void cacheLocalReport(ReconciliationReport reconciliationReport) {
        if (this.reconciliations == null) {
            this.reconciliations = new ReconciliationReport[1];
            this.reconciliations[0] = reconciliationReport;
            return;
        }
        if (reconciliationReport != null && reconciliationReport.getName() != null) {
            for (int i = 0; i < this.reconciliations.length; ++i) {
                if (!this.reconciliations[i].getName().equals(reconciliationReport.getName())) continue;
                this.reconciliations[i] = reconciliationReport;
                return;
            }
            ReconciliationReport[] reconciliationReportArray = new ReconciliationReport[this.reconciliations.length + 1];
            for (int i = 0; i < this.reconciliations.length; ++i) {
                reconciliationReportArray[i] = this.reconciliations[i];
            }
            reconciliationReportArray[this.reconciliations.length] = reconciliationReport;
            this.reconciliations = reconciliationReportArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean runReport() {
        block10: {
            boolean bl;
            block9: {
                boolean bl2;
                block8: {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        try {
                            Object object = this.tree.getSelectedUserObject();
                            if (object == null || !(object instanceof Meter)) {
                                bl2 = false;
                                Object var6_5 = null;
                                break block8;
                            }
                            Meter meter = (Meter)object;
                            if (meter == null) {
                                bl = false;
                                break block9;
                            }
                            String string = DEFAULT_RECONCILIATION_PREFIX + meter.getId();
                            ReconciliationReport reconciliationReport = EasCostClient.runReconciliationReport(this.getSession(), string, this.currentBillPeriod, this.currentReconciliation, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                            if (reconciliationReport != null && reconciliationReport.getReconciliationRows() != null) {
                                this.billDetails.setReconciliationEditorValue(reconciliationReport, true);
                                this.currentReconciliation = reconciliationReport;
                                this.layoutBillingPeriods(this.currentReconciliation);
                            }
                            break block10;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            Object var6_8 = null;
                            this.setCursor(Cursor.getDefaultCursor());
                            return true;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        this.setCursor(Cursor.getDefaultCursor());
                        throw throwable;
                    }
                }
                this.setCursor(Cursor.getDefaultCursor());
                return bl2;
            }
            Object var6_6 = null;
            this.setCursor(Cursor.getDefaultCursor());
            return bl;
        }
        Object var6_7 = null;
        this.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    private ReconciliationReport loadMeterReport(String string, String string2, String string3, boolean bl) {
        try {
            ReconciliationReport reconciliationReport;
            if (this.reconciliations == null) {
                ReconciliationReport reconciliationReport2 = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                if (reconciliationReport2 == null) {
                    reconciliationReport2 = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                }
                if (reconciliationReport2 == null) {
                    reconciliationReport2 = new ReconciliationReport(string2 == null ? "temp" : string2);
                }
                this.reconciliations = new ReconciliationReport[1];
                this.reconciliations[0] = reconciliationReport2;
                return reconciliationReport2;
            }
            if (string2 != null) {
                for (int i = 0; i < this.reconciliations.length; ++i) {
                    if (!this.reconciliations[i].getName().equals(string2)) continue;
                    if (bl) {
                        this.reconciliations[i] = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                        if (this.reconciliations[i] == null) {
                            this.reconciliations[i] = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                        }
                        if (this.reconciliations[i] == null) {
                            this.reconciliations[i] = new ReconciliationReport(string2);
                        }
                    }
                    return this.reconciliations[i];
                }
            }
            if ((reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null)) == null) {
                reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
            }
            if (reconciliationReport == null) {
                reconciliationReport = new ReconciliationReport(string2 == null ? "temp" : string2);
            }
            ReconciliationReport[] reconciliationReportArray = new ReconciliationReport[this.reconciliations.length + 1];
            for (int i = 0; i < this.reconciliations.length; ++i) {
                reconciliationReportArray[i] = this.reconciliations[i];
            }
            reconciliationReportArray[this.reconciliations.length] = reconciliationReport;
            this.reconciliations = reconciliationReportArray;
            return reconciliationReport;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void reloadMeterReport() {
        this.loadReconciliationReport(true);
    }

    public ReconciliationReport loadCurrentReconciliationReport() {
        ReconciliationReport reconciliationReport = null;
        try {
            Meter meter;
            Object object = this.tree.getSelectedUserObject();
            if (object != null && object instanceof Meter && (meter = (Meter)object) != null) {
                String string;
                String string2 = string = DEFAULT_RECONCILIATION_PREFIX + meter.getId();
                String string3 = "Jan" + this.billYearTextField.getText();
                switch (this.billMonthComboBox.getSelectedIndex()) {
                    case 0: {
                        string2 = string + "_Jan" + this.billYearTextField.getText();
                        string3 = "Jan" + this.billYearTextField.getText();
                        break;
                    }
                    case 1: {
                        string2 = string + "_Feb" + this.billYearTextField.getText();
                        string3 = "Feb" + this.billYearTextField.getText();
                        break;
                    }
                    case 2: {
                        string2 = string + "_Mar" + this.billYearTextField.getText();
                        string3 = "Mar" + this.billYearTextField.getText();
                        break;
                    }
                    case 3: {
                        string2 = string + "_Apr" + this.billYearTextField.getText();
                        string3 = "Apr" + this.billYearTextField.getText();
                        break;
                    }
                    case 4: {
                        string2 = string + "_May" + this.billYearTextField.getText();
                        string3 = "May" + this.billYearTextField.getText();
                        break;
                    }
                    case 5: {
                        string2 = string + "_Jun" + this.billYearTextField.getText();
                        string3 = "Jun" + this.billYearTextField.getText();
                        break;
                    }
                    case 6: {
                        string2 = string + "_Jul" + this.billYearTextField.getText();
                        string3 = "Jul" + this.billYearTextField.getText();
                        break;
                    }
                    case 7: {
                        string2 = string + "_Aug" + this.billYearTextField.getText();
                        string3 = "Aug" + this.billYearTextField.getText();
                        break;
                    }
                    case 8: {
                        string2 = string + "_Sep" + this.billYearTextField.getText();
                        string3 = "Sep" + this.billYearTextField.getText();
                        break;
                    }
                    case 9: {
                        string2 = string + "_Oct" + this.billYearTextField.getText();
                        string3 = "Oct" + this.billYearTextField.getText();
                        break;
                    }
                    case 10: {
                        string2 = string + "_Nov" + this.billYearTextField.getText();
                        string3 = "Nov" + this.billYearTextField.getText();
                        break;
                    }
                    case 11: {
                        string2 = string + "_Dec" + this.billYearTextField.getText();
                        string3 = "Dec" + this.billYearTextField.getText();
                    }
                }
                reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                if (reconciliationReport == null) {
                    reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return reconciliationReport;
    }

    public boolean saveReconciliationReport(ReconciliationReport reconciliationReport) {
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            return false;
        }
        Meter meter = (Meter)object;
        int n = meter.getId();
        String string = DEFAULT_RECONCILIATION_PREFIX + n;
        String string2 = "";
        switch (this.billMonthComboBox.getSelectedIndex()) {
            case 0: {
                string2 = "Jan" + this.billYearTextField.getText();
                break;
            }
            case 1: {
                string2 = "Feb" + this.billYearTextField.getText();
                break;
            }
            case 2: {
                string2 = "Mar" + this.billYearTextField.getText();
                break;
            }
            case 3: {
                string2 = "Apr" + this.billYearTextField.getText();
                break;
            }
            case 4: {
                string2 = "May" + this.billYearTextField.getText();
                break;
            }
            case 5: {
                string2 = "Jun" + this.billYearTextField.getText();
                break;
            }
            case 6: {
                string2 = "Jul" + this.billYearTextField.getText();
                break;
            }
            case 7: {
                string2 = "Aug" + this.billYearTextField.getText();
                break;
            }
            case 8: {
                string2 = "Sep" + this.billYearTextField.getText();
                break;
            }
            case 9: {
                string2 = "Oct" + this.billYearTextField.getText();
                break;
            }
            case 10: {
                string2 = "Nov" + this.billYearTextField.getText();
                break;
            }
            case 11: {
                string2 = "Dec" + this.billYearTextField.getText();
                break;
            }
            default: {
                return false;
            }
        }
        String string3 = string + "_" + string2;
        if (reconciliationReport != null) {
            reconciliationReport.setName(string3);
        }
        boolean bl = false;
        try {
            if (reconciliationReport != null) {
                EasCostClient.storeReconciliationReport(this.getSession(), n, string2, reconciliationReport);
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        return bl;
    }

    public String getMeterString() {
        String string = "";
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            return string;
        }
        Meter meter = (Meter)object;
        try {
            string = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getBillPeriodString() {
        return this.billMonthComboBox.getSelectedItemString() + " " + this.billYearTextField.getText();
    }

    public void handleBillChange() {
        this.runButton.setEnabled(true);
        if (this.initializingBillValues) {
            return;
        }
        this.discardChangesButton.setEnabled(true);
        this.saveButton.setEnabled(true);
        this.setMeterSelectionEnabled(false);
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.refreshButton) {
            this.setMeterSelectionEnabled(true);
            this.reloadMeterReport();
            if (this.billDetails != null) {
                this.billDetails.doRefresh();
            }
            this.initApplication(true);
            ((FilterTreeModel)this.tree.getModel()).reload();
            this.expandView.setSelected(false);
            this.setExpandedView(true);
        } else if (jButton == this.printButton) {
            try {
                this.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        pageFormat.setOrientation(0);
        Pageable pageable = this.getPageable(pageFormat);
        if (pageable == null || pageable.getNumberOfPages() == 0) {
            printerJob.cancel();
            return;
        }
        try {
            if (printerJob.printDialog()) {
                printerJob.setPageable(pageable);
                printerJob.print();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = null;
        if (this.billDetails != null) {
            this.billDetails.print(this.createImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight()).getGraphics(), pageFormat, 0);
            int n = this.billDetails.getEstimateNumPages();
            book = new Book();
            book.append(this.billDetails, pageFormat, n);
        }
        return book;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.billDetails == null) {
            return;
        }
        this.loadReconciliationReport(false);
    }

    private void discardChanges() {
        this.setMeterSelectionEnabled(true);
        this.loadReconciliationReport(true);
    }

    public Meter getSelectedMeter() {
        Object object = this.tree.getSelectedUserObject();
        if (object != null && object instanceof Meter) {
            return (Meter)object;
        }
        return null;
    }

    private void viewDetails() {
        if (this.billDetails != null) {
            this.billDetails.getPopupDetails();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.filterSelection) {
            this.updateFilter();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.expandView) {
            this.setExpandedView(!bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    private void setExpandedView(boolean bl) {
        if (this.meterDateSplit != null) {
            this.meterDateSplit.setVisible(bl);
        }
        if (this.mainSplit != null) {
            this.mainSplit.revalidate();
            this.mainSplit.repaint();
        }
    }

    public void initFilters() {
        EasSession easSession = this.getSession();
        Lexicon lexicon = BEasApplet.lex;
        this.filterSelection.addItem(new AllSitesFilter(easSession, lexicon));
        this.filterSelection.addItem(new StaticGroupFilter(easSession, lexicon));
        Group[] groupArray = Group.getGroups('D', easSession);
        if (groupArray == null) {
            return;
        }
        int n = groupArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (groupArray[i].isHidden()) continue;
                this.filterSelection.addItem(new DynamicGroupFilter(easSession, (DynGroup)groupArray[i], lexicon));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.filterSelection.setMaximumRowCount(Math.min(this.filterSelection.getItemCount(), 10));
    }

    public void updateFilter() {
        Filter filter = (Filter)this.filterSelection.getSelectedItem();
        if (filter != this.currentFilter) {
            this.currentFilter = filter;
            FilterTreeModel filterTreeModel = new FilterTreeModel(new FilterRootNode(filter, new RateLinkDbObjectValidator()));
            this.tree.setModel(filterTreeModel);
        }
    }

    public BEasApplet getApplet() {
        return this.easApplet;
    }

    public void dataCleansingChanged() {
        this.reconciliations = null;
    }

    private class EndActionListener
    implements ActionListener {
        private RateBillingPeriod rateBillingPeriod;
        private DateEditor editor;
        private EasTimeEditor timeEditor;

        public EndActionListener(RateBillingPeriod rateBillingPeriod, DateEditor dateEditor, EasTimeEditor easTimeEditor) {
            this.rateBillingPeriod = rateBillingPeriod;
            this.editor = dateEditor;
            this.timeEditor = easTimeEditor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BillReconciliationApplication.this.initializingBillValues) {
                return;
            }
            Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
            calendar.setTime(new Date(this.editor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
            calendar.set(11, this.timeEditor.getHour());
            calendar.set(12, this.timeEditor.getMinute());
            calendar.set(13, this.timeEditor.getSecond());
            calendar.set(14, this.timeEditor.getMillisecond());
            this.rateBillingPeriod.setEndTime(calendar.getTime().getTime());
            BillReconciliationApplication.this.handleBillChange();
        }
    }

    private class StartActionListener
    implements ActionListener {
        private RateBillingPeriod rateBillingPeriod;
        private DateEditor editor;
        private EasTimeEditor timeEditor;

        public StartActionListener(RateBillingPeriod rateBillingPeriod, DateEditor dateEditor, EasTimeEditor easTimeEditor) {
            this.rateBillingPeriod = rateBillingPeriod;
            this.editor = dateEditor;
            this.timeEditor = easTimeEditor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BillReconciliationApplication.this.initializingBillValues) {
                return;
            }
            Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
            calendar.setTime(new Date(this.editor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
            calendar.set(11, this.timeEditor.getHour());
            calendar.set(12, this.timeEditor.getMinute());
            calendar.set(13, this.timeEditor.getSecond());
            calendar.set(14, this.timeEditor.getMillisecond());
            this.rateBillingPeriod.setStartTime(calendar.getTime().getTime());
            BillReconciliationApplication.this.handleBillChange();
        }
    }

    private class MeterFilterTree
    extends FilterTree {
        public MeterFilterTree(ResourceManager resourceManager) {
            super(resourceManager);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            boolean bl = (mouseEvent.getModifiers() & 4) != 0;
            boolean bl2 = mouseEvent.isControlDown();
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                this.clearSelection();
                return;
            }
            if (bl) {
                if (bl2) {
                    this.addSelectionPath(treePath);
                } else {
                    this.setSelectionPath(treePath);
                }
            }
        }
    }

    private class MeterTreePanel
    extends JComponent {
        public MeterTreePanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(1, 2, 2));
            BillReconciliationApplication.this.filterSelection = new XpComboBox();
            BillReconciliationApplication.this.filterSelection.addActionListener(BillReconciliationApplication.this);
            jPanel.add(BillReconciliationApplication.this.filterSelection);
            this.add((Component)jPanel, "North");
            BillReconciliationApplication.this.tree = new MeterFilterTree(BillReconciliationApplication.this.getResourceManager());
            BillReconciliationApplication.this.tree.addTreeSelectionListener(BillReconciliationApplication.this);
            this.add((Component)new JScrollPane(BillReconciliationApplication.this.tree), "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            float f = (float)(dimension.width + 30) * 1.2f;
            return new Dimension((int)f, dimension.height);
        }
    }

    private class RunReportThread
    extends Thread {
        public RunReportThread() {
            super("RunBillReconcile");
        }

        public void run() {
            BillReconciliationApplication.this.reportRunning = true;
            if (BillReconciliationApplication.this.runReport()) {
                BillReconciliationApplication.this.saveButton.setEnabled(true);
                BillReconciliationApplication.this.discardChangesButton.setEnabled(true);
            }
            BillReconciliationApplication.this.reportRunning = false;
        }
    }
}

