/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.ranking;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ReportPeriod;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportParameters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class CostRankingParameters
extends ReportParameters {
    public static final int ORDER_HIGHEST = 0;
    public static final int ORDER_LOWEST = 1;
    public static final int VERSION = 411;
    private int order = 0;
    private int size = 10;
    private String costComponent = ReconciliationReport.TOTAL_COST;
    private boolean useCalculated = true;
    private int numCycles = 1;
    private String billingCycle;
    private boolean applyBaseline = false;
    private int baselineColor = ChartColors.getColorCount() - 1;
    private String baselineBillingCycle;

    public CostRankingParameters(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public CostRankingParameters(ReportInput[] reportInputArray, int n, int n2, String string, boolean bl, String string2, int n3, int n4, double d, BUnit bUnit, boolean bl2, int n5, String string3, Lexicon lexicon, boolean bl3, int n6, double d2) {
        super(reportInputArray, new ReportPeriod(EasLocalTime.getCurrentTime(), EasLocalTime.getCurrentTime(), 127, null), n4, d, bUnit, false, lexicon, bl3, n6, d2);
        this.order = n;
        this.size = n2;
        this.costComponent = string;
        this.useCalculated = bl;
        this.billingCycle = string2;
        this.numCycles = n3;
        this.applyBaseline = bl2;
        this.baselineColor = n5;
        this.baselineBillingCycle = string3;
    }

    public void load(EasReport easReport, ReportParameters reportParameters) {
        this.setInputs(this.addInputs(easReport, reportParameters.getInputs()));
        this.setPeriod(reportParameters.getPeriod());
        this.setNormalization(reportParameters.getNormalization());
        this.setNormalTemperature(reportParameters.getNormalTemperature());
        this.setNormalTemperatureUnit(reportParameters.getNormalTemperatureUnit());
        this.setDataCleanse(reportParameters.getDataCleanse());
        this.setDataCleanseWindow(reportParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(reportParameters.getDataCleansePercentage());
    }

    public int getOrder() {
        return this.order;
    }

    public int getResultSize() {
        return this.size;
    }

    public String getCostComponent() {
        return this.costComponent;
    }

    public boolean useCalculated() {
        return this.useCalculated;
    }

    public String getBillingCycle() {
        return this.billingCycle;
    }

    public int getNumBillingCycles() {
        return this.numCycles;
    }

    public boolean getApplyBaseline() {
        return this.applyBaseline;
    }

    public int getBaselineColor() {
        return this.baselineColor;
    }

    public String getBaselineBillingCycle() {
        return this.baselineBillingCycle;
    }

    public boolean loadParams(EasSession easSession, DataInput dataInput) throws IOException, EasException {
        int n = dataInput.readInt();
        if (n != 411) {
            this.order = n;
            this.size = dataInput.readInt();
            this.costComponent = dataInput.readUTF();
            this.useCalculated = dataInput.readBoolean();
            this.numCycles = dataInput.readInt();
            this.billingCycle = dataInput.readUTF();
            this.applyBaseline = false;
            this.baselineColor = ChartColors.getColorCount() - 1;
            this.baselineBillingCycle = null;
        } else {
            this.order = dataInput.readInt();
            this.size = dataInput.readInt();
            this.costComponent = dataInput.readUTF();
            this.useCalculated = dataInput.readBoolean();
            this.numCycles = dataInput.readInt();
            this.billingCycle = dataInput.readUTF();
            this.applyBaseline = dataInput.readBoolean();
            this.baselineColor = dataInput.readInt();
            this.baselineBillingCycle = dataInput.readUTF();
        }
        return true;
    }

    public void saveParams(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(411);
        dataOutput.writeInt(this.order);
        dataOutput.writeInt(this.size);
        dataOutput.writeUTF(this.costComponent == null ? "" : this.costComponent);
        dataOutput.writeBoolean(this.useCalculated);
        dataOutput.writeInt(this.numCycles);
        String string = this.billingCycle == null ? "" : this.billingCycle;
        dataOutput.writeUTF(string);
        dataOutput.writeBoolean(this.applyBaseline);
        dataOutput.writeInt(this.baselineColor);
        string = this.baselineBillingCycle == null ? "" : this.baselineBillingCycle;
        dataOutput.writeUTF(string);
    }
}

