/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.ranking;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.ui.CostInputListModel;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.reports.ranking.CostRankingParameters;
import com.tridium.eas.cost.ui.reports.ranking.CostRankingSeries;
import com.tridium.eas.cost.ui.reports.ranking.CostRankingTableModel;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.chart.Chart;
import com.tridium.eas.ui.chart.ChartColorCellRenderer;
import com.tridium.eas.ui.chart.ChartColors;
import com.tridium.eas.ui.chart.ChartModel;
import com.tridium.eas.ui.chart.DefaultBarConfig;
import com.tridium.eas.ui.inputlist.InputListItem;
import com.tridium.eas.ui.inputlist.InputListItemPopup;
import com.tridium.eas.ui.reports.EasReport;
import com.tridium.eas.ui.reports.EasReportTable;
import com.tridium.eas.ui.reports.InputItemSet;
import com.tridium.eas.ui.reports.MeterInputItem;
import com.tridium.eas.ui.reports.ReportFilterTreeModel;
import com.tridium.eas.ui.reports.ReportInput;
import com.tridium.eas.ui.reports.ReportInputItem;
import com.tridium.eas.ui.reports.ReportParameters;
import com.tridium.eas.ui.widgets.EasTable;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import com.tridium.eas.ui.widgets.GridBagManager;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.TemperatureEditor;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Iterator;
import java.util.Vector;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;
import javax.swing.table.TableModel;

public class CostRanking
extends EasReport {
    public static final String TEMPLATE_ID = "costRank";
    private static final String[] costComponentChoices = new String[]{"totalCost", "miscCost", "categoryConsumption", "categoryDemand", "categoryOther", "categoryUserDef1", "categoryUserDef2", "categoryUserDef3", "categoryUserDef4"};
    private static final String[] billMonthChoices = new String[]{"january.short", "february.short", "march.short", "april.short", "may.short", "june.short", "july.short", "august.short", "september.short", "october.short", "november.short", "december.short"};
    private Chart chart;
    private EasTable table;
    private Config config;
    private CostRankingSeries series;
    private boolean reportRunning = false;
    private JMenuItem viewRatesMenuItem = null;
    static /* synthetic */ Class class$com$tridium$eas$api$DataPoint;
    static /* synthetic */ Class class$com$tridium$eas$ui$reports$MeterInputItem;

    public String getName() {
        return this.lex.getText(TEMPLATE_ID);
    }

    public String getId() {
        return TEMPLATE_ID;
    }

    protected void startApplication() {
        super.startApplication();
        if (this.getParameter("reportName", null) == null) {
            if (globalBillPeriodMonth > -1) {
                this.config.billMonthChoice.setSelectedIndex(globalBillPeriodMonth);
            }
            if (globalBillPeriodYear != null) {
                this.config.billYearField.setText(globalBillPeriodYear);
            }
            if (globalConsecutiveBillCycles > -1) {
                this.config.numCyclesField.setText(globalConsecutiveBillCycles);
            }
            this.config.showBaseline.setSelected(globalShowBaseline);
            if (globalBaselineBillPeriodMonth > -1) {
                this.config.baselineBillMonthChoice.setSelectedIndex(globalBaselineBillPeriodMonth);
            }
            if (globalBaselineBillPeriodYear != null) {
                this.config.baselineBillYearField.setText(globalBaselineBillPeriodYear);
            }
        }
    }

    protected void stopApplication() {
        super.stopApplication();
        globalBillPeriodMonth = this.config.billMonthChoice.getSelectedIndex();
        globalBillPeriodYear = this.config.billYearField.getText();
        globalConsecutiveBillCycles = this.config.numCyclesField.getIntValue();
        globalShowBaseline = this.config.showBaseline.isSelected();
        globalBaselineBillPeriodMonth = this.config.baselineBillMonthChoice.getSelectedIndex();
        globalBaselineBillPeriodYear = this.config.baselineBillYearField.getText();
    }

    protected JComponent getReportContent() {
        this.getInputList().setModel(new CostInputListModel(this.lex));
        if (this.chart == null) {
            this.chart = new Chart(this.lex);
            this.chart.setChartStatus(this);
        }
        return this.chart;
    }

    protected JComponent getReportDetails() {
        if (this.table == null) {
            this.table = new EasReportTable((TableModel)new CostRankingTableModel(this.lex), false, this.lex);
        }
        return this.table.getScrollPane();
    }

    protected JComponent getReportConfig() {
        if (this.config == null) {
            this.config = new Config();
        }
        return this.config;
    }

    protected void initReport() {
        ChartModel chartModel = new ChartModel();
        chartModel.setTitle(this.getName());
        this.chart.setModel(chartModel);
        this.lang = this.getParameter("lang", "en");
        this.lex = BEasApplet.lex;
    }

    public boolean allowLoadUserObject(Class clazz) {
        if ((class$com$tridium$eas$api$DataPoint == null ? (class$com$tridium$eas$api$DataPoint = CostRanking.class$("com.tridium.eas.api.DataPoint")) : class$com$tridium$eas$api$DataPoint).isAssignableFrom(clazz)) {
            return false;
        }
        return super.allowLoadUserObject(clazz);
    }

    public Class getInputItemClass() {
        return class$com$tridium$eas$ui$reports$MeterInputItem == null ? (class$com$tridium$eas$ui$reports$MeterInputItem = CostRanking.class$("com.tridium.eas.ui.reports.MeterInputItem")) : class$com$tridium$eas$ui$reports$MeterInputItem;
    }

    public ReportParameters createEmptyParameters() {
        return new CostRankingParameters(this.lex);
    }

    public ReportParameters getReportParameters(boolean bl) {
        return new CostRankingParameters(this.getInputList().getModel().getInputs(), this.config.getOrder(), this.config.getResultSize(), this.config.getCostComponent(), this.config.useCalculated(), this.config.getBillingCycle(), this.config.getNumBillingCycles(), this.config.getNormalization(), this.config.getNormalTemperature(), this.config.getNormalTemperatureUnit(), this.config.getApplyBaseline(), this.config.getBaselineColor(), this.config.getBaselineBillingCycle(), this.lex, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage());
    }

    public void setReportParameters(ReportParameters reportParameters) {
        CostRankingParameters costRankingParameters = (CostRankingParameters)reportParameters;
        this.config.setOrder(costRankingParameters.getOrder());
        this.config.setResultSize(costRankingParameters.getResultSize());
        this.config.setCostComponent(costRankingParameters.getCostComponent());
        this.config.setUseCalculated(costRankingParameters.useCalculated());
        this.config.setBillingCycle(costRankingParameters.getBillingCycle());
        this.config.setNumBillingCycles(costRankingParameters.getNumBillingCycles());
        this.getInputList().getModel().setInputs(costRankingParameters.getInputs());
        this.config.setNormalization(costRankingParameters.getNormalization());
        this.config.setNormalTemperature(costRankingParameters.getNormalTemperature());
        this.config.setNormalTemperatureUnit(costRankingParameters.getNormalTemperatureUnit());
        this.config.setApplyBaseline(costRankingParameters.getApplyBaseline());
        this.config.setBaselineColor(costRankingParameters.getBaselineColor());
        if (costRankingParameters.getApplyBaseline()) {
            this.config.setBaselineBillingCycle(costRankingParameters.getBaselineBillingCycle());
        }
        this.setDataCleanse(costRankingParameters.getDataCleanse());
        this.setDataCleanseWindow(costRankingParameters.getDataCleanseWindow());
        this.setDataCleansePercentage(costRankingParameters.getDataCleansePercentage());
    }

    public void runReport(ReportParameters reportParameters) {
        if (!this.reportRunning) {
            boolean bl = false;
            if (this.getInputList().getModel().getInputs() == null || this.getInputList().getModel().getInputs().length <= 0) {
                this.addAllInputs();
                reportParameters = this.getReportParameters(false);
                bl = true;
            }
            CostRankingParameters costRankingParameters = (CostRankingParameters)reportParameters;
            ProgressThread progressThread = new ProgressThread(this, costRankingParameters, bl);
            progressThread.start();
        }
    }

    private void addAllInputs() {
        if (this.tree == null) {
            return;
        }
        ReportFilterTreeModel reportFilterTreeModel = (ReportFilterTreeModel)this.tree.getModel();
        if (reportFilterTreeModel == null || reportFilterTreeModel.getRoot() == null) {
            return;
        }
        this.addAllInputItems((FilterTreeNode)reportFilterTreeModel.getRoot());
    }

    private void addAllInputItems(FilterTreeNode filterTreeNode) {
        int n = filterTreeNode.isLeaf() ? 1 : filterTreeNode.getChildCount() + 1;
        Vector vector = new Vector(n);
        this.appendNodes(filterTreeNode, vector);
        int n2 = vector.size();
        Object[] objectArray = new FilterTreeNode[n2];
        vector.copyInto(objectArray);
        ReportFilterTreeModel reportFilterTreeModel = (ReportFilterTreeModel)this.tree.getModel();
        for (int i = 0; i < n2; ++i) {
            ReportInputItem[] reportInputItemArray = reportFilterTreeModel.getInputItems((FilterTreeNode)objectArray[i]);
            int n3 = reportInputItemArray == null ? 0 : reportInputItemArray.length;
            String string = null;
            if (n3 > 1) {
                string = ((FilterTreeNode)objectArray[i]).getNodeText();
            }
            this.addInputItemSet(new InputItemSet(string, reportInputItemArray), true);
        }
    }

    private void appendNodes(FilterTreeNode filterTreeNode, Vector vector) {
        Lexicon lexicon = BEasApplet.lex;
        Object object = filterTreeNode.getUserObject();
        if (object instanceof Meter) {
            vector.addElement(filterTreeNode);
        }
        if (!filterTreeNode.isLeaf()) {
            int n = filterTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.appendNodes((FilterTreeNode)filterTreeNode.getChildAt(i), vector);
            }
        }
    }

    public void addInputListPopupItems(InputListItemPopup inputListItemPopup) {
        this.viewRatesMenuItem = new JMenuItem(this.lex.getText("viewAttachedRates"));
        inputListItemPopup.addSeparator();
        inputListItemPopup.add(this.viewRatesMenuItem);
    }

    public void popupItemSelected(JMenuItem jMenuItem, InputListItem inputListItem) {
        ReportInput reportInput;
        if (jMenuItem == this.viewRatesMenuItem && inputListItem != null && (reportInput = inputListItem.getInput()) != null && reportInput.getInputItemCount() > 0) {
            Meter meter;
            int n = 0;
            if (reportInput.getInputItemCount() > 1) {
                for (int i = 0; i < reportInput.getInputItemCount(); ++i) {
                    if (!inputListItem.isRowSelected(i)) continue;
                    n = i;
                    break;
                }
            }
            if ((meter = ((MeterInputItem)reportInput.getInputItem(n)).getMeter()) == null) {
                return;
            }
            int n2 = meter.getId();
            String string = "meter" + n2;
            try {
                RateHistory rateHistory = EasCostClient.retrieveRateHistory(this.getSession(), n2);
                StringBuffer stringBuffer = new StringBuffer();
                if (rateHistory != null && rateHistory.getRateLinks() != null && rateHistory.getRateLinks().length > 0) {
                    stringBuffer.append(this.lex.getText("ratesAttached") + " " + (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName() + "\n");
                    RateLink[] rateLinkArray = rateHistory.getRateLinks();
                    for (int i = 0; i < rateLinkArray.length; ++i) {
                        stringBuffer.append("    " + rateLinkArray[i].getName() + "\n");
                    }
                } else {
                    stringBuffer.append(this.lex.getText("noAttachedRates") + ": \n    " + (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName());
                }
                JOptionPane.showMessageDialog(this, stringBuffer.toString(), this.lex.getText("viewAttachedRates"), 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addInputItemSet(InputItemSet inputItemSet, boolean bl) {
        boolean bl2 = bl;
        ReportInputItem[] reportInputItemArray = inputItemSet.getInputItems();
        BUnit bUnit = null;
        try {
            bUnit = reportInputItemArray[0].getUnit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = reportInputItemArray.length == 1 ? null : inputItemSet.getName();
        Lexicon lexicon = BEasApplet.lex;
        bl2 = this.addInput(new ReportInput(string, bUnit, reportInputItemArray, lexicon), bl2) && bl2;
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        if (this.isRunReportEnabled()) {
            book.append(this.chart, pageFormat);
            Iterator iterator = this.table.getPagePrinters(pageFormat).iterator();
            while (iterator.hasNext()) {
                book.append((Printable)iterator.next(), pageFormat);
            }
        }
        return book;
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.runButton) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.runReport(this.getReportParameters(false));
        } else if (jButton == this.zoomOutButton) {
            this.chart.zoomOut();
        } else {
            super.buttonPressed(jButton);
        }
    }

    public void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.toggleGrid) {
            this.chart.setShowGrid(bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    private JSplitPane getMainSplit2() {
        return this.getMainSplit();
    }

    private void setChartTitle() {
        this.chart.setTitle(this.getName() + " - " + this.config.getChartTitle());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ProgressThread
    extends Thread {
        private CostRanking report;
        private CostRankingParameters params;
        private boolean truncateInputList;

        public ProgressThread(CostRanking costRanking2, CostRankingParameters costRankingParameters, boolean bl) {
            super("CostRankingProgress");
            this.report = costRanking2;
            this.params = costRankingParameters;
            this.truncateInputList = bl;
        }

        public void run() {
            CostRanking.this.reportRunning = true;
            CostRanking.this.setCursor(Cursor.getPredefinedCursor(3));
            String string = this.params.getNumBillingCycles() + " " + CostRanking.this.lex.getText("costCycles") + " " + CostRanking.this.config.getBillCycleLabel();
            if (this.params.getApplyBaseline()) {
                string = string + "\n(" + CostRanking.this.lex.getText("baseline") + ": " + this.params.getNumBillingCycles() + " " + CostRanking.this.lex.getText("costCycles") + " " + CostRanking.this.config.getBaselineBillCycleLabel() + ")";
            }
            CostRanking.this.series = new CostRankingSeries(this.params, CostRanking.this.lex);
            ProgressMonitor progressMonitor = new ProgressMonitor(this.report, CostRanking.this.lex.getText("costComputationProgress"), "", 1, 100);
            progressMonitor.setProgress(1);
            progressMonitor.setMillisToDecideToPopup(500);
            CostRanking.this.series.load(CostRanking.this.getSession(), CostRanking.this.getInputList(), progressMonitor, this.truncateInputList);
            if (progressMonitor.isCanceled()) {
                CostRanking.this.setCursor(Cursor.getDefaultCursor());
                CostRanking.this.reportRunning = false;
                return;
            }
            progressMonitor.close();
            CostRanking.this.setChartTitle();
            CostRanking.this.chart.setSubtitle(string);
            CostRanking.this.config.setCostComponentList(CostRanking.this.series.getComponentList(), CostRanking.this.series.getCostComponent());
            CostRanking.this.setCursor(Cursor.getDefaultCursor());
            CostRanking.this.reportRunning = false;
        }
    }

    private class Config
    extends JComponent {
        private XpComboBox orderChoice;
        private NumberTextField sizeField;
        private XpComboBox dpChoice;
        private XpComboBox useCalculatedChoice;
        public XpComboBox billMonthChoice;
        public EasTextField billYearField;
        public NumberTextField numCyclesField;
        private boolean initializing = true;
        private JCheckBox normFloorArea;
        private JCheckBox normWeather;
        private TemperatureEditor tempEditor;
        public JCheckBox showBaseline;
        private XpComboBox baselineColorCombo;
        public XpComboBox baselineBillMonthChoice;
        public EasTextField baselineBillYearField;

        public Config() {
            CostRanking.this.lex = BEasApplet.lex;
            Font font = UIManager.getFont("Table.font");
            font = new Font(Theme.widget().getTextFont().getName(), font.getStyle(), 10);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            int n = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            JPanel jPanel = new JPanel(false);
            jPanel.setBorder(BorderFactory.createTitledBorder(CostRanking.this.lex.getText("ranking")));
            int n2 = 0;
            GridBagManager gridBagManager = new GridBagManager(jPanel);
            gridBagManager.insets(new Insets(0, 0, 4, 2));
            gridBagManager.anchor(17);
            JLabel jLabel = new JLabel(CostRanking.this.lex.getText("order"));
            jLabel.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, n2, jLabel);
            this.orderChoice = new XpComboBox();
            this.orderChoice.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Config.this.initializing || CostRanking.this.series == null) {
                        return;
                    }
                    CostRanking.this.series.sortRanking(Config.this.getOrder(), Config.this.getCostComponent(), Config.this.useCalculated(), Config.this.getResultSize());
                    CostRanking.this.chart.getModel().setSeries(CostRanking.this.series, new DefaultBarConfig(CostRanking.this.series), null, null);
                    ((CostRankingTableModel)CostRanking.this.table.getModel()).setSeries(CostRanking.this.series);
                    CostRanking.this.table.resetSorting();
                    CostRanking.this.table.invalidate();
                }
            });
            this.orderChoice.setFont(font);
            this.orderChoice.addItem(CostRanking.this.lex.getText("highest"));
            this.orderChoice.addItem(CostRanking.this.lex.getText("lowest"));
            gridBagManager.add(100, 100, 1, 1, 1, n2++, this.orderChoice);
            jLabel = new JLabel(CostRanking.this.lex.getText("resultSize"));
            jLabel.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, n2, jLabel);
            this.sizeField = new NumberTextField(3, true);
            this.sizeField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        if (Config.this.initializing || CostRanking.this.series == null) {
                            return;
                        }
                        CostRanking.this.series.sortRanking(Config.this.getOrder(), Config.this.getCostComponent(), Config.this.useCalculated(), Config.this.getResultSize());
                        CostRanking.this.chart.getModel().setSeries(CostRanking.this.series, new DefaultBarConfig(CostRanking.this.series), null, null);
                        ((CostRankingTableModel)CostRanking.this.table.getModel()).setSeries(CostRanking.this.series);
                        CostRanking.this.table.resetSorting();
                        CostRanking.this.table.invalidate();
                    }
                }
            });
            this.sizeField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    if (Config.this.initializing || CostRanking.this.series == null) {
                        return;
                    }
                    CostRanking.this.series.sortRanking(Config.this.getOrder(), Config.this.getCostComponent(), Config.this.useCalculated(), Config.this.getResultSize());
                    CostRanking.this.chart.getModel().setSeries(CostRanking.this.series, new DefaultBarConfig(CostRanking.this.series), null, null);
                    ((CostRankingTableModel)CostRanking.this.table.getModel()).setSeries(CostRanking.this.series);
                    CostRanking.this.table.resetSorting();
                    CostRanking.this.table.invalidate();
                }
            });
            this.sizeField.setAllowNegative(false);
            gridBagManager.add(100, 100, 1, 1, 1, n2++, this.sizeField);
            this.sizeField.setFont(font);
            this.sizeField.setText("10");
            jLabel = new JLabel(CostRanking.this.lex.getText("costComponent"));
            jLabel.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, n2, jLabel);
            this.dpChoice = new XpComboBox();
            this.dpChoice.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Config.this.initializing || CostRanking.this.series == null) {
                        return;
                    }
                    CostRanking.this.series.setCostComponent(Config.this.getCostComponent());
                    CostRanking.this.series.sortRanking(Config.this.getOrder(), Config.this.getCostComponent(), Config.this.useCalculated(), Config.this.getResultSize());
                    CostRanking.this.setChartTitle();
                    CostRanking.this.chart.getModel().setSeries(CostRanking.this.series, new DefaultBarConfig(CostRanking.this.series), null, null);
                    ((CostRankingTableModel)CostRanking.this.table.getModel()).setSeries(CostRanking.this.series);
                    CostRanking.this.table.resetSorting();
                    CostRanking.this.table.invalidate();
                }
            });
            this.dpChoice.setFont(font);
            for (int i = 0; i < costComponentChoices.length; ++i) {
                this.dpChoice.addItem(CostRanking.this.lex.getText(costComponentChoices[i]));
            }
            gridBagManager.add(100, 100, 1, 1, 1, n2++, this.dpChoice);
            jLabel = new JLabel(CostRanking.this.lex.getText("useCostValues"));
            jLabel.setFont(font);
            gridBagManager.add(0, 100, 1, 1, 0, n2, jLabel);
            this.useCalculatedChoice = new XpComboBox();
            this.useCalculatedChoice.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Config.this.initializing || CostRanking.this.series == null) {
                        return;
                    }
                    CostRanking.this.series.setUseCalculated(Config.this.useCalculated());
                    CostRanking.this.series.sortRanking(Config.this.getOrder(), Config.this.getCostComponent(), Config.this.useCalculated(), Config.this.getResultSize());
                    CostRanking.this.setChartTitle();
                    CostRanking.this.chart.getModel().setSeries(CostRanking.this.series, new DefaultBarConfig(CostRanking.this.series), null, null);
                    ((CostRankingTableModel)CostRanking.this.table.getModel()).setSeries(CostRanking.this.series);
                    CostRanking.this.table.resetSorting();
                    CostRanking.this.table.invalidate();
                }
            });
            this.useCalculatedChoice.setFont(font);
            this.useCalculatedChoice.addItem(CostRanking.this.lex.getText("calculated"));
            this.useCalculatedChoice.addItem(CostRanking.this.lex.getText("actual"));
            gridBagManager.add(100, 100, 1, 1, 1, n2++, this.useCalculatedChoice);
            this.add(jPanel);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            JPanel jPanel2 = new JPanel(false);
            jPanel2.setBorder(BorderFactory.createTitledBorder(CostRanking.this.lex.getText("billPeriod")));
            EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
            int n3 = easLocalTime.getMonth();
            int n4 = easLocalTime.getYear();
            if (n3 == 0) {
                n3 = 11;
                --n4;
            } else {
                --n3;
            }
            int n5 = 0;
            GridBagManager gridBagManager2 = new GridBagManager(jPanel2);
            gridBagManager2.insets(new Insets(0, 0, 4, 2));
            gridBagManager2.anchor(13);
            this.billMonthChoice = new XpComboBox();
            this.billMonthChoice.setFont(font);
            for (int i = 0; i < billMonthChoices.length; ++i) {
                this.billMonthChoice.addItem(CostRanking.this.lex.getText(billMonthChoices[i]));
            }
            gridBagManager2.add(0, 100, 1, 1, 0, n5, this.billMonthChoice);
            this.billMonthChoice.setSelectedIndex(n3);
            this.billYearField = new EasTextField(4, 5);
            gridBagManager2.anchor(17);
            gridBagManager2.add(100, 100, 1, 1, 1, n5++, this.billYearField);
            this.billYearField.setFont(font);
            this.billYearField.setText(String.valueOf(n4));
            jLabel = new JLabel(CostRanking.this.lex.getText("consecutiveBillingCycles"));
            jLabel.setFont(font);
            gridBagManager2.add(0, 100, 2, 1, 0, n5, jLabel);
            this.numCyclesField = new NumberTextField(3, true);
            this.numCyclesField.setAllowNegative(false);
            gridBagManager2.add(100, 100, 1, 1, 2, n5++, this.numCyclesField);
            this.numCyclesField.setFont(font);
            this.numCyclesField.setText("1");
            this.add(jPanel2);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
            JPanel jPanel3 = new JPanel(false);
            jPanel3.setBorder(BorderFactory.createTitledBorder(CostRanking.this.lex.getText("baseline")));
            --n4;
            n5 = 0;
            GridBagManager gridBagManager3 = new GridBagManager(jPanel3);
            gridBagManager3.insets(new Insets(0, 0, 4, 2));
            gridBagManager3.anchor(17);
            this.showBaseline = new JCheckBox(CostRanking.this.lex.getText("showBaseline"));
            this.showBaseline.setFont(font);
            gridBagManager3.add(0, 100, 2, 1, 0, n5, this.showBaseline);
            this.baselineColorCombo = new XpComboBox();
            this.baselineColorCombo.setFont(font);
            this.baselineColorCombo.setRenderer(new ChartColorCellRenderer());
            int n6 = 0;
            int n7 = 0;
            while (n7 < ChartColors.getColorCount()) {
                this.baselineColorCombo.addItem(new Integer(n7));
                n6 = n7++;
            }
            this.baselineColorCombo.setSelectedIndex(n6);
            gridBagManager3.add(100, 100, 2, 1, 2, n5++, this.baselineColorCombo);
            gridBagManager3.anchor(13);
            this.baselineBillMonthChoice = new XpComboBox();
            this.baselineBillMonthChoice.setFont(font);
            for (n7 = 0; n7 < billMonthChoices.length; ++n7) {
                this.baselineBillMonthChoice.addItem(CostRanking.this.lex.getText(billMonthChoices[n7]));
            }
            gridBagManager3.add(0, 100, 1, 1, 0, n5, this.baselineBillMonthChoice);
            this.baselineBillMonthChoice.setSelectedIndex(n3);
            this.baselineBillYearField = new EasTextField(4, 5);
            gridBagManager3.anchor(17);
            gridBagManager3.add(100, 100, 1, 1, 1, n5++, this.baselineBillYearField);
            this.baselineBillYearField.setFont(font);
            this.baselineBillYearField.setText(String.valueOf(n4));
            this.add(jPanel3);
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            JPanel jPanel4 = new JPanel(false);
            GridBagManager gridBagManager4 = new GridBagManager(jPanel4);
            gridBagManager4.anchor(17);
            this.add(jPanel4);
            this.normFloorArea = new JCheckBox(CostRanking.this.lex.getText("floorArea"));
            this.normFloorArea.setFont(font);
            gridBagManager4.add(0, 0, 2, 1, 0, 0, this.normFloorArea);
            this.normWeather = new JCheckBox(CostRanking.this.lex.getText("degreeDay"));
            this.normWeather.setFont(font);
            gridBagManager4.add(0, 100, 1, 1, 0, 1, this.normWeather);
            this.tempEditor = new TemperatureEditor(65, BUnit.getUnit((String)"fahrenheit"), CostRanking.this.lex);
            gridBagManager4.add(100, 100, 1, 1, 1, 1, this.tempEditor);
            jPanel4.setBorder(BorderFactory.createTitledBorder(CostRanking.this.lex.getText("normalization")));
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
            JLabel jLabel2 = new JLabel("");
            this.add(jLabel2);
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridy = n++;
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            this.initializing = false;
        }

        public int getOrder() {
            return this.orderChoice.getSelectedIndex();
        }

        public void setOrder(int n) {
            this.initializing = true;
            this.orderChoice.setSelectedIndex(n);
            this.initializing = false;
        }

        public int getResultSize() {
            return this.sizeField.getIntValue();
        }

        public void setResultSize(int n) {
            this.initializing = true;
            this.sizeField.setText(Integer.toString(n));
            this.initializing = false;
        }

        public String getCostComponent() {
            switch (this.dpChoice.getSelectedIndex()) {
                case 0: {
                    return ReconciliationReport.TOTAL_COST;
                }
                case 1: {
                    return ReconciliationReport.MISC_COST;
                }
                case 2: {
                    return ReconciliationReport.CATEGORY_CONSUMPTION_COST;
                }
                case 3: {
                    return ReconciliationReport.CATEGORY_DEMAND_COST;
                }
                case 4: {
                    return ReconciliationReport.CATEGORY_OTHER_COST;
                }
                case 5: {
                    return ReconciliationReport.CATEGORY_USER_DEF1_COST;
                }
                case 6: {
                    return ReconciliationReport.CATEGORY_USER_DEF2_COST;
                }
                case 7: {
                    return ReconciliationReport.CATEGORY_USER_DEF3_COST;
                }
                case 8: {
                    return ReconciliationReport.CATEGORY_USER_DEF4_COST;
                }
            }
            return (String)this.dpChoice.getSelectedItem();
        }

        public void setCostComponent(String string) {
            this.initializing = true;
            if (string.equals(ReconciliationReport.TOTAL_COST)) {
                this.dpChoice.setSelectedIndex(0);
                return;
            }
            if (string.equals(ReconciliationReport.MISC_COST)) {
                this.dpChoice.setSelectedIndex(1);
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_CONSUMPTION_COST)) {
                this.dpChoice.setSelectedIndex(2);
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_DEMAND_COST)) {
                this.dpChoice.setSelectedIndex(3);
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_OTHER_COST)) {
                this.dpChoice.setSelectedIndex(4);
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_USER_DEF1_COST)) {
                this.dpChoice.setSelectedIndex(5);
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_USER_DEF2_COST)) {
                this.dpChoice.setSelectedIndex(6);
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_USER_DEF3_COST)) {
                this.dpChoice.setSelectedIndex(7);
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_USER_DEF4_COST)) {
                this.dpChoice.setSelectedIndex(8);
                return;
            }
            for (int i = 0; i < this.dpChoice.getItemCount(); ++i) {
                if (!((String)this.dpChoice.getItemAt(i)).equalsIgnoreCase(string)) continue;
                this.dpChoice.setSelectedIndex(i);
                return;
            }
            this.dpChoice.addItem(string);
            this.dpChoice.setSelectedItem(string);
            CostRanking.this.getMainSplit2().validate();
            this.initializing = false;
        }

        public void setCostComponentList(String[] stringArray, String string) {
            int n;
            this.initializing = true;
            this.dpChoice.removeAllItems();
            for (n = 0; n < costComponentChoices.length; ++n) {
                this.dpChoice.addItem(CostRanking.this.lex.getText(costComponentChoices[n]));
            }
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    this.dpChoice.addItem(stringArray[n]);
                }
            }
            this.initializing = false;
            if (string.equals(ReconciliationReport.TOTAL_COST)) {
                this.dpChoice.setSelectedIndex(0);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            if (string.equals(ReconciliationReport.MISC_COST)) {
                this.dpChoice.setSelectedIndex(1);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_CONSUMPTION_COST)) {
                this.dpChoice.setSelectedIndex(2);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_DEMAND_COST)) {
                this.dpChoice.setSelectedIndex(3);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_OTHER_COST)) {
                this.dpChoice.setSelectedIndex(4);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_USER_DEF1_COST)) {
                this.dpChoice.setSelectedIndex(5);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_USER_DEF2_COST)) {
                this.dpChoice.setSelectedIndex(6);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_USER_DEF3_COST)) {
                this.dpChoice.setSelectedIndex(7);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            if (string.equals(ReconciliationReport.CATEGORY_USER_DEF4_COST)) {
                this.dpChoice.setSelectedIndex(8);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            for (n = 0; n < this.dpChoice.getItemCount(); ++n) {
                if (!((String)this.dpChoice.getItemAt(n)).equalsIgnoreCase(string)) continue;
                this.dpChoice.setSelectedIndex(n);
                CostRanking.this.getMainSplit2().validate();
                return;
            }
            this.dpChoice.setSelectedIndex(0);
            CostRanking.this.getMainSplit2().validate();
        }

        public boolean useCalculated() {
            return this.useCalculatedChoice.getSelectedIndex() == 0;
        }

        public void setUseCalculated(boolean bl) {
            this.initializing = true;
            if (bl) {
                this.useCalculatedChoice.setSelectedIndex(0);
            } else {
                this.useCalculatedChoice.setSelectedIndex(1);
            }
            this.initializing = false;
        }

        public String getBillingCycle() {
            String string = "Jan" + this.billYearField.getText();
            switch (this.billMonthChoice.getSelectedIndex()) {
                case 0: {
                    string = "Jan" + this.billYearField.getText();
                    break;
                }
                case 1: {
                    string = "Feb" + this.billYearField.getText();
                    break;
                }
                case 2: {
                    string = "Mar" + this.billYearField.getText();
                    break;
                }
                case 3: {
                    string = "Apr" + this.billYearField.getText();
                    break;
                }
                case 4: {
                    string = "May" + this.billYearField.getText();
                    break;
                }
                case 5: {
                    string = "Jun" + this.billYearField.getText();
                    break;
                }
                case 6: {
                    string = "Jul" + this.billYearField.getText();
                    break;
                }
                case 7: {
                    string = "Aug" + this.billYearField.getText();
                    break;
                }
                case 8: {
                    string = "Sep" + this.billYearField.getText();
                    break;
                }
                case 9: {
                    string = "Oct" + this.billYearField.getText();
                    break;
                }
                case 10: {
                    string = "Nov" + this.billYearField.getText();
                    break;
                }
                case 11: {
                    string = "Dec" + this.billYearField.getText();
                }
            }
            return string;
        }

        public void setBillingCycle(String string) {
            if (string == null) {
                return;
            }
            String string2 = string.substring(0, 3);
            String string3 = string.substring(3);
            int n = 0;
            if (string2.equals("Jan")) {
                n = 0;
            } else if (string2.equals("Feb")) {
                n = 1;
            } else if (string2.equals("Mar")) {
                n = 2;
            } else if (string2.equals("Apr")) {
                n = 3;
            } else if (string2.equals("May")) {
                n = 4;
            } else if (string2.equals("Jun")) {
                n = 5;
            } else if (string2.equals("Jul")) {
                n = 6;
            } else if (string2.equals("Aug")) {
                n = 7;
            } else if (string2.equals("Sep")) {
                n = 8;
            } else if (string2.equals("Oct")) {
                n = 9;
            } else if (string2.equals("Nov")) {
                n = 10;
            } else if (string2.equals("Dec")) {
                n = 11;
            }
            this.billMonthChoice.setSelectedIndex(n);
            this.billYearField.setText(string3);
        }

        public int getNumBillingCycles() {
            return this.numCyclesField.getIntValue();
        }

        public void setNumBillingCycles(int n) {
            this.numCyclesField.setText(Integer.toString(n));
        }

        public String getBillCycleLabel() {
            return this.billMonthChoice.getSelectedItem() + " " + this.billYearField.getText();
        }

        public String getChartTitle() {
            String string = (String)this.dpChoice.getSelectedItem();
            if (this.dpChoice.getSelectedIndex() != 1 && this.dpChoice.getSelectedIndex() != 2) {
                string = string + " (" + (String)this.useCalculatedChoice.getSelectedItem() + ")";
            }
            return string;
        }

        public int getNormalization() {
            int n = 0;
            if (this.normFloorArea.isSelected()) {
                n |= 2;
            }
            if (this.normWeather.isSelected()) {
                n |= 4;
            }
            return n;
        }

        public void setNormalization(int n) {
            this.normFloorArea.setSelected((n & 2) != 0);
            this.normWeather.setSelected((n & 4) != 0);
        }

        public double getNormalTemperature() {
            return this.tempEditor.getValue();
        }

        public void setNormalTemperature(double d) {
            this.tempEditor.setValue(d);
        }

        public BUnit getNormalTemperatureUnit() {
            return this.tempEditor.getUnit();
        }

        public void setNormalTemperatureUnit(BUnit bUnit) {
            this.tempEditor.setUnit(bUnit);
        }

        public String getBaselineBillingCycle() {
            String string = "Jan" + this.baselineBillYearField.getText();
            switch (this.baselineBillMonthChoice.getSelectedIndex()) {
                case 0: {
                    string = "Jan" + this.baselineBillYearField.getText();
                    break;
                }
                case 1: {
                    string = "Feb" + this.baselineBillYearField.getText();
                    break;
                }
                case 2: {
                    string = "Mar" + this.baselineBillYearField.getText();
                    break;
                }
                case 3: {
                    string = "Apr" + this.baselineBillYearField.getText();
                    break;
                }
                case 4: {
                    string = "May" + this.baselineBillYearField.getText();
                    break;
                }
                case 5: {
                    string = "Jun" + this.baselineBillYearField.getText();
                    break;
                }
                case 6: {
                    string = "Jul" + this.baselineBillYearField.getText();
                    break;
                }
                case 7: {
                    string = "Aug" + this.baselineBillYearField.getText();
                    break;
                }
                case 8: {
                    string = "Sep" + this.baselineBillYearField.getText();
                    break;
                }
                case 9: {
                    string = "Oct" + this.baselineBillYearField.getText();
                    break;
                }
                case 10: {
                    string = "Nov" + this.baselineBillYearField.getText();
                    break;
                }
                case 11: {
                    string = "Dec" + this.baselineBillYearField.getText();
                }
            }
            return string;
        }

        public void setBaselineBillingCycle(String string) {
            if (string == null) {
                return;
            }
            String string2 = string.substring(0, 3);
            String string3 = string.substring(3);
            int n = 0;
            if (string2.equals("Jan")) {
                n = 0;
            } else if (string2.equals("Feb")) {
                n = 1;
            } else if (string2.equals("Mar")) {
                n = 2;
            } else if (string2.equals("Apr")) {
                n = 3;
            } else if (string2.equals("May")) {
                n = 4;
            } else if (string2.equals("Jun")) {
                n = 5;
            } else if (string2.equals("Jul")) {
                n = 6;
            } else if (string2.equals("Aug")) {
                n = 7;
            } else if (string2.equals("Sep")) {
                n = 8;
            } else if (string2.equals("Oct")) {
                n = 9;
            } else if (string2.equals("Nov")) {
                n = 10;
            } else if (string2.equals("Dec")) {
                n = 11;
            }
            this.baselineBillMonthChoice.setSelectedIndex(n);
            this.baselineBillYearField.setText(string3);
        }

        public boolean getApplyBaseline() {
            return this.showBaseline.isSelected();
        }

        public void setApplyBaseline(boolean bl) {
            this.showBaseline.setSelected(bl);
        }

        public void setBaselineColor(int n) {
            this.baselineColorCombo.setSelectedIndex(n);
        }

        public int getBaselineColor() {
            return this.baselineColorCombo.getSelectedIndex();
        }

        public String getBaselineBillCycleLabel() {
            return this.baselineBillMonthChoice.getSelectedItem() + " " + this.baselineBillYearField.getText();
        }
    }
}

