/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.comparison;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.reports.comparison.RateComparisonApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.EasScrollPane;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class RateComparisonDetailPanel
extends JPanel
implements Printable {
    private Font cellFont = null;
    private Font headerFont = null;
    private Font titleFont = null;
    private Font subtitleFont = null;
    private FontMetrics cellFontMetrics;
    private FontMetrics headerFontMetrics;
    private FontMetrics titleFontMetrics;
    private FontMetrics subtitleFontMetrics;
    private EasSession session = null;
    private ResourceManager resourceManager = null;
    private RateComparisonApplication parentApplication = null;
    private Lexicon lex;
    private String title = "";
    private CardLayout layout = null;
    private JPanel reportPanel = null;
    public double overallCost = 0.0;
    public double consumptionCost = 0.0;
    public double demandCost = 0.0;
    public double otherCost = 0.0;
    public double userDef1Cost = 0.0;
    public double userDef2Cost = 0.0;
    public double userDef3Cost = 0.0;
    public double userDef4Cost = 0.0;
    public int myOffset = 0;
    private JLabel userDef1Label;
    private JLabel userDef2Label;
    private JLabel userDef3Label;
    private JLabel userDef4Label;
    private CostTextField userDef1TextField;
    private CostTextField userDef2TextField;
    private CostTextField userDef3TextField;
    private CostTextField userDef4TextField;
    private int currentPage = 0;
    public int pageOffset = 0;
    private Vector labelCostPairs = null;

    protected RateComparisonDetailPanel(ResourceManager resourceManager, RateComparisonApplication rateComparisonApplication, String string, Lexicon lexicon) {
        this.lex = lexicon;
        this.title = string;
        this.resourceManager = resourceManager;
        this.parentApplication = rateComparisonApplication;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add("show", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.add("hide", jPanel2);
        jPanel2.add((Component)this.buildDefaultView(string), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        jPanel3.setBorder(BorderFactory.createTitledBorder(string));
        EasScrollPane easScrollPane = new EasScrollPane(this.buildReconciliationReportPanel());
        easScrollPane.getViewport().setBackground(Color.white);
        jPanel3.add((Component)easScrollPane, "Center");
        jPanel.add((Component)jPanel3, "Center");
        ReconciliationReport reconciliationReport = null;
        this.setReconciliationEditorValue(reconciliationReport, false, true, false, 0);
    }

    private JComponent buildDefaultView(String string) {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        return jPanel;
    }

    private JComponent buildReconciliationReportPanel() {
        this.reportPanel = new JPanel(new GridBagLayout(), false);
        return this.reportPanel;
    }

    private String decodeMeterName(String string) {
        String string2 = "";
        try {
            int n = string.length();
            int n2 = string.lastIndexOf(95);
            if (n2 >= 0) {
                n = n2;
            }
            int n3 = Integer.parseInt(string.substring("meter".length(), n));
            Meter meter = Meter.get(n3, this.getSession());
            string2 = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private void layoutReconciliationReport(ReconciliationReport[] reconciliationReportArray, boolean bl, boolean bl2, int n) {
        this.reportPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        this.overallCost = 0.0;
        this.consumptionCost = 0.0;
        this.demandCost = 0.0;
        this.otherCost = 0.0;
        this.userDef1Cost = 0.0;
        this.userDef2Cost = 0.0;
        this.userDef3Cost = 0.0;
        this.userDef4Cost = 0.0;
        this.myOffset = 0;
        if (reconciliationReportArray != null && reconciliationReportArray.length >= 1) {
            Object object;
            Object object2;
            int n3;
            this.labelCostPairs = new Vector();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            this.reportPanel.add((Component)new JLabel(""), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            JLabel jLabel = new JLabel(this.lex.getText("calculatedCost"), 0);
            this.reportPanel.add((Component)jLabel, gridBagConstraints);
            if (!bl) {
                for (n3 = 1; n3 < n; ++n3) {
                    gridBagConstraints.gridy = n2++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 100.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.anchor = 17;
                    this.reportPanel.add((Component)new JLabel(" "), gridBagConstraints);
                }
            }
            n3 = 0;
            String string = "";
            for (int i = 0; i < reconciliationReportArray.length; ++i) {
                Object object3;
                object2 = reconciliationReportArray[i];
                if (object2 == null || ((ReconciliationReport)object2).getReconciliationRows() == null) continue;
                object = "";
                string = "";
                if (bl2) {
                    n3 = 1;
                    object = this.decodeMeterName(((ReconciliationReport)object2).getName());
                    gridBagConstraints.gridy = n2++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 100.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.anchor = 17;
                    object3 = new JLabel((String)object, 2);
                    ((JComponent)object3).setForeground(Color.blue);
                    this.reportPanel.add((Component)object3, gridBagConstraints);
                    string = "    ";
                    ++this.myOffset;
                    this.labelCostPairs.addElement(new LabelCostPair((JLabel)object3, null, false));
                }
                object3 = ((ReconciliationReport)object2).getReconciliationRows();
                if (bl) {
                    Serializable serializable;
                    Object object4;
                    double d = 0.0;
                    boolean bl3 = false;
                    String string2 = "";
                    for (int j = 0; j < ((ReconciliationRow[])object3).length; ++j) {
                        Serializable serializable2;
                        if (j != 0 && !object3[j].getShowCostColumns()) {
                            gridBagConstraints.gridy = n2++;
                            gridBagConstraints.gridx = 0;
                            gridBagConstraints.weightx = 100.0;
                            gridBagConstraints.weighty = 0.0;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.fill = 1;
                            gridBagConstraints.anchor = 17;
                            object4 = new JLabel(string2 + " " + this.lex.getText("subtotal"), 4);
                            ((JComponent)object4).setForeground(Color.magenta);
                            this.reportPanel.add((Component)object4, gridBagConstraints);
                            gridBagConstraints.gridx = 1;
                            gridBagConstraints.weightx = 0.0;
                            gridBagConstraints.fill = 0;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.weighty = 0.0;
                            gridBagConstraints.anchor = 10;
                            serializable = new CostTextField(9, false);
                            ((JTextField)serializable).setHorizontalAlignment(4);
                            serializable2 = new DecimalFormat(this.lex.getText("costValueFormat"));
                            ((NumberTextField)serializable).setFormatter((DecimalFormat)serializable2);
                            ((NumberTextField)serializable).setMaximumFractionDigits(2);
                            ((EasTextField)serializable).setUseLabelAppearanceWhenDisabled(true);
                            ((NumberTextField)serializable).setText(d);
                            ((JTextComponent)serializable).setEditable(false);
                            this.reportPanel.add((Component)serializable, gridBagConstraints);
                            this.labelCostPairs.addElement(new LabelCostPair((JLabel)object4, (EasTextField)serializable, true));
                            d = 0.0;
                            bl3 = true;
                            string2 = "";
                        }
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = n2++;
                        gridBagConstraints.weightx = 100.0;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.anchor = 17;
                        object4 = ((ReconciliationRow)object3[j]).getShowCostColumns() ? ((ReconciliationRow)object3[j]).getDisplayName(this.lex) : this.lex.getText("rate") + "  " + ((ReconciliationRow)object3[j]).getDisplayName(this.lex);
                        object4 = string + (String)object4;
                        serializable = new JLabel((String)object4);
                        this.reportPanel.add((Component)serializable, gridBagConstraints);
                        if (((ReconciliationRow)object3[j]).getShowCostColumns()) {
                            gridBagConstraints.gridx = 1;
                            gridBagConstraints.weightx = 0.0;
                            gridBagConstraints.fill = 0;
                            gridBagConstraints.gridwidth = 1;
                            gridBagConstraints.weighty = 0.0;
                            gridBagConstraints.anchor = 10;
                            serializable2 = new CostTextField(9, false);
                            ((JTextField)serializable2).setHorizontalAlignment(4);
                            DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
                            ((NumberTextField)serializable2).setFormatter(decimalFormat);
                            ((NumberTextField)serializable2).setMaximumFractionDigits(2);
                            ((EasTextField)serializable2).setUseLabelAppearanceWhenDisabled(true);
                            ((JTextComponent)serializable2).setEditable(false);
                            ((NumberTextField)serializable2).setText(((ReconciliationRow)object3[j]).getCalculatedCost());
                            d += ((ReconciliationRow)object3[j]).getCalculatedCost();
                            switch (((ReconciliationRow)object3[j]).getRateComponent().getCategory()) {
                                case 0: {
                                    this.consumptionCost += ((ReconciliationRow)object3[j]).getCalculatedCost();
                                    break;
                                }
                                case 1: {
                                    this.demandCost += ((ReconciliationRow)object3[j]).getCalculatedCost();
                                    break;
                                }
                                case 2: {
                                    this.otherCost += ((ReconciliationRow)object3[j]).getCalculatedCost();
                                    break;
                                }
                                case 3: {
                                    this.userDef1Cost += ((ReconciliationRow)object3[j]).getCalculatedCost();
                                    break;
                                }
                                case 4: {
                                    this.userDef2Cost += ((ReconciliationRow)object3[j]).getCalculatedCost();
                                    break;
                                }
                                case 5: {
                                    this.userDef3Cost += ((ReconciliationRow)object3[j]).getCalculatedCost();
                                    break;
                                }
                                case 6: {
                                    this.userDef4Cost += ((ReconciliationRow)object3[j]).getCalculatedCost();
                                }
                            }
                            this.reportPanel.add((Component)serializable2, gridBagConstraints);
                            this.labelCostPairs.addElement(new LabelCostPair((JLabel)serializable, (EasTextField)serializable2, false));
                            continue;
                        }
                        string2 = ((ReconciliationRow)object3[j]).getDisplayName(this.lex);
                        this.labelCostPairs.addElement(new LabelCostPair((JLabel)serializable, null, false));
                    }
                    if (bl3) {
                        gridBagConstraints.gridy = n2++;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.weightx = 100.0;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.anchor = 17;
                        JLabel jLabel2 = new JLabel(string2 + " " + this.lex.getText("subtotal"), 4);
                        jLabel2.setForeground(Color.magenta);
                        this.reportPanel.add((Component)jLabel2, gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.anchor = 10;
                        object4 = new CostTextField(9, false);
                        ((JTextField)object4).setHorizontalAlignment(4);
                        serializable = new DecimalFormat(this.lex.getText("costValueFormat"));
                        ((NumberTextField)object4).setFormatter((DecimalFormat)serializable);
                        ((NumberTextField)object4).setMaximumFractionDigits(2);
                        ((EasTextField)object4).setUseLabelAppearanceWhenDisabled(true);
                        ((NumberTextField)object4).setText(d);
                        ((JTextComponent)object4).setEditable(false);
                        this.reportPanel.add((Component)object4, gridBagConstraints);
                        d = 0.0;
                        this.labelCostPairs.addElement(new LabelCostPair(jLabel2, (EasTextField)object4, true));
                    }
                    if (reconciliationReportArray.length > 1) {
                        gridBagConstraints.gridy = n2++;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.weightx = 100.0;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.anchor = 17;
                        JLabel jLabel3 = new JLabel((String)object + " " + this.lex.getText("total"), 4);
                        jLabel3.setForeground(Color.red);
                        this.reportPanel.add((Component)jLabel3, gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.fill = 0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.anchor = 10;
                        object4 = new CostTextField(9, false);
                        ((JTextField)object4).setHorizontalAlignment(4);
                        serializable = new DecimalFormat(this.lex.getText("costValueFormat"));
                        ((NumberTextField)object4).setFormatter((DecimalFormat)serializable);
                        ((NumberTextField)object4).setMaximumFractionDigits(2);
                        ((EasTextField)object4).setUseLabelAppearanceWhenDisabled(true);
                        ((NumberTextField)object4).setText(((ReconciliationReport)object2).getTotalCalculatedCost());
                        ((JTextComponent)object4).setEditable(false);
                        this.reportPanel.add((Component)object4, gridBagConstraints);
                        this.labelCostPairs.addElement(new LabelCostPair(jLabel3, (EasTextField)object4, true));
                    }
                } else {
                    for (int j = 0; j < ((ReconciliationRow[])object3).length; ++j) {
                        if (object3[j].getShowCostColumns()) {
                            switch (object3[j].getRateComponent().getCategory()) {
                                case 0: {
                                    this.consumptionCost += object3[j].getCalculatedCost();
                                    break;
                                }
                                case 1: {
                                    this.demandCost += object3[j].getCalculatedCost();
                                    break;
                                }
                                case 2: {
                                    this.otherCost += object3[j].getCalculatedCost();
                                    break;
                                }
                                case 3: {
                                    this.userDef1Cost += object3[j].getCalculatedCost();
                                    break;
                                }
                                case 4: {
                                    this.userDef2Cost += object3[j].getCalculatedCost();
                                    break;
                                }
                                case 5: {
                                    this.userDef3Cost += object3[j].getCalculatedCost();
                                    break;
                                }
                                case 6: {
                                    this.userDef4Cost += object3[j].getCalculatedCost();
                                }
                            }
                            continue;
                        }
                        n3 = 1;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = n2++;
                        gridBagConstraints.weightx = 100.0;
                        gridBagConstraints.weighty = 0.0;
                        gridBagConstraints.gridwidth = 1;
                        gridBagConstraints.fill = 1;
                        gridBagConstraints.anchor = 17;
                        String string3 = this.lex.getText("rate") + "  " + ((ReconciliationRow)object3[j]).getDisplayName(this.lex);
                        string3 = string + string3;
                        JLabel jLabel4 = new JLabel(string3);
                        this.reportPanel.add((Component)jLabel4, gridBagConstraints);
                        ++this.myOffset;
                        this.labelCostPairs.addElement(new LabelCostPair(jLabel4, null, false));
                    }
                }
                this.overallCost += ((ReconciliationReport)object2).getTotalCalculatedCost();
            }
            if (!bl) {
                if (n3 == 0) {
                    gridBagConstraints.gridy = n2++;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 100.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.anchor = 17;
                    this.reportPanel.add((Component)new JLabel(" "), gridBagConstraints);
                }
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                JLabel jLabel5 = new JLabel(string + "    " + this.lex.getText("Consumption"));
                this.reportPanel.add((Component)jLabel5, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                object2 = new CostTextField(9, false);
                ((JTextField)object2).setHorizontalAlignment(4);
                object = new DecimalFormat(this.lex.getText("costValueFormat"));
                ((NumberTextField)object2).setFormatter((DecimalFormat)object);
                ((NumberTextField)object2).setMaximumFractionDigits(2);
                ((EasTextField)object2).setUseLabelAppearanceWhenDisabled(true);
                ((NumberTextField)object2).setText(this.consumptionCost);
                ((JTextComponent)object2).setEditable(false);
                this.reportPanel.add((Component)object2, gridBagConstraints);
                this.labelCostPairs.addElement(new LabelCostPair(jLabel5, (EasTextField)object2, false));
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                jLabel5 = new JLabel(string + "    " + this.lex.getText("Demand"));
                this.reportPanel.add((Component)jLabel5, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                object2 = new CostTextField(9, false);
                ((JTextField)object2).setHorizontalAlignment(4);
                ((NumberTextField)object2).setFormatter((DecimalFormat)object);
                ((NumberTextField)object2).setMaximumFractionDigits(2);
                ((EasTextField)object2).setUseLabelAppearanceWhenDisabled(true);
                ((NumberTextField)object2).setText(this.demandCost);
                ((JTextComponent)object2).setEditable(false);
                this.reportPanel.add((Component)object2, gridBagConstraints);
                this.labelCostPairs.addElement(new LabelCostPair(jLabel5, (EasTextField)object2, false));
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                jLabel5 = new JLabel(string + "    " + this.lex.getText("Other"));
                this.reportPanel.add((Component)jLabel5, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                object2 = new CostTextField(9, false);
                ((JTextField)object2).setHorizontalAlignment(4);
                ((NumberTextField)object2).setFormatter((DecimalFormat)object);
                ((NumberTextField)object2).setMaximumFractionDigits(2);
                ((EasTextField)object2).setUseLabelAppearanceWhenDisabled(true);
                ((NumberTextField)object2).setText(this.otherCost);
                ((JTextComponent)object2).setEditable(false);
                this.reportPanel.add((Component)object2, gridBagConstraints);
                this.labelCostPairs.addElement(new LabelCostPair(jLabel5, (EasTextField)object2, false));
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.userDef1Label = new JLabel(string + "    " + this.lex.getText("userDefinedComponent1"));
                this.userDef1Label.setVisible(false);
                this.reportPanel.add((Component)this.userDef1Label, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                this.userDef1TextField = new CostTextField(9, false);
                this.userDef1TextField.setVisible(false);
                this.userDef1TextField.setHorizontalAlignment(4);
                this.userDef1TextField.setFormatter((DecimalFormat)object);
                this.userDef1TextField.setMaximumFractionDigits(2);
                this.userDef1TextField.setUseLabelAppearanceWhenDisabled(true);
                this.userDef1TextField.setText(this.userDef1Cost);
                this.userDef1TextField.setEditable(false);
                this.reportPanel.add((Component)this.userDef1TextField, gridBagConstraints);
                this.labelCostPairs.addElement(new LabelCostPair(this.userDef1Label, this.userDef1TextField, false));
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.userDef2Label = new JLabel(string + "    " + this.lex.getText("userDefinedComponent2"));
                this.userDef2Label.setVisible(false);
                this.reportPanel.add((Component)this.userDef2Label, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                this.userDef2TextField = new CostTextField(9, false);
                this.userDef2TextField.setVisible(false);
                this.userDef2TextField.setHorizontalAlignment(4);
                this.userDef2TextField.setFormatter((DecimalFormat)object);
                this.userDef2TextField.setMaximumFractionDigits(2);
                this.userDef2TextField.setUseLabelAppearanceWhenDisabled(true);
                this.userDef2TextField.setText(this.userDef2Cost);
                this.userDef2TextField.setEditable(false);
                this.reportPanel.add((Component)this.userDef2TextField, gridBagConstraints);
                this.labelCostPairs.addElement(new LabelCostPair(this.userDef2Label, this.userDef2TextField, false));
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.userDef3Label = new JLabel(string + "    " + this.lex.getText("userDefinedComponent3"));
                this.userDef3Label.setVisible(false);
                this.reportPanel.add((Component)this.userDef3Label, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                this.userDef3TextField = new CostTextField(9, false);
                this.userDef3TextField.setVisible(false);
                this.userDef3TextField.setHorizontalAlignment(4);
                this.userDef3TextField.setFormatter((DecimalFormat)object);
                this.userDef3TextField.setMaximumFractionDigits(2);
                this.userDef3TextField.setUseLabelAppearanceWhenDisabled(true);
                this.userDef3TextField.setText(this.userDef3Cost);
                this.userDef3TextField.setEditable(false);
                this.reportPanel.add((Component)this.userDef3TextField, gridBagConstraints);
                this.labelCostPairs.addElement(new LabelCostPair(this.userDef3Label, this.userDef3TextField, false));
                gridBagConstraints.gridy = n2++;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                this.userDef4Label = new JLabel(string + "    " + this.lex.getText("userDefinedComponent4"));
                this.userDef4Label.setVisible(false);
                this.reportPanel.add((Component)this.userDef4Label, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                this.userDef4TextField = new CostTextField(9, false);
                this.userDef4TextField.setVisible(false);
                this.userDef4TextField.setHorizontalAlignment(4);
                this.userDef4TextField.setFormatter((DecimalFormat)object);
                this.userDef4TextField.setMaximumFractionDigits(2);
                this.userDef4TextField.setUseLabelAppearanceWhenDisabled(true);
                this.userDef4TextField.setText(this.userDef4Cost);
                this.userDef4TextField.setEditable(false);
                this.reportPanel.add((Component)this.userDef4TextField, gridBagConstraints);
                this.labelCostPairs.addElement(new LabelCostPair(this.userDef4Label, this.userDef4TextField, false));
            }
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            JLabel jLabel6 = new JLabel(this.lex.getText("grandTotal") + "   ", 4);
            jLabel6.setBackground(Color.darkGray);
            jLabel6.setForeground(Color.green);
            jLabel6.setOpaque(true);
            this.reportPanel.add((Component)jLabel6, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            object2 = new CostTextField(9, false);
            ((JTextField)object2).setHorizontalAlignment(4);
            object = new DecimalFormat(this.lex.getText("costValueFormat"));
            ((NumberTextField)object2).setFormatter((DecimalFormat)object);
            ((NumberTextField)object2).setMaximumFractionDigits(2);
            ((EasTextField)object2).setUseLabelAppearanceWhenDisabled(true);
            ((NumberTextField)object2).setText(this.overallCost);
            ((JTextComponent)object2).setEditable(false);
            this.reportPanel.add((Component)object2, gridBagConstraints);
            this.labelCostPairs.addElement(new LabelCostPair(jLabel6, (EasTextField)object2, true));
        }
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        this.reportPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.reportPanel.revalidate();
        this.reportPanel.repaint();
    }

    public static void alignComparisonPanels(RateComparisonDetailPanel rateComparisonDetailPanel, RateComparisonDetailPanel rateComparisonDetailPanel2, boolean bl) {
        if (bl) {
            return;
        }
        if (!(rateComparisonDetailPanel != null && rateComparisonDetailPanel.userDef1Cost != 0.0 || rateComparisonDetailPanel2 != null && rateComparisonDetailPanel2.userDef1Cost != 0.0)) {
            if (rateComparisonDetailPanel != null) {
                try {
                    rateComparisonDetailPanel.userDef1Label.setVisible(false);
                    rateComparisonDetailPanel.userDef1TextField.setVisible(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rateComparisonDetailPanel2 != null) {
                try {
                    rateComparisonDetailPanel2.userDef1Label.setVisible(false);
                    rateComparisonDetailPanel2.userDef1TextField.setVisible(false);
                }
                catch (Exception exception) {}
            }
        } else {
            if (rateComparisonDetailPanel != null) {
                try {
                    rateComparisonDetailPanel.userDef1Label.setVisible(true);
                    rateComparisonDetailPanel.userDef1TextField.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rateComparisonDetailPanel2 != null) {
                try {
                    rateComparisonDetailPanel2.userDef1Label.setVisible(true);
                    rateComparisonDetailPanel2.userDef1TextField.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!(rateComparisonDetailPanel != null && rateComparisonDetailPanel.userDef2Cost != 0.0 || rateComparisonDetailPanel2 != null && rateComparisonDetailPanel2.userDef2Cost != 0.0)) {
            if (rateComparisonDetailPanel != null) {
                try {
                    rateComparisonDetailPanel.userDef2Label.setVisible(false);
                    rateComparisonDetailPanel.userDef2TextField.setVisible(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rateComparisonDetailPanel2 != null) {
                try {
                    rateComparisonDetailPanel2.userDef2Label.setVisible(false);
                    rateComparisonDetailPanel2.userDef2TextField.setVisible(false);
                }
                catch (Exception exception) {}
            }
        } else {
            if (rateComparisonDetailPanel != null) {
                try {
                    rateComparisonDetailPanel.userDef2Label.setVisible(true);
                    rateComparisonDetailPanel.userDef2TextField.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rateComparisonDetailPanel2 != null) {
                try {
                    rateComparisonDetailPanel2.userDef2Label.setVisible(true);
                    rateComparisonDetailPanel2.userDef2TextField.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!(rateComparisonDetailPanel != null && rateComparisonDetailPanel.userDef3Cost != 0.0 || rateComparisonDetailPanel2 != null && rateComparisonDetailPanel2.userDef3Cost != 0.0)) {
            if (rateComparisonDetailPanel != null) {
                try {
                    rateComparisonDetailPanel.userDef3Label.setVisible(false);
                    rateComparisonDetailPanel.userDef3TextField.setVisible(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rateComparisonDetailPanel2 != null) {
                try {
                    rateComparisonDetailPanel2.userDef3Label.setVisible(false);
                    rateComparisonDetailPanel2.userDef3TextField.setVisible(false);
                }
                catch (Exception exception) {}
            }
        } else {
            if (rateComparisonDetailPanel != null) {
                try {
                    rateComparisonDetailPanel.userDef3Label.setVisible(true);
                    rateComparisonDetailPanel.userDef3TextField.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rateComparisonDetailPanel2 != null) {
                try {
                    rateComparisonDetailPanel2.userDef3Label.setVisible(true);
                    rateComparisonDetailPanel2.userDef3TextField.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!(rateComparisonDetailPanel != null && rateComparisonDetailPanel.userDef4Cost != 0.0 || rateComparisonDetailPanel2 != null && rateComparisonDetailPanel2.userDef4Cost != 0.0)) {
            if (rateComparisonDetailPanel != null) {
                try {
                    rateComparisonDetailPanel.userDef4Label.setVisible(false);
                    rateComparisonDetailPanel.userDef4TextField.setVisible(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rateComparisonDetailPanel2 != null) {
                try {
                    rateComparisonDetailPanel2.userDef4Label.setVisible(false);
                    rateComparisonDetailPanel2.userDef4TextField.setVisible(false);
                }
                catch (Exception exception) {}
            }
        } else {
            if (rateComparisonDetailPanel != null) {
                try {
                    rateComparisonDetailPanel.userDef4Label.setVisible(true);
                    rateComparisonDetailPanel.userDef4TextField.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (rateComparisonDetailPanel2 != null) {
                try {
                    rateComparisonDetailPanel2.userDef4Label.setVisible(true);
                    rateComparisonDetailPanel2.userDef4TextField.setVisible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (rateComparisonDetailPanel != null) {
            try {
                rateComparisonDetailPanel.reportPanel.revalidate();
                rateComparisonDetailPanel.reportPanel.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rateComparisonDetailPanel2 != null) {
            try {
                rateComparisonDetailPanel2.reportPanel.revalidate();
                rateComparisonDetailPanel2.reportPanel.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setReconciliationEditorValue(ReconciliationReport reconciliationReport, boolean bl, boolean bl2, boolean bl3, int n) {
        ReconciliationReport[] reconciliationReportArray = null;
        if (reconciliationReport != null) {
            reconciliationReportArray = new ReconciliationReport[]{reconciliationReport};
        }
        this.setReconciliationEditorValue(reconciliationReportArray, bl, bl2, bl3, n);
    }

    public void setReconciliationEditorValue(ReconciliationReport[] reconciliationReportArray, boolean bl, boolean bl2, boolean bl3, int n) {
        this.labelCostPairs = null;
        if (!(reconciliationReportArray != null && reconciliationReportArray.length >= 1 || bl)) {
            this.layout.show(this, "hide");
            this.overallCost = 0.0;
            this.consumptionCost = 0.0;
            this.demandCost = 0.0;
            this.otherCost = 0.0;
            this.userDef1Cost = 0.0;
            this.userDef2Cost = 0.0;
            this.userDef3Cost = 0.0;
            this.userDef4Cost = 0.0;
            this.myOffset = 0;
        } else {
            this.layout.show(this, "show");
            this.layoutReconciliationReport(reconciliationReportArray, bl2, bl3, n);
        }
    }

    protected void init(EasSession easSession) {
        this.session = easSession;
        this.layout.show(this, "hide");
    }

    protected void initApplication() {
        this.parentApplication.initApplication(true);
    }

    protected EasSession getSession() {
        return this.session;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public RateComparisonApplication getParentApplication() {
        return this.parentApplication;
    }

    private Font getCellFont() {
        if (this.cellFont == null) {
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            hashMap.put(TextAttribute.FAMILY, Theme.widget().getTextFont().getName());
            hashMap.put(TextAttribute.SIZE, new Float(10.0f));
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            this.cellFont = new Font(hashMap);
        }
        return this.cellFont;
    }

    private Font getHeaderFont() {
        if (this.headerFont == null) {
            this.headerFont = this.getCellFont().deriveFont(1);
        }
        return this.headerFont;
    }

    private Font getTitleFont() {
        if (this.titleFont == null) {
            this.titleFont = this.getCellFont().deriveFont(1, 14.0f);
        }
        return this.titleFont;
    }

    private Font getSubtitleFont() {
        if (this.subtitleFont == null) {
            this.subtitleFont = this.getCellFont().deriveFont(12.0f);
        }
        return this.subtitleFont;
    }

    private FontMetrics getCellFontMetrics() {
        if (this.cellFontMetrics == null) {
            this.cellFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getCellFont());
        }
        return this.cellFontMetrics;
    }

    private FontMetrics getHeaderFontMetrics() {
        if (this.headerFontMetrics == null) {
            this.headerFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getHeaderFont());
        }
        return this.headerFontMetrics;
    }

    private FontMetrics getTitleFontMetrics() {
        if (this.titleFontMetrics == null) {
            this.titleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getTitleFont());
        }
        return this.titleFontMetrics;
    }

    private FontMetrics getSubtitleFontMetrics() {
        if (this.subtitleFontMetrics == null) {
            this.subtitleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getSubtitleFont());
        }
        return this.subtitleFontMetrics;
    }

    private double calculatePreferredColumnWidth(int n) {
        int n2 = 0;
        if (n == 1) {
            n2 = this.getHeaderFontMetrics().stringWidth(this.lex.getText("calculatedCost"));
        }
        if (this.labelCostPairs != null && this.labelCostPairs.size() > 0) {
            for (int i = 0; i < this.labelCostPairs.size(); ++i) {
                LabelCostPair labelCostPair = (LabelCostPair)this.labelCostPairs.elementAt(i);
                if (labelCostPair == null || !labelCostPair.label.isVisible()) continue;
                String string = "";
                switch (n) {
                    case 0: {
                        string = labelCostPair.label.getText();
                        break;
                    }
                    case 1: {
                        string = labelCostPair.textField != null ? labelCostPair.textField.getText() : "";
                    }
                }
                n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string));
            }
        }
        return n2 + 7;
    }

    private ArrayList filterLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (!stringTokenizer.hasMoreTokens()) {
            arrayList.add(string);
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private ArrayList getCellLines(String string, FontMetrics fontMetrics, double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = this.filterLines(string);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if ((double)fontMetrics.stringWidth(string2) <= d) {
                arrayList.add(string2);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                StringBuffer stringBuffer2 = new StringBuffer().append(stringBuffer.toString());
                String string4 = stringBuffer.length() == 0 ? "" : " ";
                if ((double)fontMetrics.stringWidth(stringBuffer2.append(string4).append(string3).toString()) > d) {
                    if (stringBuffer.length() == 0) {
                        stringBuffer = new StringBuffer(string3);
                        while ((double)fontMetrics.stringWidth(stringBuffer.toString()) > d) {
                            StringBuffer stringBuffer3 = new StringBuffer();
                            while ((double)fontMetrics.stringWidth(stringBuffer3.toString()) <= d) {
                                stringBuffer3.append(stringBuffer.charAt(0));
                                stringBuffer.deleteCharAt(0);
                            }
                            arrayList.add(stringBuffer3.toString());
                        }
                        continue;
                    }
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string3);
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string3);
            }
            if (stringBuffer.length() <= 0) continue;
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public int getEstimateNumPages() {
        return this.currentPage + 1;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        int n3;
        Object object;
        int n4;
        Object object2;
        n -= this.pageOffset;
        this.currentPage = 0;
        if (this.labelCostPairs == null || this.labelCostPairs.size() < 1) {
            this.currentPage = -1;
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n5 = 3;
        int n6 = 1;
        int n7 = 0;
        int n8 = (int)pageFormat.getImageableWidth();
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getTitleFont());
        ArrayList arrayList = this.getCellLines(this.title, this.getTitleFontMetrics(), n8);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            int n9 = this.getTitleFontMetrics().stringWidth((String)object2);
            int n10 = n8 / 2 - n9 / 2;
            int n11 = n7 + n5 + this.getTitleFontMetrics().getHeight() - this.getTitleFontMetrics().getDescent();
            if (this.currentPage == n) {
                graphics2D.drawString((String)object2, n10, n11);
            }
            n7 += n5 + this.getTitleFontMetrics().getHeight();
        }
        int n12 = n7 += n5 + this.getSubtitleFontMetrics().getHeight();
        graphics2D.setFont(this.getHeaderFont());
        object2 = new Color(153, 153, 153);
        graphics2D.setColor((Color)object2);
        double d = this.calculatePreferredColumnWidth(0);
        double d2 = this.calculatePreferredColumnWidth(1);
        double d3 = d;
        double d4 = d2;
        ArrayList arrayList2 = this.getCellLines(this.lex.getText("calculatedCost"), this.getHeaderFontMetrics(), n8);
        for (n4 = 0; n4 < arrayList2.size(); ++n4) {
            object = (String)arrayList2.get(n4);
            n3 = this.getHeaderFontMetrics().stringWidth((String)object);
            n2 = (int)(d3 + d4 / 2.0 - (double)(n3 / 2));
            int n13 = n7 + n5 + (n4 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n13 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n7 = 0;
                n13 = n7 + n5 + (n4 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString((String)object, n2, n13);
        }
        n7 += this.getHeaderFontMetrics().getHeight() * arrayList2.size() + n5 + n5 + n6;
        graphics2D.setFont(this.getCellFont());
        for (n4 = 0; n4 < this.labelCostPairs.size(); ++n4) {
            int n14;
            int n15;
            int n16;
            object = (LabelCostPair)this.labelCostPairs.elementAt(n4);
            if (object == null || !((LabelCostPair)object).label.isVisible()) continue;
            if (((LabelCostPair)object).isGray) {
                graphics2D.setColor((Color)object2);
            } else {
                graphics2D.setColor(Color.black);
            }
            n3 = 0;
            n2 = (int)(d - (double)n5 - (double)n5 - (double)n6);
            d3 = 0.0;
            ArrayList arrayList3 = this.getCellLines(((LabelCostPair)object).label.getText(), this.getCellFontMetrics(), n2);
            for (n16 = 0; n16 < arrayList3.size(); ++n16) {
                String string = (String)arrayList3.get(n16);
                int n17 = this.getCellFontMetrics().stringWidth(string);
                n15 = (int)(d3 + (double)n5);
                n14 = n7 + n5 + (n16 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n14 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n7 = 0;
                    n14 = n7 + n5 + (n16 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string, n15, n14);
            }
            n16 = this.getCellFontMetrics().getHeight() * arrayList3.size() + n5 + n5 + n6;
            n3 = Math.max(n16, n3);
            if (((LabelCostPair)object).textField != null) {
                graphics2D.setColor(Color.black);
                d3 += d;
                n2 = (int)(d2 - (double)n5 - (double)n5 - (double)n6);
                arrayList3 = this.getCellLines(((LabelCostPair)object).textField.getText(), this.getCellFontMetrics(), n2);
                for (int i = 0; i < arrayList3.size(); ++i) {
                    String string = (String)arrayList3.get(i);
                    n15 = this.getCellFontMetrics().stringWidth(string);
                    n14 = (int)(d3 + d2 - (double)n5 - (double)n15);
                    int n18 = n7 + n5 + (i + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    if ((double)n18 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n7 = 0;
                        n18 = n7 + n5 + (i + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    }
                    if (this.currentPage != n) continue;
                    graphics2D.drawString(string, n14, n18);
                }
                n16 = this.getCellFontMetrics().getHeight() * arrayList3.size() + n5 + n5 + n6;
                n3 = Math.max(n16, n3);
            }
            n7 += n3;
        }
        if (this.currentPage < n) {
            return 1;
        }
        return 0;
    }

    private class LabelCostPair {
        public JLabel label = null;
        public EasTextField textField = null;
        public boolean isGray = false;

        public LabelCostPair(JLabel jLabel, EasTextField easTextField, boolean bl) {
            this.label = jLabel;
            this.textField = easTextField;
            this.isGray = bl;
        }
    }
}

