/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.comparison;

import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.cost.datatypes.RateBillingPeriod;
import com.tridium.eas.cost.datatypes.TimePeriods;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.FilterRateDialog;
import com.tridium.eas.cost.ui.RateList;
import com.tridium.eas.cost.ui.RateListParentPanel;
import com.tridium.eas.cost.ui.linking.RateLinkDbObjectValidator;
import com.tridium.eas.cost.ui.reports.comparison.RateComparisonDetailPanel;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.DateEditor;
import com.tridium.eas.ui.widgets.DynamicGroupFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.EasTimeEditor;
import com.tridium.eas.ui.widgets.EasToggleButton;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import com.tridium.eas.ui.widgets.XpComboBox;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class RateComparisonApplication
extends EasApplication
implements RateListParentPanel,
ResourceManager,
TreeSelectionListener,
ActionListener,
Printable {
    private Font cellFont = null;
    private Font headerFont = null;
    private Font titleFont = null;
    private Font subtitleFont = null;
    private FontMetrics cellFontMetrics;
    private FontMetrics headerFontMetrics;
    private FontMetrics titleFontMetrics;
    private FontMetrics subtitleFontMetrics;
    public static final String DEFAULT_RECONCILIATION_PREFIX = "meter";
    private boolean initializingBillValues = false;
    private MeterTreePanel meters;
    private RateList rates = null;
    private ReconciliationReport[] currentReconciliations;
    private ReconciliationReport[] reconciliations = null;
    private RateComparisonDetailPanel attachedRateDetails = null;
    private RateComparisonDetailPanel alternateRateDetails = null;
    private JSplitPane meterDateSplit = null;
    private JButton refreshButton;
    private JButton printButton;
    private JButton filterButton;
    private JLabel rateFilterLabel;
    private JPanel mainSplit;
    private Filter currentFilter;
    private FilterTree tree;
    private XpComboBox filterSelection;
    private EasComboBox billMonthComboBox;
    private EasTextField billYearTextField;
    private NumberTextField numCyclesField;
    private JPanel billingPeriodsPanel;
    private JButton runButton;
    private boolean billingPeriodChanged = false;
    private boolean reportRunning = false;
    private EasComboBox alternateBillMonthComboBox;
    private EasTextField alternateBillYearTextField;
    private DateEditor alternateStartEditor;
    private EasTimeEditor alternateStartTimeEditor;
    private EasComboBox alternateBillingCycleComboBox;
    private NumberTextField alternateBillingCycleTextField;
    private EasComboBox aggregateApproachComboBox;
    private RateHistory currentAlternateRateHistory;
    private ReconciliationReport currentAlternateReconciliation;
    private JToggleButton expandView;
    private JToggleButton showDetails;
    private JPanel metersPane;
    private JPanel ratesPane;
    private JLabel grandTotalDifference;
    private JLabel consumptionDifference;
    private JLabel demandDifference;
    private JLabel otherDifference;
    private JLabel userDef1Difference;
    private JLabel userDef2Difference;
    private JLabel userDef3Difference;
    private JLabel userDef4Difference;
    private JLabel userDef1Label;
    private JLabel userDef2Label;
    private JLabel userDef3Label;
    private JLabel userDef4Label;
    private int currentPage = 0;
    private static final DecimalFormat percentFormat = new DecimalFormat("#0.0%");

    public String getName() {
        Lexicon lexicon = BEasApplet.lex;
        return lexicon.getText("rateComparison");
    }

    public String getId() {
        return "rateComparison";
    }

    public final void initApplication(boolean bl) {
        this.initApplication(bl, true);
    }

    public final void initApplication(boolean bl, boolean bl2) {
        if (bl) {
            Lexicon lexicon = BEasApplet.lex;
            this.initFilters();
            this.updateFilter();
            this.rates.init(this.getSession());
            this.rates.refreshData(bl2);
            this.rates.setEnabled(true);
            this.attachedRateDetails.init(this.getSession());
            this.alternateRateDetails.init(this.getSession());
            if (this.meterDateSplit != null) {
                this.meterDateSplit.setDividerLocation(0.5);
            }
        }
    }

    protected void startApplication() {
        super.startApplication();
        if (this.meterDateSplit != null) {
            this.meterDateSplit.setDividerLocation(0.5);
        }
        if (globalConsecutiveBillCycles > -1) {
            this.numCyclesField.setText(String.valueOf(globalConsecutiveBillCycles));
        }
        if (globalBillPeriodMonth > -1) {
            this.billMonthComboBox.setSelectedIndex(globalBillPeriodMonth);
        }
        if (globalBillPeriodYear != null) {
            this.billYearTextField.setText(globalBillPeriodYear);
        }
    }

    protected void stopApplication() {
        super.stopApplication();
        globalBillPeriodMonth = this.billMonthComboBox.getSelectedIndex();
        globalBillPeriodYear = this.billYearTextField.getText();
        globalConsecutiveBillCycles = this.numCyclesField.getIntValue();
    }

    protected JComponent getApplicationToolBar() {
        return this.getApplicationToolBar(new int[]{17, 28, 19, 22});
    }

    protected JComponent getApplicationToolBar(int[] nArray) {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        Lexicon lexicon = BEasApplet.lex;
        block6: for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 17: {
                    this.refreshButton = new EasButton((ResourceManager)this, 17, lexicon.getText("refresh"));
                    this.refreshButton.addActionListener(this);
                    jToolBar.add(this.refreshButton);
                    continue block6;
                }
                case 28: {
                    this.printButton = new EasButton((ResourceManager)this, 28, lexicon.getText("print"));
                    this.printButton.addActionListener(this);
                    jToolBar.add(this.printButton);
                    continue block6;
                }
                case 19: {
                    this.expandView = new EasToggleButton(this, 19, lexicon.getText("toggleTree"));
                    this.expandView.addActionListener(this);
                    jToolBar.add(this.expandView);
                    continue block6;
                }
                case 22: {
                    this.showDetails = new EasToggleButton(this, 22, lexicon.getText("showDetails"));
                    this.showDetails.addActionListener(this);
                    jToolBar.add(this.showDetails);
                }
            }
        }
        return jToolBar;
    }

    protected JComponent getApplicationContent() {
        this.queueIconImage("/com/tridium/eas/cost/ui/images/comboPerFee.png", 301);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/demandCharge.png", 302);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/flatFee.png", 303);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/flatFeePerUnit.png", 304);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/historicalRatchet.png", 316);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/ratchet.png", 305);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/rate.png", 306);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/schedule.png", 307);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/compositeSchedule.png", 308);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/intersectionSchedule.png", 309);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/unionSchedule.png", 310);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/filter.png", 311);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/startTime.png", 312);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/endTime.png", 313);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/arrowUp.png", 314);
        this.queueIconImage("/com/tridium/eas/cost/ui/images/arrowDown.png", 315);
        if (this.mainSplit == null) {
            this.initializingBillValues = true;
            Lexicon lexicon = BEasApplet.lex;
            this.mainSplit = new JPanel(new BorderLayout(), false);
            this.add((Component)this.mainSplit, "Center");
            this.meterDateSplit = new JSplitPane(0);
            this.meterDateSplit.setDividerSize(4);
            this.meterDateSplit.setTopComponent(this.buildAvailableMetersContents(lexicon));
            this.meterDateSplit.setBottomComponent(this.buildBillDateContents(lexicon));
            this.metersPane = new JPanel(new BorderLayout(), false);
            this.metersPane.setBorder(BorderFactory.createTitledBorder(lexicon.getText("selectMeter")));
            this.metersPane.add((Component)this.meterDateSplit, "Center");
            this.mainSplit.add((Component)this.metersPane, "West");
            this.mainSplit.add((Component)this.buildBillDetailContent(lexicon), "Center");
            this.ratesPane = new JPanel(new BorderLayout(), false);
            this.ratesPane.setBorder(BorderFactory.createTitledBorder(lexicon.getText("selectAlternateRate")));
            this.ratesPane.add((Component)this.buildAvailableRatesContents(lexicon), "Center");
            this.mainSplit.add((Component)this.ratesPane, "East");
            JPanel jPanel = new JPanel(new FlowLayout(1), false);
            this.runButton = new JButton(lexicon.getText("runReport"));
            this.runButton.setEnabled(true);
            this.runButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!RateComparisonApplication.this.reportRunning) {
                        RunReportThread runReportThread = new RunReportThread();
                        runReportThread.start();
                    }
                }
            });
            jPanel.add(this.runButton);
            this.mainSplit.add((Component)jPanel, "South");
            this.initializingBillValues = false;
        }
        return this.mainSplit;
    }

    private JComponent buildAvailableRatesContents(Lexicon lexicon) {
        this.rates = new RateList(this);
        this.rates.setRateEditor(this);
        this.rates.getSelectionModel().setSelectionMode(0);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.filterButton = new EasButton((ResourceManager)this, 311, lexicon.getText("filterRates"));
        this.filterButton.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(0), false);
        jPanel2.add(this.filterButton);
        this.rateFilterLabel = new JLabel(lexicon.getText("allRates"));
        jPanel2.add(this.rateFilterLabel);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(this.rates), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel(lexicon.getText("billPeriod")), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
        int n2 = easLocalTime.getMonth();
        int n3 = easLocalTime.getYear();
        if (n2 == 0) {
            n2 = 11;
            --n3;
        } else {
            --n2;
        }
        this.alternateBillMonthComboBox = new EasComboBox(new String[]{lexicon.getText("january.short"), lexicon.getText("february.short"), lexicon.getText("march.short"), lexicon.getText("april.short"), lexicon.getText("may.short"), lexicon.getText("june.short"), lexicon.getText("july.short"), lexicon.getText("august.short"), lexicon.getText("september.short"), lexicon.getText("october.short"), lexicon.getText("november.short"), lexicon.getText("december.short")});
        this.alternateBillMonthComboBox.setSelectedIndex(n2);
        jPanel4.add((Component)this.alternateBillMonthComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.alternateBillYearTextField = new EasTextField(4, 5);
        this.alternateBillYearTextField.setUseLabelAppearanceWhenDisabled(true);
        this.alternateBillYearTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                RateComparisonApplication.this.alternateBillYearTextField.selectAll();
            }
        });
        this.alternateBillYearTextField.setText(String.valueOf(n3));
        jPanel4.add((Component)this.alternateBillYearTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel(lexicon.getText("billingCycle")), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        this.alternateBillingCycleTextField = new NumberTextField(3, true);
        this.alternateBillingCycleTextField.setAllowNegative(false);
        this.alternateBillingCycleTextField.setUseLabelAppearanceWhenDisabled(true);
        this.alternateBillingCycleTextField.setText("1");
        jPanel4.add((Component)this.alternateBillingCycleTextField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.alternateBillingCycleComboBox = new EasComboBox(new String[]{lexicon.getText("numMinutes"), lexicon.getText("numHours"), lexicon.getText("numDays"), lexicon.getText("numWeeks"), lexicon.getText("numMonths"), lexicon.getText("numYears")});
        this.alternateBillingCycleComboBox.setSelectedIndex(4);
        jPanel4.add((Component)this.alternateBillingCycleComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel(lexicon.getText("billingCycleStart")), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.alternateStartEditor = new DateEditor(lexicon);
        this.alternateStartTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.getResourceManager().getIconImage(312)), new ImageIcon(this.getResourceManager().getIconImage(313)));
        this.alternateStartEditor.setAllowFuture(true);
        jPanel4.add((Component)this.alternateStartEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel4.add((Component)this.alternateStartTimeEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel(" "), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel(lexicon.getText("alternateApproach")), gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.aggregateApproachComboBox = new EasComboBox(new String[]{lexicon.getText("aggApplyApproach"), lexicon.getText("applyAggApproach")});
        this.aggregateApproachComboBox.setSelectedIndex(0);
        jPanel4.add((Component)this.aggregateApproachComboBox, gridBagConstraints);
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)new JScrollPane(jPanel4), "South");
        return jPanel3;
    }

    private JComponent buildBillDateContents(Lexicon lexicon) {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(lexicon.getText("billPeriod")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        EasLocalTime easLocalTime = EasLocalTime.getCurrentTime();
        int n2 = easLocalTime.getMonth();
        int n3 = easLocalTime.getYear();
        if (n2 == 0) {
            n2 = 11;
            --n3;
        } else {
            --n2;
        }
        this.billMonthComboBox = new EasComboBox(new String[]{lexicon.getText("january.short"), lexicon.getText("february.short"), lexicon.getText("march.short"), lexicon.getText("april.short"), lexicon.getText("may.short"), lexicon.getText("june.short"), lexicon.getText("july.short"), lexicon.getText("august.short"), lexicon.getText("september.short"), lexicon.getText("october.short"), lexicon.getText("november.short"), lexicon.getText("december.short")});
        this.billMonthComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateComparisonApplication.this.initializingBillValues) {
                    return;
                }
                RateComparisonApplication.this.loadReconciliationReport(false);
            }
        });
        this.billMonthComboBox.setSelectedIndex(n2);
        jPanel2.add((Component)this.billMonthComboBox.getPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.billYearTextField = new EasTextField(4, 5);
        this.billYearTextField.setUseLabelAppearanceWhenDisabled(true);
        this.billYearTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateComparisonApplication.this.initializingBillValues) {
                    return;
                }
                RateComparisonApplication.this.billingPeriodChanged = true;
            }
        });
        this.billYearTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && RateComparisonApplication.this.billingPeriodChanged) {
                    RateComparisonApplication.this.billingPeriodChanged = false;
                    RateComparisonApplication.this.loadReconciliationReport(false);
                }
            }
        });
        this.billYearTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                RateComparisonApplication.this.billYearTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                if (RateComparisonApplication.this.billingPeriodChanged) {
                    RateComparisonApplication.this.billingPeriodChanged = false;
                    RateComparisonApplication.this.loadReconciliationReport(false);
                }
            }
        });
        this.billYearTextField.setText(String.valueOf(n3));
        jPanel2.add((Component)this.billYearTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)new JLabel(lexicon.getText("consecutiveBillingCycles")), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.numCyclesField = new NumberTextField(3, true);
        this.numCyclesField.setAllowNegative(false);
        this.numCyclesField.setUseLabelAppearanceWhenDisabled(true);
        this.numCyclesField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateComparisonApplication.this.initializingBillValues) {
                    return;
                }
                RateComparisonApplication.this.billingPeriodChanged = true;
            }
        });
        this.numCyclesField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && RateComparisonApplication.this.billingPeriodChanged) {
                    RateComparisonApplication.this.billingPeriodChanged = false;
                    RateComparisonApplication.this.loadReconciliationReport(false);
                }
            }
        });
        this.numCyclesField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                RateComparisonApplication.this.billYearTextField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                if (RateComparisonApplication.this.billingPeriodChanged) {
                    RateComparisonApplication.this.billingPeriodChanged = false;
                    RateComparisonApplication.this.loadReconciliationReport(false);
                }
            }
        });
        this.numCyclesField.setText("1");
        jPanel2.add((Component)this.numCyclesField, gridBagConstraints);
        jPanel.add((Component)jPanel2, "North");
        this.billingPeriodsPanel = new JPanel(new GridBagLayout(), false);
        jPanel.add((Component)new JScrollPane(this.billingPeriodsPanel), "Center");
        return jPanel;
    }

    private String decodeMeterName(String string) {
        String string2 = "";
        try {
            int n = string.length();
            int n2 = string.lastIndexOf(95);
            if (n2 >= 0) {
                n = n2;
            }
            int n3 = Integer.parseInt(string.substring(DEFAULT_RECONCILIATION_PREFIX.length(), n));
            Meter meter = Meter.get(n3, this.getSession());
            string2 = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private void layoutBillingPeriods(ReconciliationReport[] reconciliationReportArray) {
        this.billingPeriodsPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        if (reconciliationReportArray != null) {
            Lexicon lexicon = BEasApplet.lex;
            for (int i = 0; i < reconciliationReportArray.length; ++i) {
                ReconciliationReport reconciliationReport = reconciliationReportArray[i];
                if (reconciliationReport == null || reconciliationReport.getRateBillingPeriods() == null) continue;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                JPanel jPanel = new JPanel(new BorderLayout(), false);
                jPanel.setBorder(BorderFactory.createTitledBorder(this.decodeMeterName(reconciliationReport.getName())));
                this.billingPeriodsPanel.add((Component)jPanel, gridBagConstraints);
                JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
                int n2 = 0;
                RateBillingPeriod[] rateBillingPeriodArray = reconciliationReport.getRateBillingPeriods();
                for (int j = 0; j < rateBillingPeriodArray.length; ++j) {
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n2++;
                    gridBagConstraints.weightx = 100.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.anchor = 17;
                    JPanel jPanel3 = new JPanel(new BorderLayout(), false);
                    jPanel3.setBorder(BorderFactory.createTitledBorder(rateBillingPeriodArray[j].getName()));
                    jPanel2.add((Component)jPanel3, gridBagConstraints);
                    JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
                    gridBagConstraints.gridy = 1;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel4.add((Component)new JLabel(lexicon.getText("start")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    DateEditor dateEditor = new DateEditor(lexicon);
                    EasTimeEditor easTimeEditor = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.getResourceManager().getIconImage(312)), new ImageIcon(this.getResourceManager().getIconImage(313)));
                    dateEditor.setAllowFuture(true);
                    dateEditor.setValue(new EasLocalTime(rateBillingPeriodArray[j].getStartTime(), CostTimeUtil.DEFAULT_TZ));
                    Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                    calendar.setTime(new Date(rateBillingPeriodArray[j].getStartTime()));
                    easTimeEditor.setValues(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
                    jPanel4.add((Component)dateEditor, gridBagConstraints);
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel4.add((Component)easTimeEditor, gridBagConstraints);
                    dateEditor.setEditable(false);
                    easTimeEditor.setEditable(false);
                    gridBagConstraints.gridy = 2;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.anchor = 17;
                    jPanel4.add((Component)new JLabel(lexicon.getText("end")), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    DateEditor dateEditor2 = new DateEditor(lexicon);
                    EasTimeEditor easTimeEditor2 = new EasTimeEditor(true, 0, 0, 0, 0, new ImageIcon(this.getResourceManager().getIconImage(312)), new ImageIcon(this.getResourceManager().getIconImage(313)));
                    dateEditor2.setAllowFuture(true);
                    dateEditor2.setValue(new EasLocalTime(rateBillingPeriodArray[j].getEndTime(), CostTimeUtil.DEFAULT_TZ));
                    calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                    calendar.setTime(new Date(rateBillingPeriodArray[j].getEndTime()));
                    easTimeEditor2.setValues(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
                    jPanel4.add((Component)dateEditor2, gridBagConstraints);
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    jPanel4.add((Component)easTimeEditor2, gridBagConstraints);
                    dateEditor2.setEditable(false);
                    easTimeEditor2.setEditable(false);
                    gridBagConstraints.gridy = 3;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.gridwidth = 3;
                    gridBagConstraints.anchor = 10;
                    gridBagConstraints.fill = 0;
                    JButton jButton = new JButton(lexicon.getText("applyToAlternate"));
                    jButton.setEnabled(true);
                    jButton.addActionListener(new ApplyAlternateActionListener(dateEditor, easTimeEditor, dateEditor2, easTimeEditor2));
                    jPanel4.add((Component)jButton, gridBagConstraints);
                    jPanel3.add((Component)jPanel4, "Center");
                }
                jPanel.add((Component)jPanel2, "Center");
            }
        }
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        this.billingPeriodsPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.billingPeriodsPanel.revalidate();
        this.billingPeriodsPanel.repaint();
    }

    private JComponent buildAvailableMetersContents(Lexicon lexicon) {
        this.meters = new MeterTreePanel();
        return this.meters;
    }

    private JComponent buildBillDetailContent(Lexicon lexicon) {
        this.attachedRateDetails = new RateComparisonDetailPanel(this, this, lexicon.getText("attachedRate"), lexicon);
        this.alternateRateDetails = new RateComparisonDetailPanel(this, this, lexicon.getText("alternateRate"), lexicon);
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 50.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.attachedRateDetails, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.alternateRateDetails, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        jPanel3.setBorder(BorderFactory.createTitledBorder(lexicon.getText("deltaCost")));
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        jPanel4.add((Component)new JLabel(lexicon.getText("grandTotal") + " " + lexicon.getText("deltaCost"), 2), gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 0;
        this.grandTotalDifference = new JLabel("0.00", 4);
        jPanel4.add((Component)this.grandTotalDifference, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 0;
        jPanel4.add((Component)new JLabel("      "), gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        jPanel4.add((Component)new JLabel(lexicon.getText("Consumption") + " " + lexicon.getText("deltaCost"), 2), gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 0;
        this.consumptionDifference = new JLabel("0.00", 4);
        jPanel4.add((Component)this.consumptionDifference, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        jPanel4.add((Component)new JLabel(lexicon.getText("Demand") + " " + lexicon.getText("deltaCost"), 2), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 0;
        this.demandDifference = new JLabel("0.00", 4);
        jPanel4.add((Component)this.demandDifference, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        jPanel4.add((Component)new JLabel(lexicon.getText("Other") + " " + lexicon.getText("deltaCost"), 2), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 0;
        this.otherDifference = new JLabel("0.00", 4);
        jPanel4.add((Component)this.otherDifference, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        this.userDef1Label = new JLabel(lexicon.getText("userDefinedComponent1") + " " + lexicon.getText("deltaCost"), 2);
        this.userDef1Label.setVisible(false);
        jPanel4.add((Component)this.userDef1Label, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 0;
        this.userDef1Difference = new JLabel("0.00", 4);
        this.userDef1Difference.setVisible(false);
        jPanel4.add((Component)this.userDef1Difference, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        this.userDef2Label = new JLabel(lexicon.getText("userDefinedComponent2") + " " + lexicon.getText("deltaCost"), 2);
        this.userDef2Label.setVisible(false);
        jPanel4.add((Component)this.userDef2Label, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 0;
        this.userDef2Difference = new JLabel("0.00", 4);
        this.userDef2Difference.setVisible(false);
        jPanel4.add((Component)this.userDef2Difference, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        this.userDef3Label = new JLabel(lexicon.getText("userDefinedComponent3") + " " + lexicon.getText("deltaCost"), 2);
        this.userDef3Label.setVisible(false);
        jPanel4.add((Component)this.userDef3Label, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 0;
        this.userDef3Difference = new JLabel("0.00", 4);
        this.userDef3Difference.setVisible(false);
        jPanel4.add((Component)this.userDef3Difference, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 10;
        this.userDef4Label = new JLabel(lexicon.getText("userDefinedComponent4") + " " + lexicon.getText("deltaCost"), 2);
        this.userDef4Label.setVisible(false);
        jPanel4.add((Component)this.userDef4Label, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.ipadx = 0;
        this.userDef4Difference = new JLabel("0.00", 4);
        this.userDef4Difference.setVisible(false);
        jPanel4.add((Component)this.userDef4Difference, gridBagConstraints);
        jPanel3.add((Component)jPanel4, "Center");
        return jPanel2;
    }

    private void loadReconciliationReport(boolean bl) {
        int n;
        if (this.attachedRateDetails == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.initializingBillValues = true;
        Vector<ReconciliationReport> vector = new Vector<ReconciliationReport>();
        Object[] objectArray = this.tree.getSelectedUserObjects();
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                Object object;
                Object object2;
                EasObject easObject;
                Object object3 = objectArray[n];
                if (object3 != null && object3 instanceof Meter) {
                    easObject = (Meter)object3;
                    if (easObject == null) continue;
                    Object object4 = object2 = DEFAULT_RECONCILIATION_PREFIX + easObject.getId();
                    object = "Jan" + this.billYearTextField.getText();
                    switch (this.billMonthComboBox.getSelectedIndex()) {
                        case 0: {
                            object4 = (String)object2 + "_Jan" + this.billYearTextField.getText();
                            object = "Jan" + this.billYearTextField.getText();
                            break;
                        }
                        case 1: {
                            object4 = (String)object2 + "_Feb" + this.billYearTextField.getText();
                            object = "Feb" + this.billYearTextField.getText();
                            break;
                        }
                        case 2: {
                            object4 = (String)object2 + "_Mar" + this.billYearTextField.getText();
                            object = "Mar" + this.billYearTextField.getText();
                            break;
                        }
                        case 3: {
                            object4 = (String)object2 + "_Apr" + this.billYearTextField.getText();
                            object = "Apr" + this.billYearTextField.getText();
                            break;
                        }
                        case 4: {
                            object4 = (String)object2 + "_May" + this.billYearTextField.getText();
                            object = "May" + this.billYearTextField.getText();
                            break;
                        }
                        case 5: {
                            object4 = (String)object2 + "_Jun" + this.billYearTextField.getText();
                            object = "Jun" + this.billYearTextField.getText();
                            break;
                        }
                        case 6: {
                            object4 = (String)object2 + "_Jul" + this.billYearTextField.getText();
                            object = "Jul" + this.billYearTextField.getText();
                            break;
                        }
                        case 7: {
                            object4 = (String)object2 + "_Aug" + this.billYearTextField.getText();
                            object = "Aug" + this.billYearTextField.getText();
                            break;
                        }
                        case 8: {
                            object4 = (String)object2 + "_Sep" + this.billYearTextField.getText();
                            object = "Sep" + this.billYearTextField.getText();
                            break;
                        }
                        case 9: {
                            object4 = (String)object2 + "_Oct" + this.billYearTextField.getText();
                            object = "Oct" + this.billYearTextField.getText();
                            break;
                        }
                        case 10: {
                            object4 = (String)object2 + "_Nov" + this.billYearTextField.getText();
                            object = "Nov" + this.billYearTextField.getText();
                            break;
                        }
                        case 11: {
                            object4 = (String)object2 + "_Dec" + this.billYearTextField.getText();
                            object = "Dec" + this.billYearTextField.getText();
                        }
                    }
                    vector.addElement(this.loadMeterReport((String)object2, (String)object4, (String)object, bl));
                    continue;
                }
                if (object3 == null || !(object3 instanceof Site)) continue;
                easObject = (Site)object3;
                object2 = null;
                try {
                    object2 = ((Site)easObject).getMeters();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (object2 == null) continue;
                for (int i = 0; i < ((Meter[])object2).length; ++i) {
                    String string;
                    object = object2[i];
                    if (object == null) continue;
                    String string2 = string = DEFAULT_RECONCILIATION_PREFIX + ((EasObject)object).getId();
                    String string3 = "Jan" + this.billYearTextField.getText();
                    switch (this.billMonthComboBox.getSelectedIndex()) {
                        case 0: {
                            string2 = string + "_Jan" + this.billYearTextField.getText();
                            string3 = "Jan" + this.billYearTextField.getText();
                            break;
                        }
                        case 1: {
                            string2 = string + "_Feb" + this.billYearTextField.getText();
                            string3 = "Feb" + this.billYearTextField.getText();
                            break;
                        }
                        case 2: {
                            string2 = string + "_Mar" + this.billYearTextField.getText();
                            string3 = "Mar" + this.billYearTextField.getText();
                            break;
                        }
                        case 3: {
                            string2 = string + "_Apr" + this.billYearTextField.getText();
                            string3 = "Apr" + this.billYearTextField.getText();
                            break;
                        }
                        case 4: {
                            string2 = string + "_May" + this.billYearTextField.getText();
                            string3 = "May" + this.billYearTextField.getText();
                            break;
                        }
                        case 5: {
                            string2 = string + "_Jun" + this.billYearTextField.getText();
                            string3 = "Jun" + this.billYearTextField.getText();
                            break;
                        }
                        case 6: {
                            string2 = string + "_Jul" + this.billYearTextField.getText();
                            string3 = "Jul" + this.billYearTextField.getText();
                            break;
                        }
                        case 7: {
                            string2 = string + "_Aug" + this.billYearTextField.getText();
                            string3 = "Aug" + this.billYearTextField.getText();
                            break;
                        }
                        case 8: {
                            string2 = string + "_Sep" + this.billYearTextField.getText();
                            string3 = "Sep" + this.billYearTextField.getText();
                            break;
                        }
                        case 9: {
                            string2 = string + "_Oct" + this.billYearTextField.getText();
                            string3 = "Oct" + this.billYearTextField.getText();
                            break;
                        }
                        case 10: {
                            string2 = string + "_Nov" + this.billYearTextField.getText();
                            string3 = "Nov" + this.billYearTextField.getText();
                            break;
                        }
                        case 11: {
                            string2 = string + "_Dec" + this.billYearTextField.getText();
                            string3 = "Dec" + this.billYearTextField.getText();
                        }
                    }
                    vector.addElement(this.loadMeterReport(string, string2, string3, bl));
                }
            }
        }
        if (vector == null || vector.size() < 1) {
            this.currentReconciliations = null;
        } else {
            this.currentReconciliations = new ReconciliationReport[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                this.currentReconciliations[n] = (ReconciliationReport)vector.elementAt(n);
            }
        }
        this.attachedRateDetails.setReconciliationEditorValue(this.currentReconciliations, false, this.showDetails.isSelected(), true, 0);
        this.alternateRateDetails.setReconciliationEditorValue(this.currentAlternateReconciliation, false, this.showDetails.isSelected(), false, this.attachedRateDetails.myOffset);
        RateComparisonDetailPanel.alignComparisonPanels(this.attachedRateDetails, this.alternateRateDetails, this.showDetails.isSelected());
        this.layoutBillingPeriods(this.currentReconciliations);
        this.mainSplit.revalidate();
        this.mainSplit.repaint();
        this.initializingBillValues = false;
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runReport() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Lexicon lexicon = BEasApplet.lex;
        ProgressMonitor progressMonitor = new ProgressMonitor(this, lexicon.getText("rateComparisonProgress"), "", 1, 100);
        progressMonitor.setProgress(1);
        progressMonitor.setMillisToDecideToPopup(500);
        try {
            String[] stringArray;
            Object object;
            Object object2;
            ReconciliationReport[] reconciliationReportArray = "Jan" + this.billYearTextField.getText();
            switch (this.billMonthComboBox.getSelectedIndex()) {
                case 0: {
                    reconciliationReportArray = "Jan" + this.billYearTextField.getText();
                    break;
                }
                case 1: {
                    reconciliationReportArray = "Feb" + this.billYearTextField.getText();
                    break;
                }
                case 2: {
                    reconciliationReportArray = "Mar" + this.billYearTextField.getText();
                    break;
                }
                case 3: {
                    reconciliationReportArray = "Apr" + this.billYearTextField.getText();
                    break;
                }
                case 4: {
                    reconciliationReportArray = "May" + this.billYearTextField.getText();
                    break;
                }
                case 5: {
                    reconciliationReportArray = "Jun" + this.billYearTextField.getText();
                    break;
                }
                case 6: {
                    reconciliationReportArray = "Jul" + this.billYearTextField.getText();
                    break;
                }
                case 7: {
                    reconciliationReportArray = "Aug" + this.billYearTextField.getText();
                    break;
                }
                case 8: {
                    reconciliationReportArray = "Sep" + this.billYearTextField.getText();
                    break;
                }
                case 9: {
                    reconciliationReportArray = "Oct" + this.billYearTextField.getText();
                    break;
                }
                case 10: {
                    reconciliationReportArray = "Nov" + this.billYearTextField.getText();
                    break;
                }
                case 11: {
                    reconciliationReportArray = "Dec" + this.billYearTextField.getText();
                }
            }
            int n = this.numCyclesField.getIntValue();
            if (n <= 0) {
                n = 1;
            }
            Vector<ReconciliationReport> vector = new Vector<ReconciliationReport>();
            Vector<String> vector2 = new Vector<String>();
            Object[] objectArray = this.tree.getSelectedUserObjects();
            progressMonitor.setMinimum(1);
            if (objectArray != null) {
                progressMonitor.setMaximum(objectArray.length * n + n + 1);
            } else {
                progressMonitor.setMaximum(2);
            }
            int n2 = 1;
            int n3 = 0;
            boolean bl = false;
            if (objectArray != null) {
                block20: for (int i = 0; i < objectArray.length && !progressMonitor.isCanceled(); ++i) {
                    Meter[] meterArray;
                    Object object3;
                    String string;
                    Object object4;
                    EasObject easObject;
                    object2 = objectArray[i];
                    if (object2 != null && object2 instanceof Meter) {
                        easObject = (Meter)object2;
                        int n4 = easObject.getId();
                        String string2 = DEFAULT_RECONCILIATION_PREFIX + n4;
                        object4 = new ReconciliationReport[n];
                        Object object5 = reconciliationReportArray;
                        string = DEFAULT_RECONCILIATION_PREFIX + easObject.getId();
                        for (int j = 0; j < n && !progressMonitor.isCanceled(); ++j) {
                            object = string + "_" + (String)object5;
                            progressMonitor.setNote((((Meter)easObject).getSite() != null ? ((Meter)easObject).getSite().getName() + ": " : "") + ((Meter)easObject).getName() + " " + RateComparisonApplication.toBillPeriodString((String)object5, lexicon));
                            progressMonitor.setProgress(n2);
                            object4[j] = EasCostClient.runReconciliationReport(this.getSession(), string2, (String)object5, this.loadMeterReport(string, (String)object, (String)object5, true), false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                            object5 = RateComparisonApplication.getNextBillPeriod((String)object5);
                            ++n2;
                        }
                        if (progressMonitor.isCanceled()) break;
                        vector.addElement(ReconciliationReport.consolidateReconciliations((ReconciliationReport[])object4));
                        ++n3;
                        object3 = EasCostClient.retrieveRateHistory(this.getSession(), n4);
                        if (object3 == null || ((RateHistory)object3).getRateLinks() == null || ((RateHistory)object3).getRateLinks().length <= 0) continue;
                        bl = true;
                        vector2.addElement(string2);
                        continue;
                    }
                    if (object2 == null || !(object2 instanceof Site) || (meterArray = ((Site)(easObject = (Site)object2)).getMeters()) == null) continue;
                    for (int j = 0; j < meterArray.length && !progressMonitor.isCanceled(); ++j) {
                        object4 = meterArray[j];
                        int n5 = ((EasObject)object4).getId();
                        string = DEFAULT_RECONCILIATION_PREFIX + n5;
                        object3 = new ReconciliationReport[n];
                        object = reconciliationReportArray;
                        String string3 = DEFAULT_RECONCILIATION_PREFIX + ((EasObject)object4).getId();
                        for (int k = 0; k < n && !progressMonitor.isCanceled(); ++k) {
                            stringArray = string3 + "_" + (String)object;
                            progressMonitor.setNote((((Meter)object4).getSite() != null ? ((Meter)object4).getSite().getName() + ": " : "") + ((Meter)object4).getName() + " " + RateComparisonApplication.toBillPeriodString((String)object, lexicon));
                            progressMonitor.setProgress(n2);
                            object3[k] = EasCostClient.runReconciliationReport(this.getSession(), string, (String)object, this.loadMeterReport(string3, (String)stringArray, (String)object, true), false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                            object = RateComparisonApplication.getNextBillPeriod((String)object);
                            ++n2;
                        }
                        if (progressMonitor.isCanceled()) continue block20;
                        vector.addElement(ReconciliationReport.consolidateReconciliations((ReconciliationReport[])object3));
                        ++n3;
                        if (progressMonitor.isCanceled()) continue block20;
                        RateHistory rateHistory = EasCostClient.retrieveRateHistory(this.getSession(), n5);
                        if (rateHistory == null || rateHistory.getRateLinks() == null || rateHistory.getRateLinks().length <= 0) continue;
                        bl = true;
                        vector2.addElement(string);
                    }
                }
            }
            ReconciliationReport reconciliationReport = null;
            if (this.currentAlternateReconciliation != null && bl && !progressMonitor.isCanceled()) {
                int n6;
                object2 = new TimePeriods(this.alternateBillingCycleTextField.getIntValue(), this.alternateBillingCycleComboBox.getSelectedIndex() + 1);
                int n7 = this.alternateBillingCycleComboBox.getSelectedIndex() + 1;
                Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
                calendar.setTime(new Date(this.alternateStartEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
                calendar.set(11, this.alternateStartTimeEditor.getHour());
                calendar.set(12, this.alternateStartTimeEditor.getMinute());
                calendar.set(13, this.alternateStartTimeEditor.getSecond());
                calendar.set(14, this.alternateStartTimeEditor.getMillisecond());
                long l = calendar.getTime().getTime();
                long l2 = CostTimeUtil.incrementTime(CostTimeUtil.DEFAULT_TZ, l, (TimePeriods)object2, n7);
                Object object6 = reconciliationReportArray;
                object = new ReconciliationReport[n];
                for (n6 = 0; n6 < n && !progressMonitor.isCanceled(); ++n6) {
                    RateBillingPeriod[] rateBillingPeriodArray = new RateBillingPeriod[]{new RateBillingPeriod(this.currentAlternateReconciliation.getName(), l, l2)};
                    this.currentAlternateReconciliation.setRateBillingPeriods(rateBillingPeriodArray);
                    stringArray = null;
                    if (vector2 != null && vector2.size() > 0) {
                        stringArray = new String[vector2.size()];
                        for (int i = 0; i < vector2.size(); ++i) {
                            stringArray[i] = (String)vector2.elementAt(i);
                        }
                    }
                    progressMonitor.setNote(lexicon.getText("altRate") + " " + this.currentAlternateReconciliation.getName() + " " + RateComparisonApplication.toBillPeriodString((String)object6, lexicon));
                    progressMonitor.setProgress(n2);
                    object[n6] = EasCostClient.runAlternateReconciliationReport(this.getSession(), stringArray, (String)object6, this.getAggregateTimestamps(), this.currentAlternateReconciliation, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.currentAlternateRateHistory, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                    l = l2;
                    l2 = CostTimeUtil.incrementTime(CostTimeUtil.DEFAULT_TZ, l, (TimePeriods)object2, n7);
                    object6 = RateComparisonApplication.getNextBillPeriod((String)object6);
                    ++n2;
                }
                if (progressMonitor.isCanceled()) {
                    progressMonitor.close();
                    this.setCursor(Cursor.getDefaultCursor());
                    n6 = 0;
                    return n6 != 0;
                }
                reconciliationReport = ReconciliationReport.consolidateReconciliations(object);
            }
            if (vector == null || vector.size() < 1) {
                this.currentReconciliations = null;
            } else {
                this.currentReconciliations = new ReconciliationReport[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    this.currentReconciliations[i] = (ReconciliationReport)vector.elementAt(i);
                }
            }
            this.attachedRateDetails.setReconciliationEditorValue(this.currentReconciliations, true, this.showDetails.isSelected(), true, 0);
            if (reconciliationReport != null && reconciliationReport.getReconciliationRows() != null) {
                this.alternateRateDetails.setReconciliationEditorValue(reconciliationReport, true, this.showDetails.isSelected(), false, this.attachedRateDetails.myOffset);
                this.currentAlternateReconciliation = reconciliationReport;
            } else {
                this.alternateRateDetails.setReconciliationEditorValue(this.currentAlternateReconciliation, false, this.showDetails.isSelected(), false, this.attachedRateDetails.myOffset);
            }
            RateComparisonDetailPanel.alignComparisonPanels(this.attachedRateDetails, this.alternateRateDetails, this.showDetails.isSelected());
            if (this.attachedRateDetails != null && this.alternateRateDetails != null) {
                object2 = new DecimalFormat(lexicon.getText("costValueFormat"));
                double d = 0.0;
                double d2 = 0.0;
                if (this.attachedRateDetails.overallCost != 0.0) {
                    if (this.attachedRateDetails.overallCost < 0.0) {
                        d2 = this.alternateRateDetails.overallCost - this.attachedRateDetails.overallCost;
                        d = this.attachedRateDetails.overallCost < this.alternateRateDetails.overallCost ? (d2 - this.attachedRateDetails.overallCost) / (-1.0 * this.attachedRateDetails.overallCost) : (this.attachedRateDetails.overallCost - d2) / this.attachedRateDetails.overallCost;
                        d2 = this.attachedRateDetails.overallCost - this.alternateRateDetails.overallCost;
                    } else {
                        d2 = this.attachedRateDetails.overallCost - this.alternateRateDetails.overallCost;
                        d = this.alternateRateDetails.overallCost / this.attachedRateDetails.overallCost;
                    }
                    this.grandTotalDifference.setText(((NumberFormat)object2).format(d2) + " (" + percentFormat.format(d) + ")");
                } else {
                    this.grandTotalDifference.setText(((NumberFormat)object2).format(this.attachedRateDetails.overallCost - this.alternateRateDetails.overallCost));
                }
                if (this.attachedRateDetails.consumptionCost != 0.0) {
                    if (this.attachedRateDetails.consumptionCost < 0.0) {
                        d2 = this.alternateRateDetails.consumptionCost - this.attachedRateDetails.consumptionCost;
                        d = this.attachedRateDetails.consumptionCost < this.alternateRateDetails.consumptionCost ? (d2 - this.attachedRateDetails.consumptionCost) / (-1.0 * this.attachedRateDetails.consumptionCost) : (this.attachedRateDetails.consumptionCost - d2) / this.attachedRateDetails.consumptionCost;
                        d2 = this.attachedRateDetails.consumptionCost - this.alternateRateDetails.consumptionCost;
                    } else {
                        d2 = this.attachedRateDetails.consumptionCost - this.alternateRateDetails.consumptionCost;
                        d = this.alternateRateDetails.consumptionCost / this.attachedRateDetails.consumptionCost;
                    }
                    this.consumptionDifference.setText(((NumberFormat)object2).format(d2) + " (" + percentFormat.format(d) + ")");
                } else {
                    this.consumptionDifference.setText(((NumberFormat)object2).format(this.attachedRateDetails.consumptionCost - this.alternateRateDetails.consumptionCost));
                }
                if (this.attachedRateDetails.demandCost != 0.0) {
                    if (this.attachedRateDetails.demandCost < 0.0) {
                        d2 = this.alternateRateDetails.demandCost - this.attachedRateDetails.demandCost;
                        d = this.attachedRateDetails.demandCost < this.alternateRateDetails.demandCost ? (d2 - this.attachedRateDetails.demandCost) / (-1.0 * this.attachedRateDetails.demandCost) : (this.attachedRateDetails.demandCost - d2) / this.attachedRateDetails.demandCost;
                        d2 = this.attachedRateDetails.demandCost - this.alternateRateDetails.demandCost;
                    } else {
                        d2 = this.attachedRateDetails.demandCost - this.alternateRateDetails.demandCost;
                        d = this.alternateRateDetails.demandCost / this.attachedRateDetails.demandCost;
                    }
                    this.demandDifference.setText(((NumberFormat)object2).format(d2) + " (" + percentFormat.format(d) + ")");
                } else {
                    this.demandDifference.setText(((NumberFormat)object2).format(this.attachedRateDetails.demandCost - this.alternateRateDetails.demandCost));
                }
                if (this.attachedRateDetails.otherCost != 0.0) {
                    if (this.attachedRateDetails.otherCost < 0.0) {
                        d2 = this.alternateRateDetails.otherCost - this.attachedRateDetails.otherCost;
                        d = this.attachedRateDetails.otherCost < this.alternateRateDetails.otherCost ? (d2 - this.attachedRateDetails.otherCost) / (-1.0 * this.attachedRateDetails.otherCost) : (this.attachedRateDetails.otherCost - d2) / this.attachedRateDetails.otherCost;
                        d2 = this.attachedRateDetails.otherCost - this.alternateRateDetails.otherCost;
                    } else {
                        d2 = this.attachedRateDetails.otherCost - this.alternateRateDetails.otherCost;
                        d = this.alternateRateDetails.otherCost / this.attachedRateDetails.otherCost;
                    }
                    this.otherDifference.setText(((NumberFormat)object2).format(d2) + " (" + percentFormat.format(d) + ")");
                } else {
                    this.otherDifference.setText(((NumberFormat)object2).format(this.attachedRateDetails.otherCost - this.alternateRateDetails.otherCost));
                }
                boolean bl2 = this.attachedRateDetails.userDef1Cost == 0.0 && this.alternateRateDetails.userDef1Cost == 0.0;
                this.userDef1Label.setVisible(!bl2);
                this.userDef1Difference.setVisible(!bl2);
                if (this.attachedRateDetails.userDef1Cost != 0.0) {
                    if (this.attachedRateDetails.userDef1Cost < 0.0) {
                        d2 = this.alternateRateDetails.userDef1Cost - this.attachedRateDetails.userDef1Cost;
                        d = this.attachedRateDetails.userDef1Cost < this.alternateRateDetails.userDef1Cost ? (d2 - this.attachedRateDetails.userDef1Cost) / (-1.0 * this.attachedRateDetails.userDef1Cost) : (this.attachedRateDetails.userDef1Cost - d2) / this.attachedRateDetails.userDef1Cost;
                        d2 = this.attachedRateDetails.userDef1Cost - this.alternateRateDetails.userDef1Cost;
                    } else {
                        d2 = this.attachedRateDetails.userDef1Cost - this.alternateRateDetails.userDef1Cost;
                        d = this.alternateRateDetails.userDef1Cost / this.attachedRateDetails.userDef1Cost;
                    }
                    this.userDef1Difference.setText(((NumberFormat)object2).format(d2) + " (" + percentFormat.format(d) + ")");
                } else {
                    this.userDef1Difference.setText(((NumberFormat)object2).format(this.attachedRateDetails.userDef1Cost - this.alternateRateDetails.userDef1Cost));
                }
                bl2 = this.attachedRateDetails.userDef2Cost == 0.0 && this.alternateRateDetails.userDef2Cost == 0.0;
                this.userDef2Label.setVisible(!bl2);
                this.userDef2Difference.setVisible(!bl2);
                if (this.attachedRateDetails.userDef2Cost != 0.0) {
                    if (this.attachedRateDetails.userDef2Cost < 0.0) {
                        d2 = this.alternateRateDetails.userDef2Cost - this.attachedRateDetails.userDef2Cost;
                        d = this.attachedRateDetails.userDef2Cost < this.alternateRateDetails.userDef2Cost ? (d2 - this.attachedRateDetails.userDef2Cost) / (-1.0 * this.attachedRateDetails.userDef2Cost) : (this.attachedRateDetails.userDef2Cost - d2) / this.attachedRateDetails.userDef2Cost;
                        d2 = this.attachedRateDetails.userDef2Cost - this.alternateRateDetails.userDef2Cost;
                    } else {
                        d2 = this.attachedRateDetails.userDef2Cost - this.alternateRateDetails.userDef2Cost;
                        d = this.alternateRateDetails.userDef2Cost / this.attachedRateDetails.userDef2Cost;
                    }
                    this.userDef2Difference.setText(((NumberFormat)object2).format(d2) + " (" + percentFormat.format(d) + ")");
                } else {
                    this.userDef2Difference.setText(((NumberFormat)object2).format(this.attachedRateDetails.userDef2Cost - this.alternateRateDetails.userDef2Cost));
                }
                bl2 = this.attachedRateDetails.userDef3Cost == 0.0 && this.alternateRateDetails.userDef3Cost == 0.0;
                this.userDef3Label.setVisible(!bl2);
                this.userDef3Difference.setVisible(!bl2);
                if (this.attachedRateDetails.userDef3Cost != 0.0) {
                    if (this.attachedRateDetails.userDef3Cost < 0.0) {
                        d2 = this.alternateRateDetails.userDef3Cost - this.attachedRateDetails.userDef3Cost;
                        d = this.attachedRateDetails.userDef3Cost < this.alternateRateDetails.userDef3Cost ? (d2 - this.attachedRateDetails.userDef3Cost) / (-1.0 * this.attachedRateDetails.userDef3Cost) : (this.attachedRateDetails.userDef3Cost - d2) / this.attachedRateDetails.userDef3Cost;
                        d2 = this.attachedRateDetails.userDef3Cost - this.alternateRateDetails.userDef3Cost;
                    } else {
                        d2 = this.attachedRateDetails.userDef3Cost - this.alternateRateDetails.userDef3Cost;
                        d = this.alternateRateDetails.userDef3Cost / this.attachedRateDetails.userDef3Cost;
                    }
                    this.userDef3Difference.setText(((NumberFormat)object2).format(d2) + " (" + percentFormat.format(d) + ")");
                } else {
                    this.userDef3Difference.setText(((NumberFormat)object2).format(this.attachedRateDetails.userDef3Cost - this.alternateRateDetails.userDef3Cost));
                }
                bl2 = this.attachedRateDetails.userDef4Cost == 0.0 && this.alternateRateDetails.userDef4Cost == 0.0;
                this.userDef4Label.setVisible(!bl2);
                this.userDef4Difference.setVisible(!bl2);
                if (this.attachedRateDetails.userDef4Cost != 0.0) {
                    if (this.attachedRateDetails.userDef4Cost < 0.0) {
                        d2 = this.alternateRateDetails.userDef4Cost - this.attachedRateDetails.userDef4Cost;
                        d = this.attachedRateDetails.userDef4Cost < this.alternateRateDetails.userDef4Cost ? (d2 - this.attachedRateDetails.userDef4Cost) / (-1.0 * this.attachedRateDetails.userDef4Cost) : (this.attachedRateDetails.userDef4Cost - d2) / this.attachedRateDetails.userDef4Cost;
                        d2 = this.attachedRateDetails.userDef4Cost - this.alternateRateDetails.userDef4Cost;
                    } else {
                        d2 = this.attachedRateDetails.userDef4Cost - this.alternateRateDetails.userDef4Cost;
                        d = this.alternateRateDetails.userDef4Cost / this.attachedRateDetails.userDef4Cost;
                    }
                    this.userDef4Difference.setText(((NumberFormat)object2).format(d2) + " (" + percentFormat.format(d) + ")");
                } else {
                    this.userDef4Difference.setText(((NumberFormat)object2).format(this.attachedRateDetails.userDef4Cost - this.alternateRateDetails.userDef4Cost));
                }
                this.mainSplit.revalidate();
                this.mainSplit.repaint();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            progressMonitor.close();
            this.setCursor(Cursor.getDefaultCursor());
        }
        return true;
    }

    private ReconciliationReport loadMeterReport(String string, String string2, String string3, boolean bl) {
        try {
            ReconciliationReport reconciliationReport;
            if (this.reconciliations == null) {
                ReconciliationReport reconciliationReport2 = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                if (reconciliationReport2 == null) {
                    reconciliationReport2 = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                }
                if (reconciliationReport2 == null) {
                    reconciliationReport2 = new ReconciliationReport(string2 == null ? "temp" : string2);
                }
                this.reconciliations = new ReconciliationReport[1];
                this.reconciliations[0] = reconciliationReport2;
                return reconciliationReport2;
            }
            if (string2 != null) {
                for (int i = 0; i < this.reconciliations.length; ++i) {
                    if (!this.reconciliations[i].getName().equals(string2)) continue;
                    if (bl) {
                        this.reconciliations[i] = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                        if (this.reconciliations[i] == null) {
                            this.reconciliations[i] = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
                        }
                        if (this.reconciliations[i] == null) {
                            this.reconciliations[i] = new ReconciliationReport(string2);
                        }
                    }
                    return this.reconciliations[i];
                }
            }
            if ((reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string2, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null)) == null) {
                reconciliationReport = EasCostClient.retrieveReconciliationReport(this.getSession(), string, string, string3, false, true, string, false, false, BUnit.getUnit((String)"fahrenheit"), 65.0, this.getDataCleanse(), this.getDataCleanseWindow(), this.getDataCleansePercentage(), false, null);
            }
            if (reconciliationReport == null) {
                reconciliationReport = new ReconciliationReport(string2 == null ? "temp" : string2);
            }
            ReconciliationReport[] reconciliationReportArray = new ReconciliationReport[this.reconciliations.length + 1];
            for (int i = 0; i < this.reconciliations.length; ++i) {
                reconciliationReportArray[i] = this.reconciliations[i];
            }
            reconciliationReportArray[this.reconciliations.length] = reconciliationReport;
            this.reconciliations = reconciliationReportArray;
            return reconciliationReport;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void reloadMeterReport() {
        this.loadReconciliationReport(true);
    }

    public void buttonPressed(JButton jButton) {
        if (jButton == this.refreshButton) {
            this.reloadMeterReport();
            this.initApplication(true, false);
            ((FilterTreeModel)this.tree.getModel()).reload();
            this.expandView.setSelected(false);
            this.setExpandedView(true);
        } else if (jButton == this.printButton) {
            try {
                this.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (jButton == this.filterButton) {
            this.filterRates();
        } else {
            super.buttonPressed(jButton);
        }
    }

    private void filterRates() {
        Lexicon lexicon = BEasApplet.lex;
        Rate[] rateArray = FilterRateDialog.getFilteredRates(this.getSession(), this, lexicon, this.rates, this.rateFilterLabel);
        this.rates.refreshData(rateArray);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.attachedRateDetails == null) {
            return;
        }
        this.loadReconciliationReport(false);
    }

    public void setRateEditorValue(Rate rate) {
        this.currentAlternateRateHistory = null;
        this.currentAlternateReconciliation = null;
        if (rate != null) {
            RateLink rateLink = new RateLink(rate.getName());
            this.currentAlternateRateHistory = new RateHistory(rate.getName());
            this.currentAlternateRateHistory.addRateLink(rateLink);
            this.currentAlternateReconciliation = new ReconciliationReport(rate.getName());
            this.currentAlternateReconciliation.addReconciliationRow(new ReconciliationRow(rate.getName()));
            RateComponent[] rateComponentArray = rate.getRateComponents();
            if (rateComponentArray != null) {
                String string = rate.getName();
                int n = string.length();
                BUnit bUnit = rate.getCurrency();
                BUnit bUnit2 = rate.getConsumptionUnits();
                BUnit bUnit3 = rate.getDemandUnits();
                BUnit bUnit4 = rate.getReactiveEnergyUnits();
                BUnit bUnit5 = rate.getApparentEnergyUnits();
                BUnit bUnit6 = rate.getReactivePowerUnits();
                BUnit bUnit7 = rate.getApparentPowerUnits();
                for (int i = 0; i < rateComponentArray.length; ++i) {
                    String string2 = string + rateComponentArray[i].getName();
                    BUnit bUnit8 = null;
                    switch (rateComponentArray[i].getApplicableData()) {
                        case 0: {
                            bUnit8 = bUnit2;
                            break;
                        }
                        case 1: {
                            bUnit8 = bUnit3;
                            break;
                        }
                        case 2: {
                            bUnit8 = bUnit4;
                            break;
                        }
                        case 4: {
                            bUnit8 = bUnit5;
                            break;
                        }
                        case 3: {
                            bUnit8 = bUnit6;
                            break;
                        }
                        case 5: {
                            bUnit8 = bUnit7;
                        }
                    }
                    this.currentAlternateReconciliation.addReconciliationRow(new ReconciliationRow(string2, n, (RateComponent)rateComponentArray[i].newCopy(), 0.0, false, bUnit, bUnit8));
                }
            }
        }
        this.alternateRateDetails.setReconciliationEditorValue(this.currentAlternateReconciliation, true, this.showDetails.isSelected(), false, this.attachedRateDetails.myOffset);
        RateComparisonDetailPanel.alignComparisonPanels(this.attachedRateDetails, this.alternateRateDetails, this.showDetails.isSelected());
        this.mainSplit.revalidate();
        this.mainSplit.repaint();
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        pageFormat.setOrientation(1);
        Pageable pageable = this.getPageable(pageFormat);
        if (pageable == null || pageable.getNumberOfPages() == 0) {
            printerJob.cancel();
            return;
        }
        try {
            if (printerJob.printDialog()) {
                printerJob.setPageable(pageable);
                printerJob.print();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Pageable getPageable(PageFormat pageFormat) {
        Book book = new Book();
        this.print(this.createImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight()).getGraphics(), pageFormat, 0);
        int n = this.getEstimateNumPages();
        book.append(this, pageFormat, n);
        int n2 = 0;
        if (this.attachedRateDetails != null) {
            this.attachedRateDetails.pageOffset = n;
            this.attachedRateDetails.print(this.createImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight()).getGraphics(), pageFormat, n);
            n2 = this.attachedRateDetails.getEstimateNumPages();
            book.append(this.attachedRateDetails, pageFormat, n2);
        }
        if (this.alternateRateDetails != null) {
            this.alternateRateDetails.pageOffset = n + n2;
            this.alternateRateDetails.print(this.createImage((int)pageFormat.getWidth(), (int)pageFormat.getHeight()).getGraphics(), pageFormat, n + n2);
            n = this.alternateRateDetails.getEstimateNumPages();
            book.append(this.alternateRateDetails, pageFormat, n);
        }
        return book;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.filterSelection) {
            this.updateFilter();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void buttonToggled(JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == this.expandView) {
            this.setExpandedView(!bl);
        } else if (jToggleButton == this.showDetails) {
            this.setShowDetails(!bl);
        } else {
            super.buttonToggled(jToggleButton, bl);
        }
    }

    private void setExpandedView(boolean bl) {
        if (this.metersPane != null) {
            this.metersPane.setVisible(bl);
        }
        if (this.ratesPane != null) {
            this.ratesPane.setVisible(bl);
        }
        if (this.mainSplit != null) {
            this.mainSplit.revalidate();
            this.mainSplit.repaint();
        }
    }

    private void setShowDetails(boolean bl) {
        if (this.attachedRateDetails != null) {
            this.attachedRateDetails.setReconciliationEditorValue(this.currentReconciliations, false, this.showDetails.isSelected(), true, 0);
        }
        if (this.alternateRateDetails != null) {
            this.alternateRateDetails.setReconciliationEditorValue(this.currentAlternateReconciliation, true, this.showDetails.isSelected(), false, this.attachedRateDetails.myOffset);
        }
        RateComparisonDetailPanel.alignComparisonPanels(this.attachedRateDetails, this.alternateRateDetails, this.showDetails.isSelected());
        if (this.mainSplit != null) {
            this.mainSplit.revalidate();
            this.mainSplit.repaint();
        }
    }

    public void initFilters() {
        EasSession easSession = this.getSession();
        Lexicon lexicon = BEasApplet.lex;
        this.filterSelection.addItem(new AllSitesFilter(easSession, lexicon));
        this.filterSelection.addItem(new StaticGroupFilter(easSession, lexicon));
        Group[] groupArray = Group.getGroups('D', easSession);
        if (groupArray == null) {
            return;
        }
        int n = groupArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (groupArray[i].isHidden()) continue;
                this.filterSelection.addItem(new DynamicGroupFilter(easSession, (DynGroup)groupArray[i], lexicon));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.filterSelection.setMaximumRowCount(Math.min(this.filterSelection.getItemCount(), 10));
    }

    public void updateFilter() {
        Filter filter = (Filter)this.filterSelection.getSelectedItem();
        if (filter != this.currentFilter) {
            this.currentFilter = filter;
            FilterTreeModel filterTreeModel = new FilterTreeModel(new FilterRootNode(filter, new RateLinkDbObjectValidator()));
            this.tree.setModel(filterTreeModel);
        }
    }

    public BEasApplet getApplet() {
        return this.easApplet;
    }

    private String[] getMeterStrings() {
        String[] stringArray = null;
        Object[] objectArray = this.tree.getSelectedUserObjects();
        if (objectArray == null || objectArray.length < 1) {
            return stringArray;
        }
        stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                Meter meter = (Meter)objectArray[i];
                stringArray[i] = (meter.getSite() != null ? meter.getSite().getName() + ": " : "") + meter.getName();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringArray;
    }

    private boolean getAggregateTimestamps() {
        return this.aggregateApproachComboBox.getSelectedIndex() == 0;
    }

    private String getBillPeriodString() {
        return this.billMonthComboBox.getSelectedItemString() + " " + this.billYearTextField.getText();
    }

    private String getAlternateBillPeriodString() {
        return this.alternateBillMonthComboBox.getSelectedItemString() + " " + this.alternateBillYearTextField.getText();
    }

    private static String toBillPeriodString(String string, Lexicon lexicon) {
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        return lexicon.getText(string2) + " " + string3;
    }

    private static String getNextBillPeriod(String string) {
        int n = -2;
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string4 = string2;
        if (string2.equals("Jan")) {
            string4 = "Feb";
        } else if (string2.equals("Feb")) {
            string4 = "Mar";
        } else if (string2.equals("Mar")) {
            string4 = "Apr";
        } else if (string2.equals("Apr")) {
            string4 = "May";
        } else if (string2.equals("May")) {
            string4 = "Jun";
        } else if (string2.equals("Jun")) {
            string4 = "Jul";
        } else if (string2.equals("Jul")) {
            string4 = "Aug";
        } else if (string2.equals("Aug")) {
            string4 = "Sep";
        } else if (string2.equals("Sep")) {
            string4 = "Oct";
        } else if (string2.equals("Oct")) {
            string4 = "Nov";
        } else if (string2.equals("Nov")) {
            string4 = "Dec";
        } else if (string2.equals("Dec")) {
            string4 = "Jan";
            ++n;
        }
        if (n >= 0) {
            string3 = String.valueOf(n);
        }
        return string4 + string3;
    }

    private Font getCellFont() {
        if (this.cellFont == null) {
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            hashMap.put(TextAttribute.FAMILY, Theme.widget().getTextFont().getName());
            hashMap.put(TextAttribute.SIZE, new Float(10.0f));
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            this.cellFont = new Font(hashMap);
        }
        return this.cellFont;
    }

    private Font getHeaderFont() {
        if (this.headerFont == null) {
            this.headerFont = this.getCellFont().deriveFont(1);
        }
        return this.headerFont;
    }

    private Font getTitleFont() {
        if (this.titleFont == null) {
            this.titleFont = this.getCellFont().deriveFont(1, 14.0f);
        }
        return this.titleFont;
    }

    private Font getSubtitleFont() {
        if (this.subtitleFont == null) {
            this.subtitleFont = this.getCellFont().deriveFont(12.0f);
        }
        return this.subtitleFont;
    }

    private FontMetrics getCellFontMetrics() {
        if (this.cellFontMetrics == null) {
            this.cellFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getCellFont());
        }
        return this.cellFontMetrics;
    }

    private FontMetrics getHeaderFontMetrics() {
        if (this.headerFontMetrics == null) {
            this.headerFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getHeaderFont());
        }
        return this.headerFontMetrics;
    }

    private FontMetrics getTitleFontMetrics() {
        if (this.titleFontMetrics == null) {
            this.titleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getTitleFont());
        }
        return this.titleFontMetrics;
    }

    private FontMetrics getSubtitleFontMetrics() {
        if (this.subtitleFontMetrics == null) {
            this.subtitleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getSubtitleFont());
        }
        return this.subtitleFontMetrics;
    }

    private ArrayList filterLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (!stringTokenizer.hasMoreTokens()) {
            arrayList.add(string);
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private ArrayList getCellLines(String string, FontMetrics fontMetrics, double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = this.filterLines(string);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if ((double)fontMetrics.stringWidth(string2) <= d) {
                arrayList.add(string2);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                StringBuffer stringBuffer2 = new StringBuffer().append(stringBuffer.toString());
                String string4 = stringBuffer.length() == 0 ? "" : " ";
                if ((double)fontMetrics.stringWidth(stringBuffer2.append(string4).append(string3).toString()) > d) {
                    if (stringBuffer.length() == 0) {
                        stringBuffer = new StringBuffer(string3);
                        while ((double)fontMetrics.stringWidth(stringBuffer.toString()) > d) {
                            StringBuffer stringBuffer3 = new StringBuffer();
                            while ((double)fontMetrics.stringWidth(stringBuffer3.toString()) <= d) {
                                stringBuffer3.append(stringBuffer.charAt(0));
                                stringBuffer.deleteCharAt(0);
                            }
                            arrayList.add(stringBuffer3.toString());
                        }
                        continue;
                    }
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string3);
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string3);
            }
            if (stringBuffer.length() <= 0) continue;
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    private int getEstimateNumPages() {
        return this.currentPage + 1;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        int n3;
        int n4;
        this.currentPage = 0;
        Lexicon lexicon = BEasApplet.lex;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n5 = 3;
        boolean bl = true;
        int n6 = 0;
        int n7 = (int)pageFormat.getImageableWidth();
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getTitleFont());
        ArrayList arrayList = this.getCellLines(lexicon.getText("rateComparison"), this.getTitleFontMetrics(), n7);
        String[] stringArray = arrayList.iterator();
        while (stringArray.hasNext()) {
            String string = (String)stringArray.next();
            int n8 = this.getTitleFontMetrics().stringWidth(string);
            int n9 = n7 / 2 - n8 / 2;
            int n10 = n6 + n5 + this.getTitleFontMetrics().getHeight() - this.getTitleFontMetrics().getDescent();
            if (this.currentPage == n) {
                graphics2D.drawString(string, n9, n10);
            }
            n6 += n5 + this.getTitleFontMetrics().getHeight();
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        stringArray = this.getMeterStrings();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                ArrayList arrayList2 = this.getCellLines(lexicon.getText(DEFAULT_RECONCILIATION_PREFIX) + ":  " + stringArray[i], this.getSubtitleFontMetrics(), n7);
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    n4 = this.getSubtitleFontMetrics().stringWidth(string);
                    n3 = n7 / 2 - n4 / 2;
                    n2 = n6 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
                    if ((double)n2 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n6 = 0;
                        n2 = n6 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
                    }
                    if (this.currentPage == n) {
                        graphics2D.drawString(string, n3, n2);
                    }
                    n6 += n5 + this.getSubtitleFontMetrics().getHeight();
                }
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        ArrayList arrayList3 = this.getCellLines(lexicon.getText("billPeriod") + ":  " + this.getBillPeriodString(), this.getSubtitleFontMetrics(), n7);
        Object object = arrayList3.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            int n11 = this.getSubtitleFontMetrics().stringWidth(string);
            n4 = n7 / 2 - n11 / 2;
            n3 = n6 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            if ((double)n3 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n6 = 0;
                n3 = n6 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n4, n3);
            }
            n6 += n5 + this.getSubtitleFontMetrics().getHeight();
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        arrayList3 = this.getCellLines(lexicon.getText("altRate") + " " + lexicon.getText("billPeriod") + ":  " + this.getAlternateBillPeriodString(), this.getSubtitleFontMetrics(), n7);
        object = arrayList3.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            int n12 = this.getSubtitleFontMetrics().stringWidth(string);
            n4 = n7 / 2 - n12 / 2;
            n3 = n6 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            if ((double)n3 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n6 = 0;
                n3 = n6 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n4, n3);
            }
            n6 += n5 + this.getSubtitleFontMetrics().getHeight();
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        arrayList3 = this.getCellLines(lexicon.getText("consecutiveBillingCycles") + ":  " + this.numCyclesField.getText(), this.getSubtitleFontMetrics(), n7);
        object = arrayList3.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            int n13 = this.getSubtitleFontMetrics().stringWidth(string);
            n4 = n7 / 2 - n13 / 2;
            n3 = n6 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            if ((double)n3 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n6 = 0;
                n3 = n6 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n4, n3);
            }
            n6 += n5 + this.getSubtitleFontMetrics().getHeight();
        }
        n6 += n5 + this.getSubtitleFontMetrics().getHeight();
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getCellFont());
        object = this.getCellLines(lexicon.getText("grandTotal") + " " + lexicon.getText("deltaCost") + ":  " + this.grandTotalDifference.getText(), this.getCellFontMetrics(), n7);
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n4 = this.getCellFontMetrics().stringWidth(string);
            n3 = n5;
            n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n2 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n6 = 0;
                n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n3, n2);
            }
            n6 += n5 + this.getCellFontMetrics().getHeight();
        }
        object = this.getCellLines(lexicon.getText("Consumption") + " " + lexicon.getText("deltaCost") + ":  " + this.consumptionDifference.getText(), this.getCellFontMetrics(), n7);
        iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n4 = this.getCellFontMetrics().stringWidth(string);
            n3 = n5;
            n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n2 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n6 = 0;
                n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n3, n2);
            }
            n6 += n5 + this.getCellFontMetrics().getHeight();
        }
        object = this.getCellLines(lexicon.getText("Demand") + " " + lexicon.getText("deltaCost") + ":  " + this.demandDifference.getText(), this.getCellFontMetrics(), n7);
        iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n4 = this.getCellFontMetrics().stringWidth(string);
            n3 = n5;
            n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n2 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n6 = 0;
                n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n3, n2);
            }
            n6 += n5 + this.getCellFontMetrics().getHeight();
        }
        object = this.getCellLines(lexicon.getText("Other") + " " + lexicon.getText("deltaCost") + ":  " + this.otherDifference.getText(), this.getCellFontMetrics(), n7);
        iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            n4 = this.getCellFontMetrics().stringWidth(string);
            n3 = n5;
            n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n2 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n6 = 0;
                n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n3, n2);
            }
            n6 += n5 + this.getCellFontMetrics().getHeight();
        }
        if (this.userDef1Label.isVisible()) {
            object = this.getCellLines(this.userDef1Label.getText() + ":  " + this.userDef1Difference.getText(), this.getCellFontMetrics(), n7);
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                n4 = this.getCellFontMetrics().stringWidth(string);
                n3 = n5;
                n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n2 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n6 = 0;
                    n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage == n) {
                    graphics2D.drawString(string, n3, n2);
                }
                n6 += n5 + this.getCellFontMetrics().getHeight();
            }
        }
        if (this.userDef2Label.isVisible()) {
            object = this.getCellLines(this.userDef2Label.getText() + ":  " + this.userDef2Difference.getText(), this.getCellFontMetrics(), n7);
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                n4 = this.getCellFontMetrics().stringWidth(string);
                n3 = n5;
                n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n2 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n6 = 0;
                    n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage == n) {
                    graphics2D.drawString(string, n3, n2);
                }
                n6 += n5 + this.getCellFontMetrics().getHeight();
            }
        }
        if (this.userDef3Label.isVisible()) {
            object = this.getCellLines(this.userDef3Label.getText() + ":  " + this.userDef3Difference.getText(), this.getCellFontMetrics(), n7);
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                n4 = this.getCellFontMetrics().stringWidth(string);
                n3 = n5;
                n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n2 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n6 = 0;
                    n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage == n) {
                    graphics2D.drawString(string, n3, n2);
                }
                n6 += n5 + this.getCellFontMetrics().getHeight();
            }
        }
        if (this.userDef4Label.isVisible()) {
            object = this.getCellLines(this.userDef4Label.getText() + ":  " + this.userDef4Difference.getText(), this.getCellFontMetrics(), n7);
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                n4 = this.getCellFontMetrics().stringWidth(string);
                n3 = n5;
                n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n2 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n6 = 0;
                    n2 = n6 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage == n) {
                    graphics2D.drawString(string, n3, n2);
                }
                n6 += n5 + this.getCellFontMetrics().getHeight();
            }
        }
        if (this.currentPage < n) {
            return 1;
        }
        return 0;
    }

    public void dataCleansingChanged() {
        this.reconciliations = null;
    }

    private class ApplyAlternateActionListener
    implements ActionListener {
        private DateEditor startEditor;
        private EasTimeEditor startTimeEditor;
        private DateEditor endEditor;
        private EasTimeEditor endTimeEditor;

        public ApplyAlternateActionListener(DateEditor dateEditor, EasTimeEditor easTimeEditor, DateEditor dateEditor2, EasTimeEditor easTimeEditor2) {
            this.startEditor = dateEditor;
            this.startTimeEditor = easTimeEditor;
            this.endEditor = dateEditor2;
            this.endTimeEditor = easTimeEditor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (RateComparisonApplication.this.initializingBillValues) {
                return;
            }
            RateComparisonApplication.this.alternateBillMonthComboBox.setSelectedIndex(RateComparisonApplication.this.billMonthComboBox.getSelectedIndex());
            RateComparisonApplication.this.alternateBillYearTextField.setText(RateComparisonApplication.this.billYearTextField.getText());
            RateComparisonApplication.this.alternateStartEditor.setValue(this.startEditor.getValue());
            RateComparisonApplication.this.alternateStartTimeEditor.setValues(this.startTimeEditor.getHour(), this.startTimeEditor.getMinute(), this.startTimeEditor.getSecond(), this.startTimeEditor.getMillisecond());
            Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
            calendar.setTime(new Date(this.startEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
            calendar.set(11, this.startTimeEditor.getHour());
            calendar.set(12, this.startTimeEditor.getMinute());
            calendar.set(13, this.startTimeEditor.getSecond());
            calendar.set(14, this.startTimeEditor.getMillisecond());
            long l = calendar.getTime().getTime();
            calendar.setTime(new Date(this.endEditor.getValue().getTimestamp(CostTimeUtil.DEFAULT_TZ)));
            calendar.set(11, this.endTimeEditor.getHour());
            calendar.set(12, this.endTimeEditor.getMinute());
            calendar.set(13, this.endTimeEditor.getSecond());
            calendar.set(14, this.endTimeEditor.getMillisecond());
            long l2 = calendar.getTime().getTime();
            long l3 = l2 - l;
            if (l3 < 0L) {
                l3 *= -1L;
            }
            if ((n = (int)(l3 / 86400000L)) == 0 || n >= 25 && n <= 35) {
                RateComparisonApplication.this.alternateBillingCycleTextField.setText(1);
                RateComparisonApplication.this.alternateBillingCycleComboBox.setSelectedIndex(4);
            } else if (n > 0 && n % 7 == 0) {
                int n2 = (int)(l3 / 604800000L);
                RateComparisonApplication.this.alternateBillingCycleTextField.setText(n2);
                RateComparisonApplication.this.alternateBillingCycleComboBox.setSelectedIndex(3);
            } else if (n < 1) {
                int n3 = (int)(l3 / 3600000L);
                if (n3 < 1) {
                    int n4 = (int)(l3 / 60000L);
                    RateComparisonApplication.this.alternateBillingCycleTextField.setText(n4);
                    RateComparisonApplication.this.alternateBillingCycleComboBox.setSelectedIndex(0);
                } else {
                    RateComparisonApplication.this.alternateBillingCycleTextField.setText(n3);
                    RateComparisonApplication.this.alternateBillingCycleComboBox.setSelectedIndex(1);
                }
            } else {
                RateComparisonApplication.this.alternateBillingCycleTextField.setText(n);
                RateComparisonApplication.this.alternateBillingCycleComboBox.setSelectedIndex(2);
            }
        }
    }

    private class MeterFilterTree
    extends FilterTree {
        public MeterFilterTree(ResourceManager resourceManager) {
            super(resourceManager);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            boolean bl = (mouseEvent.getModifiers() & 4) != 0;
            boolean bl2 = mouseEvent.isControlDown();
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                this.clearSelection();
                return;
            }
            if (bl) {
                if (bl2) {
                    this.addSelectionPath(treePath);
                } else {
                    this.setSelectionPath(treePath);
                }
            }
        }
    }

    private class MeterTreePanel
    extends JComponent {
        public MeterTreePanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(1, 2, 2));
            RateComparisonApplication.this.filterSelection = new XpComboBox();
            RateComparisonApplication.this.filterSelection.addActionListener(RateComparisonApplication.this);
            jPanel.add(RateComparisonApplication.this.filterSelection);
            this.add((Component)jPanel, "North");
            RateComparisonApplication.this.tree = new MeterFilterTree(RateComparisonApplication.this.getResourceManager());
            RateComparisonApplication.this.tree.getSelectionModel().setSelectionMode(4);
            RateComparisonApplication.this.tree.addTreeSelectionListener(RateComparisonApplication.this);
            this.add((Component)new JScrollPane(RateComparisonApplication.this.tree), "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            float f = (float)(dimension.width + 30) * 1.2f;
            return new Dimension((int)f, dimension.height);
        }
    }

    private class RunReportThread
    extends Thread {
        public RunReportThread() {
            super("RunRateComparison");
        }

        public void run() {
            RateComparisonApplication.this.reportRunning = true;
            RateComparisonApplication.this.runReport();
            RateComparisonApplication.this.reportRunning = false;
        }
    }
}

