/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.budget;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.report.ProjectedCostInfo;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.reports.budget.BudgetReportApplication;
import com.tridium.eas.cost.ui.reports.budget.BudgetReportComponentDetails;
import com.tridium.eas.cost.ui.reports.budget.BudgetReportData;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.EasScrollPane;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class BudgetReportDetailPanel
extends JPanel
implements Printable {
    private Font cellFont = null;
    private Font headerFont = null;
    private Font titleFont = null;
    private Font subtitleFont = null;
    private FontMetrics cellFontMetrics;
    private FontMetrics headerFontMetrics;
    private FontMetrics titleFontMetrics;
    private FontMetrics subtitleFontMetrics;
    private EasSession session = null;
    private ResourceManager resourceManager = null;
    private BudgetReportApplication parentApplication = null;
    private BudgetReportComponentDetails componentDetails = null;
    protected Lexicon lex;
    private NumberTextField totalBudgetCostTextField;
    private NumberTextField totalActualCostTextField;
    private NumberTextField totalDifferenceTextField;
    private EasTextField totalDeltaPercentageTextField;
    private JSplitPane upperPane = null;
    private JPanel reportPanel = null;
    private JLabel lastSelectedLabel = null;
    private BudgetReportData lastSelectedRow = null;
    private boolean firstLoad = true;
    private static final DecimalFormat percentFormat = new DecimalFormat("#0.0%");
    private int currentPage = 0;
    private BudgetReportData[] currentData = null;

    protected BudgetReportDetailPanel(ResourceManager resourceManager, BudgetReportApplication budgetReportApplication, Lexicon lexicon) {
        this.lex = lexicon;
        this.resourceManager = resourceManager;
        this.parentApplication = budgetReportApplication;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add((Component)jPanel, "Center");
        this.upperPane = new JSplitPane();
        this.upperPane.setDividerSize(4);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel2.add((Component)this.buildBudgetReportPanel(), gridBagConstraints);
        EasScrollPane easScrollPane = new EasScrollPane(jPanel2);
        easScrollPane.getViewport().setBackground(Color.white);
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        jPanel3.setBorder(BorderFactory.createTitledBorder(lexicon.getText("summary")));
        jPanel3.add((Component)easScrollPane, "Center");
        JPanel jPanel4 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        jPanel4.add((Component)new JLabel(lexicon.getText("totals"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalBudgetCostTextField = new CostTextField(9, false);
        this.totalBudgetCostTextField.setHorizontalAlignment(4);
        DecimalFormat decimalFormat = new DecimalFormat(lexicon.getText("costValueFormat"));
        this.totalBudgetCostTextField.setFormatter(decimalFormat);
        this.totalBudgetCostTextField.setMaximumFractionDigits(2);
        this.totalBudgetCostTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalBudgetCostTextField.setEditable(false);
        jPanel4.add((Component)this.totalBudgetCostTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalActualCostTextField = new CostTextField(9, false);
        this.totalActualCostTextField.setHorizontalAlignment(4);
        this.totalActualCostTextField.setFormatter(decimalFormat);
        this.totalActualCostTextField.setMaximumFractionDigits(2);
        this.totalActualCostTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalActualCostTextField.setEditable(false);
        jPanel4.add((Component)this.totalActualCostTextField, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalDifferenceTextField = new CostTextField(9, false);
        this.totalDifferenceTextField.setHorizontalAlignment(4);
        this.totalDifferenceTextField.setFormatter(decimalFormat);
        this.totalDifferenceTextField.setMaximumFractionDigits(2);
        this.totalDifferenceTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalDifferenceTextField.setEditable(false);
        jPanel4.add((Component)this.totalDifferenceTextField, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalDeltaPercentageTextField = new EasTextField(9);
        this.totalDeltaPercentageTextField.setHorizontalAlignment(4);
        this.totalDeltaPercentageTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalDeltaPercentageTextField.setEditable(false);
        jPanel4.add((Component)this.totalDeltaPercentageTextField, gridBagConstraints);
        jPanel3.add((Component)jPanel4, "South");
        this.upperPane.setLeftComponent(jPanel3);
        this.upperPane.setRightComponent(this.buildCycleDetailPanel());
        jPanel.add((Component)this.upperPane, "Center");
        this.setBudgetData(null);
    }

    private JComponent buildBudgetReportPanel() {
        this.reportPanel = new JPanel(new GridBagLayout(), false);
        return this.reportPanel;
    }

    private JComponent buildCycleDetailPanel() {
        this.componentDetails = new BudgetReportComponentDetails(this.lex);
        return this.componentDetails;
    }

    private static String computeDeltaPercentage(double d, double d2) {
        double d3 = 0.0;
        if (d == 0.0) {
            if (d2 != 0.0) {
                return "";
            }
        } else {
            d3 = (d2 - d) / d;
        }
        return percentFormat.format(d3);
    }

    private LabelRowPair layoutBudgetReport(BudgetReportData[] budgetReportDataArray) {
        LabelRowPair labelRowPair = null;
        this.reportPanel.removeAll();
        double d = 0.0;
        double d2 = 0.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        int n = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.reportPanel.add((Component)new JLabel(this.lex.getText("billingCycle"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.reportPanel.add((Component)new JLabel(this.lex.getText("budgetCost"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.reportPanel.add((Component)new JLabel(this.lex.getText("actualCost"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.reportPanel.add((Component)new JLabel(this.lex.getText("deltaCost"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.reportPanel.add((Component)new JLabel(this.lex.getText("%") + " " + this.lex.getText("deltaCost"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        this.reportPanel.add((Component)new JSeparator(0), gridBagConstraints);
        boolean bl = false;
        if (budgetReportDataArray != null && budgetReportDataArray.length > 0) {
            for (int i = 0; i < budgetReportDataArray.length; ++i) {
                Object object;
                if (budgetReportDataArray[i] == null) continue;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 10;
                JLabel jLabel = new JLabel(budgetReportDataArray[i].getBillingCycle(this.lex), 0);
                jLabel.addMouseListener(new BudgetMouseAdapter(budgetReportDataArray[i]));
                jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
                this.reportPanel.add((Component)jLabel, gridBagConstraints);
                if (labelRowPair == null) {
                    labelRowPair = new LabelRowPair(jLabel, budgetReportDataArray[i]);
                }
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField = new CostTextField(9, false);
                costTextField.setHorizontalAlignment(4);
                DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
                costTextField.setFormatter(decimalFormat);
                costTextField.setMaximumFractionDigits(2);
                costTextField.setUseLabelAppearanceWhenDisabled(true);
                double d3 = budgetReportDataArray[i].getTotalBudgetCost();
                costTextField.setText(d3);
                costTextField.setEditable(false);
                this.reportPanel.add((Component)costTextField, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField2 = new CostTextField(9, false);
                costTextField2.setHorizontalAlignment(4);
                costTextField2.setFormatter(decimalFormat);
                costTextField2.setMaximumFractionDigits(2);
                costTextField2.setUseLabelAppearanceWhenDisabled(true);
                double d4 = 0.0;
                boolean bl2 = false;
                if (this.parentApplication.projectCosts() && budgetReportDataArray[i].isPartialReport()) {
                    object = budgetReportDataArray[i].computeProjectedCosts();
                    d4 = ((ProjectedCostInfo)object).getProjectedCost();
                    costTextField2.setBackground(Color.yellow);
                    bl2 = true;
                    bl = true;
                    budgetReportDataArray[i].setShowProjection(true);
                } else {
                    d4 = budgetReportDataArray[i].getTotalActualCost();
                }
                costTextField2.setText(d4);
                costTextField2.setEditable(false);
                this.reportPanel.add((Component)costTextField2, gridBagConstraints);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                object = new CostTextField(9, false);
                ((JTextField)object).setHorizontalAlignment(4);
                ((NumberTextField)object).setFormatter(decimalFormat);
                ((NumberTextField)object).setMaximumFractionDigits(2);
                ((EasTextField)object).setUseLabelAppearanceWhenDisabled(true);
                if (bl2) {
                    ((JComponent)object).setBackground(Color.yellow);
                }
                ((NumberTextField)object).setText(d4 - d3);
                ((JTextComponent)object).setEditable(false);
                this.reportPanel.add((Component)object, gridBagConstraints);
                gridBagConstraints.gridx = 4;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                EasTextField easTextField = new EasTextField(9);
                easTextField.setHorizontalAlignment(4);
                easTextField.setUseLabelAppearanceWhenDisabled(true);
                if (bl2) {
                    easTextField.setBackground(Color.yellow);
                }
                easTextField.setText(BudgetReportDetailPanel.computeDeltaPercentage(d3, d4));
                easTextField.setEditable(false);
                this.reportPanel.add((Component)easTextField, gridBagConstraints);
                d += d3;
                d2 += d4;
            }
            if (bl) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 5;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 17;
                JLabel jLabel = new JLabel(this.lex.getText("yellowCostsProjected"), 2);
                jLabel.setBackground(Color.yellow);
                jLabel.setOpaque(true);
                this.reportPanel.add((Component)jLabel, gridBagConstraints);
            }
        }
        if (bl) {
            this.totalActualCostTextField.setBackground(Color.yellow);
            this.totalDifferenceTextField.setBackground(Color.yellow);
            this.totalDeltaPercentageTextField.setBackground(Color.yellow);
        } else {
            Color color = this.totalBudgetCostTextField.getBackground();
            this.totalActualCostTextField.setBackground(color);
            this.totalDifferenceTextField.setBackground(color);
            this.totalDeltaPercentageTextField.setBackground(color);
        }
        this.totalBudgetCostTextField.setText(d);
        this.totalActualCostTextField.setText(d2);
        this.totalDifferenceTextField.setText(d2 - d);
        this.totalDeltaPercentageTextField.setText(BudgetReportDetailPanel.computeDeltaPercentage(d, d2));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        this.reportPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.reportPanel.revalidate();
        this.reportPanel.repaint();
        return labelRowPair;
    }

    public void setBudgetData(BudgetReportData[] budgetReportDataArray) {
        this.currentData = budgetReportDataArray;
        LabelRowPair labelRowPair = this.layoutBudgetReport(budgetReportDataArray);
        if (this.firstLoad && budgetReportDataArray != null) {
            this.upperPane.setDividerLocation(-1);
            this.firstLoad = false;
        }
        if (labelRowPair != null) {
            labelRowPair.getLabel().setBorder(BorderFactory.createBevelBorder(1, Color.red, Color.red));
            this.lastSelectedLabel = labelRowPair.getLabel();
            BudgetReportData budgetReportData = labelRowPair.getRow();
            boolean bl = false;
            if (budgetReportData != null) {
                bl = budgetReportData.getShowProjection();
            }
            this.componentDetails.setBudgetData(budgetReportData, bl, this.parentApplication.doShowDetails());
            this.lastSelectedRow = labelRowPair.getRow();
        } else {
            this.componentDetails.setBudgetData(null, false, this.parentApplication.doShowDetails());
            this.lastSelectedRow = null;
        }
    }

    public void setShowDetails(boolean bl) {
        boolean bl2 = false;
        if (this.lastSelectedRow != null) {
            bl2 = this.lastSelectedRow.getShowProjection();
        }
        this.componentDetails.setBudgetData(this.lastSelectedRow, bl2, !bl);
    }

    protected void init(EasSession easSession) {
        this.session = easSession;
        this.componentDetails.init(easSession);
    }

    protected void initApplication() {
        this.parentApplication.initApplication(true);
    }

    protected EasSession getSession() {
        return this.session;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public BudgetReportApplication getParentApplication() {
        return this.parentApplication;
    }

    private void selectItLater(Component component) {
        if (component instanceof JTextField) {
            final JTextField jTextField = (JTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTextField.selectAll();
                }
            });
        }
    }

    private Font getCellFont() {
        if (this.cellFont == null) {
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            hashMap.put(TextAttribute.FAMILY, Theme.widget().getTextFont().getName());
            hashMap.put(TextAttribute.SIZE, new Float(10.0f));
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            this.cellFont = new Font(hashMap);
        }
        return this.cellFont;
    }

    private Font getHeaderFont() {
        if (this.headerFont == null) {
            this.headerFont = this.getCellFont().deriveFont(1);
        }
        return this.headerFont;
    }

    private Font getTitleFont() {
        if (this.titleFont == null) {
            this.titleFont = this.getCellFont().deriveFont(1, 14.0f);
        }
        return this.titleFont;
    }

    private Font getSubtitleFont() {
        if (this.subtitleFont == null) {
            this.subtitleFont = this.getCellFont().deriveFont(12.0f);
        }
        return this.subtitleFont;
    }

    private FontMetrics getCellFontMetrics() {
        if (this.cellFontMetrics == null) {
            this.cellFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getCellFont());
        }
        return this.cellFontMetrics;
    }

    private FontMetrics getHeaderFontMetrics() {
        if (this.headerFontMetrics == null) {
            this.headerFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getHeaderFont());
        }
        return this.headerFontMetrics;
    }

    private FontMetrics getTitleFontMetrics() {
        if (this.titleFontMetrics == null) {
            this.titleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getTitleFont());
        }
        return this.titleFontMetrics;
    }

    private FontMetrics getSubtitleFontMetrics() {
        if (this.subtitleFontMetrics == null) {
            this.subtitleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getSubtitleFont());
        }
        return this.subtitleFontMetrics;
    }

    private double calculatePreferredColumnWidth(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = this.lex.getText("billingCycle");
                break;
            }
            case 1: {
                string = this.lex.getText("budgetCost");
                break;
            }
            case 2: {
                string = this.lex.getText("actualCost");
                break;
            }
            case 3: {
                string = this.lex.getText("deltaCost");
                break;
            }
            case 4: {
                string = this.lex.getText("%") + " " + this.lex.getText("deltaCost");
            }
        }
        int n2 = this.getHeaderFontMetrics().stringWidth(string);
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        if (this.currentData != null && this.currentData.length > 0) {
            for (int i = 0; i < this.currentData.length; ++i) {
                if (this.currentData[i] == null) continue;
                String string2 = this.currentData[i].getBillingCycle(this.lex);
                double d = this.currentData[i].getTotalBudgetCost();
                double d2 = 0.0;
                if (this.parentApplication.projectCosts() && this.currentData[i].isPartialReport()) {
                    ProjectedCostInfo projectedCostInfo = this.currentData[i].computeProjectedCosts();
                    d2 = projectedCostInfo.getProjectedCost();
                } else {
                    d2 = this.currentData[i].getTotalActualCost();
                }
                double d3 = d2 - d;
                String string3 = BudgetReportDetailPanel.computeDeltaPercentage(d, d2);
                String string4 = "";
                switch (n) {
                    case 0: {
                        string4 = string2;
                        break;
                    }
                    case 1: {
                        string4 = decimalFormat.format(d);
                        break;
                    }
                    case 2: {
                        string4 = decimalFormat.format(d2);
                        break;
                    }
                    case 3: {
                        string4 = decimalFormat.format(d3);
                        break;
                    }
                    case 4: {
                        string4 = string3;
                    }
                }
                n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string4));
            }
        }
        if (n == 0) {
            n2 = Math.max(n2, this.getHeaderFontMetrics().stringWidth(this.lex.getText("totals")));
        } else {
            String string5 = "";
            switch (n) {
                case 1: {
                    string5 = this.totalBudgetCostTextField.getText();
                    break;
                }
                case 2: {
                    string5 = this.totalActualCostTextField.getText();
                    break;
                }
                case 3: {
                    string5 = this.totalDifferenceTextField.getText();
                    break;
                }
                case 4: {
                    string5 = this.totalDeltaPercentageTextField.getText();
                }
            }
            n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string5));
        }
        return n2 + 7;
    }

    private ArrayList filterLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (!stringTokenizer.hasMoreTokens()) {
            arrayList.add(string);
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private ArrayList getCellLines(String string, FontMetrics fontMetrics, double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = this.filterLines(string);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if ((double)fontMetrics.stringWidth(string2) <= d) {
                arrayList.add(string2);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                StringBuffer stringBuffer2 = new StringBuffer().append(stringBuffer.toString());
                String string4 = stringBuffer.length() == 0 ? "" : " ";
                if ((double)fontMetrics.stringWidth(stringBuffer2.append(string4).append(string3).toString()) > d) {
                    if (stringBuffer.length() == 0) {
                        stringBuffer = new StringBuffer(string3);
                        while ((double)fontMetrics.stringWidth(stringBuffer.toString()) > d) {
                            StringBuffer stringBuffer3 = new StringBuffer();
                            while ((double)fontMetrics.stringWidth(stringBuffer3.toString()) <= d) {
                                stringBuffer3.append(stringBuffer.charAt(0));
                                stringBuffer.deleteCharAt(0);
                            }
                            arrayList.add(stringBuffer3.toString());
                        }
                        continue;
                    }
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string3);
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string3);
            }
            if (stringBuffer.length() <= 0) continue;
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public int getEstimateNumPages() {
        return this.currentPage + 1;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        double d;
        int n11;
        int n12;
        this.currentPage = 0;
        if (this.currentData == null || this.currentData.length < 1) {
            this.currentPage = -1;
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n13 = 3;
        int n14 = 1;
        int n15 = 0;
        int n16 = (int)pageFormat.getImageableWidth();
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getTitleFont());
        ArrayList arrayList = this.getCellLines(this.lex.getText("budgetReport"), this.getTitleFontMetrics(), n16);
        String[] stringArray = arrayList.iterator();
        while (stringArray.hasNext()) {
            String string = (String)stringArray.next();
            int n17 = this.getTitleFontMetrics().stringWidth(string);
            int n18 = n16 / 2 - n17 / 2;
            int n19 = n15 + n13 + this.getTitleFontMetrics().getHeight() - this.getTitleFontMetrics().getDescent();
            if (this.currentPage == n) {
                graphics2D.drawString(string, n18, n19);
            }
            n15 += n13 + this.getTitleFontMetrics().getHeight();
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        stringArray = this.parentApplication.getMeterStrings();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                ArrayList arrayList2 = this.getCellLines(this.lex.getText("meter") + ":  " + stringArray[i], this.getSubtitleFontMetrics(), n16);
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    n12 = this.getSubtitleFontMetrics().stringWidth(string);
                    n11 = n16 / 2 - n12 / 2;
                    int n20 = n15 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
                    if ((double)n20 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n15 = 0;
                        n20 = n15 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
                    }
                    if (this.currentPage == n) {
                        graphics2D.drawString(string, n11, n20);
                    }
                    n15 += n13 + this.getSubtitleFontMetrics().getHeight();
                }
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        ArrayList arrayList3 = this.getCellLines(this.lex.getText("billPeriod") + ":  " + this.parentApplication.getBillPeriodString(), this.getSubtitleFontMetrics(), n16);
        Iterator iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n21 = this.getSubtitleFontMetrics().stringWidth(string);
            n12 = n16 / 2 - n21 / 2;
            n11 = n15 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            if ((double)n11 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n11 = n15 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n12, n11);
            }
            n15 += n13 + this.getSubtitleFontMetrics().getHeight();
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        arrayList3 = this.getCellLines(this.lex.getText("consecutiveBillingCycles") + ":  " + this.parentApplication.getNumConsecutiveCyclesString(), this.getSubtitleFontMetrics(), n16);
        iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n22 = this.getSubtitleFontMetrics().stringWidth(string);
            n12 = n16 / 2 - n22 / 2;
            n11 = n15 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            if ((double)n11 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n11 = n15 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n12, n11);
            }
            n15 += n13 + this.getSubtitleFontMetrics().getHeight();
        }
        int n23 = n15 += n13 + this.getSubtitleFontMetrics().getHeight();
        graphics2D.setFont(this.getHeaderFont());
        Color color = new Color(153, 153, 153);
        graphics2D.setColor(color);
        double d2 = 0.0;
        double d3 = d = this.calculatePreferredColumnWidth(0);
        ArrayList arrayList4 = this.getCellLines(this.lex.getText("billingCycle"), this.getHeaderFontMetrics(), n16);
        for (int i = 0; i < arrayList4.size(); ++i) {
            String string = (String)arrayList4.get(i);
            n10 = this.getHeaderFontMetrics().stringWidth(string);
            int n24 = (int)(d2 + d / 2.0 - (double)(n10 / 2));
            n9 = n15 + n13 + (i + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n9 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n9 = n15 + n13 + (i + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n24, n9);
        }
        d2 += d;
        arrayList4 = this.getCellLines(this.lex.getText("budgetCost"), this.getHeaderFontMetrics(), n16);
        double d4 = d = this.calculatePreferredColumnWidth(1);
        for (n10 = 0; n10 < arrayList4.size(); ++n10) {
            String string = (String)arrayList4.get(n10);
            n9 = this.getHeaderFontMetrics().stringWidth(string);
            int n25 = (int)(d2 + d / 2.0 - (double)(n9 / 2));
            n8 = n15 + n13 + (n10 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n8 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n8 = n15 + n13 + (n10 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n25, n8);
        }
        d2 += d;
        arrayList4 = this.getCellLines(this.lex.getText("actualCost"), this.getHeaderFontMetrics(), n16);
        double d5 = d = this.calculatePreferredColumnWidth(2);
        for (n9 = 0; n9 < arrayList4.size(); ++n9) {
            String string = (String)arrayList4.get(n9);
            n8 = this.getHeaderFontMetrics().stringWidth(string);
            int n26 = (int)(d2 + d / 2.0 - (double)(n8 / 2));
            n7 = n15 + n13 + (n9 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n7 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n7 = n15 + n13 + (n9 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n26, n7);
        }
        d2 += d;
        arrayList4 = this.getCellLines(this.lex.getText("deltaCost"), this.getHeaderFontMetrics(), n16);
        double d6 = d = this.calculatePreferredColumnWidth(3);
        for (n8 = 0; n8 < arrayList4.size(); ++n8) {
            String string = (String)arrayList4.get(n8);
            n7 = this.getHeaderFontMetrics().stringWidth(string);
            int n27 = (int)(d2 + d / 2.0 - (double)(n7 / 2));
            n6 = n15 + n13 + (n8 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n6 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n6 = n15 + n13 + (n8 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n27, n6);
        }
        d2 += d;
        arrayList4 = this.getCellLines(this.lex.getText("%") + " " + this.lex.getText("deltaCost"), this.getHeaderFontMetrics(), n16);
        double d7 = d = this.calculatePreferredColumnWidth(4);
        for (n7 = 0; n7 < arrayList4.size(); ++n7) {
            String string = (String)arrayList4.get(n7);
            n6 = this.getHeaderFontMetrics().stringWidth(string);
            int n28 = (int)(d2 + d / 2.0 - (double)(n6 / 2));
            int n29 = n15 + n13 + (n7 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n29 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n29 = n15 + n13 + (n7 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n28, n29);
        }
        n15 += n13 + this.getHeaderFontMetrics().getHeight();
        graphics2D.setFont(this.getCellFont());
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        boolean bl = false;
        for (n6 = 0; n6 < this.currentData.length; ++n6) {
            int n30;
            int n31;
            int n32;
            int n33;
            int n34;
            graphics2D.setColor(Color.black);
            if (this.currentData[n6] == null) continue;
            String string = this.currentData[n6].getBillingCycle(this.lex);
            double d8 = this.currentData[n6].getTotalBudgetCost();
            double d9 = 0.0;
            n5 = 0;
            if (this.parentApplication.projectCosts() && this.currentData[n6].isPartialReport()) {
                ProjectedCostInfo projectedCostInfo = this.currentData[n6].computeProjectedCosts();
                d9 = projectedCostInfo.getProjectedCost();
                n5 = 1;
                bl = true;
            } else {
                d9 = this.currentData[n6].getTotalActualCost();
            }
            double d10 = d9 - d8;
            String string2 = BudgetReportDetailPanel.computeDeltaPercentage(d8, d9);
            int n35 = 0;
            int n36 = (int)(d3 - (double)n13 - (double)n13 - (double)n14);
            d2 = 0.0;
            ArrayList arrayList5 = this.getCellLines(string, this.getCellFontMetrics(), n36);
            for (n34 = 0; n34 < arrayList5.size(); ++n34) {
                String string3 = (String)arrayList5.get(n34);
                int n37 = this.getCellFontMetrics().stringWidth(string3);
                n33 = (int)(d2 + (double)n13);
                n32 = n15 + n13 + (n34 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n32 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n15 = 0;
                    n32 = n15 + n13 + (n34 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string3, n33, n32);
            }
            n34 = this.getCellFontMetrics().getHeight() * arrayList5.size() + n13 + n13 + n14;
            n35 = Math.max(n34, n35);
            d2 += d3;
            n36 = (int)(d4 - (double)n13 - (double)n13 - (double)n14);
            arrayList5 = this.getCellLines(decimalFormat.format(d8), this.getCellFontMetrics(), n36);
            for (n31 = 0; n31 < arrayList5.size(); ++n31) {
                String string4 = (String)arrayList5.get(n31);
                n33 = this.getCellFontMetrics().stringWidth(string4);
                n32 = (int)(d2 + d4 - (double)n13 - (double)n33);
                n30 = n15 + n13 + (n31 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n30 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n15 = 0;
                    n30 = n15 + n13 + (n31 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string4, n32, n30);
            }
            n34 = this.getCellFontMetrics().getHeight() * arrayList5.size() + n13 + n13 + n14;
            n35 = Math.max(n34, n35);
            d2 += d4;
            n36 = (int)(d5 - (double)n13 - (double)n13 - (double)n14);
            if (n5 != 0) {
                graphics2D.setColor(color);
            } else {
                graphics2D.setColor(Color.black);
            }
            arrayList5 = this.getCellLines(decimalFormat.format(d9), this.getCellFontMetrics(), n36);
            for (n31 = 0; n31 < arrayList5.size(); ++n31) {
                String string5 = (String)arrayList5.get(n31);
                n33 = this.getCellFontMetrics().stringWidth(string5);
                n32 = (int)(d2 + d5 - (double)n13 - (double)n33);
                n30 = n15 + n13 + (n31 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n30 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n15 = 0;
                    n30 = n15 + n13 + (n31 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string5, n32, n30);
            }
            n34 = this.getCellFontMetrics().getHeight() * arrayList5.size() + n13 + n13 + n14;
            n35 = Math.max(n34, n35);
            d2 += d5;
            n36 = (int)(d6 - (double)n13 - (double)n13 - (double)n14);
            arrayList5 = this.getCellLines(decimalFormat.format(d10), this.getCellFontMetrics(), n36);
            for (n31 = 0; n31 < arrayList5.size(); ++n31) {
                String string6 = (String)arrayList5.get(n31);
                n33 = this.getCellFontMetrics().stringWidth(string6);
                n32 = (int)(d2 + d6 - (double)n13 - (double)n33);
                n30 = n15 + n13 + (n31 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n30 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n15 = 0;
                    n30 = n15 + n13 + (n31 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string6, n32, n30);
            }
            n34 = this.getCellFontMetrics().getHeight() * arrayList5.size() + n13 + n13 + n14;
            n35 = Math.max(n34, n35);
            d2 += d6;
            n36 = (int)(d7 - (double)n13 - (double)n13 - (double)n14);
            arrayList5 = this.getCellLines(string2, this.getCellFontMetrics(), n36);
            for (n31 = 0; n31 < arrayList5.size(); ++n31) {
                String string7 = (String)arrayList5.get(n31);
                n33 = this.getCellFontMetrics().stringWidth(string7);
                n32 = (int)(d2 + d7 - (double)n13 - (double)n33);
                n30 = n15 + n13 + (n31 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n30 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n15 = 0;
                    n30 = n15 + n13 + (n31 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string7, n32, n30);
            }
            n34 = this.getCellFontMetrics().getHeight() * arrayList5.size() + n13 + n13 + n14;
            n35 = Math.max(n34, n35);
            n15 += n35;
        }
        graphics2D.setColor(color);
        graphics2D.setFont(this.getHeaderFont());
        n6 = 0;
        int n38 = (int)(d3 - (double)n13 - (double)n13 - (double)n14);
        d2 = 0.0;
        ArrayList arrayList6 = this.getCellLines(this.lex.getText("totals"), this.getHeaderFontMetrics(), n38);
        for (n4 = 0; n4 < arrayList6.size(); ++n4) {
            String string = (String)arrayList6.get(n4);
            int n39 = this.getHeaderFontMetrics().stringWidth(string);
            n5 = (int)(d2 + (double)n13);
            int n40 = n15 + n13 + (n4 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n40 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n40 = n15 + n13 + (n4 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n5, n40);
        }
        n4 = this.getHeaderFontMetrics().getHeight() * arrayList6.size() + n13 + n13 + n14;
        n6 = Math.max(n4, n6);
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getCellFont());
        d2 += d3;
        n38 = (int)(d4 - (double)n13 - (double)n13 - (double)n14);
        arrayList6 = this.getCellLines(this.totalBudgetCostTextField.getText(), this.getCellFontMetrics(), n38);
        for (n3 = 0; n3 < arrayList6.size(); ++n3) {
            String string = (String)arrayList6.get(n3);
            n5 = this.getCellFontMetrics().stringWidth(string);
            int n41 = (int)(d2 + d4 - (double)n13 - (double)n5);
            n2 = n15 + n13 + (n3 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n2 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n2 = n15 + n13 + (n3 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n41, n2);
        }
        n4 = this.getCellFontMetrics().getHeight() * arrayList6.size() + n13 + n13 + n14;
        n6 = Math.max(n4, n6);
        if (bl) {
            graphics2D.setColor(color);
        }
        d2 += d4;
        n38 = (int)(d5 - (double)n13 - (double)n13 - (double)n14);
        arrayList6 = this.getCellLines(this.totalActualCostTextField.getText(), this.getCellFontMetrics(), n38);
        for (n3 = 0; n3 < arrayList6.size(); ++n3) {
            String string = (String)arrayList6.get(n3);
            n5 = this.getCellFontMetrics().stringWidth(string);
            int n42 = (int)(d2 + d5 - (double)n13 - (double)n5);
            n2 = n15 + n13 + (n3 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n2 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n2 = n15 + n13 + (n3 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n42, n2);
        }
        n4 = this.getCellFontMetrics().getHeight() * arrayList6.size() + n13 + n13 + n14;
        n6 = Math.max(n4, n6);
        d2 += d5;
        n38 = (int)(d6 - (double)n13 - (double)n13 - (double)n14);
        arrayList6 = this.getCellLines(this.totalDifferenceTextField.getText(), this.getCellFontMetrics(), n38);
        for (n3 = 0; n3 < arrayList6.size(); ++n3) {
            String string = (String)arrayList6.get(n3);
            n5 = this.getCellFontMetrics().stringWidth(string);
            int n43 = (int)(d2 + d6 - (double)n13 - (double)n5);
            n2 = n15 + n13 + (n3 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n2 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n2 = n15 + n13 + (n3 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n43, n2);
        }
        n4 = this.getCellFontMetrics().getHeight() * arrayList6.size() + n13 + n13 + n14;
        n6 = Math.max(n4, n6);
        d2 += d6;
        n38 = (int)(d7 - (double)n13 - (double)n13 - (double)n14);
        arrayList6 = this.getCellLines(this.totalDeltaPercentageTextField.getText(), this.getCellFontMetrics(), n38);
        for (n3 = 0; n3 < arrayList6.size(); ++n3) {
            String string = (String)arrayList6.get(n3);
            n5 = this.getCellFontMetrics().stringWidth(string);
            int n44 = (int)(d2 + d7 - (double)n13 - (double)n5);
            n2 = n15 + n13 + (n3 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n2 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n15 = 0;
                n2 = n15 + n13 + (n3 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n44, n2);
        }
        n4 = this.getCellFontMetrics().getHeight() * arrayList6.size() + n13 + n13 + n14;
        n6 = Math.max(n4, n6);
        n15 += n6;
        if (bl) {
            n15 += n13 + this.getCellFontMetrics().getHeight();
            arrayList6 = this.getCellLines(this.lex.getText("grayCostsProjected"), this.getCellFontMetrics(), n16);
            Iterator iterator2 = arrayList6.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                n5 = this.getCellFontMetrics().stringWidth(string);
                int n45 = n16 / 2 - n5 / 2;
                n2 = n15 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                if ((double)n2 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n15 = 0;
                    n2 = n15 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                }
                if (this.currentPage == n) {
                    graphics2D.drawString(string, n45, n2);
                }
                n15 += n13 + this.getCellFontMetrics().getHeight();
            }
        }
        if (this.currentPage < n) {
            return 1;
        }
        return 0;
    }

    private class LabelRowPair {
        private JLabel label;
        private BudgetReportData row;

        public LabelRowPair(JLabel jLabel, BudgetReportData budgetReportData) {
            this.label = jLabel;
            this.row = budgetReportData;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public BudgetReportData getRow() {
            return this.row;
        }
    }

    private class BudgetMouseAdapter
    extends MouseAdapter {
        private BudgetReportData referenceRow;

        public BudgetMouseAdapter(BudgetReportData budgetReportData) {
            this.referenceRow = budgetReportData;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == BudgetReportDetailPanel.this.lastSelectedLabel) {
                return;
            }
            if (BudgetReportDetailPanel.this.lastSelectedLabel != null) {
                BudgetReportDetailPanel.this.lastSelectedLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            jLabel.setBorder(BorderFactory.createBevelBorder(1, Color.red, Color.red));
            BudgetReportDetailPanel.this.lastSelectedLabel = jLabel;
            boolean bl = false;
            if (this.referenceRow != null) {
                bl = this.referenceRow.getShowProjection();
            }
            BudgetReportDetailPanel.this.componentDetails.setBudgetData(this.referenceRow, bl, BudgetReportDetailPanel.this.parentApplication.doShowDetails());
            BudgetReportDetailPanel.this.lastSelectedRow = this.referenceRow;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == BudgetReportDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == BudgetReportDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }
}

