/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.budget;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.cost.datatypes.RateBillingPeriod;
import com.tridium.eas.cost.report.Budget;
import com.tridium.eas.cost.report.ProjectedCostInfo;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.util.CostTimeUtil;
import javax.baja.util.Lexicon;

public class BudgetReportData {
    private String billingCycle = "Jan2004";
    private ReconciliationReport[] reconciliations = null;
    private Budget[] budgets = null;
    private boolean showProjection = false;
    private ProjectedCostInfo lastProjection = null;

    public BudgetReportData(String string, ReconciliationReport[] reconciliationReportArray, Budget[] budgetArray) {
        this.setBillingCycle(string);
        this.setReconciliations(reconciliationReportArray);
        this.setBudgets(budgetArray);
    }

    public String getBillingCycle() {
        return this.billingCycle;
    }

    public void setBillingCycle(String string) {
        this.billingCycle = string;
    }

    public ReconciliationReport[] getReconciliations() {
        return this.reconciliations;
    }

    public void setReconciliations(ReconciliationReport[] reconciliationReportArray) {
        this.reconciliations = reconciliationReportArray;
    }

    public Budget[] getBudgets() {
        return this.budgets;
    }

    public void setBudgets(Budget[] budgetArray) {
        this.budgets = budgetArray;
    }

    public boolean getShowProjection() {
        return this.showProjection;
    }

    public void setShowProjection(boolean bl) {
        this.showProjection = bl;
    }

    public String getBillingCycle(Lexicon lexicon) {
        String string = this.getBillingCycle();
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        return lexicon.getText(string2) + " " + string3;
    }

    public double getTotalCalculatedCost() {
        ReconciliationReport[] reconciliationReportArray = this.getReconciliations();
        double d = 0.0;
        if (reconciliationReportArray != null) {
            for (int i = 0; i < reconciliationReportArray.length; ++i) {
                if (reconciliationReportArray[i] == null) continue;
                d += reconciliationReportArray[i].getTotalCalculatedCost();
            }
        }
        return d;
    }

    public double getTotalActualCost() {
        ReconciliationReport[] reconciliationReportArray = this.getReconciliations();
        double d = 0.0;
        if (reconciliationReportArray != null) {
            for (int i = 0; i < reconciliationReportArray.length; ++i) {
                if (reconciliationReportArray[i] == null) continue;
                d += reconciliationReportArray[i].getTotalActualCost(false, 1.0);
            }
        }
        return d;
    }

    public double getTotalBudgetCost() {
        Budget[] budgetArray = this.getBudgets();
        double d = 0.0;
        if (budgetArray != null) {
            for (int i = 0; i < budgetArray.length; ++i) {
                if (budgetArray[i] == null) continue;
                d += budgetArray[i].getBudgetCost();
            }
        }
        return d;
    }

    public boolean isPartialReport() {
        if (this.reconciliations != null) {
            long l = EasLocalTime.getCurrentTime().getTimestamp(CostTimeUtil.DEFAULT_TZ);
            for (int i = 0; i < this.reconciliations.length; ++i) {
                RateBillingPeriod[] rateBillingPeriodArray;
                if (this.reconciliations[i] == null || (rateBillingPeriodArray = this.reconciliations[i].getRateBillingPeriods()) == null) continue;
                for (int j = 0; j < rateBillingPeriodArray.length; ++j) {
                    if (rateBillingPeriodArray[j] == null || l >= rateBillingPeriodArray[j].getEndTime()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ProjectedCostInfo computeProjectedCosts() {
        if (this.reconciliations != null) {
            long l = EasLocalTime.getCurrentTime().getTimestamp(CostTimeUtil.DEFAULT_TZ);
            double d = 0.0;
            double[] dArray = new double[this.reconciliations.length];
            for (int i = 0; i < this.reconciliations.length; ++i) {
                ProjectedCostInfo projectedCostInfo;
                dArray[i] = -1.0;
                if (this.reconciliations[i] == null || (projectedCostInfo = this.reconciliations[i].computeProjectedCosts(l)) == null) continue;
                dArray[i] = projectedCostInfo.getConfidenceFactor();
                d += projectedCostInfo.getProjectedCost();
            }
            double d2 = 0.0;
            double d3 = 0.0;
            int n = 0;
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] >= 0.0)) continue;
                d3 += dArray[i];
                ++n;
            }
            if (n > 0) {
                d2 = d3 / (double)n;
            }
            this.lastProjection = new ProjectedCostInfo(d, d2);
            return this.lastProjection;
        }
        this.lastProjection = null;
        return this.lastProjection;
    }

    public ProjectedCostInfo getProjectedCosts() {
        return this.lastProjection;
    }
}

