/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.reports.analyzer;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.components.FixedFee;
import com.tridium.eas.cost.report.AnalyzerAdjustment;
import com.tridium.eas.cost.report.AnalyzerReport;
import com.tridium.eas.cost.report.BillCycleResult;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.reports.analyzer.AnalyzerComponentDetailPanel;
import com.tridium.eas.cost.ui.reports.analyzer.WhatIfAnalyzerApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.EasScrollPane;
import com.tridium.eas.ui.widgets.NumberTextField;
import com.tridium.ui.theme.Theme;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AnalyzerDetailPanel
extends JPanel
implements Printable {
    private Font cellFont = null;
    private Font headerFont = null;
    private Font titleFont = null;
    private Font subtitleFont = null;
    private FontMetrics cellFontMetrics;
    private FontMetrics headerFontMetrics;
    private FontMetrics titleFontMetrics;
    private FontMetrics subtitleFontMetrics;
    private EasSession session = null;
    private ResourceManager resourceManager = null;
    private WhatIfAnalyzerApplication parentApplication = null;
    private AnalyzerComponentDetailPanel componentDetails = null;
    protected Lexicon lex;
    private CardLayout layout = null;
    private AnalyzerReport currentSelectedReport = null;
    private NumberTextField totalCalcCostTextField;
    private NumberTextField totalAdjustedCostTextField;
    private NumberTextField totalSavingsTextField;
    private JSplitPane defaultPane = null;
    private JSplitPane upperPane = null;
    private JPanel reportPanel = null;
    private BillCycleResult[] reportRows = null;
    private JLabel lastSelectedLabel = null;
    private BillCycleResult lastSelectedRow = null;
    private boolean changeOccurred = false;
    private boolean firstLoad = true;
    private int savedDividerLocation = 0;
    private boolean adjustDivider = false;
    private Hashtable adjustedCostFields;
    private JButton resetAllButton;
    private int currentPage = 0;

    protected AnalyzerDetailPanel(ResourceManager resourceManager, WhatIfAnalyzerApplication whatIfAnalyzerApplication, Lexicon lexicon) {
        this.lex = lexicon;
        this.resourceManager = resourceManager;
        this.parentApplication = whatIfAnalyzerApplication;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add("show", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        this.add("hide", jPanel2);
        jPanel2.add((Component)this.buildDefaultView(), "Center");
        this.upperPane = new JSplitPane();
        this.upperPane.setDividerSize(4);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel3.add((Component)this.buildAnalyzerReportPanel(), gridBagConstraints);
        EasScrollPane easScrollPane = new EasScrollPane(jPanel3);
        easScrollPane.getViewport().setBackground(Color.white);
        JPanel jPanel4 = new JPanel(new BorderLayout(), false);
        jPanel4.setBorder(BorderFactory.createTitledBorder(lexicon.getText("billCycleSummary")));
        jPanel4.add((Component)easScrollPane, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout(), false);
        JPanel jPanel6 = new JPanel(new FlowLayout(1), false);
        this.resetAllButton = new JButton(lexicon.getText("resetAll"));
        this.resetAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzerDetailPanel.this.resetAll();
            }
        });
        jPanel6.add(this.resetAllButton);
        jPanel5.add((Component)jPanel6, "South");
        JPanel jPanel7 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(lexicon.getText("grandTotal") + "   ", 4);
        jLabel.setBackground(Color.darkGray);
        jLabel.setForeground(Color.green);
        jLabel.setOpaque(true);
        jPanel7.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalCalcCostTextField = new CostTextField(9, false);
        this.totalCalcCostTextField.setHorizontalAlignment(4);
        DecimalFormat decimalFormat = new DecimalFormat(lexicon.getText("costValueFormat"));
        this.totalCalcCostTextField.setFormatter(decimalFormat);
        this.totalCalcCostTextField.setMaximumFractionDigits(2);
        this.totalCalcCostTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalCalcCostTextField.setEditable(false);
        jPanel7.add((Component)this.totalCalcCostTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalAdjustedCostTextField = new CostTextField(9, false);
        this.totalAdjustedCostTextField.setHorizontalAlignment(4);
        this.totalAdjustedCostTextField.setFormatter(decimalFormat);
        this.totalAdjustedCostTextField.setMaximumFractionDigits(2);
        this.totalAdjustedCostTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalAdjustedCostTextField.setEditable(false);
        jPanel7.add((Component)this.totalAdjustedCostTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel2 = new JLabel(lexicon.getText("savings") + "   ", 4);
        jLabel2.setBackground(Color.darkGray);
        jLabel2.setForeground(Color.green);
        jLabel2.setOpaque(true);
        jPanel7.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        this.totalSavingsTextField = new CostTextField(9, false);
        this.totalSavingsTextField.setHorizontalAlignment(4);
        this.totalSavingsTextField.setFormatter(decimalFormat);
        this.totalSavingsTextField.setMaximumFractionDigits(2);
        this.totalSavingsTextField.setUseLabelAppearanceWhenDisabled(true);
        this.totalSavingsTextField.setEditable(false);
        jPanel7.add((Component)this.totalSavingsTextField, gridBagConstraints);
        jPanel5.add((Component)jPanel7, "North");
        jPanel4.add((Component)jPanel5, "South");
        this.upperPane.setLeftComponent(jPanel4);
        this.upperPane.setRightComponent(this.buildAnalyzerRowEditorPanel());
        jPanel.add((Component)this.upperPane, "Center");
        this.setAnalyzerEditorValue(null, false);
    }

    private JComponent buildDefaultView() {
        this.defaultPane = new JSplitPane();
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)new JLabel(this.lex.getText("billingCycle"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)new JLabel(this.lex.getText("calculatedCost"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)new JLabel(this.lex.getText("adjustedCost"), 0), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)new JSeparator(0), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        EasScrollPane easScrollPane = new EasScrollPane(jPanel);
        easScrollPane.getViewport().setBackground(Color.white);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.lex.getText("billCycleSummary")));
        jPanel2.add((Component)easScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(), false);
        JPanel jPanel4 = new JPanel(new FlowLayout(1), false);
        JButton jButton = new JButton(this.lex.getText("resetAll"));
        jButton.setEnabled(false);
        jPanel4.add(jButton);
        jPanel3.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel(new GridBagLayout(), false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(this.lex.getText("grandTotal") + "   ", 4);
        jLabel.setBackground(Color.darkGray);
        jLabel.setForeground(Color.green);
        jLabel.setOpaque(true);
        jPanel5.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        CostTextField costTextField = new CostTextField(9, false);
        costTextField.setHorizontalAlignment(4);
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        costTextField.setFormatter(decimalFormat);
        costTextField.setMaximumFractionDigits(2);
        costTextField.setUseLabelAppearanceWhenDisabled(true);
        costTextField.setText(0.0);
        costTextField.setEditable(false);
        jPanel5.add((Component)costTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        CostTextField costTextField2 = new CostTextField(9, false);
        costTextField2.setHorizontalAlignment(4);
        costTextField2.setFormatter(decimalFormat);
        costTextField2.setMaximumFractionDigits(2);
        costTextField2.setUseLabelAppearanceWhenDisabled(true);
        costTextField2.setText(0.0);
        costTextField2.setEditable(false);
        jPanel5.add((Component)costTextField2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel2 = new JLabel(this.lex.getText("savings") + "   ", 4);
        jLabel2.setBackground(Color.darkGray);
        jLabel2.setForeground(Color.green);
        jLabel2.setOpaque(true);
        jPanel5.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        CostTextField costTextField3 = new CostTextField(9, false);
        costTextField3.setHorizontalAlignment(4);
        costTextField3.setFormatter(decimalFormat);
        costTextField3.setMaximumFractionDigits(2);
        costTextField3.setUseLabelAppearanceWhenDisabled(true);
        costTextField3.setText(0.0);
        costTextField3.setEditable(false);
        jPanel5.add((Component)costTextField3, gridBagConstraints);
        jPanel3.add((Component)jPanel5, "North");
        jPanel2.add((Component)jPanel3, "South");
        this.defaultPane.setLeftComponent(jPanel2);
        JPanel jPanel6 = new JPanel(new BorderLayout(), false);
        jPanel6.setBorder(BorderFactory.createTitledBorder(this.lex.getText("billCycleDetails")));
        this.defaultPane.setRightComponent(jPanel6);
        return this.defaultPane;
    }

    private JComponent buildAnalyzerReportPanel() {
        this.reportPanel = new JPanel(new GridBagLayout(), false);
        return this.reportPanel;
    }

    private JComponent buildAnalyzerRowEditorPanel() {
        this.componentDetails = new AnalyzerComponentDetailPanel(this, this.lex);
        return this.componentDetails;
    }

    private LabelRowPair layoutAnalyzerReport(AnalyzerReport analyzerReport) {
        LabelRowPair labelRowPair = null;
        this.reportPanel.removeAll();
        this.adjustedCostFields = null;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        if (analyzerReport == null || analyzerReport.getCycleResults() == null) {
            this.reportPanel.add((Component)new JLabel(this.lex.getText("noCycleResults")), gridBagConstraints);
            gridBagConstraints.gridy = 2;
        } else {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            this.reportPanel.add((Component)new JLabel(this.lex.getText("billingCycle"), 0), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            this.reportPanel.add((Component)new JLabel(this.lex.getText("calculatedCost"), 0), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            this.reportPanel.add((Component)new JLabel(this.lex.getText("adjustedCost"), 0), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 12;
            this.reportPanel.add((Component)new JSeparator(0), gridBagConstraints);
            this.reportRows = analyzerReport.getCycleResults();
            this.adjustedCostFields = new Hashtable(this.reportRows.length);
            for (int i = 0; i < this.reportRows.length; ++i) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = i + 3;
                gridBagConstraints.weightx = 100.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.anchor = 10;
                JLabel jLabel = new JLabel(this.reportRows[i].getBillingCycle(this.lex), 0);
                jLabel.addMouseListener(new AnalyzerMouseAdapter(this.reportRows[i]));
                jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
                this.reportPanel.add((Component)jLabel, gridBagConstraints);
                if (labelRowPair == null) {
                    labelRowPair = new LabelRowPair(jLabel, this.reportRows[i]);
                }
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField = new CostTextField(9, false);
                costTextField.setHorizontalAlignment(4);
                DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
                costTextField.setFormatter(decimalFormat);
                costTextField.setMaximumFractionDigits(2);
                costTextField.setUseLabelAppearanceWhenDisabled(true);
                costTextField.setText(this.reportRows[i].getCalculatedCost());
                costTextField.setEditable(false);
                this.reportPanel.add((Component)costTextField, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                CostTextField costTextField2 = new CostTextField(9, false);
                costTextField2.setHorizontalAlignment(4);
                costTextField2.setFormatter(decimalFormat);
                costTextField2.setMaximumFractionDigits(2);
                costTextField2.setUseLabelAppearanceWhenDisabled(true);
                costTextField2.setText(this.reportRows[i].getAdjustedCost());
                costTextField2.setEditable(false);
                this.adjustedCostFields.put(this.reportRows[i], costTextField2);
                this.reportPanel.add((Component)costTextField2, gridBagConstraints);
            }
            gridBagConstraints.gridy = this.reportRows.length + 3;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.anchor = 17;
        this.reportPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.reportPanel.revalidate();
        this.reportPanel.repaint();
        return labelRowPair;
    }

    public void setAnalyzerEditorValue(AnalyzerReport analyzerReport, boolean bl) {
        this.currentSelectedReport = analyzerReport;
        if (analyzerReport == null && !bl) {
            this.layout.show(this, "hide");
            this.componentDetails.setAnalyzerRowEditorValue(null);
            this.lastSelectedRow = null;
        } else {
            this.layout.show(this, "show");
            LabelRowPair labelRowPair = this.layoutAnalyzerReport(analyzerReport);
            if (analyzerReport != null) {
                this.computeTotals(analyzerReport);
            }
            if (this.firstLoad) {
                this.upperPane.setDividerLocation(0.32);
                this.defaultPane.setDividerLocation(0.32);
                this.firstLoad = false;
            }
            if (analyzerReport.getCycleResults() != null && analyzerReport.getCycleResults().length == 1) {
                this.savedDividerLocation = this.upperPane.getDividerLocation();
                this.upperPane.setDividerLocation(0.0);
                this.defaultPane.setDividerLocation(0.0);
                this.adjustDivider = true;
            } else if (this.adjustDivider) {
                this.upperPane.setDividerLocation(this.savedDividerLocation);
                this.defaultPane.setDividerLocation(this.savedDividerLocation);
                this.adjustDivider = false;
            }
            if (labelRowPair != null) {
                labelRowPair.getLabel().setBorder(BorderFactory.createBevelBorder(1, Color.red, Color.red));
                this.lastSelectedLabel = labelRowPair.getLabel();
                this.componentDetails.setAnalyzerRowEditorValue(labelRowPair.getRow());
                this.lastSelectedRow = labelRowPair.getRow();
            } else {
                this.componentDetails.setAnalyzerRowEditorValue(null);
                this.lastSelectedRow = null;
            }
        }
    }

    public AnalyzerReport getSelectedAnalyzerReport() {
        return this.currentSelectedReport;
    }

    private void computeTotals(AnalyzerReport analyzerReport) {
        double d = analyzerReport.getTotalCalculatedCost();
        double d2 = analyzerReport.getTotalAdjustedCost();
        this.totalCalcCostTextField.setText(d);
        this.totalAdjustedCostTextField.setText(d2);
        this.totalSavingsTextField.setText(d - d2);
    }

    public void computeTotals(BillCycleResult billCycleResult) {
        NumberTextField numberTextField;
        if (this.adjustedCostFields != null && (numberTextField = (NumberTextField)this.adjustedCostFields.get(billCycleResult)) != null) {
            numberTextField.setText(billCycleResult.getAdjustedCost());
        }
        this.computeTotals(this.getSelectedAnalyzerReport());
    }

    private void resetAll() {
        int n = JOptionPane.showConfirmDialog(this.parentApplication, this.lex.getText("confirmResetAll"), this.lex.getText("confirmReset"), 0);
        if (n != 0) {
            return;
        }
        if (this.currentSelectedReport != null) {
            this.currentSelectedReport.resetComponents();
            this.setAnalyzerEditorValue(this.currentSelectedReport, true);
        }
    }

    protected void init(EasSession easSession) {
        this.session = easSession;
        this.layout.show(this, "hide");
        this.componentDetails.init(easSession);
    }

    protected void initApplication() {
        this.parentApplication.initApplication(true);
    }

    protected EasSession getSession() {
        return this.session;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public WhatIfAnalyzerApplication getParentApplication() {
        return this.parentApplication;
    }

    private void selectItLater(Component component) {
        if (component instanceof JTextField) {
            final JTextField jTextField = (JTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTextField.selectAll();
                }
            });
        }
    }

    private Font getCellFont() {
        if (this.cellFont == null) {
            HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
            hashMap.put(TextAttribute.FAMILY, Theme.widget().getTextFont().getName());
            hashMap.put(TextAttribute.SIZE, new Float(10.0f));
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            this.cellFont = new Font(hashMap);
        }
        return this.cellFont;
    }

    private Font getHeaderFont() {
        if (this.headerFont == null) {
            this.headerFont = this.getCellFont().deriveFont(1);
        }
        return this.headerFont;
    }

    private Font getTitleFont() {
        if (this.titleFont == null) {
            this.titleFont = this.getCellFont().deriveFont(1, 14.0f);
        }
        return this.titleFont;
    }

    private Font getSubtitleFont() {
        if (this.subtitleFont == null) {
            this.subtitleFont = this.getCellFont().deriveFont(12.0f);
        }
        return this.subtitleFont;
    }

    private FontMetrics getCellFontMetrics() {
        if (this.cellFontMetrics == null) {
            this.cellFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getCellFont());
        }
        return this.cellFontMetrics;
    }

    private FontMetrics getHeaderFontMetrics() {
        if (this.headerFontMetrics == null) {
            this.headerFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getHeaderFont());
        }
        return this.headerFontMetrics;
    }

    private FontMetrics getTitleFontMetrics() {
        if (this.titleFontMetrics == null) {
            this.titleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getTitleFont());
        }
        return this.titleFontMetrics;
    }

    private FontMetrics getSubtitleFontMetrics() {
        if (this.subtitleFontMetrics == null) {
            this.subtitleFontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getSubtitleFont());
        }
        return this.subtitleFontMetrics;
    }

    private double calculatePreferredColumnWidth(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = this.lex.getText("calculatedUnits");
                break;
            }
            case 2: {
                string = this.lex.getText("costPerUnit");
                break;
            }
            case 3: {
                string = this.lex.getText("calculatedCost");
                break;
            }
            case 4: {
                string = this.lex.getText("adjustedCost");
            }
        }
        int n2 = this.getHeaderFontMetrics().stringWidth(string);
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("costValueFormat"));
        DecimalFormat decimalFormat2 = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
        if (this.reportRows != null && this.reportRows.length > 0) {
            block31: for (int i = 0; i < this.reportRows.length; ++i) {
                AnalyzerAdjustment[] analyzerAdjustmentArray;
                if (this.reportRows[i] == null) continue;
                if (n == 0) {
                    n2 = Math.max(n2, this.getHeaderFontMetrics().stringWidth(this.reportRows[i].getBillingCycle(this.lex)));
                }
                if ((analyzerAdjustmentArray = this.reportRows[i].getAdjustments()) == null) continue;
                for (int j = 0; j < analyzerAdjustmentArray.length; ++j) {
                    ReconciliationRow reconciliationRow;
                    if (analyzerAdjustmentArray[j] == null || (reconciliationRow = analyzerAdjustmentArray[j].getReconciliationRow()) == null) continue;
                    String string2 = "";
                    if (reconciliationRow.getShowCostColumns()) {
                        switch (n) {
                            case 0: {
                                string2 = reconciliationRow.getDisplayName(this.lex, analyzerAdjustmentArray[j].getUnitsExist());
                                break;
                            }
                            case 1: {
                                if (analyzerAdjustmentArray[j].getUnitsExist()) {
                                    string2 = decimalFormat.format(analyzerAdjustmentArray[j].getCalcUnits());
                                    break;
                                }
                                string2 = this.lex.getText("notApplicable");
                                break;
                            }
                            case 2: {
                                if (analyzerAdjustmentArray[j].getFeeExists()) {
                                    if (reconciliationRow.getRateComponent() != null && reconciliationRow.getRateComponent() instanceof FixedFee) {
                                        string2 = decimalFormat2.format(analyzerAdjustmentArray[j].getFeePerUnit());
                                        break;
                                    }
                                    string2 = decimalFormat.format(analyzerAdjustmentArray[j].getFeePerUnit());
                                    break;
                                }
                                string2 = this.lex.getText("notApplicable");
                                break;
                            }
                            case 3: {
                                string2 = decimalFormat.format(analyzerAdjustmentArray[j].getCalculatedCost());
                                break;
                            }
                            case 4: {
                                string2 = decimalFormat.format(analyzerAdjustmentArray[j].getAdjustedCost());
                            }
                        }
                    }
                    n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string2));
                }
                String string3 = "";
                switch (n) {
                    case 0: {
                        string3 = this.reportRows[i].getBillingCycle(this.lex) + " " + this.lex.getText("total");
                        n2 = Math.max(n2, this.getHeaderFontMetrics().stringWidth(string3));
                        break;
                    }
                    case 3: {
                        string3 = decimalFormat.format(this.reportRows[i].getCalculatedCost());
                        n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string3));
                        break;
                    }
                    case 4: {
                        string3 = decimalFormat.format(this.reportRows[i].getAdjustedCost());
                        n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string3));
                    }
                }
                string3 = "";
                switch (n) {
                    case 0: {
                        string3 = this.reportRows[i].getBillingCycle(this.lex) + " " + this.lex.getText("savings");
                        n2 = Math.max(n2, this.getHeaderFontMetrics().stringWidth(string3));
                        continue block31;
                    }
                    case 4: {
                        string3 = decimalFormat.format(this.reportRows[i].getCalculatedCost() - this.reportRows[i].getAdjustedCost());
                        n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string3));
                    }
                }
            }
        }
        String string4 = "";
        switch (n) {
            case 0: {
                string4 = this.lex.getText("grandTotal");
                n2 = Math.max(n2, this.getHeaderFontMetrics().stringWidth(string4));
                break;
            }
            case 3: {
                string4 = this.totalCalcCostTextField.getText();
                n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string4));
                break;
            }
            case 4: {
                string4 = this.totalAdjustedCostTextField.getText();
                n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string4));
            }
        }
        string4 = "";
        switch (n) {
            case 0: {
                string4 = this.lex.getText("savings");
                n2 = Math.max(n2, this.getHeaderFontMetrics().stringWidth(string4));
                break;
            }
            case 4: {
                string4 = this.totalSavingsTextField.getText();
                n2 = Math.max(n2, this.getCellFontMetrics().stringWidth(string4));
            }
        }
        return n2 + 7;
    }

    private ArrayList filterLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (!stringTokenizer.hasMoreTokens()) {
            arrayList.add(string);
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        return arrayList;
    }

    private ArrayList getCellLines(String string, FontMetrics fontMetrics, double d) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = this.filterLines(string);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if ((double)fontMetrics.stringWidth(string2) <= d) {
                arrayList.add(string2);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                StringBuffer stringBuffer2 = new StringBuffer().append(stringBuffer.toString());
                String string4 = stringBuffer.length() == 0 ? "" : " ";
                if ((double)fontMetrics.stringWidth(stringBuffer2.append(string4).append(string3).toString()) > d) {
                    if (stringBuffer.length() == 0) {
                        stringBuffer = new StringBuffer(string3);
                        while ((double)fontMetrics.stringWidth(stringBuffer.toString()) > d) {
                            StringBuffer stringBuffer3 = new StringBuffer();
                            while ((double)fontMetrics.stringWidth(stringBuffer3.toString()) <= d) {
                                stringBuffer3.append(stringBuffer.charAt(0));
                                stringBuffer.deleteCharAt(0);
                            }
                            arrayList.add(stringBuffer3.toString());
                        }
                        continue;
                    }
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer(string3);
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string3);
            }
            if (stringBuffer.length() <= 0) continue;
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    public int getEstimateNumPages() {
        return this.currentPage + 1;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.currentPage = 0;
        if (this.reportRows == null || this.reportRows.length < 1) {
            this.currentPage = -1;
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int n9 = 3;
        int n10 = 1;
        int n11 = 0;
        int n12 = (int)pageFormat.getImageableWidth();
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getTitleFont());
        ArrayList arrayList = this.getCellLines(this.lex.getText("whatIfAnalyzer"), this.getTitleFontMetrics(), n12);
        String[] stringArray = arrayList.iterator();
        while (stringArray.hasNext()) {
            String string = (String)stringArray.next();
            int n13 = this.getTitleFontMetrics().stringWidth(string);
            int n14 = n12 / 2 - n13 / 2;
            int n15 = n11 + n9 + this.getTitleFontMetrics().getHeight() - this.getTitleFontMetrics().getDescent();
            if (this.currentPage == n) {
                graphics2D.drawString(string, n14, n15);
            }
            n11 += n9 + this.getTitleFontMetrics().getHeight();
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        stringArray = this.parentApplication.getMeterStrings();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                ArrayList arrayList2 = this.getCellLines(this.lex.getText("meter") + ":  " + stringArray[i], this.getSubtitleFontMetrics(), n12);
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    n8 = this.getSubtitleFontMetrics().stringWidth(string);
                    n7 = n12 / 2 - n8 / 2;
                    int n16 = n11 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
                    if ((double)n16 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n11 = 0;
                        n16 = n11 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
                    }
                    if (this.currentPage == n) {
                        graphics2D.drawString(string, n7, n16);
                    }
                    n11 += n9 + this.getSubtitleFontMetrics().getHeight();
                }
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        ArrayList arrayList3 = this.getCellLines(this.lex.getText("billPeriod") + ":  " + this.parentApplication.getBillPeriodString(), this.getSubtitleFontMetrics(), n12);
        Object object = arrayList3.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            int n17 = this.getSubtitleFontMetrics().stringWidth(string);
            n8 = n12 / 2 - n17 / 2;
            n7 = n11 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            if ((double)n7 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n11 = 0;
                n7 = n11 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n8, n7);
            }
            n11 += n9 + this.getSubtitleFontMetrics().getHeight();
        }
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.getSubtitleFont());
        arrayList3 = this.getCellLines(this.lex.getText("consecutiveBillingCycles") + ":  " + this.parentApplication.getNumConsecutiveCyclesString(), this.getSubtitleFontMetrics(), n12);
        object = arrayList3.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            int n18 = this.getSubtitleFontMetrics().stringWidth(string);
            n8 = n12 / 2 - n18 / 2;
            n7 = n11 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            if ((double)n7 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n11 = 0;
                n7 = n11 + this.getSubtitleFontMetrics().getHeight() - this.getSubtitleFontMetrics().getDescent();
            }
            if (this.currentPage == n) {
                graphics2D.drawString(string, n8, n7);
            }
            n11 += n9 + this.getSubtitleFontMetrics().getHeight();
        }
        n11 += n9 + this.getSubtitleFontMetrics().getHeight();
        object = new DecimalFormat(this.lex.getText("costValueFormat"));
        DecimalFormat decimalFormat = new DecimalFormat(this.lex.getText("extendedCostValueFormat"));
        Color color = new Color(153, 153, 153);
        double d = this.calculatePreferredColumnWidth(0);
        double d2 = this.calculatePreferredColumnWidth(1);
        double d3 = this.calculatePreferredColumnWidth(2);
        double d4 = this.calculatePreferredColumnWidth(3);
        double d5 = this.calculatePreferredColumnWidth(4);
        for (n6 = 0; n6 < this.reportRows.length; ++n6) {
            int n19;
            int n20;
            String string;
            int n21;
            if (this.reportRows[n6] == null) continue;
            n5 = n11;
            graphics2D.setFont(this.getHeaderFont());
            graphics2D.setColor(color);
            double d6 = 0.0;
            double d7 = d;
            ArrayList arrayList4 = this.getCellLines(this.reportRows[n6].getBillingCycle(this.lex), this.getHeaderFontMetrics(), n12);
            for (n21 = 0; n21 < arrayList4.size(); ++n21) {
                string = (String)arrayList4.get(n21);
                n4 = this.getHeaderFontMetrics().stringWidth(string);
                n20 = (int)(d6 + d7 / 2.0 - (double)(n4 / 2));
                n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                if ((double)n19 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n11 = 0;
                    n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string, n20, n19);
            }
            d6 += d7;
            arrayList4 = this.getCellLines(this.lex.getText("calculatedUnits"), this.getHeaderFontMetrics(), n12);
            d7 = d2;
            for (n21 = 0; n21 < arrayList4.size(); ++n21) {
                string = (String)arrayList4.get(n21);
                n4 = this.getHeaderFontMetrics().stringWidth(string);
                n20 = (int)(d6 + d7 / 2.0 - (double)(n4 / 2));
                n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                if ((double)n19 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n11 = 0;
                    n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string, n20, n19);
            }
            d6 += d7;
            arrayList4 = this.getCellLines(this.lex.getText("costPerUnit"), this.getHeaderFontMetrics(), n12);
            d7 = d3;
            for (n21 = 0; n21 < arrayList4.size(); ++n21) {
                string = (String)arrayList4.get(n21);
                n4 = this.getHeaderFontMetrics().stringWidth(string);
                n20 = (int)(d6 + d7 / 2.0 - (double)(n4 / 2));
                n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                if ((double)n19 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n11 = 0;
                    n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string, n20, n19);
            }
            d6 += d7;
            arrayList4 = this.getCellLines(this.lex.getText("calculatedCost"), this.getHeaderFontMetrics(), n12);
            d7 = d4;
            for (n21 = 0; n21 < arrayList4.size(); ++n21) {
                string = (String)arrayList4.get(n21);
                n4 = this.getHeaderFontMetrics().stringWidth(string);
                n20 = (int)(d6 + d7 / 2.0 - (double)(n4 / 2));
                n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                if ((double)n19 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n11 = 0;
                    n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string, n20, n19);
            }
            d6 += d7;
            arrayList4 = this.getCellLines(this.lex.getText("adjustedCost"), this.getHeaderFontMetrics(), n12);
            d7 = d5;
            for (n21 = 0; n21 < arrayList4.size(); ++n21) {
                string = (String)arrayList4.get(n21);
                n4 = this.getHeaderFontMetrics().stringWidth(string);
                n20 = (int)(d6 + d7 / 2.0 - (double)(n4 / 2));
                n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                if ((double)n19 > pageFormat.getImageableHeight()) {
                    ++this.currentPage;
                    n11 = 0;
                    n19 = n11 + n9 + (n21 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                }
                if (this.currentPage != n) continue;
                graphics2D.drawString(string, n20, n19);
            }
            n11 += n9 + this.getHeaderFontMetrics().getHeight();
            graphics2D.setFont(this.getCellFont());
            graphics2D.setColor(Color.black);
            AnalyzerAdjustment[] analyzerAdjustmentArray = this.reportRows[n6].getAdjustments();
            if (analyzerAdjustmentArray != null) {
                int n22;
                int n23;
                int n24;
                Object object2;
                int n25;
                for (n25 = 0; n25 < analyzerAdjustmentArray.length; ++n25) {
                    ReconciliationRow reconciliationRow;
                    if (analyzerAdjustmentArray[n25] == null || (reconciliationRow = analyzerAdjustmentArray[n25].getReconciliationRow()) == null) continue;
                    if (reconciliationRow.getShowCostColumns()) {
                        int n26;
                        int n27;
                        int n28;
                        String string2;
                        int n29 = 0;
                        int n30 = (int)(d - (double)n9 - (double)n9 - (double)n10);
                        d6 = 0.0;
                        object2 = this.getCellLines(reconciliationRow.getDisplayName(this.lex, analyzerAdjustmentArray[n25].getUnitsExist()), this.getCellFontMetrics(), n30);
                        for (n24 = 0; n24 < ((ArrayList)object2).size(); ++n24) {
                            string2 = (String)((ArrayList)object2).get(n24);
                            n23 = this.getCellFontMetrics().stringWidth(string2);
                            int n31 = (int)(d6 + (double)n9);
                            n28 = n11 + n9 + (n24 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            if ((double)n28 > pageFormat.getImageableHeight()) {
                                ++this.currentPage;
                                n11 = 0;
                                n28 = n11 + n9 + (n24 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            }
                            if (this.currentPage != n) continue;
                            graphics2D.drawString(string2, n31, n28);
                        }
                        n24 = this.getCellFontMetrics().getHeight() * ((ArrayList)object2).size() + n9 + n9 + n10;
                        n29 = Math.max(n24, n29);
                        d6 += d;
                        n30 = (int)(d2 - (double)n9 - (double)n9 - (double)n10);
                        string2 = "";
                        string2 = analyzerAdjustmentArray[n25].getUnitsExist() ? ((NumberFormat)object).format(analyzerAdjustmentArray[n25].getCalcUnits()) : this.lex.getText("notApplicable");
                        object2 = this.getCellLines(string2, this.getCellFontMetrics(), n30);
                        for (n23 = 0; n23 < ((ArrayList)object2).size(); ++n23) {
                            String string3 = (String)((ArrayList)object2).get(n23);
                            n28 = this.getCellFontMetrics().stringWidth(string3);
                            n27 = (int)(d6 + d2 - (double)n9 - (double)n28);
                            n26 = n11 + n9 + (n23 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            if ((double)n26 > pageFormat.getImageableHeight()) {
                                ++this.currentPage;
                                n11 = 0;
                                n26 = n11 + n9 + (n23 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            }
                            if (this.currentPage != n) continue;
                            graphics2D.drawString(string3, n27, n26);
                        }
                        n24 = this.getCellFontMetrics().getHeight() * ((ArrayList)object2).size() + n9 + n9 + n10;
                        n29 = Math.max(n24, n29);
                        d6 += d2;
                        n30 = (int)(d3 - (double)n9 - (double)n9 - (double)n10);
                        string2 = "";
                        string2 = analyzerAdjustmentArray[n25].getFeeExists() ? (reconciliationRow.getRateComponent() != null && reconciliationRow.getRateComponent() instanceof FixedFee ? decimalFormat.format(analyzerAdjustmentArray[n25].getFeePerUnit()) : ((NumberFormat)object).format(analyzerAdjustmentArray[n25].getFeePerUnit())) : this.lex.getText("notApplicable");
                        object2 = this.getCellLines(string2, this.getCellFontMetrics(), n30);
                        for (n23 = 0; n23 < ((ArrayList)object2).size(); ++n23) {
                            String string4 = (String)((ArrayList)object2).get(n23);
                            n28 = this.getCellFontMetrics().stringWidth(string4);
                            n27 = (int)(d6 + d3 - (double)n9 - (double)n28);
                            n26 = n11 + n9 + (n23 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            if ((double)n26 > pageFormat.getImageableHeight()) {
                                ++this.currentPage;
                                n11 = 0;
                                n26 = n11 + n9 + (n23 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            }
                            if (this.currentPage != n) continue;
                            graphics2D.drawString(string4, n27, n26);
                        }
                        n24 = this.getCellFontMetrics().getHeight() * ((ArrayList)object2).size() + n9 + n9 + n10;
                        n29 = Math.max(n24, n29);
                        d6 += d3;
                        n30 = (int)(d4 - (double)n9 - (double)n9 - (double)n10);
                        object2 = this.getCellLines(((NumberFormat)object).format(analyzerAdjustmentArray[n25].getCalculatedCost()), this.getCellFontMetrics(), n30);
                        for (n23 = 0; n23 < ((ArrayList)object2).size(); ++n23) {
                            String string5 = (String)((ArrayList)object2).get(n23);
                            n28 = this.getCellFontMetrics().stringWidth(string5);
                            n27 = (int)(d6 + d4 - (double)n9 - (double)n28);
                            n26 = n11 + n9 + (n23 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            if ((double)n26 > pageFormat.getImageableHeight()) {
                                ++this.currentPage;
                                n11 = 0;
                                n26 = n11 + n9 + (n23 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            }
                            if (this.currentPage != n) continue;
                            graphics2D.drawString(string5, n27, n26);
                        }
                        n24 = this.getCellFontMetrics().getHeight() * ((ArrayList)object2).size() + n9 + n9 + n10;
                        n29 = Math.max(n24, n29);
                        d6 += d4;
                        n30 = (int)(d5 - (double)n9 - (double)n9 - (double)n10);
                        object2 = this.getCellLines(((NumberFormat)object).format(analyzerAdjustmentArray[n25].getAdjustedCost()), this.getCellFontMetrics(), n30);
                        for (n23 = 0; n23 < ((ArrayList)object2).size(); ++n23) {
                            String string6 = (String)((ArrayList)object2).get(n23);
                            n28 = this.getCellFontMetrics().stringWidth(string6);
                            n27 = (int)(d6 + d5 - (double)n9 - (double)n28);
                            n26 = n11 + n9 + (n23 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            if ((double)n26 > pageFormat.getImageableHeight()) {
                                ++this.currentPage;
                                n11 = 0;
                                n26 = n11 + n9 + (n23 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                            }
                            if (this.currentPage != n) continue;
                            graphics2D.drawString(string6, n27, n26);
                        }
                        n24 = this.getCellFontMetrics().getHeight() * ((ArrayList)object2).size() + n9 + n9 + n10;
                        n29 = Math.max(n24, n29);
                        n11 += n29;
                        continue;
                    }
                    ArrayList arrayList5 = this.getCellLines(this.componentDetails.decodeMeterRateName(analyzerAdjustmentArray[n25]), this.getCellFontMetrics(), n12);
                    Iterator iterator = arrayList5.iterator();
                    while (iterator.hasNext()) {
                        object2 = (String)iterator.next();
                        n24 = this.getCellFontMetrics().stringWidth((String)object2);
                        int n32 = n9;
                        n23 = n11 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                        if ((double)n23 > pageFormat.getImageableHeight()) {
                            ++this.currentPage;
                            n11 = 0;
                            n23 = n11 + this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                        }
                        if (this.currentPage == n) {
                            graphics2D.drawString((String)object2, n32, n23);
                        }
                        n11 += n9 + this.getCellFontMetrics().getHeight();
                    }
                }
                graphics2D.setFont(this.getHeaderFont());
                graphics2D.setColor(color);
                n25 = 0;
                n4 = (int)(d - (double)n9 - (double)n9 - (double)n10);
                d6 = 0.0;
                ArrayList arrayList6 = this.getCellLines(this.reportRows[n6].getBillingCycle(this.lex) + " " + this.lex.getText("total"), this.getHeaderFontMetrics(), n4);
                for (n19 = 0; n19 < arrayList6.size(); ++n19) {
                    object2 = (String)arrayList6.get(n19);
                    n24 = this.getHeaderFontMetrics().stringWidth((String)object2);
                    int n33 = (int)(d6 + (double)n9);
                    n23 = n11 + n9 + (n19 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                    if ((double)n23 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n11 = 0;
                        n23 = n11 + n9 + (n19 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                    }
                    if (this.currentPage != n) continue;
                    graphics2D.drawString((String)object2, n33, n23);
                }
                n19 = this.getHeaderFontMetrics().getHeight() * arrayList6.size() + n9 + n9 + n10;
                n25 = Math.max(n19, n25);
                graphics2D.setFont(this.getCellFont());
                graphics2D.setColor(Color.black);
                d6 += d + d2 + d3;
                n4 = (int)(d4 - (double)n9 - (double)n9 - (double)n10);
                arrayList6 = this.getCellLines(((NumberFormat)object).format(this.reportRows[n6].getCalculatedCost()), this.getCellFontMetrics(), n4);
                for (n22 = 0; n22 < arrayList6.size(); ++n22) {
                    String string7 = (String)arrayList6.get(n22);
                    int n34 = this.getCellFontMetrics().stringWidth(string7);
                    n23 = (int)(d6 + d4 - (double)n9 - (double)n34);
                    int n35 = n11 + n9 + (n22 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    if ((double)n35 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n11 = 0;
                        n35 = n11 + n9 + (n22 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    }
                    if (this.currentPage != n) continue;
                    graphics2D.drawString(string7, n23, n35);
                }
                n19 = this.getCellFontMetrics().getHeight() * arrayList6.size() + n9 + n9 + n10;
                n25 = Math.max(n19, n25);
                d6 += d4;
                n4 = (int)(d5 - (double)n9 - (double)n9 - (double)n10);
                arrayList6 = this.getCellLines(((NumberFormat)object).format(this.reportRows[n6].getAdjustedCost()), this.getCellFontMetrics(), n4);
                for (n22 = 0; n22 < arrayList6.size(); ++n22) {
                    String string8 = (String)arrayList6.get(n22);
                    int n36 = this.getCellFontMetrics().stringWidth(string8);
                    n23 = (int)(d6 + d5 - (double)n9 - (double)n36);
                    int n37 = n11 + n9 + (n22 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    if ((double)n37 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n11 = 0;
                        n37 = n11 + n9 + (n22 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    }
                    if (this.currentPage != n) continue;
                    graphics2D.drawString(string8, n23, n37);
                }
                n19 = this.getCellFontMetrics().getHeight() * arrayList6.size() + n9 + n9 + n10;
                n25 = Math.max(n19, n25);
                n11 += n25;
                graphics2D.setFont(this.getHeaderFont());
                graphics2D.setColor(color);
                n25 = 0;
                n4 = (int)(d - (double)n9 - (double)n9 - (double)n10);
                d6 = 0.0;
                arrayList6 = this.getCellLines(this.reportRows[n6].getBillingCycle(this.lex) + " " + this.lex.getText("savings"), this.getHeaderFontMetrics(), n4);
                for (n22 = 0; n22 < arrayList6.size(); ++n22) {
                    String string9 = (String)arrayList6.get(n22);
                    int n38 = this.getHeaderFontMetrics().stringWidth(string9);
                    n23 = (int)(d6 + (double)n9);
                    int n39 = n11 + n9 + (n22 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                    if ((double)n39 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n11 = 0;
                        n39 = n11 + n9 + (n22 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
                    }
                    if (this.currentPage != n) continue;
                    graphics2D.drawString(string9, n23, n39);
                }
                n19 = this.getHeaderFontMetrics().getHeight() * arrayList6.size() + n9 + n9 + n10;
                n25 = Math.max(n19, n25);
                graphics2D.setFont(this.getCellFont());
                graphics2D.setColor(Color.black);
                d6 += d + d2 + d3 + d4;
                n4 = (int)(d5 - (double)n9 - (double)n9 - (double)n10);
                arrayList6 = this.getCellLines(((NumberFormat)object).format(this.reportRows[n6].getCalculatedCost() - this.reportRows[n6].getAdjustedCost()), this.getCellFontMetrics(), n4);
                for (n22 = 0; n22 < arrayList6.size(); ++n22) {
                    String string10 = (String)arrayList6.get(n22);
                    int n40 = this.getCellFontMetrics().stringWidth(string10);
                    n23 = (int)(d6 + d5 - (double)n9 - (double)n40);
                    int n41 = n11 + n9 + (n22 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    if ((double)n41 > pageFormat.getImageableHeight()) {
                        ++this.currentPage;
                        n11 = 0;
                        n41 = n11 + n9 + (n22 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
                    }
                    if (this.currentPage != n) continue;
                    graphics2D.drawString(string10, n23, n41);
                }
                n19 = this.getCellFontMetrics().getHeight() * arrayList6.size() + n9 + n9 + n10;
                n25 = Math.max(n19, n25);
                n11 += n25;
            }
            n11 += n9 + this.getHeaderFontMetrics().getHeight();
        }
        graphics2D.setColor(color);
        graphics2D.setFont(this.getHeaderFont());
        n6 = 0;
        n5 = (int)(d - (double)n9 - (double)n9 - (double)n10);
        int n42 = 0;
        ArrayList arrayList7 = this.getCellLines(this.lex.getText("grandTotal"), this.getHeaderFontMetrics(), n5);
        for (n3 = 0; n3 < arrayList7.size(); ++n3) {
            String string = (String)arrayList7.get(n3);
            int n43 = this.getHeaderFontMetrics().stringWidth(string);
            int n44 = n42 + n9;
            int n45 = n11 + n9 + (n3 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n45 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n11 = 0;
                n45 = n11 + n9 + (n3 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n44, n45);
        }
        n3 = this.getHeaderFontMetrics().getHeight() * arrayList7.size() + n9 + n9 + n10;
        n6 = Math.max(n3, n6);
        graphics2D.setFont(this.getCellFont());
        graphics2D.setColor(Color.black);
        n42 = (int)((double)n42 + (d + d2 + d3));
        n5 = (int)(d4 - (double)n9 - (double)n9 - (double)n10);
        arrayList7 = this.getCellLines(this.totalCalcCostTextField.getText(), this.getCellFontMetrics(), n5);
        for (n2 = 0; n2 < arrayList7.size(); ++n2) {
            String string = (String)arrayList7.get(n2);
            int n46 = this.getCellFontMetrics().stringWidth(string);
            int n47 = (int)((double)n42 + d4 - (double)n9 - (double)n46);
            n4 = n11 + n9 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n4 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n11 = 0;
                n4 = n11 + n9 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n47, n4);
        }
        n3 = this.getCellFontMetrics().getHeight() * arrayList7.size() + n9 + n9 + n10;
        n6 = Math.max(n3, n6);
        n42 = (int)((double)n42 + d4);
        n5 = (int)(d5 - (double)n9 - (double)n9 - (double)n10);
        arrayList7 = this.getCellLines(this.totalAdjustedCostTextField.getText(), this.getCellFontMetrics(), n5);
        for (n2 = 0; n2 < arrayList7.size(); ++n2) {
            String string = (String)arrayList7.get(n2);
            int n48 = this.getCellFontMetrics().stringWidth(string);
            int n49 = (int)((double)n42 + d5 - (double)n9 - (double)n48);
            n4 = n11 + n9 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n4 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n11 = 0;
                n4 = n11 + n9 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n49, n4);
        }
        n3 = this.getCellFontMetrics().getHeight() * arrayList7.size() + n9 + n9 + n10;
        n6 = Math.max(n3, n6);
        n11 += n6;
        graphics2D.setFont(this.getHeaderFont());
        graphics2D.setColor(color);
        n6 = 0;
        n5 = (int)(d - (double)n9 - (double)n9 - (double)n10);
        n42 = 0;
        arrayList7 = this.getCellLines(this.lex.getText("savings"), this.getHeaderFontMetrics(), n5);
        for (n2 = 0; n2 < arrayList7.size(); ++n2) {
            String string = (String)arrayList7.get(n2);
            int n50 = this.getHeaderFontMetrics().stringWidth(string);
            int n51 = n42 + n9;
            n4 = n11 + n9 + (n2 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            if ((double)n4 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n11 = 0;
                n4 = n11 + n9 + (n2 + 1) * this.getHeaderFontMetrics().getHeight() - this.getHeaderFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n51, n4);
        }
        n3 = this.getHeaderFontMetrics().getHeight() * arrayList7.size() + n9 + n9 + n10;
        n6 = Math.max(n3, n6);
        graphics2D.setFont(this.getCellFont());
        graphics2D.setColor(Color.black);
        n42 = (int)((double)n42 + (d + d2 + d3 + d4));
        n5 = (int)(d5 - (double)n9 - (double)n9 - (double)n10);
        arrayList7 = this.getCellLines(this.totalSavingsTextField.getText(), this.getCellFontMetrics(), n5);
        for (n2 = 0; n2 < arrayList7.size(); ++n2) {
            String string = (String)arrayList7.get(n2);
            int n52 = this.getCellFontMetrics().stringWidth(string);
            int n53 = (int)((double)n42 + d5 - (double)n9 - (double)n52);
            n4 = n11 + n9 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            if ((double)n4 > pageFormat.getImageableHeight()) {
                ++this.currentPage;
                n11 = 0;
                n4 = n11 + n9 + (n2 + 1) * this.getCellFontMetrics().getHeight() - this.getCellFontMetrics().getDescent();
            }
            if (this.currentPage != n) continue;
            graphics2D.drawString(string, n53, n4);
        }
        n3 = this.getCellFontMetrics().getHeight() * arrayList7.size() + n9 + n9 + n10;
        n6 = Math.max(n3, n6);
        n11 += n6;
        if (this.currentPage < n) {
            return 1;
        }
        return 0;
    }

    private class LabelRowPair {
        private JLabel label;
        private BillCycleResult row;

        public LabelRowPair(JLabel jLabel, BillCycleResult billCycleResult) {
            this.label = jLabel;
            this.row = billCycleResult;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public BillCycleResult getRow() {
            return this.row;
        }
    }

    private class AnalyzerMouseAdapter
    extends MouseAdapter {
        private BillCycleResult referenceRow;

        public AnalyzerMouseAdapter(BillCycleResult billCycleResult) {
            this.referenceRow = billCycleResult;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == AnalyzerDetailPanel.this.lastSelectedLabel) {
                return;
            }
            if (AnalyzerDetailPanel.this.lastSelectedLabel != null) {
                AnalyzerDetailPanel.this.lastSelectedLabel.setBorder(BorderFactory.createRaisedBevelBorder());
            }
            jLabel.setBorder(BorderFactory.createBevelBorder(1, Color.red, Color.red));
            AnalyzerDetailPanel.this.lastSelectedLabel = jLabel;
            AnalyzerDetailPanel.this.componentDetails.setAnalyzerRowEditorValue(this.referenceRow);
            AnalyzerDetailPanel.this.lastSelectedRow = this.referenceRow;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == AnalyzerDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JLabel jLabel = (JLabel)mouseEvent.getComponent();
            if (jLabel == AnalyzerDetailPanel.this.lastSelectedLabel) {
                return;
            }
            jLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }
}

