/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui.linking;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.FilterRateDialog;
import com.tridium.eas.cost.ui.RateList;
import com.tridium.eas.cost.ui.linking.RateHistoryDetailPanel;
import com.tridium.eas.cost.ui.linking.RateLinkDbObjectValidator;
import com.tridium.eas.cost.util.CopySupport;
import com.tridium.eas.ui.BEasApplet;
import com.tridium.eas.ui.EasApplication;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasEditorListener;
import com.tridium.eas.ui.widgets.AllSitesFilter;
import com.tridium.eas.ui.widgets.DynamicGroupFilter;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.Filter;
import com.tridium.eas.ui.widgets.FilterRootNode;
import com.tridium.eas.ui.widgets.FilterTree;
import com.tridium.eas.ui.widgets.FilterTreeModel;
import com.tridium.eas.ui.widgets.ListPopupHandler;
import com.tridium.eas.ui.widgets.StaticGroupFilter;
import com.tridium.eas.ui.widgets.XpComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class AttachARateApplication
extends JPanel
implements ResourceManager,
TreeSelectionListener,
ActionListener {
    public static final String RATE_HISTORY_PREFIX = "meter";
    public static CopySupport clipboard = null;
    private boolean checkDemoMode = false;
    private boolean demoMode = false;
    private MeterTreePanel meters;
    private RateHistory[] rateHistories = null;
    private RateList rates = null;
    private RateHistoryDetailPanel meterDetails = null;
    private RatePopup ratePopup = null;
    private JButton refreshButton;
    private JButton filterButton;
    private JLabel rateFilterLabel;
    private JPanel mainSplit;
    private Filter currentFilter;
    private FilterTree tree;
    private XpComboBox filterSelection;
    private JToolBar toolbar = null;
    private EasApplication easApplication;
    private boolean lastChange = true;

    public AttachARateApplication(EasApplication easApplication) {
        this.easApplication = easApplication;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getApplicationContent(), "Center");
    }

    public Image loadImage(String string) {
        return this.easApplication.loadImage(string);
    }

    public Image getIconImage(int n) {
        return this.easApplication.getIconImage(n);
    }

    public final void initApplication(boolean bl) {
        this.initApplication(bl, true);
    }

    public final void initApplication(boolean bl, boolean bl2) {
        if (bl) {
            Lexicon lexicon = BEasApplet.lex;
            this.initFilters();
            this.updateFilter();
            this.rates.init(this.easApplication.getSession());
            this.rates.refreshData(bl2);
            this.rates.setEnabled(true);
            this.meterDetails.init(this.easApplication.getSession());
        }
    }

    public JToolBar getToolBar() {
        return this.getApplicationToolBar(new int[]{17});
    }

    private JToolBar getApplicationToolBar(int[] nArray) {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        Lexicon lexicon = BEasApplet.lex;
        for (int i = 0; i < nArray.length; ++i) {
            switch (nArray[i]) {
                case 17: {
                    this.refreshButton = new EasButton((ResourceManager)this, 17, lexicon.getText("refresh"));
                    this.refreshButton.addActionListener(this);
                    this.toolbar.add(this.refreshButton);
                    this.toolbar.addSeparator();
                }
            }
        }
        return this.toolbar;
    }

    private JComponent getApplicationContent() {
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/comboPerFee.png", 301);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/demandCharge.png", 302);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/flatFee.png", 303);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/flatFeePerUnit.png", 304);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/historicalRatchet.png", 316);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/ratchet.png", 305);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/rate.png", 306);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/schedule.png", 307);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/compositeSchedule.png", 308);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/intersectionSchedule.png", 309);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/unionSchedule.png", 310);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/filter.png", 311);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/startTime.png", 312);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/endTime.png", 313);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/arrowUp.png", 314);
        this.easApplication.queueIconImage("/com/tridium/eas/cost/ui/images/arrowDown.png", 315);
        if (this.mainSplit == null) {
            Lexicon lexicon = BEasApplet.lex;
            this.mainSplit = new JPanel(new BorderLayout(), false);
            this.add((Component)this.mainSplit, "Center");
            JPanel jPanel = new JPanel(new BorderLayout(), false);
            jPanel.setBorder(BorderFactory.createTitledBorder(lexicon.getText("selectRate")));
            jPanel.add((Component)this.buildAvailableRatesContents(lexicon), "Center");
            this.mainSplit.add((Component)jPanel, "East");
            JPanel jPanel2 = new JPanel(new BorderLayout(), false);
            jPanel2.setBorder(BorderFactory.createTitledBorder(lexicon.getText("selectMeter")));
            jPanel2.add((Component)this.buildAvailableMetersContents(lexicon), "Center");
            this.mainSplit.add((Component)jPanel2, "West");
            JPanel jPanel3 = new JPanel(new BorderLayout(), false);
            jPanel3.setBorder(BorderFactory.createEmptyBorder(50, 0, 0, 0));
            jPanel3.add((Component)this.buildMeterEditorContent(), "Center");
            this.mainSplit.add((Component)jPanel3, "Center");
        }
        return this.mainSplit;
    }

    private JComponent buildAvailableRatesContents(Lexicon lexicon) {
        this.rates = new RateList(this.getResourceManager());
        this.rates.getSelectionModel().setSelectionMode(0);
        this.rates.setPopupHandler(new ListPopupHandler(){

            public void openPopup(Object object, int n, int n2, int n3) {
                if (AttachARateApplication.this.rates.isEnabled()) {
                    if (AttachARateApplication.this.ratePopup == null) {
                        Lexicon lexicon = BEasApplet.lex;
                        AttachARateApplication.this.ratePopup = new RatePopup(lexicon);
                    }
                    AttachARateApplication.this.ratePopup.show(AttachARateApplication.this.rates, n >= 0, n2, n3);
                }
            }
        });
        this.rates.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 155) {
                    AttachARateApplication.this.addRate();
                } else if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                    AttachARateApplication.this.copyRate();
                }
            }
        });
        this.rates.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    AttachARateApplication.this.addRate();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.filterButton = new EasButton((ResourceManager)this, 311, lexicon.getText("filterRates"));
        this.filterButton.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(0), false);
        jPanel2.add(this.filterButton);
        this.rateFilterLabel = new JLabel(lexicon.getText("allRates"));
        jPanel2.add(this.rateFilterLabel);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(this.rates), "Center");
        return jPanel;
    }

    private JComponent buildAvailableMetersContents(Lexicon lexicon) {
        this.meters = new MeterTreePanel();
        return this.meters;
    }

    private JComponent buildMeterEditorContent() {
        Lexicon lexicon = BEasApplet.lex;
        this.meterDetails = new RateHistoryDetailPanel(this, this, lexicon);
        return this.meterDetails;
    }

    public void setMeterSelectionEnabled(boolean bl) {
        if (bl != this.lastChange) {
            EventObject eventObject = new EventObject(this);
            if (bl) {
                ((EasEditorListener)((Object)this.easApplication)).editingStopped(eventObject);
            } else {
                ((EasEditorListener)((Object)this.easApplication)).editingStarted(eventObject);
            }
        }
        this.lastChange = bl;
        this.tree.setEnabled(bl);
        this.filterSelection.setEnabled(bl);
    }

    private RateHistory getSelectedRateHistory(boolean bl) {
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            return null;
        }
        Meter meter = (Meter)object;
        if (meter == null) {
            return null;
        }
        int n = meter.getId();
        String string = RATE_HISTORY_PREFIX + n;
        try {
            if (this.rateHistories == null) {
                RateHistory rateHistory = EasCostClient.retrieveRateHistory(this.easApplication.getSession(), n);
                if (rateHistory == null) {
                    rateHistory = new RateHistory(string);
                }
                this.rateHistories = new RateHistory[1];
                this.rateHistories[0] = rateHistory;
                return rateHistory;
            }
            for (int i = 0; i < this.rateHistories.length; ++i) {
                if (!this.rateHistories[i].getName().equals(string)) continue;
                if (bl) {
                    this.rateHistories[i] = EasCostClient.retrieveRateHistory(this.easApplication.getSession(), n);
                    if (this.rateHistories[i] == null) {
                        this.rateHistories[i] = new RateHistory(string);
                    }
                }
                return this.rateHistories[i];
            }
            RateHistory rateHistory = EasCostClient.retrieveRateHistory(this.easApplication.getSession(), n);
            if (rateHistory == null) {
                rateHistory = new RateHistory(string);
            }
            RateHistory[] rateHistoryArray = new RateHistory[this.rateHistories.length + 1];
            for (int i = 0; i < this.rateHistories.length; ++i) {
                rateHistoryArray[i] = this.rateHistories[i];
            }
            rateHistoryArray[this.rateHistories.length] = rateHistory;
            this.rateHistories = rateHistoryArray;
            return rateHistory;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean saveRateHistory(RateHistory rateHistory) {
        if (rateHistory == null) {
            return true;
        }
        Object object = this.tree.getSelectedUserObject();
        if (object == null || !(object instanceof Meter)) {
            return true;
        }
        Meter meter = (Meter)object;
        RateLink[] rateLinkArray = rateHistory.getRateLinks();
        if (rateLinkArray != null) {
            BUnit bUnit = AttachARateApplication.getConsumptionUnits(meter);
            BUnit bUnit2 = AttachARateApplication.getDemandUnits(meter);
            BUnit bUnit3 = AttachARateApplication.getReactiveEnergyUnits(meter);
            BUnit bUnit4 = AttachARateApplication.getApparentEnergyUnits(meter);
            BUnit bUnit5 = AttachARateApplication.getReactivePowerUnits(meter);
            BUnit bUnit6 = AttachARateApplication.getApparentPowerUnits(meter);
            Lexicon lexicon = BEasApplet.lex;
            for (int i = 0; i < rateLinkArray.length; ++i) {
                try {
                    Rate rate = EasCostClient.retrieveRate(this.easApplication.getSession(), rateLinkArray[i].getName());
                    if (rate == null) continue;
                    BUnit bUnit7 = rate.getConsumptionUnits();
                    BUnit bUnit8 = rate.getDemandUnits();
                    BUnit bUnit9 = rate.getReactiveEnergyUnits();
                    BUnit bUnit10 = rate.getApparentEnergyUnits();
                    BUnit bUnit11 = rate.getReactivePowerUnits();
                    BUnit bUnit12 = rate.getApparentPowerUnits();
                    if (bUnit != null && !bUnit.equals((Object)bUnit7)) {
                        JOptionPane.showMessageDialog(this, rate.getName() + " (" + bUnit7.toString() + ") " + lexicon.getText("unitsMismatchError") + " " + meter.getName() + " (" + bUnit.toString() + ")", lexicon.getText("consumptionUnitsMismatch"), 0);
                        return false;
                    }
                    if (bUnit2 != null && !bUnit2.equals((Object)bUnit8)) {
                        JOptionPane.showMessageDialog(this, rate.getName() + " (" + bUnit8.toString() + ") " + lexicon.getText("unitsMismatchError") + " " + meter.getName() + " (" + bUnit2.toString() + ")", lexicon.getText("demandUnitsMismatch"), 0);
                        return false;
                    }
                    if (bUnit3 != null && !bUnit3.equals((Object)bUnit9)) {
                        JOptionPane.showMessageDialog(this, rate.getName() + " (" + bUnit9.toString() + ") " + lexicon.getText("unitsMismatchError") + " " + meter.getName() + " (" + bUnit3.toString() + ")", lexicon.getText("reactiveEnergyUnitsMismatch"), 0);
                        return false;
                    }
                    if (bUnit4 != null && !bUnit4.equals((Object)bUnit10)) {
                        JOptionPane.showMessageDialog(this, rate.getName() + " (" + bUnit10.toString() + ") " + lexicon.getText("unitsMismatchError") + " " + meter.getName() + " (" + bUnit4.toString() + ")", lexicon.getText("apparentEnergyUnitsMismatch"), 0);
                        return false;
                    }
                    if (bUnit5 != null && !bUnit5.equals((Object)bUnit11)) {
                        JOptionPane.showMessageDialog(this, rate.getName() + " (" + bUnit11.toString() + ") " + lexicon.getText("unitsMismatchError") + " " + meter.getName() + " (" + bUnit5.toString() + ")", lexicon.getText("reactivePowerUnitsMismatch"), 0);
                        return false;
                    }
                    if (bUnit6 == null || bUnit6.equals((Object)bUnit12)) continue;
                    JOptionPane.showMessageDialog(this, rate.getName() + " (" + bUnit12.toString() + ") " + lexicon.getText("unitsMismatchError") + " " + meter.getName() + " (" + bUnit6.toString() + ")", lexicon.getText("apparentPowerUnitsMismatch"), 0);
                    return false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }
        }
        int n = meter.getId();
        rateHistory.setName(RATE_HISTORY_PREFIX + n);
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = true;
        try {
            EasCostClient.storeRateHistory(this.easApplication.getSession(), n, rateHistory);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        this.setCursor(Cursor.getDefaultCursor());
        return bl;
    }

    public void reloadRateHistory() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.meterDetails.setRateHistoryEditorValue(this.getSelectedRateHistory(true));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private static BUnit getConsumptionUnits(Meter meter) {
        BUnit bUnit = null;
        try {
            DataPoint dataPoint = meter.getDataPoint(RcSubtype.CONSUMPTION.getCode());
            if (dataPoint != null) {
                bUnit = dataPoint.getUnit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bUnit;
    }

    private static BUnit getDemandUnits(Meter meter) {
        BUnit bUnit = null;
        try {
            DataPoint dataPoint = meter.getDataPoint(RcSubtype.DEMAND.getCode());
            if (dataPoint != null) {
                bUnit = dataPoint.getUnit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bUnit;
    }

    private static BUnit getReactiveEnergyUnits(Meter meter) {
        BUnit bUnit = null;
        try {
            DataPoint dataPoint = meter.getDataPoint(RcSubtype.REACTIVE_ENERGY.getCode());
            if (dataPoint != null) {
                bUnit = dataPoint.getUnit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bUnit;
    }

    private static BUnit getApparentEnergyUnits(Meter meter) {
        BUnit bUnit = null;
        try {
            DataPoint dataPoint = meter.getDataPoint(RcSubtype.APPARENT_ENERGY.getCode());
            if (dataPoint != null) {
                bUnit = dataPoint.getUnit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bUnit;
    }

    private static BUnit getReactivePowerUnits(Meter meter) {
        BUnit bUnit = null;
        try {
            DataPoint dataPoint = meter.getDataPoint(RcSubtype.REACTIVE_POWER.getCode());
            if (dataPoint != null) {
                bUnit = dataPoint.getUnit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bUnit;
    }

    private static BUnit getApparentPowerUnits(Meter meter) {
        BUnit bUnit = null;
        try {
            DataPoint dataPoint = meter.getDataPoint(RcSubtype.APPARENT_POWER.getCode());
            if (dataPoint != null) {
                bUnit = dataPoint.getUnit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bUnit;
    }

    public void refreshRates() {
        if (this.rates != null) {
            this.rates.refreshData(true);
        }
    }

    private void buttonPressed(JButton jButton) {
        if (jButton == this.refreshButton) {
            this.setMeterSelectionEnabled(true);
            this.reloadRateHistory();
            if (this.meterDetails != null) {
                this.meterDetails.doRefresh();
            }
            this.initApplication(true, false);
            ((FilterTreeModel)this.tree.getModel()).reload();
        } else if (jButton == this.filterButton) {
            this.filterRates();
        }
    }

    public void addRate() {
        this.addRate((Rate)this.rates.getSelectedValue());
    }

    public void addRate(Rate rate) {
        RateHistory rateHistory = this.getSelectedRateHistory(false);
        if (rate != null && rateHistory != null) {
            String string = rate.getName();
            RateLink[] rateLinkArray = rateHistory.getRateLinks();
            if (!(rateLinkArray != null && rateLinkArray.length > 0 || this.isDemoMode() || Meter.getAvailableLicensedMeterCount(this.easApplication.getSession()) > 0)) {
                Lexicon lexicon = BEasApplet.lex;
                JOptionPane.showMessageDialog(this, lexicon.getText("noAvailableMetersLicensed"), lexicon.getText("licenseError"), 0);
                return;
            }
            long l = -1L;
            boolean bl = false;
            if (rateLinkArray != null) {
                for (int i = 0; i < rateLinkArray.length; ++i) {
                    if (rateLinkArray[i].getName().equals(string)) {
                        Lexicon lexicon = BEasApplet.lex;
                        JOptionPane.showMessageDialog(this, string + " " + lexicon.getText("rateLinkDuplicateMessage"), lexicon.getText("rateLinkDuplicate"), 0);
                        return;
                    }
                    long l2 = rateLinkArray[i].getEndTime();
                    if (l2 < 0L) {
                        l = l2;
                        bl = true;
                        continue;
                    }
                    if (bl || l2 <= l) continue;
                    l = l2;
                }
            }
            RateLink rateLink = new RateLink(string);
            if (l >= 0L) {
                rateLink.setStartTime(l);
                rateLink.setBillingCycleStart(l);
            }
            rateHistory.addRateLink(rateLink);
            this.meterDetails.setRateHistoryEditorValue(rateHistory);
            this.meterDetails.handleRateChange();
            this.meterDetails.setSelectedRateLink(rateLink);
        }
    }

    private void copyRate() {
        Rate rate = this.rates.getSelectedRate();
        if (rate != null) {
            clipboard = (Rate)rate.newCopy();
        }
    }

    private void filterRates() {
        Lexicon lexicon = BEasApplet.lex;
        Rate[] rateArray = FilterRateDialog.getFilteredRates(this.easApplication.getSession(), this, lexicon, this.rates, this.rateFilterLabel);
        this.rates.refreshData(rateArray);
    }

    private void popupMetersAttached() {
        Rate rate = this.rates.getSelectedRate();
        if (rate == null) {
            return;
        }
        try {
            String string = rate.getName();
            Lexicon lexicon = BEasApplet.lex;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = EasCostClient.retrieveCostMeters(this.easApplication.getSession(), string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        if (!bl) {
                            stringBuffer.append(string + "\n" + lexicon.getText("metersAttached") + ":\n");
                            bl = true;
                        }
                        stringBuffer.append("    " + stringArray[i] + "\n");
                        break;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
            }
            if (!bl) {
                stringBuffer.append(lexicon.getText("noMetersAttached") + ":\n  " + string);
            }
            JTextArea jTextArea = new JTextArea(stringBuffer.toString(), 20, 60);
            jTextArea.setBackground(UIManager.getDefaults().getColor("Label.background"));
            jTextArea.setBorder(BorderFactory.createEmptyBorder());
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            JOptionPane.showMessageDialog(this.easApplication, jScrollPane, lexicon.getText("viewAttachedMeters"), 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.meterDetails == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.meterDetails.setRateHistoryEditorValue(this.getSelectedRateHistory(false));
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.filterSelection) {
            this.updateFilter();
        } else if (object instanceof JButton) {
            this.buttonPressed((JButton)object);
        }
    }

    public void initFilters() {
        EasSession easSession = this.easApplication.getSession();
        Lexicon lexicon = BEasApplet.lex;
        this.filterSelection.addItem(new AllSitesFilter(easSession, lexicon));
        this.filterSelection.addItem(new StaticGroupFilter(easSession, lexicon));
        Group[] groupArray = Group.getGroups('D', easSession);
        if (groupArray == null) {
            return;
        }
        int n = groupArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                if (groupArray[i].isHidden()) continue;
                this.filterSelection.addItem(new DynamicGroupFilter(easSession, (DynGroup)groupArray[i], lexicon));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.filterSelection.setMaximumRowCount(Math.min(this.filterSelection.getItemCount(), 10));
    }

    public void updateFilter() {
        Filter filter = (Filter)this.filterSelection.getSelectedItem();
        if (filter != this.currentFilter) {
            this.currentFilter = filter;
            FilterTreeModel filterTreeModel = new FilterTreeModel(new FilterRootNode(filter, new RateLinkDbObjectValidator()));
            this.tree.setModel(filterTreeModel);
        }
    }

    private ResourceManager getResourceManager() {
        return this;
    }

    public void stopApplication() {
        Lexicon lexicon;
        int n;
        if (this.meterDetails != null && this.meterDetails.unsavedChangesExist() && (n = JOptionPane.showConfirmDialog(null, (lexicon = BEasApplet.lex).getText("saveChangesTo") + " " + lexicon.getText("attachArate") + "?", lexicon.getText("saveChanges") + "?", 1)) == 0) {
            this.meterDetails.applyChanges();
        }
    }

    private boolean isDemoMode() {
        if (!this.checkDemoMode) {
            this.demoMode = !Meter.isEasCostLicensed(this.easApplication.getSession()) && !Meter.isEasE2Licensed(this.easApplication.getSession());
            this.checkDemoMode = true;
        }
        return this.demoMode;
    }

    private class MeterFilterTree
    extends FilterTree {
        public MeterFilterTree(ResourceManager resourceManager) {
            super(resourceManager);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.isEnabled()) {
                return;
            }
            boolean bl = (mouseEvent.getModifiers() & 4) != 0;
            boolean bl2 = mouseEvent.isControlDown();
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                this.clearSelection();
                return;
            }
            if (bl) {
                if (bl2) {
                    this.addSelectionPath(treePath);
                } else {
                    this.setSelectionPath(treePath);
                }
            }
        }
    }

    private class MeterTreePanel
    extends JComponent {
        public MeterTreePanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(false);
            jPanel.setLayout(new FlowLayout(1, 2, 2));
            AttachARateApplication.this.filterSelection = new XpComboBox();
            AttachARateApplication.this.filterSelection.addActionListener(AttachARateApplication.this);
            jPanel.add(AttachARateApplication.this.filterSelection);
            this.add((Component)jPanel, "North");
            AttachARateApplication.this.tree = new MeterFilterTree(AttachARateApplication.this.getResourceManager());
            AttachARateApplication.this.tree.addTreeSelectionListener(AttachARateApplication.this);
            this.add((Component)new JScrollPane(AttachARateApplication.this.tree), "Center");
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            int n = 175;
            if (dimension.width > n) {
                n = dimension.width;
            }
            return new Dimension(n, dimension.height);
        }
    }

    private class RatePopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem addItem = null;
        private EasPopupMenu.EasPopupMenuItem copyItem = null;
        private EasPopupMenu.EasPopupMenuItem viewItem = null;
        private boolean addItemShowing = false;
        private Lexicon lex;

        public RatePopup(Lexicon lexicon) {
            this.lex = lexicon;
            this.addItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("attachRate"), 0, null);
            this.copyItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("copy"), 1, null);
            this.viewItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("viewAttachedMeters"), 2, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    AttachARateApplication.this.addRate();
                    break;
                }
                case 1: {
                    AttachARateApplication.this.copyRate();
                    break;
                }
                case 2: {
                    AttachARateApplication.this.popupMetersAttached();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            boolean bl2 = bl;
            if (bl2 && !this.addItemShowing) {
                this.add(this.addItem);
                this.add(this.copyItem);
                this.add(this.viewItem);
                this.revalidate();
                this.addItemShowing = true;
            } else if (this.addItemShowing && !bl2) {
                this.remove(this.addItem);
                this.remove(this.copyItem);
                this.remove(this.viewItem);
                this.revalidate();
                this.addItemShowing = false;
            }
            if (this.addItemShowing) {
                super.show(component, n, n2);
            }
        }
    }
}

