/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.baja.util.Lexicon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ScrollPaneDialog
extends JDialog
implements ActionListener {
    private JButton closeButton = null;
    private Component parent;

    public ScrollPaneDialog(JComponent jComponent, Component component, Frame frame, String string, boolean bl, Lexicon lexicon) {
        super(frame, string, bl);
        this.parent = component;
        JComponent jComponent2 = (JComponent)this.getContentPane();
        jComponent2.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1), false);
        this.closeButton = new JButton(lexicon.getText("close"));
        this.closeButton.addActionListener(this);
        this.closeButton.setActionCommand("close");
        jPanel.add(this.closeButton);
        jComponent2.add((Component)jPanel, "South");
        jComponent2.add((Component)new JScrollPane(jComponent), "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ScrollPaneDialog.this.closeButton.requestFocus();
            }
        });
        this.pack();
    }

    public void show() {
        this.pack();
        Point point = this.parent.getLocationOnScreen();
        Point point2 = new Point(point.x + this.parent.getSize().width / 2, point.y + this.parent.getSize().height / 2);
        int n = this.getPreferredSize().width;
        int n2 = this.getPreferredSize().height;
        int n3 = point2.x - n / 2;
        int n4 = point2.y - n2 / 2;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 + n > toolkit.getScreenSize().width) {
            n3 = toolkit.getScreenSize().width - n;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 + n2 > toolkit.getScreenSize().height) {
            n4 = toolkit.getScreenSize().height - n2;
        }
        this.setLocation(n3, n4);
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton || actionEvent.getActionCommand().equals("close")) {
            this.hide();
        }
    }

    public Container getParent() {
        return (Container)this.parent;
    }
}

