/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.cost.datatypes.CompositeRateSchedule;
import com.tridium.eas.cost.datatypes.IntersectionCompositeRateSchedule;
import com.tridium.eas.cost.datatypes.RateSchedule;
import com.tridium.eas.cost.datatypes.UnionCompositeRateSchedule;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.DisabledImageGenerator;
import com.tridium.eas.ui.widgets.FilterTreeNode;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class RateTreeCellRenderer
extends DefaultTreeCellRenderer {
    private ImageIcon rateScheduleIcon = null;
    private ImageIcon disabledRateScheduleIcon = null;
    private ImageIcon compositeRateScheduleIcon = null;
    private ImageIcon disabledCompositeRateScheduleIcon = null;
    private ImageIcon intersectionRateScheduleIcon = null;
    private ImageIcon disabledIntersectionRateScheduleIcon = null;
    private ImageIcon unionRateScheduleIcon = null;
    private ImageIcon disabledUnionRateScheduleIcon = null;

    public RateTreeCellRenderer(ResourceManager resourceManager) {
        DisabledImageGenerator disabledImageGenerator = new DisabledImageGenerator();
        this.rateScheduleIcon = new ImageIcon(resourceManager.getIconImage(307));
        this.disabledRateScheduleIcon = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(307)));
        this.compositeRateScheduleIcon = new ImageIcon(resourceManager.getIconImage(308));
        this.disabledCompositeRateScheduleIcon = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(308)));
        this.intersectionRateScheduleIcon = new ImageIcon(resourceManager.getIconImage(309));
        this.disabledIntersectionRateScheduleIcon = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(309)));
        this.unionRateScheduleIcon = new ImageIcon(resourceManager.getIconImage(310));
        this.disabledUnionRateScheduleIcon = new ImageIcon(disabledImageGenerator.toDisabledImage(resourceManager.getIconImage(310)));
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        Object object2 = this.getUserObject(object);
        if (object2 == null) {
            return jLabel;
        }
        if (object2 instanceof RateSchedule) {
            jLabel.setText(((RateSchedule)object2).getName());
            if (object2 instanceof IntersectionCompositeRateSchedule) {
                jLabel.setIcon(this.intersectionRateScheduleIcon);
                jLabel.setDisabledIcon(this.disabledIntersectionRateScheduleIcon);
            } else if (object2 instanceof UnionCompositeRateSchedule) {
                jLabel.setIcon(this.unionRateScheduleIcon);
                jLabel.setDisabledIcon(this.disabledUnionRateScheduleIcon);
            } else if (object2 instanceof CompositeRateSchedule) {
                jLabel.setIcon(this.compositeRateScheduleIcon);
                jLabel.setDisabledIcon(this.disabledCompositeRateScheduleIcon);
            } else {
                jLabel.setIcon(this.rateScheduleIcon);
                jLabel.setDisabledIcon(this.disabledRateScheduleIcon);
            }
        }
        return jLabel;
    }

    private Object getUserObject(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)object).getUserObject();
        }
        if (object instanceof FilterTreeNode) {
            return ((FilterTreeNode)object).getUserObject();
        }
        return null;
    }
}

